<?php
require_once DOL_DOCUMENT_ROOT. '/compta/facture/class/facture.class.php';
/**
 * Created by PhpStorm.
 * User: razmin
 * Date: 08/11/2018
 * Time: 09:08 PM
 */
class facturen extends  Facture
{
    function fetch_lines()
    {
        $this->lines=array();

        $sql = 'SELECT l.rowid, l.fk_facture, l.fk_product, l.fk_parent_line, l.label as custom_label, l.description, l.product_type, l.price, l.qty, l.vat_src_code, l.tva_tx,';
        $sql.= ' l.situation_percent, l.fk_prev_id,';
        $sql.= ' l.localtax1_tx, l.localtax2_tx, l.localtax1_type, l.localtax2_type, l.remise_percent, l.fk_remise_except, l.subprice,';
        $sql.= ' l.rang, l.special_code,';
        $sql.= ' l.date_start as date_start, l.date_end as date_end,';
        $sql.= ' l.info_bits, l.total_ht, l.total_tva, l.total_localtax1, l.total_localtax2, l.total_ttc, l.fk_code_ventilation, l.fk_product_fournisseur_price as fk_fournprice, l.buy_price_ht as pa_ht,';
        $sql.= ' l.fk_unit,';
        $sql.= ' l.fk_multicurrency, l.multicurrency_code, l.multicurrency_subprice, l.multicurrency_total_ht, l.multicurrency_total_tva, l.multicurrency_total_ttc,';
        $sql.= ' p.ref as product_ref, p.fk_product_type as fk_product_type, p.label as product_label, p.description as product_desc';
        $sql.= ' FROM '.MAIN_DB_PREFIX.'facturedet as l';
        $sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'product as p ON l.fk_product = p.rowid';
        $sql.= ' WHERE l.fk_facture = '.$this->id;
        $sql.= ' ORDER BY l.rang, l.rowid';

        dol_syslog(get_class($this).'::fetch_lines', LOG_DEBUG);
        $result = $this->db->query($sql);
        if ($result)
        {
            $num = $this->db->num_rows($result);
            $i = 0;
            while ($i < $num)
            {
                $objp = $this->db->fetch_object($result);
                $line = new FactureLigne($this->db);

                $line->id               = $objp->rowid;
                $line->rowid	        = $objp->rowid;             // deprecated
                $line->fk_facture       = $objp->fk_facture;
                $line->label            = $objp->custom_label;		// deprecated
                $line->desc             = $objp->description;		// Description line
                $line->description      = $objp->description;		// Description line
                $line->product_type     = $objp->product_type;		// Type of line
                $line->ref              = $objp->product_ref;		// Ref product
                $line->product_ref      = $objp->product_ref;		// Ref product
                $line->libelle          = $objp->product_label;		// TODO deprecated
                $line->product_label	= $objp->product_label;		// Label product
                $line->product_desc     = $objp->product_desc;		// Description product
                $line->fk_product_type  = $objp->fk_product_type;	// Type of product
                $line->qty              = $objp->qty;
                $line->subprice         = $objp->subprice;

                $line->vat_src_code     = $objp->vat_src_code;
                $line->tva_tx           = $objp->tva_tx;
                $line->localtax1_tx     = $objp->localtax1_tx;
                $line->localtax2_tx     = $objp->localtax2_tx;
                $line->localtax1_type   = $objp->localtax1_type;
                $line->localtax2_type   = $objp->localtax2_type;
                $line->remise_percent   = $objp->remise_percent;
                $line->fk_remise_except = $objp->fk_remise_except;
                $line->fk_product       = $objp->fk_product;
                $line->date_start       = $this->db->jdate($objp->date_start);
                $line->date_end         = $this->db->jdate($objp->date_end);
                $line->date_start       = $this->db->jdate($objp->date_start);
                $line->date_end         = $this->db->jdate($objp->date_end);
                $line->info_bits        = $objp->info_bits;
                $line->total_ht         = $objp->total_ht;
                $line->total_tva        = $objp->total_tva;
                $line->total_localtax1  = $objp->total_localtax1;
                $line->total_localtax2  = $objp->total_localtax2;
                $line->total_ttc        = $objp->total_ttc;
                $line->code_ventilation = $objp->fk_code_ventilation;
                $line->fk_fournprice 	= $objp->fk_fournprice;
                $marginInfos			= getMarginInfos($objp->subprice, $objp->remise_percent, $objp->tva_tx, $objp->localtax1_tx, $objp->localtax2_tx, $line->fk_fournprice, $objp->pa_ht);
                $line->pa_ht 			= $marginInfos[0];
                $line->marge_tx			= $marginInfos[1];
                $line->marque_tx		= $marginInfos[2];
                $line->rang				= $objp->rang;
                $line->special_code		= $objp->special_code;
                $line->fk_parent_line	= $objp->fk_parent_line;
                $line->situation_percent= $objp->situation_percent;
                $line->fk_prev_id       = $objp->fk_prev_id;
                $line->fk_unit	        = $objp->fk_unit;

                // Accountancy
                $line->fk_accounting_account	= $objp->fk_code_ventilation;

                // Multicurrency
                $line->fk_multicurrency 		= $objp->fk_multicurrency;
                $line->multicurrency_code 		= $objp->multicurrency_code;
                $line->multicurrency_subprice 	= $objp->multicurrency_subprice;
                $line->multicurrency_total_ht 	= $objp->multicurrency_total_ht;
                $line->multicurrency_total_tva 	= $objp->multicurrency_total_tva;
                $line->multicurrency_total_ttc 	= $objp->multicurrency_total_ttc;


                $extralabelsline = $line->fetch_optionals($line->id);
                $this->lines[$i] = $line;

                $i++;
            }
            $this->db->free($result);
            return 1;
        }
        else
        {
            $this->error=$this->db->error();
            return -3;
        }
    }
}