<?php


/**
 * \file    unidadmedida/cunits.class.php
 * \ingroup unidadmedida
 * \brief   This file is a CRUD class file (Create/Read/Update/Delete)
 *          Clase para Manipular las Unidades de Medida del Sistema
 */


require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php';
//require_once DOL_DOCUMENT_ROOT . '/societe/class/societe.class.php';
//require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';

/**
 * Class Cunits
 *
 * Clase para Trabajar con Unidades de Medida del Sistema
 *
 * @see CommonObject
 */
class Cunits extends CommonObject
{
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'cunits';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'c_units';

	/**
	 * @var CunitsLine[] Lines
	 */
	public $lines = array();

	/**
	 */
	
	public $code;
	public $label;
	public $short_label;
	public $active;

	/**
	 */
	

	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDB $db)
	{
		$this->db = $db;
	}

	/**
	 * Create object into database
	 *
	 * @param  User $user      User that creates
	 * @param  bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, Id of created object if OK
	 */
	public function create(User $user, $notrigger = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$error = 0;

		// Clean parameters
		
		if (isset($this->code)) {
			 $this->code = trim($this->code);
		}
		if (isset($this->label)) {
			 $this->label = trim($this->label);
		}
		if (isset($this->short_label)) {
			 $this->short_label = trim($this->short_label);
		}
		if (isset($this->active)) {
			 $this->active = trim($this->active);
		}

		

		// Check parameters
		// Put here code to add control on parameters values

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . '(';
		
		$sql.= 'code,';
		$sql.= 'label,';
		$sql.= 'short_label,';
		$sql.= 'active';

		
		$sql .= ') VALUES (';
		
		$sql .= ' '.(! isset($this->code)?'NULL':"'".$this->db->escape($this->code)."'").',';
		$sql .= ' '.(! isset($this->label)?'NULL':"'".$this->db->escape($this->label)."'").',';
		$sql .= ' '.(! isset($this->short_label)?'NULL':"'".$this->db->escape($this->short_label)."'").',';
		$sql .= ' '.(! isset($this->active)?'NULL':$this->active);

		
		$sql .= ')';

		$this->db->begin();

		$resql = $this->db->query($sql);
		if (!$resql) {
			$error ++;
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . implode(',', $this->errors), LOG_ERR);
		}

		if (!$error) {
			$this->id = $this->db->last_insert_id(MAIN_DB_PREFIX . $this->table_element);

			if (!$notrigger) {
				// Uncomment this and change MYOBJECT to your own tag if you
				// want this action to call a trigger.

				//// Call triggers
				//$result=$this->call_trigger('MYOBJECT_CREATE',$user);
				//if ($result < 0) $error++;
				//// End call triggers
			}
		}

		// Commit or rollback
		if ($error) {
			$this->db->rollback();

			return - 1 * $error;
		} else {
			$this->db->commit();

			return $this->id;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT';
		$sql .= ' t.rowid,';
		
		$sql .= " t.code,";
		$sql .= " t.label,";
		$sql .= " t.short_label,";
		$sql .= " t.active";

		
		$sql .= ' FROM ' . MAIN_DB_PREFIX . $this->table_element . ' as t';
		$sql.= ' WHERE 1 = 1';
		if (! empty($conf->multicompany->enabled)) {
		    $sql .= " AND entity IN (" . getEntity("cunits", 1) . ")";
		}
		if (null !== $ref) {
			$sql .= ' AND t.ref = ' . '\'' . $ref . '\'';
		} else {
			$sql .= ' AND t.rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj = $this->db->fetch_object($resql);

				$this->id = $obj->rowid;
				
				$this->code = $obj->code;
				$this->label = $obj->label;
				$this->short_label = $obj->short_label;
				$this->active = $obj->active;

				
			}
			
			// Retrieve all extrafields for invoice
			// fetch optionals attributes and labels
			require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
			$extrafields=new ExtraFields($this->db);
			$extralabels=$extrafields->fetch_name_optionals_label($this->table_element,true);
			$this->fetch_optionals($this->id,$extralabels);

			// $this->fetch_lines();
			
			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . implode(',', $this->errors), LOG_ERR);

			return - 1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($sortorder='', $sortfield='', $limit=0, $offset=0, array $filter = array(), $filtermode='AND')
	{
		$return = array();

		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT';
		$sql .= ' t.rowid,';
		
		$sql .= " t.code,";
		$sql .= " t.label,";
		$sql .= " t.short_label,";
		$sql .= " t.active";

		
		$sql .= ' FROM ' . MAIN_DB_PREFIX . $this->table_element. ' as t';

		// Manage filter
		$sqlwhere = array();
		if (count($filter) > 0) {
			foreach ($filter as $key => $value) {
				//$sqlwhere [] = $key . ' LIKE \'%' . $this->db->escape($value) . '%\'';
				$sqlwhere [] = $key . '' . $this->db->escape($value) . '';
			}
		}
		$sql.= ' WHERE 1 = 1';
		if (! empty($conf->multicompany->enabled)) {
		    $sql .= " AND entity IN (" . getEntity("cunits", 1) . ")";
		}
		if (count($sqlwhere) > 0) {
			$sql .= ' AND ' . implode(' '.$filtermode.' ', $sqlwhere);
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield,$sortorder);
		}
		if (!empty($limit)) {
		 $sql .=  ' ' . $this->db->plimit($limit + 1, $offset);
		}

		$this->lines = array();

		$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new CunitsLine();

				$line->id = $obj->rowid;
				
				$line->code = $obj->code;
				$line->label = $obj->label;
				$line->short_label = $obj->short_label;
				$line->active = $obj->active;

				$this->lines[$line->id] = $line;
				//$return[] = $line;
			}
			$this->db->free($resql);

			//return $num;
			return $this->lines;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . implode(',', $this->errors), LOG_ERR);

			return - 1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @param  User $user      User that modifies
	 * @param  bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update(User $user, $notrigger = false)
	{
		$error = 0;

		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		
		if (isset($this->code)) {
			 $this->code = trim($this->code);
		}
		if (isset($this->label)) {
			 $this->label = trim($this->label);
		}
		if (isset($this->short_label)) {
			 $this->short_label = trim($this->short_label);
		}
		if (isset($this->active)) {
			 $this->active = trim($this->active);
		}

		

		// Check parameters
		// Put here code to add a control on parameters values

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET';
		
		$sql .= ' code = '.(isset($this->code)?"'".$this->db->escape($this->code)."'":"null").',';
		$sql .= ' label = '.(isset($this->label)?"'".$this->db->escape($this->label)."'":"null").',';
		$sql .= ' short_label = '.(isset($this->short_label)?"'".$this->db->escape($this->short_label)."'":"null").',';
		$sql .= ' active = '.(isset($this->active)?$this->active:"null");

        
		$sql .= ' WHERE rowid=' . $this->id;

		$this->db->begin();

		$resql = $this->db->query($sql);
		if (!$resql) {
			$error ++;
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . implode(',', $this->errors), LOG_ERR);
		}

		if (!$error && !$notrigger) {
			// Uncomment this and change MYOBJECT to your own tag if you
			// want this action calls a trigger.

			//// Call triggers
			//$result=$this->call_trigger('MYOBJECT_MODIFY',$user);
			//if ($result < 0) { $error++; //Do also what you must do to rollback action if trigger fail}
			//// End call triggers
		}

		// Commit or rollback
		if ($error) {
			$this->db->rollback();

			return - 1 * $error;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete(User $user, $notrigger = false)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$error = 0;

		$this->db->begin();

		if (!$error) {
			if (!$notrigger) {
				// Uncomment this and change MYOBJECT to your own tag if you
				// want this action calls a trigger.

				//// Call triggers
				//$result=$this->call_trigger('MYOBJECT_DELETE',$user);
				//if ($result < 0) { $error++; //Do also what you must do to rollback action if trigger fail}
				//// End call triggers
			}
		}

		// If you need to delete child tables to, you can insert them here
		
		if (!$error) {
			$sql = 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element;
			$sql .= ' WHERE rowid=' . $this->id;

			$resql = $this->db->query($sql);
			if (!$resql) {
				$error ++;
				$this->errors[] = 'Error ' . $this->db->lasterror();
				dol_syslog(__METHOD__ . ' ' . implode(',', $this->errors), LOG_ERR);
			}
		}

		// Commit or rollback
		if ($error) {
			$this->db->rollback();

			return - 1 * $error;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Load an object from its id and create a new one in database
	 *
	 * @param int $fromid Id of object to clone
	 *
	 * @return int New id of clone
	 */
	public function createFromClone($fromid)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		global $user;
		$error = 0;
		$object = new Cunits($this->db);

		$this->db->begin();

		// Load source object
		$object->fetch($fromid);
		// Reset object
		$object->id = 0;

		// Clear fields
		// ...

		// Create clone
		$result = $object->create($user);

		// Other options
		if ($result < 0) {
			$error ++;
			$this->errors = $object->errors;
			dol_syslog(__METHOD__ . ' ' . implode(',', $this->errors), LOG_ERR);
		}

		// End
		if (!$error) {
			$this->db->commit();

			return $object->id;
		} else {
			$this->db->rollback();

			return - 1;
		}
	}

	/**
	 *  Return a link to the object card (with optionaly the picto)
	 *
	 *	@param	int		$withpicto			Include picto in link (0=No picto, 1=Include picto into link, 2=Only picto)
	 *	@param	string	$option				On what the link point to
     *  @param	int  	$notooltip			1=Disable tooltip
     *  @param	int		$maxlen				Max length of visible user name
     *  @param  string  $morecss            Add more css on link
	 *	@return	string						String with URL
	 */
	function getNomUrl($withpicto=0, $option='', $notooltip=0, $maxlen=24, $morecss='')
	{
		global $db, $conf, $langs;
        global $dolibarr_main_authentication, $dolibarr_main_demo;
        global $menumanager;

        if (! empty($conf->dol_no_mouse_hover)) $notooltip=1;   // Force disable tooltips
        
        $result = '';
        $companylink = '';

        $label = '<u>' . $langs->trans("MyModule") . '</u>';
        $label.= '<br>';
        $label.= '<b>' . $langs->trans('Ref') . ':</b> ' . $this->ref;

        $url = DOL_URL_ROOT.'/unidadmedida/'.$this->table_name.'_card.php?id='.$this->id;
        
        $linkclose='';
        if (empty($notooltip))
        {
            if (! empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
            {
                $label=$langs->trans("ShowProject");
                $linkclose.=' alt="'.dol_escape_htmltag($label, 1).'"';
            }
            $linkclose.=' title="'.dol_escape_htmltag($label, 1).'"';
            $linkclose.=' class="classfortooltip'.($morecss?' '.$morecss:'').'"';
        }
        else $linkclose = ($morecss?' class="'.$morecss.'"':'');
        
		$linkstart = '<a href="'.$url.'"';
		$linkstart.=$linkclose.'>';
		$linkend='</a>';

        if ($withpicto)
        {
            $result.=($linkstart.img_object(($notooltip?'':$label), 'label', ($notooltip?'':'class="classfortooltip"')).$linkend);
            if ($withpicto != 2) $result.=' ';
		}
		$result.= $linkstart . $this->ref . $linkend;
		return $result;
	}

	/**
	 *  Retourne le libelle du status d'un user (actif, inactif)
	 *
	 *  @param	int		$mode          0=libelle long, 1=libelle court, 2=Picto + Libelle court, 3=Picto, 4=Picto + Libelle long, 5=Libelle court + Picto
	 *  @return	string 			       Label of status
	 */
	function getLibStatut($mode=0)
	{
		return $this->LibStatut($this->status,$mode);
	}

	/**
	 *  Return the status
	 *
	 *  @param	int		$status        	Id status
	 *  @param  int		$mode          	0=long label, 1=short label, 2=Picto + short label, 3=Picto, 4=Picto + long label, 5=Short label + Picto, 5=Long label + Picto
	 *  @return string 			       	Label of status
	 */
	static function LibStatut($status,$mode=0)
	{
		global $langs;

		if ($mode == 0)
		{
			$prefix='';
			if ($status == 1) return $langs->trans('Enabled');
			if ($status == 0) return $langs->trans('Disabled');
		}
		if ($mode == 1)
		{
			if ($status == 1) return $langs->trans('Enabled');
			if ($status == 0) return $langs->trans('Disabled');
		}
		if ($mode == 2)
		{
			if ($status == 1) return img_picto($langs->trans('Enabled'),'statut4').' '.$langs->trans('Enabled');
			if ($status == 0) return img_picto($langs->trans('Disabled'),'statut5').' '.$langs->trans('Disabled');
		}
		if ($mode == 3)
		{
			if ($status == 1) return img_picto($langs->trans('Enabled'),'statut4');
			if ($status == 0) return img_picto($langs->trans('Disabled'),'statut5');
		}
		if ($mode == 4)
		{
			if ($status == 1) return img_picto($langs->trans('Enabled'),'statut4').' '.$langs->trans('Enabled');
			if ($status == 0) return img_picto($langs->trans('Disabled'),'statut5').' '.$langs->trans('Disabled');
		}
		if ($mode == 5)
		{
			if ($status == 1) return $langs->trans('Enabled').' '.img_picto($langs->trans('Enabled'),'statut4');
			if ($status == 0) return $langs->trans('Disabled').' '.img_picto($langs->trans('Disabled'),'statut5');
		}
		if ($mode == 6)
		{
			if ($status == 1) return $langs->trans('Enabled').' '.img_picto($langs->trans('Enabled'),'statut4');
			if ($status == 0) return $langs->trans('Disabled').' '.img_picto($langs->trans('Disabled'),'statut5');
		}
	}


	/**
	 * Initialise object with example values
	 * Id must be 0 if object instance is a specimen
	 *
	 * @return void
	 */
	public function initAsSpecimen()
	{
		$this->id = 0;
		
		$this->code = '';
		$this->label = '';
		$this->short_label = '';
		$this->active = '';

		
	}
	function load_measuring_units($name='measuring_units', $measuring_style='', $default='0', $adddefault=0)
	{
		global $langs,$conf,$mysoc;
		$langs->load("other");

		$return='';

		$measuring_units=array();
		if ($measuring_style == 'weight') $measuring_units=array(-6=>1,-3=>1,0=>1,3=>1,98=>1,99=>1);
		else if ($measuring_style == 'size') $measuring_units=array(-3=>1,-2=>1,-1=>1,0=>1,98=>1,99=>1);
		else if ($measuring_style == 'surface') $measuring_units=array(-6=>1,-4=>1,-2=>1,0=>1,98=>1,99=>1);
		else if ($measuring_style == 'volume') $measuring_units=array(-9=>1,-6=>1,-3=>1,0=>1,88=>1,89=>1,97=>1,99=>1,/* 98=>1 */);  // Liter is not used as already available with dm3
		else if ($measuring_style == 'all') {
			$measuring_units=$this->lines;
		}  // Liter is not used as already available with dm3

		$return.= '<select class="flat" name="'.$name.'">';
		if ($adddefault) $return.= '<option value="0">'.$langs->trans("Default").'</option>';

		foreach ($measuring_units as $key => $value)
		{
			$return.= '<option value="'.$key.'"';
			if ($key == $default)
			{
				$return.= ' selected';
			}
			//$return.= '>'.$value.'</option>';
			$return.= '>'.$langs->trans($value->label).'</option>';
		}
		$return.= '</select>';

		return $return;
	}
	function select_measuring_units($name='measuring_units', $measuring_style='', $default='0', $adddefault=0)
	{
		print $this->load_measuring_units($name, $measuring_style, $default, $adddefault);
	}
	function measuring_units_string($unit,$measuring_style='')
	{
		global $langs;

		$measuring_units=array();
		if ($measuring_style == 'weight')
		{
			$measuring_units[3] = $langs->transnoentitiesnoconv("WeightUnitton");
			$measuring_units[0] = $langs->transnoentitiesnoconv("WeightUnitkg");
			$measuring_units[-3] = $langs->transnoentitiesnoconv("WeightUnitg");
			$measuring_units[-6] = $langs->transnoentitiesnoconv("WeightUnitmg");
			$measuring_units[98] = $langs->transnoentitiesnoconv("WeightUnitounce");
			$measuring_units[99] = $langs->transnoentitiesnoconv("WeightUnitpound");
		}
		else if ($measuring_style == 'size')
		{
			$measuring_units[0] = $langs->transnoentitiesnoconv("SizeUnitm");
			$measuring_units[-1] = $langs->transnoentitiesnoconv("SizeUnitdm");
			$measuring_units[-2] = $langs->transnoentitiesnoconv("SizeUnitcm");
			$measuring_units[-3] = $langs->transnoentitiesnoconv("SizeUnitmm");
			$measuring_units[98] = $langs->transnoentitiesnoconv("SizeUnitfoot");
			$measuring_units[99] = $langs->transnoentitiesnoconv("SizeUnitinch");
		}
		else if ($measuring_style == 'surface')
		{
			$measuring_units[0] = $langs->transnoentitiesnoconv("SurfaceUnitm2");
			$measuring_units[-2] = $langs->transnoentitiesnoconv("SurfaceUnitdm2");
			$measuring_units[-4] = $langs->transnoentitiesnoconv("SurfaceUnitcm2");
			$measuring_units[-6] = $langs->transnoentitiesnoconv("SurfaceUnitmm2");
			$measuring_units[98] = $langs->transnoentitiesnoconv("SurfaceUnitfoot2");
			$measuring_units[99] = $langs->transnoentitiesnoconv("SurfaceUnitinch2");
		}
		else if ($measuring_style == 'volume')
		{
			$measuring_units[0] = $langs->transnoentitiesnoconv("VolumeUnitm3");
			$measuring_units[-3] = $langs->transnoentitiesnoconv("VolumeUnitdm3");
			$measuring_units[-6] = $langs->transnoentitiesnoconv("VolumeUnitcm3");
			$measuring_units[-9] = $langs->transnoentitiesnoconv("VolumeUnitmm3");
			$measuring_units[88] = $langs->transnoentitiesnoconv("VolumeUnitfoot3");
			$measuring_units[89] = $langs->transnoentitiesnoconv("VolumeUnitinch3");
			$measuring_units[97] = $langs->transnoentitiesnoconv("VolumeUnitounce");
			$measuring_units[98] = $langs->transnoentitiesnoconv("VolumeUnitlitre");
			$measuring_units[99] = $langs->transnoentitiesnoconv("VolumeUnitgallon");
		}
		else{

		}

		return $measuring_units[$unit];
	}

	/**
	 *	Transform a given unit into the square of that unit, if known
	 *
	 *	@param	int		$unit            Unit key (-3,-2,-1,0,98,99...)
	 *	@return	int	   			         Squared unit key (-6,-4,-2,0,98,99...)
	 * 	@see	formproduct->load_measuring_units
	 */
	function measuring_units_squared($unit)
	{
		$measuring_units=array();
		$measuring_units[0] = 0;   // m -> m3
		$measuring_units[-1] = -2; // dm-> dm2
		$measuring_units[-2] = -4; // cm -> cm2
		$measuring_units[-3] = -6; // mm -> mm2
		$measuring_units[98] = 98; // foot -> foot2
		$measuring_units[99] = 99; // inch -> inch2
		return $measuring_units[$unit];
	}


	/**
	 *	Transform a given unit into the cube of that unit, if known
	 *
	 *	@param	int		$unit            Unit key (-3,-2,-1,0,98,99...)
	 *	@return	int	   			         Cubed unit key (-9,-6,-3,0,88,89...)
	 * 	@see	formproduct->load_measuring_units
	 */
	function measuring_units_cubed($unit)
	{
		$measuring_units=array();
		$measuring_units[0] = 0;   // m -> m2
		$measuring_units[-1] = -3; // dm-> dm3
		$measuring_units[-2] = -6; // cm -> cm3
		$measuring_units[-3] = -9; // mm -> mm3
		$measuring_units[98] = 88; // foot -> foot3
		$measuring_units[99] = 89; // inch -> inch3
		return $measuring_units[$unit];
	}


}

/**
 * Class CunitsLine
 */
class CunitsLine
{
	/**
	 * @var int ID
	 */
	public $id;
	/**
	 * @var mixed Sample line property 1
	 */
	
	public $code;
	public $label;
	public $short_label;
	public $active;

	/**
	 * @var mixed Sample line property 2
	 */
	
}
