<?php
/* Copyright (C) 2015 Yassine Belkaid  <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       htdocs/transferorders/index.php
 *      \ingroup    transferorders
 *		\brief     	List of transfer orders
 */

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
dol_include_once('/transferorders/class/transferorder.class.php');
dol_include_once('/transferorders/common.inc.php');

// Security check
$socid = GETPOST("socid","int");
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'salaries', '', '', '');

$search_ref 	= GETPOST('search_ref','int');
$search_label 	= GETPOST('search_label','alpha');
$search_author 	= GETPOST('search_author','alpha');
$search_account = GETPOST('search_account','alpha');
$search_payment_date= GETPOST('search_payment_date','alpha');
$search_created_at 	= GETPOST('search_created_at','alpha');
$sortfield 		= GETPOST("sortfield",'alpha');
$sortorder 		= GETPOST("sortorder",'alpha');
$page 			= GETPOST("page",'int');
$page = (empty($page) ? 0 : $page);
if ($page == -1) { $page = 0; }
$offset = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$limit = $conf->liste_limit;
if (!$sortfield) $sortfield = "t.payment_date";
if (!$sortorder) $sortorder = "DESC";

$filtre = $_GET["filtre"];

// Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_ref 		= "";
	$search_label 		= "";
	$search_author		= "";
	$search_payment_date= "";
    $search_account		= "";
    $search_created_at	= "";
}

$transferorderscls = new transferorderscls($db);
$result = $transferorderscls->fetch();

/*
 * View
 */
$morejs = array('/transferorders/js/transfer_orders.js');
llxHeader(array(),$langs->trans("SalariesPayments"),'','','','',$morejs);

$form 				= new Form($db);
$transOrderStatic 	= new TransferOrder($db);
$userstatic 		= new User($db);
$bankAccountstatic 	= new Account($db);

$sql = "SELECT u.rowid as uid, u.lastname, u.firstname,u.admin,u.login,u.email,bc.label as accountLabel,bc.number as accountNumber,";
$sql.= " t.rowid, t.fk_user_author, t.fk_account, t.payment_date, t.createdAt, t.label";
// $sql.= " pst.code as payment_code";
$sql.= " FROM ".MAIN_DB_PREFIX."transfer_order as t,";
// $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."c_paiement as pst ON s.fk_typepayment = pst.id,";
$sql.= " ".MAIN_DB_PREFIX."user as u,";
$sql.= " ".MAIN_DB_PREFIX."bank_account as bc";
$sql.= " WHERE u.rowid = t.fk_user_author AND bc.rowid = t.fk_account";
$sql.= " AND t.entity = ".$conf->entity;

// Search criteria
if ($search_ref)	$sql.= " AND t.rowid=".$search_ref;
if ($search_label)   $sql.= " AND t.label = '".$search_label."'";
if ($search_author)   $sql.= " AND t.fk_user_author=".$search_author;
if ($search_account) 	$sql.= " AND t.fk_account=".$search_account;
if ($search_payment_date && false !== strpos($search_payment_date, '/')) {
	list($day, $month, $year) = explode("/", $search_payment_date);
	$sql .= " AND t.payment_date = '". $search_payment_date ."'";
}

if ($search_created_at && false !== strpos($search_created_at, '/')) {
	list($day, $month, $year) = explode("/", $search_created_at);
	$sql .= " AND t.createdAt = '". $search_created_at ."'";
}

if ($filtre) {
    $filtre = str_replace(":","=",$filtre);
    $sql   .= " AND ".$filtre;
}

$sql.= $db->order($sortfield,$sortorder);
$sql.= $db->plimit($limit+1,$offset);

$result = $db->query($sql);

if ($result) {
    $num = $db->num_rows($result);
    $i 		= 0;
    $total 	= 0 ;
	$var 	= true;

	$param='';

	print_barre_liste($langs->trans("SalariesPayments"), $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $totalnboflines, 'title_accountancy.png');

	print '<form method="GET" action="'.$_SERVER["PHP_SELF"].'">';

    print '<table class="noborder" width="100%">';
    print '<tr class="liste_titre">';
	print_liste_field_titre($langs->trans("Ref"), $_SERVER["PHP_SELF"], "t.rowid", "", $param, "", $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Label"),$_SERVER["PHP_SELF"],"t.label","",$param,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Author"),$_SERVER["PHP_SELF"],"t.fk_user_author","",$param,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Account"),$_SERVER["PHP_SELF"],"t.fk_account","",$param,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("DatePayment"),$_SERVER["PHP_SELF"],"t.payment_date","",$param,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("CreatedAt"),$_SERVER["PHP_SELF"],"t.createdAt","",$param,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Downloading"),$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
    print "</tr>\n";

	print '<tr class="liste_titre">';
	// Ref
	print '<td class="liste_titre" align="left">';
	print '<input class="flat" type="text" size="3" name="search_ref" value="'.$search_ref.'">';
	print '</td>';
	// Label
	print '<td class="liste_titre" align="center">';
	print '<input class="flat" type="text" size="20" name="search_label" value="'.$search_label.'">';
	print '</td>';
	// People
	print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_author,"search_author",1,"",0,'','',0,32);
	print '</td>';
	// Account
	print '<td class="liste_titre" align="center">';
	$form->select_comptes($search_account,"search_account",0,'',1);
	print '</td>';
	// Created Date
	print '<td class="liste_titre" align="center">';
	print '<input class="flat datepickerp center" type="text" size="25" name="search_payment_date" value="'.$search_payment_date.'">';
	print '</td>';
	print '<td class="liste_titre" align="center">';
	print '<input class="flat datepickerp center" type="text" size="20" name="search_created_at" value="'.$search_created_at.'">';
	print '</td>';

	print '<td class="liste_titre" align="right"><input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print "</td></tr>\n";

	$bankAccount2 = new Account($db);
    while ($i < min($num, $limit)) {
        $obj = $db->fetch_object($result);
        $var = !$var;
        print "<tr ".$bc[$var].">";

        $userstatic->id 		= $obj->uid;
        $userstatic->lastname   = $obj->lastname;
        $userstatic->firstname  = $obj->firstname;
        $userstatic->admin 		= $obj->admin;
        $userstatic->login 		= $obj->login;
        $userstatic->email 		= $obj->email;
        $userstatic->societe_id = $user->societe_id;

        $transOrderStatic->id  = $obj->rowid;
		$transOrderStatic->ref = $obj->rowid;

		$bankAccountstatic->id 	  = $obj->fk_account;
		$bankAccountstatic->label = $obj->accountLabel;
		$bankAccountstatic->number = $obj->accountNumber;

		$bankAccount2->fetch($obj->fk_account);
        // Ref
		print '<td align="left">'. $transOrderStatic->getNomUrl(1)."</td>\n";
        // Label
		print '<td align="center">'. ucfirst($obj->label) ."</td>\n";
		// User name
		print '<td align="center">'. $userstatic->getNomUrl(1)."</td>\n";
		// Account
		print '<td align="center">'. $bankAccount2->getNomUrl(1) ."</td>\n";
		// Date payment
        print '<td align="center">'.dol_print_date($db->jdate($obj->payment_date),'day')."</td>\n";
        // created at
        print '<td align="center">'.dol_print_date($db->jdate($obj->createdAt),'day')."</td>\n";
        print "<td align='right'><a target='_blank' href='card.php?id=". $obj->rowid ."&action=pdf'><img src='".DOL_URL_ROOT."/theme/common/mime/pdf.png' alt='' title='Télécharger ordre de virement' /></a></td>";
        print "</tr>\n";

        // $total = $total + $obj->amount;

        $i++;
    }
    
    /*print '<tr class="liste_total"><td colspan="6" class="liste_total">'.$langs->trans("Total").'</td>';
    print '<td  class="liste_total" align="right">'.price($total,0,$outputlangs,1,-1,-1,$conf->currency)."</td>";
	print "<td></td></tr>";*/

    print "</table>";
    print '<div style="float: right; margin-top: 8px;">';
	print '<a href="./card.php?action=create&leftmenu=tax_salary" class="butAction">'.$langs->trans('AddNewTransferOrder').'</a>';
	print '</div>';

	print '</form>';

    $db->free($result);
}
else {
    dol_print_error($db);
}

llxFooter();

$db->close();
