<?php
/* List of transfer orders, you can add/edit/delete it
 * Copyright (C) 2016  Yassine Belkaid <y.belkaid@nextconcept.ma>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	TransferOrders	TransferOrders module
 * 	\brief		TransferOrders module descriptor.
 * 	\file		core/modules/modTransferOrders.class.php
 * 	\ingroup	TransferOrders
 * 	\brief		TransferOrders is adds more functionnality to compta
 */
include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

/**
 * Description and activation class for module MyModule
 */
class modTransferOrders extends DolibarrModules
{
	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db 			= $db;
		// $this->numero 		= 808810;
		$this->numero 		= 190972000;
		$this->rights_class = 'transferorders';
		$this->family = "Next";
		$this->name 		= preg_replace('/^mod/i', '', get_class($this));
		$this->description 	= "descriptionmodtransferorders";
		$this->version 		= '7.0';
		$this->const_name 	= 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special 		= 0;
		$this->picto 		= 'transferorders@transferorders';
		$this->module_parts = array(
			'triggers' 	=> 0,
			'css' 		=> array(),
			'hooks' 	=> array('salarycard')
		);

		$this->dirs 		= array();
		// $this->config_page_url = array("admin_setup.php@transferorders");
		$this->config_page_url = array();

		$this->hidden 		= false;
		$this->depends 		= array('modBanque','modSalaries');
		$this->requiredby 	= array();
		$this->conflictwith = array();
		$this->phpmin 		= array(5, 3);
		$this->need_dolibarr_version = array(3, 0);
		$this->langfiles 	= array("transferorders@transferorders", "compta", "bills", "banks", "salaries");
		$this->const 		= array(
			0 => array(
				'MAIN_MODULE_'. strtoupper($this->name) .'_HOOKS',
				'chaine',
				'salarycard',
				'Hook to update transfer orders table when a salaries payment is deleted',
				0
			)
		);
		$this->tabs 		= array();
		// Dictionaries
		if (! isset($conf->transferorders->enabled)) {
			$conf->transferorders = new stdClass();
			$conf->transferorders->enabled = 0;
		}
		$this->dictionaries = array();

		// Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
		$this->boxes = array(); // Boxes list

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 1;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Read transfer order';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'read';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Create/modify your transfer order';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'write';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Delete transfer order';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'delete';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Read transfer orders for everybody';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'read_all';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Create/modify transfer order for everybody';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'write_all';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Setup transfer order of users (setup and update)';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'define_contract';
		$this->rights[$r][5] = '';
		$r++;

		// Main menu entries
		$r = 0;

		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=accountancy',
			'type'		=> 'left',
			'titre'		=> "SalariesPayments",
			'leftmenu'	=> 'transferorders',
			'url'		=> '/transferorders/liste.php',
			'langs'		=> 'transferorders@transferorders',
			'position'	=> 4,
			'enabled' 	=> '$conf->transferorders->enabled',
			'perms'		=> 1,
			'target'	=> '',
			'user'		=> 2 // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=accountancy,fk_leftmenu=transferorders',
			'type'		=> 'left',
			'titre'		=> "SalariesPayments",
			'url'		=> '/transferorders/liste.php',
			'langs'		=> 'transferorders@transferorders',
			'position'	=> 5,
			'perms'		=> 1,
			'enabled' 	=> '$conf->transferorders->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=accountancy,fk_leftmenu=transferorders',
			'type'		=> 'left',
			'titre'		=> "PaymentsAndBP",
			'url'		=> '/transferorders/payslipp.php',
			'langs'		=> 'transferorders@transferorders',
			'position'	=> 6,
			'perms'		=> 1,
			'enabled' 	=> '$conf->transferorders->enabled',
			'target'	=> '',
			'user'		=> 2
		);

		// Exports
		$r = 0;
	}

	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();
		$sql2 = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."transfer_order` (
		  `rowid` int(11) NULL AUTO_INCREMENT PRIMARY KEY,
		  `label` varchar(100) DEFAULT NULL,
		  `fk_user_author` int(8) NULL,
		  `fk_account` int(8) NULL,
		  `payment_date` datetime NULL,
		  `payment_salaries` text NULL,
		  `createdAt` datetime NULL,
		  `entity` int(4) DEFAULT NULL
		)";
		$resql = $this->db->query($sql2);
		if (!$resql) {
			$errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			print_r($errors);
			die();
		} 


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_cnss', 1, 'user', '2016-02-25 16:33:15', 'Immatriculation de la CNSS', 'varchar', '10', 1, 0, NULL, 3, 1, 'a:1:{s:7:\"options\";a:1:{s:0:\"\";N;}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_date_embauche', 1, 'user', '2016-02-25 16:33:22', 'Date embauche', 'date', '', 0, 0, NULL, 0, 1, 'a:1:{s:7:\"options\";a:1:{s:0:\"\";N;}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_num_holiday', 1, 'user', '2016-02-25 16:33:26', 'Nombre des jours de congé', 'int', '4', 0, 0, NULL, 1, 1, 'a:1:{s:7:\"options\";a:1:{s:0:\"\";N;}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_cin', 1, 'user', '2016-02-25 16:33:30', 'CIN', 'varchar', '10', 0, 0, NULL, 2, 1, 'a:1:{s:7:\"options\";a:1:{s:0:\"\";N;}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_sit_family', 1, 'user', '2016-02-25 16:33:35', 'Situation familiale', 'select', '', 0, 0, NULL, 4, 1, 'a:1:{s:7:\"options\";a:2:{i:0;s:12:\"Célibataire\";i:1;s:9:\"Marié(e)\";}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_sit_assure', 1, 'user', '2016-02-25 16:33:41', 'Situation assuré', 'select', '', 0, 0, NULL, 5, 1, 'a:1:{s:7:\"options\";a:8:{i:1;s:7:\"Sortant\";i:2;s:8:\"Decédé\";i:3;s:10:\"Maternité\";i:4;s:7:\"Maladie\";i:5;s:19:\"Accident de travail\";i:6;s:19:\"Congé Sans salaire\";i:7;s:21:\"Maintenu Sans Salaire\";i:8;s:23:\"Maladie Professionnelle\";}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_is_declared', 1, 'user', '2016-02-25 16:33:46', 'Déjà déclaré', 'select', '', 0, 0, NULL, 6, 1, 'a:1:{s:7:\"options\";a:3:{i:0;s:3:\"Non\";i:1;s:3:\"Oui\";i:2;s:7:\"Sortant\";}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_etablissement', 1, 'user', '2016-02-25 16:33:51', 'Etablissement', 'varchar', '100', 0, 0, NULL, 7, 1, 'a:1:{s:7:\"options\";a:1:{s:0:\"\";N;}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_etab_opt', 1, 'user', '2016-02-25 16:32:59', 'Etablissement option', 'varchar', '100', 0, 0, NULL, 8, 1, 'a:1:{s:7:\"options\";a:1:{s:0:\"\";N;}}', 0);";
		$resql = $this->db->query($sql2);
		


		$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."extrafields` (`name`, `entity`, `elementtype`, `tms`, `label`, `type`, `size`, `fieldunique`, `fieldrequired`, `perms`, `pos`, `alwayseditable`, `param`, `list`) VALUES
		('nx_nbr_enfants', 1, 'user', '2016-02-25 16:32:59', 'Nombre d\'enfant', 'int', '4', 0, 0, NULL, 9, 1, 'a:1:{s:7:\"options\";a:1:{s:0:\"\";N;}}', 0);";
		$resql = $this->db->query($sql2);
		



		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."payment_salary` ADD `payslip` SMALLINT(4) NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_cnss` varchar(10) NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_date_embauche` date NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_num_holiday` int(4) NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_cin` varchar(10) NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_sit_family` text NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_sit_assure` text NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_is_declared` text NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_etablissement` varchar(100) NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_etab_opt` varchar(100) NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		

		$sql2 = "ALTER TABLE `".MAIN_DB_PREFIX."user_extrafields` ADD `nx_nbr_enfants` int(4) NULL DEFAULT NULL;";
		$resql = $this->db->query($sql2);
		




		$result = $this->loadTables();

		return $this->_init($sql, $options);
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql 	= $this->dropColmunsAndRows();
		// $sql[] 	= "DROP TABLE `llx_transfer_order`";
		
		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /mymodule/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/transferorders/sql/');
	}

	private function dropColmunsAndRows()
	{
		return array(
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_cnss"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_date_embauche"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_num_holiday"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_cin"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_sit_family"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_sit_assure"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_is_declared"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_etablissement"',
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "nx_etab_opt"',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_cnss',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_date_embauche',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_num_holiday',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_cin',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_sit_family',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_sit_assure',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_is_declared',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_etablissement',
			'ALTER TABLE `'.MAIN_DB_PREFIX.'user_extrafields` DROP `nx_etab_opt'
		);
	}
}
