<?php

// Load Dolibase
include_once 'autoload.php';

// Load Dolibase Page class
dolibase_include_once('/core/pages/setup.php');

// Load Dolibarr functions2 lib
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';

// Create Page using Dolibase
$page = new SetupPage("ThemeCustomizer", '$user->rights->theme_customizer->customize', true);
$page->setTitleLink(DOL_URL_ROOT.'/admin/ihm.php?mainmenu=home', 'GoToDisplaySettings');

// Get parameters
$action = GETPOST('action', 'alpha');

global $db, $conf, $user;

// Set Actions
if (preg_match('/^(set|del)_(.*)/', $action, $reg))
{
	$param = $reg[2];
	$value = (is_submitted($param) ? GETPOST($param) : ($action[0] == 's' ? 1 : 0));

	if (dol_set_user_param($db, $conf, $user, array('THEME_ELDY_ENABLE_PERSONALIZED' => '1', $param => $value)))
	{
		dolibase_redirect($_SERVER["PHP_SELF"].'?mainmenu=home');
	}
	else
	{
		dol_print_error($db);
	}
}

// Set Tabs
$page->addTab("General", "/themecustomizer/index.php?mainmenu=home");
$page->addTab("Menus", "/themecustomizer/menus.php?mainmenu=home");
$page->addTab("Body", "/themecustomizer/body.php?mainmenu=home");
$page->addTab("Buttons", "/themecustomizer/buttons.php?mainmenu=home");
$page->addTab("Graphs", "/themecustomizer/graphs.php?mainmenu=home", true);
if ($user->admin) {
	$page->addTab("LoginPage", "/themecustomizer/login_page.php?mainmenu=home");
}
$page->addTab("Advanced", "/themecustomizer/advanced.php?mainmenu=home");

$page->begin();

// Graph colors
$table_header = array(
	array('name' => 'GraphColors'),
	array('name' => '', 'attr' => 'align="center" width="100"')
);

$page->openTable($table_header);

$color_file = DOL_DOCUMENT_ROOT."/theme/".$conf->theme."/graph-color.php";
if (is_readable($color_file))
{
	include_once $color_file;
}

global $theme_datacolor;

$default_colors = array(
	'fe6383',
	'ff9f40',
	'ffcc56',
	'4ac0c0',
	'36a2eb',
	'949fb1',
	'4d5360',
	'97bbcd',
	'dcdcdc'
);

for ($i = 0; $i < 9; $i++)
{
	$num = $i +1;
	$option_name = "GRAPH_COLOR_".$num;

	$conf->global->$option_name = isset($user->conf->$option_name) ? $user->conf->$option_name : colorArrayToHex($theme_datacolor[$i], $default_colors[$i]);
	$page->addColorOption("GraphColor".$num, $option_name);
}

$page->closeTable();

// Clear Cache notice
$page->addLineBreak();

echo info_admin($langs->trans('ClearCacheNotice'));

$page->end();
