<?php

//if (! defined('NOREQUIREUSER')) define('NOREQUIREUSER','1');	// Not disabled because need to load personalized language
//if (! defined('NOREQUIREDB'))   define('NOREQUIREDB','1');	// Not disabled to increase speed. Language code is found on url.
if (! defined('NOREQUIRESOC'))    define('NOREQUIRESOC','1');
if (! defined('NOREQUIRETRAN')) define('NOREQUIRETRAN','1');	// No need for translations
if (! defined('NOCSRFCHECK'))     define('NOCSRFCHECK',1);
if (! defined('NOTOKENRENEWAL'))  define('NOTOKENRENEWAL',1);
if (! defined('NOLOGIN'))         define('NOLOGIN',1);       // File can be accessed after login + after executing hooks
if (! defined('NOREQUIREMENU'))   define('NOREQUIREMENU',1);   // No need for top menu content
if (! defined('NOREQUIREHTML'))   define('NOREQUIREHTML',1);   // No need for HTML
if (! defined('NOREQUIREAJAX'))   define('NOREQUIREAJAX','1'); // No need for AJAX

define('NOREDIRECTBYMAINTOLOGIN', 1);

// Load Dolibarr environment
if (false === (@include '../../main.inc.php')) {  // From htdocs directory
	require '../../../main.inc.php'; // From "custom" directory
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';

global $conf;

$dol_version = explode('.', DOL_VERSION);

// Parameters
$button_back_color = (isset($conf->global->LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR) && ! empty($conf->global->LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR) ? $conf->global->LOGIN_PAGE_CUSTOM_BUTTON_BACK_COLOR : '467fcf');
$button_border_color = (isset($conf->global->LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR) && ! empty($conf->global->LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR) ? $conf->global->LOGIN_PAGE_CUSTOM_BUTTON_BORDER_COLOR : '467fcf');
$button_text_color = (isset($conf->global->LOGIN_PAGE_CUSTOM_BUTTON_TEXT_COLOR) && ! empty($conf->global->LOGIN_PAGE_CUSTOM_BUTTON_TEXT_COLOR) ? $conf->global->LOGIN_PAGE_CUSTOM_BUTTON_TEXT_COLOR : 'ffffff');
$links_color = (isset($conf->global->LOGIN_PAGE_CUSTOM_LINKS_COLOR) && ! empty($conf->global->LOGIN_PAGE_CUSTOM_LINKS_COLOR) ? $conf->global->LOGIN_PAGE_CUSTOM_LINKS_COLOR : '467fcf');
$inputs_hover_border_color = (isset($conf->global->LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR) && ! empty($conf->global->LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR) ? $conf->global->LOGIN_PAGE_CUSTOM_INPUT_HOVER_BORDER_COLOR : '467fcf');
$border_radius = (isset($conf->global->LOGIN_PAGE_CUSTOM_ROUND_BORDERS) && $conf->global->LOGIN_PAGE_CUSTOM_ROUND_BORDERS ? '25px' : '3px');

// Set content type
header('Content-Type: text/css');

// Set custom style
if (isset($conf->global->LOGIN_PAGE_STYLE) && $conf->global->LOGIN_PAGE_STYLE == 'custom' && ! isset($_SESSION["dol_login"]))
{
	?>
	/* ============================================================================== */
	/* Reset Default styles                                                           */
	/* ============================================================================== */
	* {
		padding: 0;
		margin: 0;
		-webkit-box-sizing: border-box;
		-moz-box-sizing: border-box;
		box-sizing: border-box;
	}

	html, body {
		position: relative;
		height: 100%;
	}

	.login_vertical_align {
		padding: 0 !important;
	}

	.login_table {
		background-color: transparent !important;
		border: 0 !important;
		border-radius: 0;
		box-shadow: none !important;
		padding: 0 !important;
		margin: 0 !important;
	}

	div#login_left, div#login_right {
		display: block !important;
		padding: 0 !important;
	}

	.login_table input#username, .login_table input#password, .login_table input#securitycode {
		margin: 0 !important;
	}

	#login_line2 .button {
		box-shadow: none !important;
		background-image: none !important;
		margin-left: 0 !important;
		margin-right: 0 !important;
	}

	/* ============================================================================== */
	/* Login                                                                          */
	/* ============================================================================== */
	.bodylogin {
		display: flex;
		background-color: #f5f7fb;
	}

	.login_center {
		margin: auto;
		padding: 0 10px;
		background-image: none !important;
	}

	.login_center form {
		background-color: #fff;
		border: 1px solid rgba(0, 40, 100, 0.12);
		border-radius: 3px;
		box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
		margin: 0 auto;
		padding: 30px 30px 20px !important;
		margin-bottom: 20px;
	}

	@media screen and (min-width: 768px) {
		.login_center form {
			width: 480px;
		}
	}

	.login_center a {
		color: #495057;
		text-decoration: none;
	}

	.login_table_title {
		display: none;
	}

	#login_left {
		position: relative;
		margin-bottom: 10px;
	}

	#login_left img {
		max-width: 150px;
	}

	#login_right table {
		width: 100%;
	}

	<?php if ((int)$dol_version[0] > 8) { ?>

	#login_right .trinputlogin .tdinputlogin, #login_right span.select2-container {
		display: flex;
		background-color: #fff;
		background-image: none !important;
		border: 1px solid #e4e7ea;
		border-radius: <?php echo $border_radius; ?> !important;
		padding: 6px 0;
		margin-bottom: 20px;
		overflow: hidden;
	}

	#login_right .trinputlogin .tdinputlogin:focus-within, #login_right span.select2-container:focus-within {
		border-color: #<?php echo $inputs_hover_border_color; ?> !important;
		outline: 0;
		box-shadow: 0 0 0 2px rgba(<?php echo join(',', colorStringToArray($inputs_hover_border_color)); ?>, 0.25);
	}

	#login_right span.fa {
		border-right: 1px solid #e4e7ea;
		padding: 8px 12px;
	}

	.login_table .tdinputlogin .fa {
		width: auto !important;
	}

	.login_table .trinputlogin {
		font-size: 1em !important;
		margin: 0 !important;
	}

	<?php } else { ?>

	#login_right tr td > span {
		display: flex;
		background-color: #fff;
		background-image: none !important;
		border: 1px solid #e4e7ea;
		border-radius: <?php echo $border_radius; ?> !important;
		padding: 6px 0;
		margin-bottom: 20px;
		overflow: hidden;
	}

	#login_right tr td > span:focus-within {
		border-color: #<?php echo $inputs_hover_border_color; ?> !important;
		outline: 0;
		box-shadow: 0 0 0 2px rgba(<?php echo join(',', colorStringToArray($inputs_hover_border_color)); ?>, 0.25);
	}

	#login_right span.fa::before {
		border-right: 1px solid #e4e7ea;
		padding: 8px 12px;
	}

	#img_securitycode, #captcha_refresh_img {
		margin-top: -20px;
	}

	<?php } ?>

	#login_right span.select2-container, #login_right span.select2-container > span.selection {
		width: 100% !important;
		text-align: center;
	}

	#login_right span.select2-selection {
		border: none !important;
		height: auto !important;
	}

	#login_right span.select2-container > span.selection > span {
		color: #495057;
	}

	#login_right span.select2-selection__arrow {
		top: 6px !important;
		right: 6px !important;
	}

	#login_right span.fa::before {
		font-size: 13px;
		color: #5c6873;
	}

	#login_right input {
		font-size: 14px;
		border: none !important;
		padding: 6px 12px !important;
		color: #495057;
		width: 100%;
		overflow: hidden;
	}

	#login_line2 .button {
		background-color: #<?php echo $button_back_color; ?> !important;
		border: 1px solid #<?php echo $button_border_color; ?> !important;
		color: #<?php echo $button_text_color; ?> !important;
		padding: 15px 20px;
		font-size: 14px;
		font-weight: bold;
		margin-bottom: 20px;
		border-radius: <?php echo $border_radius; ?> !important;
		width: 100%;
		cursor: pointer;
		opacity: 0.9;
	}

	#login_line2 .button:hover {
		opacity: 1;
	}

	#login_line2 .button::-moz-focus-inner {
		border: 0;
	}

	#login_line2 a {
		color: #<?php echo $links_color; ?> !important;
		font-size: 13px;
	}

	#img_securitycode {
		border: 1px solid #e4e7ea;
	}

	#img_securitycode, #captcha_refresh_img {
		vertical-align: middle;
		margin-left: 5px;
	}

	.login_main_home {
		max-width: 100% !important;
	}

	.passwordmessagedesc {
		color: #9aa0ac !important;
		font-size: 12px;
	}
	<?php
}
