<?php

/**
 * Class ActionsThemeCustomizer
 */
class ActionsThemeCustomizer
{
    /**
     * Customize Dolibarr theme
     *
     */
    public function customizeTheme()
    {
        // Note: changes on style.css.php file will not work from here, because hooks are not loaded when calling this css file
        // so don't try to modify $conf proprieties used in the style css file here & keep wondering why they not work..

        global $user, $conf;

        // Top Menu
        if (isset($user->conf->HIDE_TOPMENU)) {
            $conf->dol_hide_topmenu = $user->conf->HIDE_TOPMENU;
        }

        // Help link
        if (isset($user->conf->DISABLE_HELP_LINK)) {
            $conf->global->MAIN_HELP_DISABLELINK = $user->conf->DISABLE_HELP_LINK;
        }

        // Left Menu
        if (isset($user->conf->HIDE_LEFTMENU)) {
            $conf->dol_hide_leftmenu = $user->conf->HIDE_LEFTMENU;
        }

        // Company logo
        if (isset($user->conf->HIDE_COMPANY_LOGO)) {
            $conf->global->MAIN_SHOW_LOGO = ! $user->conf->HIDE_COMPANY_LOGO;
        }

        // Invert menu
        if (isset($user->conf->INVERT_MENU)) {
            $conf->global->MAIN_MENU_INVERT = $user->conf->INVERT_MENU;
        }

        // Hide disabled menus
        if (isset($user->conf->HIDE_DISABLED_MENUS)) {
            $conf->global->MAIN_MENU_HIDE_UNAUTHORIZED = $user->conf->HIDE_DISABLED_MENUS;
        }

        // Optimize for small screens
        if (isset($user->conf->OPTIMIZE_SMALLSCREEN)) {
            $conf->dol_optimize_smallscreen = $user->conf->OPTIMIZE_SMALLSCREEN;
        }

        // Set Graphs colors
        $dolibarr_version = explode('.', DOL_VERSION);
        $file_name = ((int)$dolibarr_version[0] >= 10 ? "theme_vars.inc.php" : "graph-color.php");
        $color_file = DOL_DOCUMENT_ROOT."/theme/".$conf->theme."/".$file_name;
        if (is_readable($color_file))
        {
            include_once $color_file;
            require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';

            global $theme_datacolor;

            for ($i = 0; $i < 12; $i++)
            {
                $const_name = 'GRAPH_COLOR_'.($i+1);

                if (isset($user->conf->$const_name) && ! empty($user->conf->$const_name)) {
                    $theme_datacolor[$i] = colorStringToArray($user->conf->$const_name);
                }
            }
        }
    }

    /**
     * Overloading afterLogin function
     *
     * @param   array()         $parameters     Hook metadatas (context, etc...)
     * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     * @param   string          &$action        Current action (if set). Generally create or edit or null
     * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
     * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
     */
    public function afterLogin($parameters, &$object, &$action, $hookmanager)
    {
        if (in_array('login', explode(':', $parameters['context'])))
        {
            $this->customizeTheme();
        }

        return 0;
    }

	/**
     * Overloading updateSession function
     *
     * @param   array()         $parameters     Hook metadatas (context, etc...)
     * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     * @param   string          &$action        Current action (if set). Generally create or edit or null
     * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
     * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
     */
	public function updateSession($parameters, &$object, &$action, $hookmanager)
	{
        if (in_array('main', explode(':', $parameters['context'])))
        {
            $this->customizeTheme();
        }

        return 0;
	}

    /**
     * Overloading printSearchForm function
     *
     * @param   array()         $parameters     Hook metadatas (context, etc...)
     * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     * @param   string          &$action        Current action (if set). Generally create or edit or null
     * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
     * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
     */
    public function printSearchForm($parameters, &$object, &$action, $hookmanager)
    {
        if (in_array('searchform', explode(':', $parameters['context'])))
        {
            global $user;

            if (isset($user->conf->HIDE_SEARCH_FORM) && $user->conf->HIDE_SEARCH_FORM)
            {
                $this->resPrint = '';

                return 1;
            }
        }

        return 0;
    }
}
