<?php

// Load Dolibase
include_once 'autoload.php';

// Load Dolibase Page class
dolibase_include_once('/core/pages/setup.php');

// Create Page using Dolibase
$page = new SetupPage("ThemeCustomizer", '$user->rights->theme_customizer->customize', true);
$page->setTitleLink(DOL_URL_ROOT.'/admin/ihm.php?mainmenu=home', 'GoToDisplaySettings');

// Get parameters
$action = GETPOST('action', 'alpha');

global $db, $conf, $user;

// Set Actions
if (preg_match('/^(set|del)_(.*)/', $action, $reg))
{
	$param = $reg[2];
	$value = (is_submitted($param) ? GETPOST($param) : ($action[0] == 's' ? 1 : 0));

	if (dol_set_user_param($db, $conf, $user, array('THEME_ELDY_ENABLE_PERSONALIZED' => '1', $param => $value)))
	{
		dolibase_redirect($_SERVER["PHP_SELF"].'?mainmenu=home');
	}
	else
	{
		dol_print_error($db);
	}
}

// Set Tabs
$page->addTab("General", "/themecustomizer/index.php?mainmenu=home");
$page->addTab("Menus", "/themecustomizer/menus.php?mainmenu=home");
$page->addTab("Body", "/themecustomizer/body.php?mainmenu=home", true);
$page->addTab("Buttons", "/themecustomizer/buttons.php?mainmenu=home");
$page->addTab("Graphs", "/themecustomizer/graphs.php?mainmenu=home");
if ($user->admin) {
	$page->addTab("LoginPage", "/themecustomizer/login_page.php?mainmenu=home");
}
$page->addTab("Advanced", "/themecustomizer/advanced.php?mainmenu=home");

$page->begin();

// Page Body
$table_header = array(
	array('name' => 'Body'),
	array('name' => '', 'attr' => 'align="center" width="100"')
);

$page->openTable($table_header);

$option_name = "THEME_ELDY_BACKBODY";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_BACKBODY) ? $user->conf->THEME_ELDY_BACKBODY : '';
$page->addColorOption("BodyBackColor", $option_name);
/*
$option_name = "THEME_ELDY_TEXT";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_TEXT) ? $user->conf->THEME_ELDY_TEXT : '';
$page->addColorOption("BodyTextColor", $option_name);
*/
$option_name = "THEME_ELDY_FONT_SIZE1";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_FONT_SIZE1) ? $user->conf->THEME_ELDY_FONT_SIZE1 : '';
$page->addNumberOption("BodyTextSize", $option_name, 8, 30, '', 350);

$option_name = "THEME_ELDY_TEXTTITLENOTAB";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_TEXTTITLENOTAB) ? $user->conf->THEME_ELDY_TEXTTITLENOTAB : '';
$page->addColorOption("TitleColor", $option_name);

$option_name = "THEME_ELDY_TEXTLINK";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_TEXTLINK) ? $user->conf->THEME_ELDY_TEXTLINK : '';
$page->addColorOption("LinksColor", $option_name);

$page->closeTable();

// Tables
$page->addLineBreak();

$table_header[0]['name'] = 'Tables';

$page->openTable($table_header);

$option_name = "THEME_ELDY_BACKTITLE1";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_BACKTITLE1) ? $user->conf->THEME_ELDY_BACKTITLE1 : '';
$page->addColorOption("TableHeaderBackColor", $option_name);

$option_name = "THEME_ELDY_LINEIMPAIR1";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_LINEIMPAIR1) ? $user->conf->THEME_ELDY_LINEIMPAIR1 : '';
$page->addColorOption("OddLineBackColor", $option_name);

$option_name = "THEME_ELDY_LINEPAIR1";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_LINEPAIR1) ? $user->conf->THEME_ELDY_LINEPAIR1 : '';
$page->addColorOption("EvenLineBackColor", $option_name);

$option_name = "THEME_ELDY_USE_HOVER";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_USE_HOVER) ? $user->conf->THEME_ELDY_USE_HOVER : false;
$page->addSwitchOption("UseHover", $option_name);

if (isset($user->conf->THEME_ELDY_USE_HOVER))
{
	$option_name = "THEME_ELDY_USE_HOVER";
	$conf->global->$option_name = isset($user->conf->THEME_ELDY_USE_HOVER) ? $user->conf->THEME_ELDY_USE_HOVER : '';
	$page->addColorOption("HoverColor", $option_name);
}

$option_name = "TABLE_TOPBORDER_COLOR";
$conf->global->$option_name = isset($user->conf->TABLE_TOPBORDER_COLOR) ? $user->conf->TABLE_TOPBORDER_COLOR : '';
$page->addColorOption("TableTopBorderColor", $option_name);

$page->closeTable();

// Tabs
$page->addLineBreak();

$table_header[0]['name'] = 'Tabs';

$page->openTable($table_header);

$option_name = "THEME_ELDY_BACKTABCARD1";
$conf->global->$option_name = isset($user->conf->THEME_ELDY_BACKTABCARD1) ? $user->conf->THEME_ELDY_BACKTABCARD1 : '';
$page->addColorOption("TabBackColor", $option_name);

$option_name = "ACTIVETAB_TOPBORDER_COLOR";
$conf->global->$option_name = isset($user->conf->ACTIVETAB_TOPBORDER_COLOR) ? $user->conf->ACTIVETAB_TOPBORDER_COLOR : '';
$page->addColorOption("ActiveTabTopBorderColor", $option_name);

$page->closeTable();

// Other
$page->addLineBreak();

$table_header[0]['name'] = 'Other';

$page->openTable($table_header);

$option_name = "LIST_ALLOW_TEXT_OVERFLOW";
$conf->global->$option_name = isset($user->conf->LIST_ALLOW_TEXT_OVERFLOW) ? $user->conf->LIST_ALLOW_TEXT_OVERFLOW : false;
$page->addSwitchOption("AllowTextOverflowOnLists", $option_name);

if (compare_version(DOL_VERSION, '<' ,'7.0.0')) // not work well on Dolibarr 7.0.x
{
	$option_name = "OPTIMIZE_SMALLSCREEN";
	$conf->global->$option_name = isset($user->conf->OPTIMIZE_SMALLSCREEN) ? $user->conf->OPTIMIZE_SMALLSCREEN : false;
	$page->addSwitchOption("OptimizeForSmallScreen", $option_name);
}

$page->closeTable();

// Clear Cache notice
$page->addLineBreak();

echo info_admin($langs->trans('ClearCacheNotice'));

$page->end();
