<?php
/* Copyright (C) 2010-2014 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2010      Regis Houssin        <regis.houssin@inodbox.com>
 * Copyright (C) 2012-2015 Juanjo Menent        <jmenent@2byte.es>
 * Copyright (C) 2013      Cédric Salvador      <csalvador@gpcsolutions.fr>
 * Copyright (C) 2015      Marcos García        <marcosgdf@gmail.com>
 * Copyright (C) 2018	   Ferran Marcet        <fmarcet@2byte.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

/**
 *  \file		htdocs/core/menus/standard/themeadmin.lib.php
 *  \brief		Library for file themeadmin menus
 */
require_once DOL_DOCUMENT_ROOT.'/core/class/menubase.class.php';


$ardolv = DOL_VERSION;
$ardolv = explode(".", $ardolv);
$dolvs = $ardolv[0];

dol_include_once('/themeadmin/core/menus/standard/versions/'.$dolvs.'-0-0.php');

/**
 * Core function to output top menu themeadmin
 *
 * @param 	DoliDB	$db				Database handler
 * @param 	string	$atarget		Target (Example: '' or '_top')
 * @param 	int		$type_user     	0=Menu for backoffice, 1=Menu for front office
 * @param  	array	$tabMenu        If array with menu entries already loaded, we put this array here (in most cases, it's empty)
 * @param	Menu	$menu			Object Menu to return back list of menu entries
 * @param	int		$noout			1=Disable output (Initialise &$menu only).
 * @param	string	$mode			'top', 'topnb', 'left', 'jmobile'
 * @return	int						0
 */
function print_themeadmin_menu($db,$atarget,$type_user,&$tabMenu,&$menu,$noout=0,$mode='',$moredata=null)
{
	global $user,$conf,$langs,$dolibarr_main_db_name,$mysoc;
	// if (empty($conf->global->MAIN_MENU_INVERT) && empty($noout) && ! empty($conf->global->MAIN_SHOW_LOGO) && empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
	// if (empty($conf->global->MAIN_MENU_INVERT) && empty($noout) && empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
	// {
	// 	$mysoc->logo_mini=$conf->global->MAIN_INFO_SOCIETE_LOGO_MINI;
	// 	if (! empty($mysoc->logo_mini) && is_readable($conf->mycompany->dir_output.'/logos/thumbs/'.$mysoc->logo_mini))
	// 	{
	// 		$urllogo=DOL_URL_ROOT.'/viewimage.php?cache=1&amp;modulepart=mycompany&amp;file='.urlencode('logos/thumbs/'.$mysoc->logo_mini);
	// 	}
	// 	else
	// 	{
	// 		$urllogo=DOL_URL_ROOT.'/theme/dolibarr_logo.png';
	// 	}
	// 	$title=$langs->trans("GoIntoSetupToChangeLogo");
	// 	print "\n".'<!-- Show logo on menu -->'."\n";
	// 	print '<div class="top-menu-10">'."\n";
	// 		print '<div class="menu_contenu" id="menu_contenu_logo">';

	// 			print '<div class="logo" >';
	// 				print '<img class="mycompany" title="'.dol_escape_htmltag($title).'" alt="" src="'.$urllogo.'" style="max-width: 100%">'."\n";
	// 			print '</div>';
	// 			// print '<div style="line-height: 2.6;">';
	// 			// 	print '<img src="'.DOL_URL_ROOT.'/theme/themeadmin/img/menus/menu.png" class="icon-menu"> <input type="hidden" class="visibil" value="visible">';
	// 			// print '</div>';
	// 			print '<li class="menuhider module_dol" style="border-right:0px !important"><a class="tmenuimage" tabindex="-1" href="#">';
	// 				print '<div class="mainmenu menu topmenuimage"><span class="mainmenu tmenuimage" id="mainmenuspan_menu"></span></div>';
	// 			print '</a></li>';
	// 		print '</div>';
	// 	print '</div>'."\n";
	// }
	// print '<div><input type="hidden" id="session" value="'.$_SESSION['showmenuleft'].'" ></div>';

	print_top_menu();

}



/**
 * Output start menu array
 *
 * @return	void
 */
function print_start_menu_array()
{
    global $conf;
	print '<div class="tmenudiv" style="float:left">';

	print '<div class="scrol_div">';
	print '<ul role="navigation" style=""  class="tmenu"'.(empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER)?'':' title="Top menu"').'>';
}

/**
 * Output start menu entry
 *
 * @param	string	$idsel		Text
 * @param	string	$classname	String to add a css class
 * @param	int		$showmode	0 = hide, 1 = allowed or 2 = not allowed
 * @return	void
 */
function print_start_menu_entry($idsel,$classname,$showmode)
{
	if ($showmode)
	{
		//tobechanged
		$style_ = "";
		if ($idsel == "menu") {
			$style_ = 'style="display:none;"';
		}
		print '<li '.$classname.' id="mainmenutd_'.$idsel.'" '.$style_.'>';
		//print '<div class="tmenuleft tmenusep"></div>';
		// print '<div class="tmenucenter">';
	}
}

/**
 * Output menu entry
 *
 * @param	string	$text		Text
 * @param	int		$showmode	0 = hide, 1 = allowed or 2 = not allowed
 * @param	string	$url		Url
 * @param	string	$id			Id
 * @param	string	$idsel		Id sel
 * @param	string	$classname	Class name
 * @param	string	$atarget	Target
 * @return	void
 */
function print_text_menu_entry($text, $showmode, $url, $id, $idsel, $classname, $atarget)
{
	global $langs;

	if ($showmode == 1)
	{
		//tobechanged
		// print '<span class="themeadminiconopenmenu fa fa-chevron-right login-dropdown-btn"></span>';
		print '<a class="tmenuimage" style="text-align:center;" tabindex="-1" href="'.$url.'"'.($atarget?' target="'.$atarget.'"':'').'>';
		print '<div class="icon-'.$idsel.' '.$id.' '.$idsel.' "></div>';
		// print '<div class="'.$id.' '.$idsel.' topmenuimage"><span class="'.$id.' tmenuimage" id="mainmenuspan_'.$idsel.'"></span></div>';
		// print '</a>';
		// print '<a '.$classname.' id="mainmenua_'.$idsel.'" href="'.$url.'"'.($atarget?' target="'.$atarget.'"':'').'>';
		// print '<div class="mainmenuaspan"><b>';
		// print $text;
		// print '</b></div>';
		print '</a>';
	}
	if ($showmode == 2)
	{
		// print '<div class="'.$id.' '.$idsel.' topmenuimage tmenudisabled"><span class="'.$id.'" id="mainmenuspan_'.$idsel.'"></span></div>';
		print '<a class="tmenudisabled" id="mainmenua_'.$idsel.'" href="#" title="'.dol_escape_htmltag($langs->trans("NotAllowed")).'">';
		// print '<span class="mainmenuaspan">';
		// print $text;
		// print '</span>';
		print '</a>';
	}
}

/**
 * Output end menu entry
 *
 * @param	int		$showmode	0 = hide, 1 = allowed or 2 = not allowed
 * @return	void
 */
function print_end_menu_entry($showmode)
{
	if ($showmode)
	{
		//tobechanged
		print '</li>';
		// print '</div></li>';
	}
	print "\n";
}

/**
 * Output menu array
 *
 * @return	void
 */
function print_end_menu_array()
{
	global $user,$conf,$langs,$dolibarr_main_db_name,$mysoc;

	print '</ul>';
	print '</div>';
	print '</div>';
 
	print "\n";
	?>
	<script type="text/javascript">
		// jQuery(document).ready(function() {
		//     /* If page_y set, we set scollbar with it */
		// 	page_y=getParameterByName('page_y', 0);				/* search in GET parameter */
		// 	if (page_y == 0) page_y = jQuery("#page_y").text();		/* search in POST parameter that is filed at bottom of page */
		// 	if (page_y > 0)
		// 	{
		// 		// console.log("page_y found is "+page_y);
		// 		$('#id-right').scrollTop(page_y);
		// 	}

		// });
	</script>
	<?php
}



/**
 * Core function to output left menu themeadmin
 * Fill &$menu (example with $forcemainmenu='home' $forceleftmenu='all', return left menu tree of Home)
 *
 * @param	DoliDB		$db                 Database handler
 * @param 	array		$menu_array_before  Table of menu entries to show before entries of menu handler (menu->liste filled with menu->add)
 * @param   array		$menu_array_after   Table of menu entries to show after entries of menu handler (menu->liste filled with menu->add)
 * @param	array		$tabMenu       		If array with menu entries already loaded, we put this array here (in most cases, it's empty)
 * @param	Menu		$menu				Object Menu to return back list of menu entries
 * @param	int			$noout				Disable output (Initialise &$menu only).
 * @param	string		$forcemainmenu		'x'=Force mainmenu to mainmenu='x'
 * @param	string		$forceleftmenu		'all'=Force leftmenu to '' (= all). If value come being '', we change it to value in session and 'none' if not defined in session.
 * @param	array		$moredata			An array with more data to output
 * @return	int								nb of menu entries
 */
function print_left_themeadmin_menu($db, $menu_array_before, $menu_array_after, &$tabMenu, &$menu, $noout = 0, $forcemainmenu = '', $forceleftmenu = '', $moredata = null)
{
	global $user,$conf,$langs,$dolibarr_main_db_name,$mysoc;

	$mainmenu=(empty($_SESSION["mainmenu"])?'':$_SESSION["mainmenu"]);
	$leftmenu=(empty($_SESSION["leftmenu"])?'':$_SESSION["leftmenu"]);

	$leftmenu = '';

	$id='mainmenu';
	$listofmodulesforexternal=explode(',', $conf->global->MAIN_MODULES_FOR_EXTERNAL);


    
    if (is_array($moredata) && ! empty($moredata['searchform']))	// searchform can contains select2 code or link to show old search form or link to switch on search page
	{
	    print "\n";
	    print "<!-- Begin SearchForm -->\n";
	    print '<div id="blockvmenusearch" class="blockvmenusearch">'."\n";
	    print $moredata['searchform'];
	    print '</div>'."\n";
	    print "<!-- End SearchForm -->\n";
	}

	if (is_array($moredata) && ! empty($moredata['bookmarks']))
	{
	    print "\n";
	    print "<!-- Begin Bookmarks -->\n";
	    print '<div id="blockvmenubookmarks" class="blockvmenubookmarks">'."\n";
	    print $moredata['bookmarks'];
	    print '</div>'."\n";
	    print "<!-- End Bookmarks -->\n";
	}

	if (empty($noout)) print_start_menu_array();

    $usemenuhider = 1;

	// Show/Hide vertical menu
	if ($mode != 'jmobile' && $mode != 'topnb' && $usemenuhider && empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
	{
    	$showmode=1;
    	// $classname = 'class="tmenu menuhider"';
    	// $idsel='menu';

    	// $menu->add('#', '', 0, $showmode, $atarget, "xxx", '', 0, $id, $idsel, $classname);
	}


	$menu_arr = array_menu_left();
	// Add menus
	foreach($menu_arr as $key => $smenu)
	{
		$smenu = (object) $smenu;

		if ($smenu->enabled)
		{
			if ($smenu->session)
			{
				$_SESSION['idmenu'] = '';
			}

			// Load Langue
			if(! empty($smenu->loadLangs))
			{
				$langs->loadLangs($smenu->loadLangs);
			}

			// Trans title
			$mtitle = '';
			if(is_array($smenu->title))
			{
				foreach($smenu->title as $item)
				{
					$mtitle .=  $langs->trans($item);
				}
			}
			else
			{
				$mtitle =  $langs->trans($smenu->title);
			}
			// Add item
			$menu->add($smenu->link, $mtitle, $smenu->level, $smenu->enabled, $smenu->target, $smenu->mainmenu, $smenu->leftmenu, $smenu->position, $smenu->id, $smenu->idsel, $smenu->classname, $smenu->prefix);
		}
	}

	// Show personalized menus
	$menuArbo = new Menubase($db, 'eldy');
	$newTabMenu = $menuArbo->menuTopCharger('', '', $type_user, 'eldy', $tabMenu);	// Return tabMenu with only top entries
	$num = count($newTabMenu);
	for($i = 0; $i < $num; $i++)
	{
		$idsel=(empty($newTabMenu[$i]['mainmenu'])?'none':$newTabMenu[$i]['mainmenu']);

		$showmode=isVisibleToUserType($type_user, $newTabMenu[$i], $listofmodulesforexternal);
		if ($showmode == 1)
		{
			$substitarray = array('__LOGIN__' => $user->login, '__USER_ID__' => $user->id, '__USER_SUPERVISOR_ID__' => $user->fk_user);
			$substitarray['__USERID__'] = $user->id;	// For backward compatibility
			$newTabMenu[$i]['url'] = make_substitutions($newTabMenu[$i]['url'], $substitarray);

		    // url = url from host, shorturl = relative path into dolibarr sources
			$url = $shorturl = $newTabMenu[$i]['url'];
			if (! preg_match("/^(http:\/\/|https:\/\/)/i", $newTabMenu[$i]['url']))	// Do not change url content for external links
			{
				$tmp=explode('?', $newTabMenu[$i]['url'], 2);
				$url = $shorturl = $tmp[0];
				$param = (isset($tmp[1])?$tmp[1]:'');

				if (! preg_match('/mainmenu/i', $param) || ! preg_match('/leftmenu/i', $param)) $param.=($param?'&':'').'mainmenu='.$newTabMenu[$i]['mainmenu'].'&amp;leftmenu=';
				//$url.="idmenu=".$newTabMenu[$i]['rowid'];    // Already done by menuLoad
				$url = dol_buildpath($url, 1).($param?'?'.$param:'');
				//$shorturl = $shorturl.($param?'?'.$param:'');
                $shorturl = $url;
				if (DOL_URL_ROOT) $shorturl = preg_replace('/^'.preg_quote(DOL_URL_ROOT, '/').'/', '', $shorturl);
			}

			// Define the class (top menu selected or not)
			if (! empty($_SESSION['idmenu']) && $newTabMenu[$i]['rowid'] == $_SESSION['idmenu']) $classname='class="tmenusel"';
			elseif (! empty($_SESSION["mainmenu"]) && $newTabMenu[$i]['mainmenu'] == $_SESSION["mainmenu"]) $classname='class="tmenusel"';
			else $classname='class="tmenu"';
		}
		elseif ($showmode == 2) $classname='class="tmenu"';

		$menu->add($shorturl, $newTabMenu[$i]['titre'], 0, $showmode, ($newTabMenu[$i]['target']?$newTabMenu[$i]['target']:$atarget), ($newTabMenu[$i]['mainmenu']?$newTabMenu[$i]['mainmenu']:$newTabMenu[$i]['rowid']), ($newTabMenu[$i]['leftmenu']?$newTabMenu[$i]['leftmenu']:''), $newTabMenu[$i]['position'], $id, $idsel, $classname);
	}



	// Sort on position
	$menu->liste = dol_sort_array($menu->liste, 'position');
	// print_r($menu->liste);
    // Output menu entries
    $titre = '';
    if (empty($noout)) {
        foreach($menu->liste as $menkey => $menuval) {
            print_start_menu_entry($menuval['idsel'], $menuval['classname'], $menuval['enabled']);
            print_text_menu_entry($menuval['titre'], $menuval['enabled'], (($menuval['url']!='#' && !preg_match('/^(http:\/\/|https:\/\/)/i', $menuval['url'])) ? DOL_URL_ROOT:'').$menuval['url'], $menuval['id'], $menuval['idsel'], $menuval['classname'], ($menuval['target']?$menuval['target']:$atarget));
            // print_title_soumenu();
            print_sous_menu($db,$menu_array,$menu_array_after,$tabMenu,$menu,0,'','',$menkey,$menuval['idsel'],$menuval['titre']);
            print_end_menu_entry($menuval['enabled']);
            if($menuval['idsel'] == $mainmenu){
            	$titre = $menuval['titre'];
            }
        }

    }


	
	$showmode=1;
    if (empty($noout)) {
        print_start_menu_entry('', 'class="tmenuend"', $showmode);
        print_end_menu_entry($showmode);
        print_end_menu_array();
    }

    print '<div style="float:left" class="ddd">';
		$namemenu = ($mainmenu ? $mainmenu : $leftmenu);
		print_sous_menu($db,$menu_array,$menu_array_after,$tabMenu,$menu,0,'','',$menkey,$namemenu,$titre);
    print '</div>';


    // if($mainmenu == 'home'){

    	
    	
	    $arr_colors = [
	        'members' => '#79633f',
	        'hrm' => '#755114',
	        'expensereport' => '#79633f',
	        'thirdparties' => '#599caf',
	        'thirdparties' => '#599caf',
	        'companies' => '#599caf',
	        'commercial' => '#599caf',
	        'projet' => '#6c6a98',
	        'agenda' => '#b46080',
	        'billing' => '#99a17d',
	        'commande' => '#99a17d',
	        'commercial' => '#99a17d',
	        'accountancy' => '#dc9246',
	    ];




    	?>
		<script type="text/javascript" src="<?php echo dol_buildpath("/themeadmin/js/jquery.slimscroll.min.js",2) ?>"></script>

    	<style>
    		
			.parent_tabbord{
			    width: 100%;
			}
			.child_div{
			    width:25%;
			    float:left;
			    margin-bottom: 20px;
			}
			.child_tabbord_1{
			    padding:10px;
			    float : left;
			    width: 95%;
			    /*height: 90px !important;*/
			    border-radius:4px;
			    border-bottom: 3px solid #00c292;
			    border-right: 3px solid #00c292;
			    background-color: #ffffff;
			}
			.tab_visiteurs{
			    color: #00c292 !important;
			    font-size: 14px;
			}
			.child_tabbord_2{
			    padding:10px;
			    float : left;
			    width: 95%;
			    /*height: 90px !important;*/
			    border-radius:4px;
			    border-bottom: 3px solid #ffb463;
			    border-right: 3px solid #ffb463;
			    background-color: #ffffff;
			}
			.tab_projets{
			    color: #ffb463 !important;
			    font-size: 14px;
			}
			.child_tabbord_3{
			    padding:10px;
			    float : left;
			    width: 95%;
			    /*height: 90px !important;*/
			    border-radius:4px;
			    border-bottom: 3px solid #9dc9e3;
			    border-right: 3px solid #9dc9e3;
			    background-color: #ffffff;
			}
			.tab_notifications{
			    color: #9dc9e3 !important;
			    font-size: 14px;
			}
			.child_tabbord_4{
			    padding:10px;
			    float : left;
			    width: 95%;
			    /*height: 90px !important;*/
			    border-radius:4px;
			    border-bottom: 3px solid #cccc12;
			    border-right: 3px solid #cccc12;
			    background-color: #ffffff;
			}
			.tab_emailing{
			    color: #cccc12 !important;
			    font-size: 14px;
			}
			.users_icon{
			    /*font-famil y: dolibarr-icons;*/
			    float: right;
			    font-size: 25px;
			    color: #fff;
			    background: #00c292;
			    border-radius: 50%;
			    padding: 10px  34px 11px 13px;
			}

			.notif_icon{
			    /*font-family: dolibarr-icons;*/
			    float: right;
			    font-size: 25px;
			    color: #fff;
			    background: #9dc9e3;
			    border-radius: 50%;
			    padding: 11px 15px;
			}
			.proj_icon{
			    float: right;
			    font-size: 25px;
			    color: #fff;
			    background: #ffb463;
			    border-radius: 50%;
			    padding: 11px 35px 11px 12px;
			}
			.emails_icon{
			    float: right;
			    font-size: 25px;
			    color: #fff;
			    background: #cccc12;
			    border-radius: 50%;
			    padding: 11px 35px 11px 11px;
			}
			span.elem_tab {
			    font-size: 11px !important;
			    color: #09355b;
			}
			#mainmenutd_<?php echo $mainmenu ?>{
				background: #e9eaed;
			}

			table.table-fiche-title{
			    background-color: <?php echo $arr_colors[$mainmenu]; ?> !important;
			}

			div.fiche table.notopnoleftnoright{
			    background-color: <?php echo $arr_colors[$mainmenu]; ?> !important;
			}

    	</style>
    	<?php
	// }
	?>
	<script>
		var h_top = $("#tmenu_tooltip").height()-1;
			    // var to_scroll = $( 'div[data-actif="nc_actif_element"]' ).parent("li");
		    	// var to_scroll2 = $( 'a[data-actif="nc_actif_element"]' ).parent("li");
			    // $( '#id-container > #id-right').css("height","calc(100vh - "+h_top+"px)");
				$( 'div[data-actif="nc_actif_element"]' ).parent("li").attr("data-actif","nc_actif_element");
				$( 'div[data-actif="nc_actif_element"]' ).parent("li").children("a").attr("data-actif","nc_actif_element");
				$( '.icon-plus-filter.search_icons_container').parent("td").css("width","70px");
				$( '.icon-plus-filter.search_icons_container').parent().parent("td").css("width","70px");
				// $( '#id-container > .side-nav > #id-left' ).append( '<div _ngcontent-c0="" class="sidebar-background"></div>' );
				$( '#id-left > .vmenu' ).wrap( "<div id='inner-content-div'></div>" );
			    // $('#inner-content-div').slimScroll({
			    //     height: 'calc(100vh - '+h_top+'px)'
			    // });
				$('#inner-content-div').height('calc(85vh - '+h_top+'px)');
			    sizes_calc();
	</script>
	<?php
	return 0;
}



?>
<script type="text/javascript" src="<?php echo dol_buildpath('/themeadmin/js/jquery.slimscroll.min.js',2)?>"></script>

<script>
	$(window).on('load',function(){


		$('#inner-content-sousmenu ul').slimScroll({
			height : '85vh',
    	});
		$('.scrol_div').slimScroll({
			height : '85vh',
    	});
		$mainmenu = '<?php echo GETPOST('mainmenu') ;?>';
		$leftmenu = '<?php echo GETPOST('leftmenu') ;?>';
		$menu='';
		if($mainmenu){
			$menu = $mainmenu;
		}else if($leftmenu){
			$menu = $leftmenu;
		}
		$('#mainmenutd_'+$menu).addClass('li-visited');

		// $('.login_block_other').append(' <img src="<?php echo dol_buildpath("/themeadmin/img/icon-right.png",2)?>" style="display:none;" class="img_right">');

	    var h_top = $("#tmenu_tooltip").height();

		$( '#id-left > .vmenu' ).wrap( "<div id='inner-content-div'></div>" );
		    	
	    $(".login_block_other").hover(function(){
    		// console.log(window.innerWidth);
			if(window.innerWidth <= 750){
    			// console.log('width-screen:'+window.innerWidth);
		     	$('.login_block_other').find('.inline-block').css('display','block');
		     	$('.login_block_other').css('display','-webkit-box');
			}
	    },function(){
			if(window.innerWidth <= 750){
	     		$('.login_block_other').find('.inline-block').css('display','none');
	     	}
	    });


	    $("li.tmenu, li.tmenusel").hover(function(){
	    	// $('ul.vmenu').hide();
	    	var id=$(this).attr('id');
	    	id = id.split('mainmenutd_');
	    	$(this).css('background','#dbdce2');
	    	if(id[1] != 'menu'){
		    	//get top left-menu
		    	$top_1=$(this).position().top;
		    	$top = $top_1 + h_top;

		    	$ht_li = $(this).height();
		    	$('.ddd').find('.sous-menu').remove();
		    	$('.ddd').append('<div class="sous-menu">'+$(this).find('.sous-menu').html()+'</div>');
	    		$('.ddd').find('.sous-menu ul').wrap( "<div id='inner-content-sousmenu'></div>" );
	    		$('#inner-content-sousmenu ul').slimScroll({
		    			height : '85vh',
		    	});

	    	}
    		// $('#id-left div.tmenudiv').slimScroll({
    		// 	height : '100vh',
    		// });

	    	// $ht = $top + $('#inner-content-sousmenu ul').height();
	    	// height_total = $('#inner-content-div').height();

    		// $('.sous-menu .slimScrollDiv').css('height',0);
    		// $('#id-left .slimScrollDiv').css('height',0);
	  
		}, function(){
	    	$(this).css('background','#fff');
	    	// $(this).find('.slimScrollDiv').unwrap();
	    	// $(this).find('.sous-menu ul').unwrap();
	    	// $('.slimScrollBar').remove();
	    	// $('.slimScrollRail').remove();
	    	// $(this).find('ul').hide();
		});

	});
</script>


