<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file		lib/events.lib.php
 *	\ingroup	events
 *	\brief		This file is an example module library
 *				Put some comments here
 */

/**
 *  Return array head with list of tabs to view object informations.
 *
 *  @return array               head array with tabs
 */
function suivisav_prepare_head($id)
{
    global $db, $langs, $conf;

    $h = 0;
    $head = array();
    $id = ($id? $id :GETPOST("id"));
    $head[$h][0] = dol_buildpath("/suivisav/card.php?id=".$id, 1);
    $head[$h][1] = $langs->trans('suivisav');
    $head[$h][2] = 'card';
    $h++;

    $head[$h][0] = dol_buildpath("/suivisav/agenda.php?id_suivi=".$id, 1);;
    $head[$h][1] = $langs->trans('Events');
    $head[$h][2] = 'agenda';
    $h++;

    return $head;
}
function SuiviSavHead()
{
    global $langs, $conf, $db;
    $langs->load("suivisav@suivisav");

    $h = 0;
    $head = array();

    $head[$h][0] = dol_buildpath("/suivisav/admin/suivisav_setup.php", 2);
    $head[$h][1] = $langs->trans("champsuivisav");
    $head[$h][2] = 'champsuivisav';
    $h++;
    $head[$h][0] = dol_buildpath("/suivisav/admin/admin_category.php", 2);
    $head[$h][1] = $langs->trans("champsuivisav_type");
    $head[$h][2] = 'champsuivisav_type';
    $h++;

    return $head;
}
// function menu_poste($id)
// {
//     global $langs, $conf, $db;
//     $langs->load("events@events");
//     dol_include_once('/events/class/postes.class.php');
//     dol_include_once('/events/class/candidatures.class.php');

//     $h = 0;
//     $head = array();
        
//         $head[$h][0] = dol_buildpath("events/card.php?id=".$id,2);
//         $head[$h][1] = $langs->trans("general");
//         $head[$h][2] = 'general';
//         $h++;

//         $head[$h][0] = dol_buildpath("events/employe.php?poste=".$id,2);
//         $head[$h][1] = $langs->trans("candidatures");
//         $head[$h][2] = 'employes';
//         $h++;

//     return $head;
// }


