<?php
/* Copyright (C) 2017  Oubtou Mohamed <oubtou@hotmail.com>
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module MyModule
 */
class modsuivisav extends DolibarrModules
{
	/**
	 * Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * @param DoliDB $db Database handler
	 */
	public function __construct($db)
	{
        global $langs,$conf;

        $this->editor_name = 'Dolibarr Store';
		$this->editor_url = 'https://www.nextconcept.ma';


        $this->db = $db;
		$this->numero = 677720011;		
		$this->rights_class = 'suivisav';
		$this->family = "Next";
		$this->module_position = 1;
		$this->name = preg_replace('/^mod/i','',get_class($this)); 
		$this->description = "DESCRIPTION940329081";
		$this->version = '1.0';
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		$this->special = 0;
		$this->picto = 'suivisav@suivisav';

		$this->module_parts = array(
			'triggers' 	=> 1,
			'css' 		=> array('suivisav/css/suivisav.css'),
			'js' 		=> array('suivisav/js/suivisav.js'),
		);

		
		$this->dirs = array();
		$this->config_page_url = array('suivisav_setup.php@suivisav');

		// Dependencies
		$this->hidden = false;			
		$this->depends = array("modProduct","modSociete");		
		$this->requiredby = array();	
		$this->conflictwith = array();	
		$this->phpmin = array(5,0);					
		$this->need_dolibarr_version = array(3,0);	
		$this->langfiles = array("suivisav@suivisav");

		$this->const = array();

		
        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->suivisav->enabled))
        {
        	$conf->suivisav=new stdClass();
        	$conf->suivisav->enabled=0;
        }
		$this->dictionaries=array();
		$this->cronjobs = array();			
        $this->boxes = array();			

		$this->rights = array();
		$r=10;
		$r++;

		// Permission Suivis des SAV
		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Consulter';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'consulter';
		$r++;
		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Ajouter_Modifier';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'update';
		$r++;
		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Supprimer';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'delete';
		$r=0;

		// print_r($this->rights);die();

		$this->menu[$r]=array(	'fk_menu'=>0,
			'type'=>'top',
			'titre'=>'suivisav',
			'mainmenu'=>'suivisav',
			'leftmenu'=>'suivisav',
			'url'=>'/suivisav/index.php',
			'langs'=>'suivisav@suivisav',
			'position'=>100,
			'enabled'=>'1',
			'perms'=>'$user->rights->suivisav->gestion->consulter',
			'target'=>'',
			'user'=>2
		);$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=suivisav',
			'type'=>'left',
			'titre'=>'suivisav',
            'leftmenu'=>'suivisav1',
			'url'=>'/suivisav/index.php',
			'langs'=>'suivisav@suivisav',
			'position'=>101,
			'enabled'=>'1',
			'perms'=>'$user->rights->suivisav->gestion->consulter',
			'target'=>'',
			'user'=>2
		);$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=suivisav,fk_leftmenu=suivisav1',
				'type'=>'left',
				'titre'=>'Liste_des_Suivi_SAV',
				'url'=>'/suivisav/index.php',
				'langs'=>'suivisav@suivisav',
				'position'=>102,
				'enabled'=>'1',
				'perms'=>'$user->rights->suivisav->gestion->consulter',
				'target'=>'',
				'user'=>2
			);$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=suivisav,fk_leftmenu=suivisav1',
				'type'=>'left',
				'titre'=>'Ajouter_une_Suivi_SAV',
				'url'=>'/suivisav/card.php?action=add',
				'langs'=>'suivisav@suivisav',
				'position'=>103,
				'enabled'=>'1',
				'perms'=>'$user->rights->suivisav->gestion->update',
				'target'=>'',
				'user'=>2
			);$r++;


		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=suivisav',
			'type'=>'left',
			'titre'=>'Matériels_non_récupérés',
			//'mainmenu'=>'suivisav',
            'leftmenu'=>'suivisav2',
			'url'=>'/suivisav/norecup.php',
			'langs'=>'suivisav@suivisav',
			'position'=>104,
			'enabled'=>'1',
			'perms'=>'$user->rights->suivisav->gestion->consulter',
			'target'=>'',
			'user'=>2
		);$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=suivisav',
			'type'=>'left',
			'titre'=>'list_event',
			//'mainmenu'=>'suivisav',
            'leftmenu'=>'suivisav4',
			'url'=>'/suivisav/agenda.php',
			'langs'=>'suivisav@suivisav',
			'position'=>105,
			'enabled'=>'1',
			'perms'=>'$user->rights->suivisav->gestion->consulter',
			'target'=>'',
			'user'=>2
		);$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=suivisav',
			'type'=>'left',
			'titre'=>'Paramétrage',
			//'mainmenu'=>'suivisav',
            'leftmenu'=>'suivisav3',
			'url'=>'/suivisav/type/index.php',
			'langs'=>'suivisav@suivisav',
			'position'=>106,
			'enabled'=>'1',
			'perms'=>'$user->rights->suivisav->gestion->consulter',
			'target'=>'',
			'user'=>2
		);$r++;

			$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=suivisav,fk_leftmenu=suivisav3',
				'type'=>'left',
				'titre'=>'Catégories_Suivi_SAV',
				'url'=>'/suivisav/type/index.php',
				'langs'=>'suivisav@suivisav',
				'position'=>107,
				'enabled'=>'1',
				'perms'=>'$user->rights->suivisav->gestion->update',
				'target'=>'',
				'user'=>2
			);$r++;

		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=suivisav',
			'type'=>'left',
			'titre'=>'Configuration',
			//'mainmenu'=>'suivisav',
            'leftmenu'=>'suivisav5',
			'url'=>'/suivisav/admin/suivisav_setup.php',
			'langs'=>'suivisav@suivisav',
			'position'=>108,
			'enabled'=>'1',
			'perms'=>'$user->rights->suivisav->gestion->consulter',
			'target'=>'',
			'user'=>2
		);$r++;

	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */

	
	public function init($options='')
	{
		$sql = array();


		$sql1 = 'CREATE TABLE IF NOT EXISTS `'.MAIN_DB_PREFIX.'suivisav` (
		  `rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  `serie` varchar(255) NOT NULL,
		  `product` int(11) NOT NULL,
		  `client` int(11) NOT NULL,
		  `fournisseur` int(11) NOT NULL,
		  `debut` datetime DEFAULT NULL,
		  `fin` datetime DEFAULT NULL,
		  `recuperation` smallint(2) DEFAULT NULL DEFAULT "0",
		  `notes` text DEFAULT NULL,
		  `category` varchar(100) DEFAULT NULL
		);';
		$resql = $this->db->query($sql1);

		$sql2 = 'CREATE TABLE IF NOT EXISTS `'.MAIN_DB_PREFIX.'suivisav_type` (
		  `rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  `name` varchar(100) NOT NULL
		);';
		$resql2 = $this->db->query($sql2);

		$sql3 = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."suivisav_type_extrafields` (
	  		`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		    `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		    `fk_object` int(11) NOT NULL,
		    `import_key` varchar(14) DEFAULT NULL
		);";
		$resql3 = $this->db->query($sql3);

		$sql4 = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."suivisav_extrafields` (
	  		`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		    `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		    `fk_object` int(11) NOT NULL,
		    `import_key` varchar(14) DEFAULT NULL
		);";
		$resql4 = $this->db->query($sql4);


		// $this->_load_tables('/suivisav/sql/');
		return $this->_init($sql, $options);
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * @param      string	$options    Options when enabling module ('', 'noboxes')
	 * @return     int             	1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = $this->dropTables();

		return $this->_remove($sql, $options);
	}


	private function dropTables()
	{
		return array(
		);
		/*return array(
			'DROP TABLE `llx_reception`',
		);*/
	}



}

