<?php 
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/commonobject.class.php'; 
include_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';


dol_include_once('/suivisav/core/modules/modsuivisav.class.php');

class suivisav extends Commonobject{ 

	public $errors = array();
	public $id;
	public $rowid;
	public $clien;
	public $fournisseur;
	public $type;
	public $genre;
	public $debut;
	public $fin;


	public $element = 'suivisav';
	public $table_element = 'suivisav';
	
	public $fields = array(
        'rowid' => array('type'=>'integer', 'label'=>'rowid', 'enabled'=>1, 'visible'=>-2, 'notnull'=>1, 'index'=>1, 'position'=>1, 'comment'=>'Id'),
    );

	public function __construct(DoliDBMysqli $db){ 
		$this->db = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        if(!$setRef)
        	$setRef = (null !== $this->serie) ? $this->serie : $this->id;

        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/suivisav/card.php?id='. $id,2) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@lproduction';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        $result = $link."<div class='icon-accessoire mainvmenu'></div>  ".$setRef.$linkend;
        return $result;
    }

	public function create($echo_sql=0)
	{

		$sql  = "INSERT INTO " . MAIN_DB_PREFIX .get_class($this)." ";
		$sql.= " (`serie`, `product`, `client`, `fournisseur`, `debut`, `fin`, `recuperation`, `notes`, `category`)";
		
		$sql.= " VALUES (";
			
			$sql.= ($this->serie?"'".$this->db->escape($this->serie)."'":"null");
			$sql.= ", ".($this->product>0?$this->product:"null");	
			$sql.= ", ".($this->client>0?$this->client:"null");	
			$sql.= ", ".($this->fournisseur>0?$this->fournisseur:"null");	
	        $sql .= ", ".($this->debut != '' ? "'".$this->db->idate($this->debut)."'" : 'null');
	        $sql.= ", ".($this->fin != '' ? "'".$this->db->idate($this->fin)."'" : 'null');
			$sql.= ", ".($this->recuperation>0?$this->recuperation:"null");	
			$sql.= ", ".($this->notes?"'".$this->db->escape($this->notes)."'":"null");
			$sql.= ", ".($this->category>0?$this->category:"null");	

		$sql.= ")";
		$resql = $this->db->query($sql);
		if($resql){
			$this->id=$this->db->last_insert_id(MAIN_DB_PREFIX.$this->table_element);
			$result=$this->insertExtraFields();
			$this->db->commit();
			return $this->id;
		}
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			print_r($this->errors);
			die();
			return 0;
		}

	}

	public function update($id,$echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		$sql = 'UPDATE ' . MAIN_DB_PREFIX .get_class($this). ' SET ';

	    $sql .= "serie=".($this->serie ? "'".$this->db->escape($this->serie)."'":"null").', ';
	    $sql .= "product=".($this->product>0? $this->db->escape($this->product):"null").', ';
	    $sql .= "client=".($this->client>0?$this->db->escape($this->client):"null").', ';
	    $sql .= "fournisseur=".($this->fournisseur>0?$this->db->escape($this->fournisseur):"null").', ';
	    $sql .= "notes=".($this->notes ?"'".$this->db->escape($this->notes)."'":"null").', ';
	    $sql .= "debut=".($this->debut? "'".$this->debut."'" :"null").', ';
	    $sql .= "fin=".($this->fin ? "'".$this->fin."'" :"null").', ';
	    $sql .= "recuperation=".($this->recuperation>0?$this->db->escape($this->recuperation):"null").', ';
	    $sql .= "category=".($this->category>0?$this->db->escape($this->category):"null").' ';

		// $sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . $id;
		$resql = $this->db->query($sql);
		if($resql){
			$result=$this->insertExtraFields();
		}
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '. $this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function delete($echo_sql=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX .get_class($this).' WHERE rowid = ' . $this->rowid;
		// die($sql);
		// if ($echo_sql) {
		// 	echo "<br>".$sql."<br>";
		// }

		$resql 	= $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error '.get_class($this).' : '.$this->db->lasterror();
			return -1;
		} 
		return 1;
	}

	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $namproduct = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX.get_class($this);
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->rowid.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            
	            if($obj->product){
	            	$prod = new product($this->db);
	            	$prod->fetch($obj->product);
	            	$namproduct = dol_trunc($prod->label,10);
	            }
	            $moreforfilter.='>'.$obj->serie.' - '.$namproduct.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    return $moreforfilter;
	}

	public function get_item($item,$rowid)
	{
		$sql = "SELECT ".$item." FROM ".MAIN_DB_PREFIX.get_class($this)." WHERE rowid=".$rowid;

		$resql = $this->db->query($sql);
		$item ;

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$item = $obj->item;
			}
			$this->db->free($resql);
			return $item;
		}
	}

    public function getYears()
    {
    	$sql = 'SELECT YEAR(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this);
    	$resql = $this->db->query($sql);
    	$years = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$years[$obj->years] = $obj->years;
			}
			$this->db->free($resql);
    	}

    	return $years;
    }

    public function getmonth($year)
    {
    	$sql = 'SELECT MONTH(debut) as years FROM ' . MAIN_DB_PREFIX.get_class($this).' WHERE YEAR(debut) = '.$year;
    	$resql 		 = $this->db->query($sql);
    	$years = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$years[$obj->years] = $obj->years;
			}
			$this->db->free($resql);
    	}

    	return $years;
    }
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT ".MAIN_DB_PREFIX.$this->table_element.".* FROM ";
		$sql .= MAIN_DB_PREFIX .get_class($this);
		
		if (!empty($join)) {
			$sql .= " ".$join; 
		}
		
		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		// echo $sql;
		$this->rows = array();
		$resql = $this->db->query($sql);
		if ($resql) {

			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->id 	= $obj->rowid; 
				$line->rowid 	= $obj->rowid; 
				$line->serie 	= $obj->serie; 
				$line->product 	=  $obj->product;
				$line->client 	=  $obj->client; 
				$line->fournisseur 	=  $obj->fournisseur; 
				$line->notes 	=  $obj->notes; 
				$line->recuperation 	=  $obj->recuperation; 
				$line->debut 	=  $obj->debut;
				$line->fin 		=  $obj->fin;
				$line->category =  $obj->category; 
				$this->rows[] 	= $line;
			}
			$this->db->free($resql);
			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}
	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .get_class($this). ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 			    = $this->db->fetch_object($resql);
				$this->id 		    =  $obj->rowid;
				$this->rowid 		=  $obj->rowid;
				$this->serie 		=  $obj->serie; 
				$this->product 		=  $obj->product;
				$this->client 		=  $obj->client; 
				$this->fournisseur 	=  $obj->fournisseur; 
				$this->notes 		=  $obj->notes; 
				$this->recuperation =  $obj->recuperation; 
				$this->debut 	    =  $obj->debut;
				$this->fin 	        =  $obj->fin;
				$this->category 	=  $obj->category;
				$this->fetch_optionals();
				
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	} 
	public function select_all_products($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }
	    $objet = "label";
	    $moreforfilter.='<select class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt.",".$objet." FROM ".MAIN_DB_PREFIX."product";

    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.' - '.$obj->$objet.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function select_all_clients($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }
	
	    $moreforfilter.='<select class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX."societe";

    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}

	public function select_tiers_fournisseur($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }
	
	    $moreforfilter.='<select class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX."societe";
    	$sql .= ' WHERE fournisseur = 1';
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}
	
	public function select_all_category($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }
	
	    $moreforfilter.='<select class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX."suivisav_type";

    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'" data-ref="'.$obj->$opt.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}
	
	public function suivisavpermissionto($source){
	    if(is_dir($source)) {
	    	@chmod($source, 0775);
	        $dir_handle=opendir($source);
	        while($file=readdir($dir_handle)){
	            if($file!="." && $file!=".."){
	                if(is_dir($source."/".$file)){
	                    @chmod($source."/".$file, 0775);
	                    $this->suivisavpermissionto($source."/".$file);
	                } else {
	                    @chmod($source."/".$file, 0664);
	                }
	            }
	        }
	        closedir($dir_handle);
	    } else {
	        @chmod($source, 0664);
	    }
	}

	public function add_event($obj, $action='', $note='')
	{
		global $user, $langs;
		// Add entry in event table
		include_once DOL_DOCUMENT_ROOT.'/comm/action/class/actioncomm.class.php';
		$object  = new ActionComm($this->db);
        $id_type = dol_getIdFromCode($this->db, 'AC_OTH', 'c_actioncomm');
        $object->type_id = $id_type;
        $object->label = $langs->trans('suivisav_'.$action).' - '.$obj->serie;
        if(!empty($note))
        	$object->note = trim($note);
        
        if($action == 'created')
        	$object->note = $langs->trans('suivisav_created_add').' '.$obj->serie.' '.$langs->trans('vient_etre_cree');
        $object->socid = $obj->client;
        $object->datep = date('Y-m-d');
        $object->datef = date('Y-m-d');
        $object->userownerid = $user->id;
        $object->elementtype = 'suivisav';
        $object->fk_element = $obj->rowid;
        $object->elementid = $obj->rowid;
        
        $result = $object->create($user);
        if($result)
        	return 1;
        else 
        	return 0;
	}



} 

class suivisav_type extends Commonobject{

	public $errors = array();
	public $rows = array();
	public $rowid;
	public $name;



	public $element = 'suivisav_type';
	public $table_element = 'suivisav_type';

	public function __construct(DoliDBMysqli $db)
	{
		$this->db = $db;
		return 1;
	}

	public function getNomUrl($withpicto = 0,  $id = null, $ref = null)
    {
        global $langs;

        $result	= '';
        $setRef = (null !== $ref) ? $ref : '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $setRef;

        $link 	 = '<a href="'.dol_buildpath('/suivisav/type/card.php?id='. $id ,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';
        $linkend ='</a>';
        $picto   = 'elemt@lproduction';

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$setRef.$linkend;
        
        $result = $link."<span class='icon_folder'></span>  ".$setRef.$linkend;
        return $result;
    }
	public function create($echo_sql=0)
	{
		$sql = "INSERT INTO " . MAIN_DB_PREFIX . "suivisav_type (name) VALUES ('".$this->name."')";

		$resql = $this->db->query($sql);
		if($resql){
			$this->id=$this->db->last_insert_id(MAIN_DB_PREFIX.$this->table_element);
			$result=$this->insertExtraFields();
			$this->db->commit();
			return $this->id;
		}
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error suivisav_type ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			//var_dump($errors);
			return -1;
		}
	}

	public function fetch($id, $ref = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'suivisav_type WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			
			if ($numrows) {
				$obj 					= $this->db->fetch_object($resql);
				$this->rowid 			= $obj->rowid;
				$this->name 	 		= $obj->name;
				$this->fetch_optionals();
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1 ;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND',$join='')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = "SELECT ".MAIN_DB_PREFIX.$this->table_element.".* FROM ";
		if (!empty($join)) {
			$sql .= " ".$join; 
		}
		$sql .= MAIN_DB_PREFIX . "suivisav_type where 1>0 ";
		 

		
		if (!empty($filter)) {
			$sql .= $filter;
		}
		
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}

		// echo $sql."<br>";
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
				$line->rowid 			= $obj->rowid;
				$line->name 	 		= $obj->name;
				$this->rows[] = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function update($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		$sql = 'UPDATE ' . MAIN_DB_PREFIX .'suivisav_type'. ' SET ';

	    $sql .= "name=".($this->name ?"'".$this->db->escape($this->name)."'":"null").' ';
		$sql .= ' WHERE rowid = ' . $id;

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$result=$this->insertExtraFields();
			$this->db->commit();
			return 1;
		}
	}

	public function delete()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . 'suivisav_type' .' WHERE rowid = ' . $this->rowid;
		//echo $sql;
		$resql 	= $this->db->query($sql);
		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function get_names()
	{
		$sql = "SELECT name FROM ";
		$sql .= MAIN_DB_PREFIX . "suivisav_type";

		$resql = $this->db->query($sql);
		$names = array();

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
					$names[ $obj->name ] = $obj->name;
			}
			$this->db->free($resql);
			return $names;
		}
	}


	public function select_with_filter($selected=0,$name='select_',$showempty=1,$val="rowid",$opt="label",$id=''){
	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;
	    if ($conf->use_javascript_ajax)
	    {
	        include_once DOL_DOCUMENT_ROOT . '/core/lib/ajax.lib.php';
	        $comboenhancement = ajax_combobox('select_'.$id);
	        $moreforfilter.=$comboenhancement;
	        $nodatarole=($comboenhancement?' data-role="none"':'');
	    }

	    $moreforfilter.='<select width="100%" class="flat" id="select_'.$id.'" name="'.$name.'" '.$nodatarole.'>';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT ".$val.",".$opt." FROM ".MAIN_DB_PREFIX.get_class($this);
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->$opt.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<style>#s2id_select_'.$name.'{ width: 100% !important;}</style>';
	    return $moreforfilter;
	}
}

class suivisavcls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('suivisav@suivisav');

        $modulrecrut = new modsuivisav($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'https://www.nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_SUIVISAV',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_SUIVISAV',$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_SUIVISAV',0))
            dolibarr_set_const($this->db,'ID_MODULE_SUIVISAV',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_SUIVISAV',0))
            dolibarr_set_const($this->db,'DATE_MODULE_SUIVISAV',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_SUIVISAV',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_SUIVISAV',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_SUIVISAV',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

	        $name = ( $mysoc->name ? $mysoc->name : "(U) ".$user->lastname.' '.$user->firstname);
	        $name = urlencode($name);
        	$id_modul = urlencode($id_modul);
	        $mail = urlencode($mysoc->email); 

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link."&name=".$name."&email=".$mail;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_SUIVISAV', 1, 'chaine',0,'',0);
                unActivateModule("modsuivisav");
            }
            $newdate_modul = date("Y-m-d", strtotime("+ 1 day"));
            dolibarr_set_const($this->db,'DATE_MODULE_SUIVISAV', $newdate_modul, 'chaine',0,'',0);
        }
        return 1;
    } 
} 

?>