<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   presences     Module presences
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/presences/core/modules directory.
 *  \file       htdocs/presences/core/modules/modpresences.class.php
 *  \ingroup    presences
 *  \brief      Description and activation file for module presences
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';

/**
 *  Description and activation class for module presences
 */
class modpresences extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

		// $this->editor_name = 'Editor';
		// $this->editor_url = 'https://www.site.ma';
		
		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 1909680919; 
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'presences';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "Next";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = "ModuleDescpresences";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '8.0';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='presences@presences';
		
		
		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		// for default path (eg: /presences/core/xxxxx) (0=disable, 1=enable)
		// for specific path of parts (eg: /presences/core/modules/barcode)
		// for specific css file (eg: /presences/css/presences.css.php)
		//$this->module_parts = array(
		//                        	'triggers' => 0,                                 	// Set this to 1 if module has its own trigger directory (core/triggers)
		//							'login' => 0,                                    	// Set this to 1 if module has its own login method directory (core/login)
		//							'substitutions' => 0,                            	// Set this to 1 if module has its own substitution function file (core/substitutions)
		//							'menus' => 0,                                    	// Set this to 1 if module has its own menus handler directory (core/menus)
		//							'theme' => 0,                                    	// Set this to 1 if module has its own theme directory (theme)
		//                        	'tpl' => 0,                                      	// Set this to 1 if module overwrite template dir (core/tpl)
		//							'barcode' => 0,                                  	// Set this to 1 if module has its own barcode directory (core/modules/barcode)
		//							'models' => 0,                                   	// Set this to 1 if module has its own models directory (core/modules/xxx)
		//							'css' => array('/presences/css/presences.css.php'),	// Set this to relative path of css file if module has its own css file
	 	//							'js' => array('/presences/js/presences.js'),          // Set this to relative path of js file if module must load a js on all pages
		//							'hooks' => array('hookcontext1','hookcontext2')  	// Set here all hooks context managed by module
		//							'dir' => array('output' => 'othermodulename'),      // To force the default directories names
		//							'workflow' => array('WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2'=>array('enabled'=>'! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)', 'picto'=>'yourpicto@presences')) // Set here all workflow context managed by module
		//                        );
		$this->module_parts = array(
		    'css' => array("/presences/css/presences.css"),
		    // 'hooks' => array(),
		);

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/presences/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into presences/admin directory, to use to setup module.
		// $this->config_page_url = array();
		$this->config_page_url = array("admin.php@presences");

		// $this->config_page_url = array("admin.php@presences");
		// $this->config_page_url = array("presences_setup.php@presences");

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("presences@presences");

		// Constants
		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
		// $this->const=array(
		// 	0 => array('MAIN_INFO_SOCIETE_TIME_IN','chaine','myvalue','This is a constant to add',1),
		//  	1=>array('MAIN_INFO_SOCIETE_TIME_OUT','chaine','myvalue','This is another constant to add',0, 'current', 1)
		// );
		$this->const = array();
		$type = ($conf->global->MAIN_INFO_SOCIETE_TIME_TYPE_HORAIRE? $conf->global->MAIN_INFO_SOCIETE_TIME_TYPE_HORAIRE : 'continu' );
		$nb_h_w = ($conf->global->MAIN_INFO_SOCIETE_TIME_TYPE_NB_HEUR_WEEK? $conf->global->MAIN_INFO_SOCIETE_TIME_TYPE_NB_HEUR_WEEK : 44 );


		$time_in = ($conf->global->MAIN_INFO_SOCIETE_TIME_IN? $conf->global->MAIN_INFO_SOCIETE_TIME_IN : 9 );
	    $time_out = ($conf->global->MAIN_INFO_SOCIETE_TIME_OUT? $conf->global->MAIN_INFO_SOCIETE_TIME_OUT : 16 );
	    
	    $time_in_m  = ($conf->global->MAIN_INFO_SOCIETE_TIME_IN_M? $conf->global->MAIN_INFO_SOCIETE_TIME_IN_M : 9 );
	    $time_out_m = ($conf->global->MAIN_INFO_SOCIETE_TIME_OUT_M? $conf->global->MAIN_INFO_SOCIETE_TIME_OUT_M : 13 );
	    $time_in_s  = ($conf->global->MAIN_INFO_SOCIETE_TIME_IN_S? $conf->global->MAIN_INFO_SOCIETE_TIME_IN_S : 15 );
	    $time_out_s = ($conf->global->MAIN_INFO_SOCIETE_TIME_OUT_S? $conf->global->MAIN_INFO_SOCIETE_TIME_OUT_S : 19 );

		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_TYPE_HORAIRE", $type, 'chaine', 0, '', $conf->entity);
		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_TYPE_NB_HEUR_WEEK", $nb_h_w, 'int', 0, '', $conf->entity);
		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_IN", '09:00', 'time', $time_in, '', $conf->entity);
		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_OUT", '16:00', 'time', $time_out, '', $conf->entity);

		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_IN_M", '09:00', 'time', $time_in_m, '', $conf->entity);
		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_OUT_M", '13:00', 'time', $time_out_m, '', $conf->entity);

		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_IN_S", '15:00', 'time', $time_in_s, '', $conf->entity);
		dolibarr_set_const($this->db, "MAIN_INFO_SOCIETE_TIME_OUT_S", '19:00', 'time', $time_out_s, '', $conf->entity);
		// Array to add new pages in new tabs
		// Example: $this->tabs = array('objecttype:+tabname1:Title1:presences@presences:$user->rights->presences->read:/presences/mynewtab1.php?id=__ID__',  	// To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:presences@presences:$user->rights->othermodule->read:/presences/mynewtab2.php?id=__ID__',  	// To add another new tab identified by code tabname2
        //                              'objecttype:-tabname:NU:conditiontoremove');                                                     						// To remove an existing tab identified by code tabname
		// where objecttype can be
		// 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
		// 'contact'          to add a tab in contact view
		// 'contract'         to add a tab in contract view
		// 'group'            to add a tab in group view
		// 'intervention'     to add a tab in intervention view
		// 'invoice'          to add a tab in customer invoice view
		// 'invoice_supplier' to add a tab in supplier invoice view
		// 'member'           to add a tab in fundation member view
		// 'opensurveypoll'	  to add a tab in opensurvey poll view
		// 'order'            to add a tab in customer order view
		// 'order_supplier'   to add a tab in supplier order view
		// 'payment'		  to add a tab in payment view
		// 'payment_supplier' to add a tab in supplier payment view
		// 'product'          to add a tab in product view
		// 'propal'           to add a tab in propal view
		// 'project'          to add a tab in project view
		// 'stock'            to add a tab in stock view
		// 'thirdparty'       to add a tab in third party view
		// 'user'             to add a tab in user view
        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->presences->enabled))
        {
        	$conf->presences=new stdClass();
        	$conf->presences->enabled=0;
        }
		$this->dictionaries=array();
        /* Example:
        if (! isset($conf->presences->enabled)) $conf->presences->enabled=0;	// This is to avoid warnings
        $this->dictionaries=array(
            'langs'=>'presences@presences',
            'tabname'=>array(MAIN_DB_PREFIX."table1",MAIN_DB_PREFIX."table2",MAIN_DB_PREFIX."table3"),		// List of tables we want to see into dictonnary editor
            'tablib'=>array("Table1","Table2","Table3"),													// Label of tables
            'tabsql'=>array('SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table1 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table2 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table3 as f'),	// Request to select fields
            'tabsqlsort'=>array("label ASC","label ASC","label ASC"),																					// Sort order
            'tabfield'=>array("code,label","code,label","code,label"),																					// List of fields (result of select to show dictionary)
            'tabfieldvalue'=>array("code,label","code,label","code,label"),																				// List of fields (list of fields to edit a record)
            'tabfieldinsert'=>array("code,label","code,label","code,label"),																			// List of fields (list of fields for insert)
            'tabrowid'=>array("rowid","rowid","rowid"),																									// Name of columns with primary key (try to always name it 'rowid')
            'tabcond'=>array($conf->presences->enabled,$conf->presences->enabled,$conf->presences->enabled)												// Condition to show each dictionary
        );
        */

        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes
		// Example:
		//$this->boxes=array(array(0=>array('file'=>'myboxa.php','note'=>'','enabledbydefaulton'=>'Home'),1=>array('file'=>'myboxb.php','note'=>''),2=>array('file'=>'myboxc.php','note'=>'')););

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=1;

		// Add here list of permission defined by an id, a label, a boolean and two constant strings.

		$this->rights[$r][0] = $this->numero+$r;	// Permission id (must not be already used)
		$this->rights[$r][1] = 'consulter';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'gestion';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'consulter';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Ajouter/Modifier';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'update';
		$r++;




		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Supprimer';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'gestion';
		$this->rights[$r][5] = 'delete';
		$r++;

		// Main menu entries
		$this->menu = array();			// List of menus to add
		$r=0;

		// Add here entries to declare new menus

		// Top Menu

		$this->menu[$r]=array(	'fk_menu'=>0,
			'type'=>'top',
			'titre'=>'presences',
			'mainmenu'=>'presences',
			'leftmenu'=>'presences',
			'url'=>'/presences/card.php',
			'langs'=>'presences@presences',
			'position'=>203,
			'enabled'=>'1',
			'perms'=>'$user->rights->presences->gestion->consulter',
			'target'=>'',
			'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=presences',
				'type'=>'left',
				'titre'=> 'pointe_presence',
				'url'=>'/presences/card.php',
				'langs'=>'presences@presences',
				'position'=>1,
				'enabled'=>'1',
				'perms'=>'$user->rights->presences->gestion->consulter',
				'target'=>'',
				'user'=>2);
		$r++;
		
		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=presences',
				'type'=>'left',
				'titre'=> 'Liste_des_presences',
				'url'=>'/presences/index.php',
				'langs'=>'presences@presences',
				'position'=>2,
				'enabled'=>'1',
				'perms'=>'$user->rights->presences->gestion->consulter',
				'target'=>'',
				'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=presences',
				'type'=>'left',
				'titre'=> 'list_retard',
				'url'=>'/presences/list_retard.php',
				'langs'=>'presences@presences',
				'position'=>2,
				'enabled'=>'1',
				'perms'=>'$user->rights->presences->gestion->consulter',
				'target'=>'',
				'user'=>2);
		$r++;

		$this->menu[$r]=array('fk_menu'=>'fk_mainmenu=presences',
				'type'=>'left',
				'titre'=> 'Configuration',
				'url'=>'/presences/admin/admin.php',
				'langs'=>'presences@presences',
				'position'=>5,
				'enabled'=>'1',
				'perms'=>'$user->rights->presences->gestion->consulter',
				'target'=>'',
				'user'=>2);
		$r++;

		$r=1;
		
	}




	function init($options='')
	{
		global $conf;
		$sqlm = array();

		if (!dolibarr_get_const($this->db,'MAIN_DATE_IN_MEMORY_ARE_GMT_PRESENCES',0))
			dolibarr_set_const($this->db,'MAIN_DATE_IN_MEMORY_ARE_GMT_PRESENCES',"Europe/Paris",'chaine',0,'',0);
		

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."presences` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`user` int(11) NULL,
		  	`projets` text NULL,
		  	`taches` text NULL,
		  	`date_entre` datetime NULL,
		  	`date_sorte` datetime NULL
		);";
		$resql = $this->db->query($sql);
		
		// ALTER TABLE PRESENCES
			$sql = "ALTER table `".MAIN_DB_PREFIX."presences` add projets text, add taches text";
			$resql = $this->db->query($sql);

			$sql = "ALTER TABLE `".MAIN_DB_PREFIX."presences`
				MODIFY `user` int(11) DEFAULT NULL,
				MODIFY `projets` text  DEFAULT NULL,
				MODIFY `taches` text  DEFAULT NULL,
				MODIFY `date_entre` DATETIME DEFAULT NULL,
				MODIFY `date_sorte` DATETIME DEFAULT NULL";
			$resql = $this->db->query($sql);
			
		

		$sql = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."justif_task` (
		  	`rowid` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
		  	`fk_task` int(11) NULL,
		  	`fk_user` int(11) NULL,
		  	`justif`  boolean NULL,
		  	`msg_justif` text NULL
		);";
		$resql = $this->db->query($sql);

		// ALTER TABLE JUSTIF_TASK
			$sql = "ALTER table `".MAIN_DB_PREFIX."justif_task` add date date, add presence int(11), add dure double";
			$resql = $this->db->query($sql);

			$sql = "ALTER TABLE `".MAIN_DB_PREFIX."justif_task`
				MODIFY `fk_task` int(11) DEFAULT NULL,
				MODIFY `fk_user` int(11) DEFAULT NULL,
				MODIFY `justif` boolean DEFAULT NULL,
				MODIFY `msg_justif` text  DEFAULT NULL,
				MODIFY `date` DATE DEFAULT NULL,
				MODIFY `dure` double DEFAULT NULL,
				MODIFY `presence` int(11) DEFAULT NULL";
			$resql = $this->db->query($sql);
			

			
			$resql = $this->db->query("ALTER table `".MAIN_DB_PREFIX."justif_task` add duretask double NULL");



		$sql = "ALTER table `".MAIN_DB_PREFIX."projet_task_time` add fk_presence int(11) NULL";
		$resql = $this->db->query($sql);

		
		return $this->_init($sqlm, $options);	


	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();

		// dolibarr_del_const($this->db, "MAIN_INFO_SOCIETE_TIME_IN", $conf->entity);
		// dolibarr_del_const($this->db, "MAIN_INFO_SOCIETE_TIME_OUT", $conf->entity);

		return $this->_remove($sql, $options);
	}

}
