<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		admin/poppy.php
 * 	\ingroup	poppy
 * 	\brief		This file is an example module setup page
 * 				Put some comments here
 */
// Dolibarr environment


$res = @include("../../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../../main.inc.php"); // From "custom" directory
}

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/poppy.lib.php';

// Translations
$langs->load("poppy@poppy");

// Access control
if (! $user->admin) {
    accessforbidden();
}

// Parameters
$action = GETPOST('action', 'alpha');

/*
 * Actions
 */
if (preg_match('/set_(.*)/',$action,$reg))
{
	$code=$reg[1];
	$value = GETPOST($code);
	if(is_array($value))$value = implode(',',$value);

	if (dolibarr_set_const($db, $code, $value, 'chaine', 0, '', $conf->entity) > 0)
	{
		header("Location: ".$_SERVER["PHP_SELF"]);
		exit;
	}
	else
	{
		dol_print_error($db);
	}
}

if (preg_match('/del_(.*)/',$action,$reg))
{
	$code=$reg[1];
	if (dolibarr_del_const($db, $code, 0) > 0)
	{
		Header("Location: ".$_SERVER["PHP_SELF"]);
		exit;
	}
	else
	{
		dol_print_error($db);
	}
}

/*
 * View
 */
$page_name = "PoppySetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
    . $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
$head = poppyAdminPrepareHead();
dol_fiche_head(
    $head,
    'settings',
    $langs->trans("Module104013Name"),
    0,
    "poppy@poppy"
);

// Setup page goes here
$form=new Form($db);
$var=false;
print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("Parameters").'</td>'."\n";
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="center" width="100">'.$langs->trans("Value").'</td>'."\n";


// Example with a yes / no select
$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("POPPY_RETRICT_TO_ONE").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_POPPY_RETRICT_TO_ONE">';
echo ajax_constantonoff('POPPY_RETRICT_TO_ONE');
print '</form>';
print '</td></tr>';// Example with a yes / no select
$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("POPPY_GO_TO_QTY_AFTER_SELECT_PRODUCT").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_POPPY_GO_TO_QTY_AFTER_SELECT_PRODUCT">';
echo ajax_constantonoff('POPPY_GO_TO_QTY_AFTER_SELECT_PRODUCT');
print '</form>';
print '</td></tr>';
$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("POPPY_ADD_BUTTON_ON_DRAFT_SHIPPING").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_POPPY_ADD_BUTTON_ON_DRAFT_SHIPPING">';
echo ajax_constantonoff('POPPY_ADD_BUTTON_ON_DRAFT_SHIPPING');
print '</form>';
print '</td></tr>';
$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("POPPY_SEND_ON_SHIPPING_VALIDATION_CARD_IF_ALL_SHIPPED").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_POPPY_SEND_ON_SHIPPING_VALIDATION_CARD_IF_ALL_SHIPPED">';
echo ajax_constantonoff('POPPY_SEND_ON_SHIPPING_VALIDATION_CARD_IF_ALL_SHIPPED');
print '</form>';
print '</td></tr>';

if($conf->categorie->enabled) {

	dol_include_once('/categories/class/categorie.class.php');
	$TCat = array();
	if(!empty($conf->global->POPPY_EXCLUDE_CATEGORY)) $TCat = explode(',',$conf->global->POPPY_EXCLUDE_CATEGORY);

	$var=!$var;
	print '<tr '.$bc[$var].'>';
	print '<td>'.$langs->trans("POPPY_EXCLUDE_CATEGORY").'</td>';
	print '<td align="center" width="20">&nbsp;</td>';
	print '<td align="right" width="300">';
	print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
	print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
	print '<input type="hidden" name="action" value="set_POPPY_EXCLUDE_CATEGORY">';
	$cate_arbo = $form->select_all_categories(Categorie::TYPE_PRODUCT, '', 'parent', 64, 0, 1);

	print $form->multiselectarray('POPPY_EXCLUDE_CATEGORY', $cate_arbo, $TCat);

	print '<input type="submit" class="button" value="'.$langs->trans("Modify").'">';
	print '</form>';
	print '</td></tr>';

}

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("POPPY_CAN_APPLY_THE_QTY_SCANNED").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_POPPY_CAN_APPLY_THE_QTY_SCANNED">';
echo ajax_constantonoff('POPPY_CAN_APPLY_THE_QTY_SCANNED');
print '</form>';
print '</td></tr>';

$var=!$var;
print '<tr '.$bc[$var].'>';
print '<td>'.$langs->trans("POPPY_ALLOW_TO_PREPARE_ORDER").'</td>';
print '<td align="center" width="20">&nbsp;</td>';
print '<td align="right" width="300">';
print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
print '<input type="hidden" name="action" value="set_POPPY_ALLOW_TO_PREPARE_ORDER">';
echo ajax_constantonoff('POPPY_ALLOW_TO_PREPARE_ORDER');
print '</form>';
print '</td></tr>';


print '</table>';

llxFooter();

$db->close();