<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file		lib/polemploi.lib.php
 *	\ingroup	polemploi
 *	\brief		This file is an example module library
 *				Put some comments here
 */

function menu_candidature($id)
{
    global $langs, $conf, $db;
    $langs->load("polemploi@polemploi");
    dol_include_once('/polemploi/class/postes.class.php');
    dol_include_once('/polemploi/class/candidatures.class.php');

    $h = 0;
    $head = array();
    $candidature = new candidatures_pole($db);
    $candidature->fetch($id);
    // print_r($_SERVER);
    $link = $_SERVER["REQUEST_URI"];
    if(!empty($id))
        $link = dol_buildpath("polemploi/candidatures/card.php?id=".$id,2);
    else
        $link=dol_buildpath("polemploi/candidatures/card.php?action=add",2);

        $head[$h][0] = $link;
        $head[$h][1] = $langs->trans("General");
        $head[$h][2] = 'general';
        $h++;

        if(!empty($id)){
            $head[$h][0] = dol_buildpath("polemploi/cv/index.php?candidature=".$id,2);
            $head[$h][1] = $langs->trans("cv");
            $head[$h][2] = 'cv';
            $h++;
        }

        if(empty($id)){
            $head[$h][0] = dol_buildpath("polemploi/cv/card.php?candidature=".$id."&action=add",2);
            $head[$h][1] = $langs->trans("cv");
            $head[$h][2] = 'cv';
            $h++;
        }
        if($candidature->employe){
            $head[$h][0] = dol_buildpath("polemploi/candidatures/fiche_employe.php?candidature=".$id,2);
            $head[$h][1] = $langs->trans("fiche_employe");
            $head[$h][2] = 'fiche_employe';
            $h++;
        }
       
    return $head;
}

function menu_newcandidat($value='')
{
    $html = '<div class="tabs tabs_candidats" data-role="controlgroup" data-type="horizontal">';

        $html .= '<div class="inline-block tabsElem tabsElemActive">';
            // <!-- id tab = general -->
            $html .= '<a id="general_candid" class="tabactive tab inline-block" >Général</a>';
        $html .= '</div>';
        $html .= '<div class="inline-block tabsElem">';
            // <!-- id tab = cv -->
            $html .= '<a id="cv" class="tabunactive tab inline-block" >CV et Lettres</a>';
        $html .= '</div>';
    $html .= '</div>';
    print $html;
}


function menu_config()
{
    global $langs, $conf, $db, $user;
    $langs->load("polemploi@polemploi");
    dol_include_once('/polemploi/class/postes.class.php');
    dol_include_once('/polemploi/class/candidatures.class.php');

    $h = 0;
    $head = array();
    

    $head[$h][0] = dol_buildpath("polemploi/admin/admin_poste.php",2);
    $head[$h][1] = $langs->trans("champs_post");
    $head[$h][2] = 'champs_post';
    $h++;

    $head[$h][0] = dol_buildpath("polemploi/admin/admin_candidature.php",2);
    $head[$h][1] = $langs->trans("champs_candid");
    $head[$h][2] = 'champs_candid';
    $h++;
    if ($user->rights->polemploi->gestion->consulter) {
        $head[$h][0] = dol_buildpath("polemploi/admin/admin_dict.php",2);
        $head[$h][1] = $langs->trans("DictionarySetup");
        $head[$h][2] = 'DictionarySetup';
        $h++;
    }
       
    return $head;
}
function menu_dict()
{
    global $langs, $conf, $db;
    $langs->load("polemploi@polemploi");
    dol_include_once('/polemploi/class/postes.class.php');
    dol_include_once('/polemploi/class/candidatures.class.php');

    $h = 0;
    $head = array();

    $head[$h][0] = dol_buildpath("polemploi/admin/admin_dict.php",2);
    $head[$h][1] = $langs->trans("poste");
    $head[$h][2] = 'poste';
    $h++;

    $head[$h][0] = dol_buildpath("polemploi/admin/admin_dict_candid.php",2);
    $head[$h][1] = $langs->trans("candidature");
    $head[$h][2] = 'candidature';
    $h++;
       
    return $head;
}

function menu_poste($id)
{
    global $langs, $conf, $db;
    $langs->load("polemploi@polemploi");
    dol_include_once('/polemploi/class/postes.class.php');
    dol_include_once('/polemploi/class/candidatures.class.php');

    $h = 0;
    $head = array();
        
        $head[$h][0] = dol_buildpath("polemploi/card.php?id=".$id,2);
        $head[$h][1] = $langs->trans("General");
        $head[$h][2] = 'general';
        $h++;

        $head[$h][0] = dol_buildpath("polemploi/employe.php?poste=".$id,2);
        $head[$h][1] = $langs->trans("candidatures");
        $head[$h][2] = 'employes';
        $h++;

    return $head;
}


