<?php
/* Copyright (C) 2015 Yassine Belkaid   <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       htdocs/transferorders/card.php
 *      \ingroup    transferorders
 *		\brief      Page of transfer orders
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

if(file_exists(DOL_DOCUMENT_ROOT.'/compta/salaries/class/paymentsalary.class.php')){
	require_once DOL_DOCUMENT_ROOT.'/compta/salaries/class/paymentsalary.class.php';
}else{
	require_once DOL_DOCUMENT_ROOT.'/salaries/class/paymentsalary.class.php';
}
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/salaries.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
// require_once DOL_DOCUMENT_ROOT.'/transferorders/class/transferorder.class.php';
// require_once DOL_DOCUMENT_ROOT.'/transferorders/common.inc.php';
dol_include_once('/ovfournisseur/class/transferorder.class.php');
dol_include_once('/ovfournisseur/transferorders/common.inc.php');

$id 	= GETPOST("id",'int');
$action = GETPOST('action');
$format = GETPOST('format');
$langs->load("compta");
$langs->load("salaries");
$langs->load("bills");
// Security check
$socid = GETPOST("socid","int");
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'salaries', '', '', '');

$transferOrder  	= new TransferOrder($db);
$userstatic 		= new User($db);
$bankAccountstatic 	= new Account($db);

/**
 * Actions
 */

if ($_POST["cancel"] == $langs->trans("Cancel")) {
	header("Location: index.php");
	exit;
}

$morejs	= array("/ovfournisseur/js/ovfournisseur.js");
$error 	= 0;

if ($id && $action == "pdf") {
	$title = "Transfer order";
	

	require_once dol_buildpath('/ovfournisseur/pdf/pdf.lib.php');
	$pdf->SetFont('dejavusans', '', 14, '', true);

	// Add a page
	$pdf->AddPage();

	// set text shadow effect
	$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

	require_once dol_buildpath('/ovfournisseur/transferorders/tpl/transferorders.php');

	// Print text using writeHTMLCell()
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

	// ---------------------------------------------------------

	// Close and output PDF document
	// This method has several options, check the source code documentation for more information.
	$pdf->Output('order_virement-'.$cd .'-'. $cm .'-'. $cy.'.pdf', 'I');
	die();
}

if ($id && $action == "pdf_payslip") {
	require_once dol_buildpath('/transferorders/pdf/pdf-no-header.lib.php');
    $logo = DOL_URL_ROOT .'/documents/next-concept.png';
	$pdf->SetFont('times', '', 11, '', true);

	if (!file_exists($logo)) {
		$logo = '';
	}

	// Add a page
	$pdf->AddPage();
	$object	= new PaymentSalary($db);

	$object->fetch($id);
	$userstatic->fetch($object->fk_user);

	$periodeDe 	  = dol_print_date($object->datesp, 'day');
	$periodeAu 	  = dol_print_date($object->dateep, 'day');
	$datePaiement = dol_print_date($object->datep, 'day');
	$typePaiement = ucfirst($transferOrder->getPaymentType($object->type_payement));
	$matricule 	  = (string) sprintf("%04d", $userstatic->id);
	$fonction 	  = ucfirst($userstatic->job);
	$fullname 	  = strtoupper($userstatic->lastname) .' '. ucfirst($userstatic->firstname);
	$civility 	  = strtoupper($userstatic->civility);
	$address	  = ucfirst($userstatic->address);
	$zip 		  = $userstatic->zip;
	$town 		  = ucfirst($userstatic->town) .' '. ucfirst($userstatic->fk_state); 
	$salary 	  = (float) price2num($userstatic->salary);

	require_once dol_buildpath('/transferorders/tpl/payslip.php');

	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
	$saved_path = $dolibarr_main_data_root.'/users/';

	if (!file_exists($saved_path.$userstatic->id))
		mkdir($saved_path.$userstatic->id);

	$saved_path .= $userstatic->id .'/payslip-'.$object->datep.'-'. $object->id .'.pdf';
	// update payslip so we can visualize it
	$transferOrder->updatePayslip($id);
	$pdf->Output($saved_path, 'FI');
	header("Location: payslipp.php");
	die();
}

if ($action == 'add') {
	$insertedAll = true;
	$getInsertedLines = array();
	$payment_date     = (isset($_POST['payment_date']) && !empty($_POST['payment_date']) ? trim($_POST['payment_date'])  : '');
	$fk_user_author   = (isset($_POST['fk_user_author']) && !empty($_POST['fk_user_author']) ? (int) trim($_POST['fk_user_author'])  : '');
	$fk_account 	  = (isset($_POST['fk_account']) && !empty($_POST['fk_account']) ? (int) trim($_POST['fk_account'])  : '');
	$fk_label 		  = (isset($_POST['fk_label']) && !empty($_POST['fk_label']) ? (string) trim($_POST['fk_label'])  : '');
	$etat             = (isset($_POST['etat']) && !empty($_POST['etat']) ? (string) trim($_POST['etat'])  : 'en_cours');
	// unset some vars to have just clean array 
	unset($_POST['payment_date'], $_POST['payment_dateday'], $_POST['payment_datemonth'], $_POST['payment_dateyear']);
	unset($_POST['fk_user_author'],$_POST['fk_account']);
	unset($_POST['action'], $_POST['token']);
	foreach ($_POST['datep'] as $key => $val) {
		$object = new PaymentSalary($db);
		
		list($dd, $md, $yd) = explode("/", $val);
		list($dv, $mv, $yv) = explode("/", $_POST['datep'][$key]);
		list($dsp, $msp, $ysp) 	= explode("/", $_POST['datesp'][$key]);
		list($dep, $mep, $yep) 	= explode("/", $_POST['dateep'][$key]);
		$fk_user 	= $_POST['fk_user'][$key];
		$label 		= $_POST['label'][$key];
		$amount 	= $_POST['amount'][$key];
		$accountid 	= $_POST['accountid'][$key];
		$paymenttype = $_POST['paymenttype'][$key];
		$num_payment = $_POST['num_payment'][$key];

		$datep  = dol_mktime(12,0,0, $md, $dd, $yd);
		$datev  = dol_mktime(12,0,0, $mv, $dv, $yv);
		$datesp = dol_mktime(12,0,0, $msp, $dsp, $ysp);
		$dateep = dol_mktime(12,0,0, $mep, $dep, $yep);
		if (empty($datev)) $datev=$datep;

		$object->accountid 	   = (int)$accountid;
		$object->fk_user 	   = (int)$fk_user;
		$object->datev 		   = $datev;
		$object->datep 		   = $datep;
		$object->amount 	   = price2num($amount);
		$object->label 		   = $label;
		$object->datesp 	   = $datesp;
		$object->dateep 	   = $dateep;
		$object->note 		   = "";
		$object->type_payment  = (int)$paymenttype;
		$object->num_payment   = (int)$num_payment;
		$object->fk_user_creat = $user->id;

		// Set user current salary as ref salaray for the payment
		$fuser 	= new User($db);
		$fuser->fetch((int)$fk_user);
		$object->salary = $fuser->salary;

		if (empty($datep) || empty($datev) || empty($datesp) || empty($dateep)) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Date")),'errors');
			$error++;
		}
		if (empty($object->fk_user) || $object->fk_user < 0) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Employee")),'errors');
			$error++;
		}
		if (empty($object->type_payment) || $object->type_payment < 0) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("PaymentMode")),'errors');
			$error++;
		}
		if (empty($object->amount)) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Amount")),'errors');
			$error++;
		}
		if (! empty($conf->banque->enabled) && ! $object->accountid > 0) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Account")),'errors');
			$error++;
		}

		if (!$error) {
			$db->begin();

			$ret = $object->create($user);
			
			if ($ret > 0) {
				$db->commit();
				$getInsertedLines[] = $ret;
			}
			else {
				$db->rollback();
				setEventMessages($object->error, $object->errors, 'errors');
				header("Location: card.php?action=create&leftmenu=tax_salary");
				exit;
			}
		}
	}

	list($dpd, $mpd, $ypd) 			 = explode("/", $payment_date);
	// insert transfer order
	$transferOrder->label  			 = $fk_label;
	$transferOrder->fk_user_author   = (int)$fk_user_author;
	$transferOrder->fk_account 	     = (int)$fk_account;
	$transferOrder->payment_date     = dol_mktime(12,0,0, $mpd, $dpd, $ypd);
	$transferOrder->payment_salaries = $getInsertedLines;
	$transferOrder->etat = $etat;

	$check = $transferOrder->create($user);
	if ($check > 0) {
		$db->commit();
		header("Location: liste.php");
		exit;
	}
	else {
		$db->rollback();
		setEventMessages($transferOrder->error, $transferOrder->errors, 'errors');
		header("Location: card.php?action=create&leftmenu=tax_salary");
		exit;
	}
}

if ($action == 'update') {
	$insertedAll = true;
	$getInsertedLines = array();
	$to_id = (isset($_POST['transfer_order_id']) && !empty($_POST['transfer_order_id']) ? (int) trim($_POST['transfer_order_id'])  : '');

	foreach ($_POST['datep'] as $key => $val) {
		$object = new PaymentSalary($db);
		
		list($dd, $md, $yd) = explode("/", $val);
		list($dv, $mv, $yv) = explode("/", $_POST['datep'][$key]);
		list($dsp, $msp, $ysp) 	= explode("/", $_POST['datesp'][$key]);
		list($dep, $mep, $yep) 	= explode("/", $_POST['dateep'][$key]);
		$fk_user = $_POST['fk_user'][$key];
		$label = $_POST['label'][$key];
		$amount = $_POST['amount'][$key];
		$accountid = $_POST['accountid'][$key];
		$paymenttype = $_POST['paymenttype'][$key];
		$num_payment = $_POST['num_payment'][$key];

		$datep  = dol_mktime(12,0,0, $md, $dd, $yd);
		$datev  = dol_mktime(12,0,0, $mv, $dv, $yv);
		$datesp = dol_mktime(12,0,0, $msp, $dsp, $ysp);
		$dateep = dol_mktime(12,0,0, $mep, $dep, $yep);
		if (empty($datev)) $datev=$datep;

		$object->accountid 	= (int)$accountid;
		$object->fk_user 	= (int)$fk_user;
		$object->datev 		= $datev;
		$object->datep 		= $datep;
		$object->amount 	= price2num($amount);
		$object->label 		= $label;
		$object->datesp 	= $datesp;
		$object->dateep 	= $dateep;
		$object->note 		= "";
		$object->type_payment = (int)$paymenttype;
		$object->num_payment  = (int)$num_payment;
		$object->fk_user_creat= $user->id;

		// Set user current salary as ref salaray for the payment
		$fuser 	= new User($db);
		$fuser->fetch((int)$fk_user);
		$object->salary = $fuser->salary;

		if (empty($datep) || empty($datev) || empty($datesp) || empty($dateep)) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Date")),'errors');
			$error++;
		}
		if (empty($object->fk_user) || $object->fk_user < 0) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Employee")),'errors');
			$error++;
		}
		if (empty($object->type_payment) || $object->type_payment < 0) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("PaymentMode")),'errors');
			$error++;
		}
		if (empty($object->amount)) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Amount")),'errors');
			$error++;
		}
		if (! empty($conf->banque->enabled) && ! $object->accountid > 0) {
			setEventMessage($langs->trans("ErrorFieldRequired",$langs->transnoentitiesnoconv("Account")),'errors');
			$error++;
		}

		if (!$error) {
			$db->begin();

			$ret = $object->create($user);
			
			if ($ret > 0) {
				$db->commit();
				$getInsertedLines[] = $ret;
			}
			else {
				$db->rollback();
				setEventMessages($object->error, $object->errors, 'errors');
				header("Location: card.php?action=create&leftmenu=tax_salary");
				exit;
			}
		}
	}

	// update transfer order
	$transferOrder->fetch($to_id);
	$transferOrder->payment_salaries = array_unique(array_merge($transferOrder->payment_salaries, $getInsertedLines));

	$check = $transferOrder->updatePaymentSalaries($user);

	if ($check > 0) {
		$db->commit();
		header("Location: card.php?id=". $to_id ."&leftmenu=tax_salary");
		exit;
	}
	else {
		$db->rollback();
		setEventMessages($transferOrder->error, $transferOrder->errors, 'errors');
		header("Location: card.php?id=". $to_id ."&leftmenu=tax_salary");
		exit;
	}
}

// traiter 
if ($action == 'traite' && $id) {
	$ov_transfer_ordre = new TransferOrder($db);
	$ov_transfer_ordre->fetch($id);
	$ov_transfer_ordre->etat = 'traite';
	// print_r($ov_transfer_ordre);die();
	$result = $ov_transfer_ordre->update($id);
	if ($result > 0) {
		$db->commit();
		header("Location: card.php?id=".$id."&leftmenu=suppliers_bills");
		exit;
	}
}



if ($action == 'delete' && $id) {
	$transferOrder->id = $id;
	$ret = $transferOrder->delete($user);

	if ($ret > 0) {
		$db->commit();

		header("Location: ".DOL_URL_ROOT.'/transferorders/index.php');
		exit;
	}
	else {
		$db->rollback();
		setEventMessage($transferOrder->error,'errors');
	}
}

/*
 *	View
 */
llxHeader(array(),'Ordre de virement','','','','',$morejs);

$form = new Form($db);

if ($id) {
	$object = new PaymentSalary($db);
	$result = $object->fetch($id);
	if ($result <= 0) {
		dol_print_error($db);
		exit;
	}
}

// Formulaire saisie salaire
if ($action == 'create') {
	$year_current 	= strftime("%Y",dol_now());
	$pastmonth 		= strftime("%m",dol_now()) - 1;
	$pastmonthyear = $year_current;
	if ($pastmonth == 0) {
		$pastmonth = 12;
		$pastmonthyear--;
	}

	$datesp = dol_mktime(0, 0, 0, $datespmonth, $datespday, $datespyear);
	$dateep = dol_mktime(23, 59, 59, $dateepmonth, $dateepday, $dateepyear);

	// We define date_start and date_end
	if (empty($datesp) || empty($dateep)) {
		$datesp=dol_get_first_day($pastmonthyear,$pastmonth,false); $dateep=dol_get_last_day($pastmonthyear,$pastmonth,false);
	}

	print '<form name="salary" action="'.$_SERVER["PHP_SELF"].'" method="post">';
	print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
	print '<input type="hidden" name="action" value="add">';
	print '<input type="hidden" id="baseCore" value="'.DOL_URL_ROOT.'/core/">';
	print '<input type="hidden" id="transfer_orders_root" value="'.dol_buildpath('/transferorders/',2).'">';

	print_fiche_titre($langs->trans("NewTransferOrder"),'', 'title_accountancy.png');

	dol_fiche_head('', '');
	
	$payment_date = (isset($_POST['payment_date']) && !empty($_POST['payment_date']) ? trim($_POST['payment_date'])  : '');
	
	print '<table class="border" width="100%">';
		print "<tr>";
			print '<td class="fieldrequired">'.$langs->trans("DatePayment").'</td><td>';
				$form->select_date($payment_date,"payment_date",'','','','add',1,1,0, 0, '', '', $payment_date);
			print '</td>';
		print '</tr>';
		// Author
		print "<tr>";
			print '<td class="fieldrequired">'.$langs->trans("Author").'</td><td>';
				// print $form->select_dolusers(GETPOST('fk_user_author','int'),'fk_user_author' , 1, '', 0, '', '', 0, 0, 0, '', 0, '', 'fk_user',true, ' required="required" ');
				print $form->select_dolusers(GETPOST('fk_user_author','int'), 'fk_user_author', 1, '', 0, '', '', 0, 0, 0, '', 0, '', 'fk_user',true);
			print '</td>';
		print '</tr>';
		// Label
		print "<tr>";
			print '<td class="fieldrequired">'.$langs->trans("Label").'</td><td>';
			print '<input name="fk_label" size="20" />';
			print '</td>';
		print '</tr>';
		// Bank
		print '<tr>';
			print '<td class="fieldrequired">'.$langs->trans("Account").'</td>';
			print '<td>';
				$form->select_comptes($_POST["fk_account"],"fk_account",0,'',0);  // Affiche liste des comptes courant
				print '</td>';
			print '</tr>';


		print '<tr><td class="fieldrequired">'.$langs->trans("Status").'</td>';
			print '<td>';
				print '<select id="etat_ov" name="etat">';
					print '<option value="en_cours">'.$langs->trans('en_cours').'</option>';
					print '<option value="traite">'.$langs->trans('traite').'</option>';
				print '</select>';  //etat ov
			print '</td>';
		print '</tr>';

	print '</table><br /><br />';

	print '<table id="to_parent_wrapper" class="border" width="100%">';
	print "<tr>";
		print '<td class="fieldrequired">'.$langs->trans("DatePayment").'</td>';
		print '<td>'.$langs->trans("DateValue").'</td>';
		print '<td class="fieldrequired">'.$langs->trans("Employee").'</td>';
		print '<td class="fieldrequired">'.$langs->trans("Label").'</td>';
		print '<td class="fieldrequired">'.$langs->trans("DateStartPeriod").'</td>';
		print '<td class="fieldrequired">'.$langs->trans("DateEndPeriod").'</td>';
		print '<td class="fieldrequired">'.$langs->trans("Amount").'</td>';
		print '<td class="fieldrequired">'.$langs->trans("Account").'</td>';
		print '<td class="fieldrequired">'.$langs->trans("PaymentMode").'</td>';
		print '<td>'.$langs->trans('Numero').' <br /><em>('.$langs->trans("ChequeOrTransferNumber").')</em></td>';
	print '</tr>';

	print '<tr class="transfer_order_wrapper_0 counted_lines" data-trans-order="0">';
		print '<td><input type="text" class="datepickerp" name="datep[]" size="9" autocomplete="off" required="required" /></td>';
		print '<td><input type="text" class="datepickerv" name="datev[]" size="9" autocomplete="off" /></td>';
		// Employee
		print '<td>';
			// print $form->select_dolusers('','fk_user[]',1, '', 0, '', '', 0, 0, 0, '', 0, '', 'fk_user',false, ' required="required" ');
			print $form->select_dolusers('','fk_user[]',1, '', 0, '', '', 0, 0, 0, '', 0, '', 'fk_user',false);
		print '</td>';
		// Label
		print '<td><input type="text" name="label[]" size="20" value="'. $langs->trans("SalaryPayment") .'" required="required" /></td>';
		// Start Date 
		print '<td><input type="text" class="datepickersp" name="datesp[]" size="9" autocomplete="off" required="required" /></td>';
		// end Date
		print '<td><input type="text" class="datepickerep" name="dateep[]" size="9" autocomplete="off" required="required" /></td>';
		// Amount
		print '<td><input type="text" class="montant" name="amount[]" size="10" required="required" /></td>';
		// Bank
		print '<td>';
			// Affiche liste des comptes courant
			$form->select_comptes('',"accountid[]",0,'',1, ' style="width:120px;"'); 
		print '</td>';
		// Type payment
		print '<td>';
			$form->select_types_paiements('', "paymenttype[]", '', 0, 0, 1);
		print '</td>';
		// Number
		print '<td><input class="num_payment" name="num_payment[]" type="text" /></td>';
	print '</tr>';


	// Other attributes
	$parameters=array('colspan' => ' colspan="1"');
	$reshook=$hookmanager->executeHooks('formObjectOptions',$parameters,$object,$action);    // Note that $action and $object may have been modified by hook

	print '</table>';

	dol_fiche_end();

    print '<div style="float: left; margin-top: 8px;">';
	print '<a id="addMoreTransOrderOv" href="javascript:void(0);" class="butAction">'.$langs->trans('AddNewTransferOrderLine').'</a>';
	print '</div>';

	print '<br><br><div class="center">';
	print '<input type="submit" class="button" value="'.$langs->trans("Save").'">';
	print '</div>';

	print '</form>';
}

$page = GETPOST("page",'int');
$page = (empty($page) ? 0 : $page);
if ($page == -1) { $page = 0; }
$offset = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$limit = $conf->liste_limit;
if ($id) {
	$transferOrder->fetch($id);
	// $head  	= salaries_prepare_head($transferOrder);

	if ($transferOrder->error) {
		echo $transferOrder->error;
	}

	$userstatic->id 		= $transferOrder->uid;
    $userstatic->lastname   = $transferOrder->lastname;
    $userstatic->firstname  = $transferOrder->firstname;
    $userstatic->admin 		= $transferOrder->admin;
    $userstatic->login 		= $transferOrder->login;
    $userstatic->email 		= $transferOrder->email;
    $userstatic->societe_id = $user->societe_id;

	$bankAccountstatic->id 	  = $transferOrder->fk_account;
	$bankAccountstatic->label = $transferOrder->accountLabel;
	$bankAccountstatic->number = $transferOrder->accountNumber;

	$bankAccount2 = new Account($db);
	$bankAccount2->fetch($transferOrder->fk_account);
	print_fiche_titre($langs->trans("TransferOrders"),'', 'title_accountancy.png');
	// dol_fiche_head(array(), '', $langs->trans("TransferOrders"), 0, 'payment');
	$etat = (!empty($transferOrder->etat) ? $transferOrder->etat : 'en_cours');
	$const_color = [
		'en_cours' =>(dolibarr_get_const($db,'COLOR_OT_ENCOUR',$conf->entity) ? dolibarr_get_const($db,'COLOR_OT_ENCOUR',$conf->entity) : ovfournisseur::COLORS_ETAT['en_cours'] ),
		'traite' =>(dolibarr_get_const($db,'COLOR_OT_TRAITE',$conf->entity) ? dolibarr_get_const($db,'COLOR_OT_TRAITE',$conf->entity) : ovfournisseur::COLORS_ETAT['traite'] )
	];
	print '<table class="border" width="100%">';
		print "<tr>";
			print '<td width="25%"></td><td>';
				print '<span class="etat_ov" ><b>'.$langs->trans('Status_Ov').': </b><span class="etat_'.$etat.'" style="background:'.$const_color[$etat].'"></span>'.$langs->trans($etat).'</span>';
			print '</td>';
		print '</tr>';

		print "<tr>";
			print '<td width="25%">'.$langs->trans("DatePayment").'</td>';
			print '<td>';
				print dol_print_date($transferOrder->payment_date, 'day');
			print '</td>';
		print '</tr>';
		// Author
		print "<tr>";
		print '<td >'.$langs->trans("Author").'</td><td>';
		print $userstatic->getNomUrl(1);
		print '</td></tr>';
		// Bank
		print '<tr><td>'.$langs->trans("Account").'</td><td>';
			print $bankAccount2->getNomUrl(1);  // Affiche liste des comptes courant
		print '</td></tr>';
		// Create Date
		print '<tr><td>'.$langs->trans("CreatedAt").'</td><td>';
			print dol_print_date($transferOrder->createdAt, 'day');  // Affiche liste des comptes courant
		print '</td></tr>';
	print '</table><br /><br />';

	print '<div style="float: right; margin-top: 8px;">';
		if(empty($transferOrder->etat) || $transferOrder->etat == 'en_cours')
		print '<a href="card.php?action=traite&id='. $id .'" class="butAction">'.$langs->trans('traite').'</a>';
		print '<a href="./liste.php?" class="butAction">'.$langs->trans('Cancel').'</a>';
	print '</div>';
	if (count($transferOrder->payment_salaries)) {
		$salstatic 	= new PaymentSalary($db);
		$result 	= $transferOrder->getPaymentSalariesByTransferOrderId();

		if ($result) {
		    $num = $db->num_rows($result);
		    $i = 0;
		    $total = 0 ;
			$var=true;
			$param='';

			print_barre_liste($langs->trans("SalariesPayments"),$page,$_SERVER["PHP_SELF"],$param,$sortfield,$sortorder,'',$num,$totalnboflines, 'title_accountancy.png');

		    print '<table class="noborder" width="100%">';

		    print '<tr class="liste_titre">';
			print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"],"","",$param,"","","");
			print_liste_field_titre($langs->trans("Person"),$_SERVER["PHP_SELF"],"","",$param,"","","");
			print_liste_field_titre($langs->trans("ExpectedToPay"),$_SERVER["PHP_SELF"],"","",$param,"","","");
			print_liste_field_titre($langs->trans("Label"),$_SERVER["PHP_SELF"],"","",$param,'align="left"',"","");
			print_liste_field_titre($langs->trans("DatePayment"),$_SERVER["PHP_SELF"],"","",$param,'align="center"',"",$sortorder);
			print_liste_field_titre($langs->trans("PaymentMode"),$_SERVER["PHP_SELF"],"","",$param,'align="left"',"","");
			print_liste_field_titre($langs->trans("PayedByThisPayment"),$_SERVER["PHP_SELF"],"","",$param,'align="right"',"","");
			print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
		    print "</tr>\n";

		    if ($num)
		    while ($i < min($num,$limit)) {
		        $obj = $db->fetch_object($result);
		        $var = !$var;
		        print "<tr ".$bc[$var].">";

		        $userstatic->id=$obj->uid;
		        $userstatic->lastname=$obj->lastname;
		        $userstatic->firstname=$obj->firstname;
		        $userstatic->admin=$obj->admin;
		        $userstatic->login=$obj->login;
		        $userstatic->email=$obj->email;
		        $userstatic->societe_id=$obj->fk_soc;

		        $salstatic->id=$obj->rowid;
				$salstatic->ref=$obj->rowid;
		        // Ref
				print "<td>".$salstatic->getNomUrl(1)."</td>\n";
				// User name
				print "<td>".$userstatic->getNomUrl(1)."</td>\n";
				// Current salary
				print "<td>".($obj->salary?price($obj->salary):'')."</td>\n";
				// Label payment
		        print "<td>".dol_trunc($obj->label,40)."</td>\n";
				// Date payment
		        print '<td align="center">'.dol_print_date($db->jdate($obj->datep),'day')."</td>\n";
		        // Type
		        // print '<td>'.$langs->trans("PaymentTypeShort".$obj->payment_code).' '.$obj->num_payment.'</td>';
		        print '<td>'.$langs->trans("PaymentTypeShort".$obj->payment_code).' </td>';
				// Amount
		        print "<td align=\"right\">".price($obj->amount)."</td>";
		        print "<td></td>";
		        print "</tr>\n";

		        $total = $total + $obj->amount;

		        $i++;
		    }
		    
		    print '<tr class="liste_total"><td colspan="6" class="liste_total">'.$langs->trans("Total").'</td>';
		    print '<td  class="liste_total" align="right">'.price($total,0,$outputlangs,1,-1,-1,$conf->currency)."</td>";
			print "<td></td></tr>";

		    print "</table>";
		    // print '<br><br><a style="float:right;" href="./card.php?id='.$id.'&action_export=pdf" target="_blank" class="butAction">'.$langs->trans('Exportpdf').'</a>';
                

			// print '</form>';

			if (count($transferOrder->payment_salaries) === 1) {
				print '<form name="salary" action="'.$_SERVER["PHP_SELF"].'" method="post">';
				print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
				print '<input type="hidden" name="transfer_order_id" value="'. $id .'">';
				print '<input type="hidden" name="action" value="update">';
				print '<input type="hidden" id="baseCore" value="'.DOL_URL_ROOT.'/core/">';
				print '<input type="hidden" id="transfer_orders_root" value="'.DOL_URL_ROOT.'/transferorders/">';

				print '<table id="to_parent_wrapper" class="border" width="100%">';
				print "<tr>";
					print '<td class="fieldrequired">'.$langs->trans("DatePayment").'</td>';
					print '<td>'.$langs->trans("DateValue").'</td>';
					print '<td class="fieldrequired">'.$langs->trans("Employee").'</td>';
					print '<td class="fieldrequired">'.$langs->trans("Label").'</td>';
					print '<td class="fieldrequired">'.$langs->trans("DateStartPeriod").'</td>';
					print '<td class="fieldrequired">'.$langs->trans("DateEndPeriod").'</td>';
					print '<td class="fieldrequired">'.$langs->trans("Amount").'</td>';
					print '<td class="fieldrequired">'.$langs->trans("Account").'</td>';
					print '<td class="fieldrequired">'.$langs->trans("PaymentMode").'</td>';
					print '<td>'.$langs->trans('Numero').' <br /><em>('.$langs->trans("ChequeOrTransferNumber").')</em></td>';
				print '</tr>';

				print '<tr class="transfer_order_wrapper_0 counted_lines" data-trans-order="0">';
					print '<td><input class="datepickerp" name="datep[]" size="9" autocomplete="off" required="required" /></td>';
					print '<td><input class="datepickerv" name="datev[]" size="9" autocomplete="off" /></td>';
					// Employee
					print '<td>';
						print $form->select_dolusers('','fk_user[]',1, '', 0, '', '', 0, 0, 0, '', 0, '', 'fk_user',false);
					print '</td>';
					// Label
					print '<td><input name="label[]" size="20" value="'. $langs->trans("SalaryPayment") .'" required="required" /></td>';
					// Start Date 
					print '<td><input class="datepickersp" name="datesp[]" size="9" autocomplete="off" required="required" /></td>';
					// end Date
					print '<td><input class="datepickerep" name="dateep[]" size="9" autocomplete="off" required="required" /></td>';
					// Amount
					print '<td><input class="montant" name="amount[]" size="10" required="required" /></td>';
					// Bank
					print '<td>';
						// Affiche liste des comptes courant
						$form->select_comptes('',"accountid[]",0,'',1, ' style="width:120px;"'); 
					print '</td>';
					// Type payment
					print '<td>';
						$form->select_types_paiements('', "paymenttype[]", '', 0, 0, 1);
					print '</td>';
					// Number
					print '<td><input class="num_payment" name="num_payment[]" type="text" /></td>';
				print '</tr>';

				print '</table>';

			    print '<div style="float: left; margin-top: 8px;">';
				print '<a id="addMoreTransOrderOv" href="javascript:void(0);" class="butAction">'.$langs->trans('AddNewTransferOrderLine').'</a>';
				print '</div>';

				print '<br><br><div class="center">';
				print '<input type="submit" class="button" value="'.$langs->trans("Save").'">';
				print '</div>';

				print '</form>';
			}

		    $db->free($result);
		}
		else {
		    dol_print_error($db);
		}
	}
	else {
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="card.php?action=delete&id='. $id .'" class="butAction">'.$langs->trans('Delete').'</a>';
		print '</div>';
	}

}

?>
<script type="text/javascript">
	$(document).ready(function(){
		$('select.fk_user,select[name="accountid[]"]').select2();
	});
</script>
<?php
llxFooter();

$db->close();
