<?php
/* List of transfer orders, you can add/edit/delete it
 * Copyright (C) 2016  Yassine Belkaid <y.belkaid@nextconcept.ma>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	ovfournisseur	ovfournisseur module
 * 	\brief		ovfournisseur module descriptor.
 * 	\file		core/modules/modovfournisseur.class.php
 * 	\ingroup	ovfournisseur
 * 	\brief		ovfournisseur is adds more functionnality to compta
 */
include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

/**
 * Description and activation class for module MyModule
 */
class modOVfournisseur extends DolibarrModules
{
	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db 			= $db;
		// $this->numero 		= 808810;
		$this->numero 		= 190972100;
		$this->rights_class = 'ovfournisseur';
		$this->family = "Next";
		$this->name 		= preg_replace('/^mod/i', '', get_class($this));
		$this->description 	= "descriptionmodovfournisseur";
		$this->version 		= '4.0';
		$this->const_name 	= 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special 		= 0;
		$this->picto 		= 'ovfournisseur@ovfournisseur';
		$this->module_parts = array(
			'triggers' 	=> 1,
			'css' 		=> array('/ovfournisseur/css/ovfournisseur.css'),
			'js' 		=> array('/ovfournisseur/js/ovfournisseur.js','/ovfournisseur/js/ovfournisseur.js.php'),
			'hooks' 	=> array('ovfournisseurcard')
		);

		$this->dirs 		= array();
		$this->config_page_url = array("admin.php@ovfournisseur");

		$this->hidden 		= false;
		$this->depends 		= array('modBanque','modFacture');
		$this->requiredby 	= array();
		$this->conflictwith = array();
		$this->phpmin 		= array(5, 3);
		$this->need_dolibarr_version = array(3, 0);
		$this->langfiles 	= array("ovfournisseur@ovfournisseur", "compta", "bills", "banks", "salaries");
		$this->const 		= array(
			0 => array(
				'MAIN_MODULE_'. strtoupper($this->name) .'_HOOKS',
				'chaine',
				'salarycard',
				'Hook to update transfer orders table when a salaries payment is deleted',
				0
			)
		);
		
		$this->tabs 		= array();
		// Dictionaries
		if (! isset($conf->ovfournisseur->enabled)) {
			$conf->ovfournisseur = new stdClass();
			$conf->ovfournisseur->enabled = 0;
		}
		$this->dictionaries = array();

		// Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
		$this->boxes = array(); // Boxes list

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 1;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Read transfer order';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'read';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Create/modify your transfer order';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'write';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Delete transfer order';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'delete';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Read transfer orders for everybody';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'read_all';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Create/modify transfer order for everybody';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'write_all';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero+$r;
		$this->rights[$r][1] = 'Setup transfer order of users (setup and update)';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'define_contract';
		$this->rights[$r][5] = '';
		$r++;

		// Main menu entries
		$r = 0;

		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=billing',
			'type'		=> 'left',
			'titre'		=> "ovfournisseurs",
			'leftmenu'	=> 'ovfournisseur',
			'url'		=> '/ovfournisseur/liste.php',
			'langs'		=> 'ovfournisseur@ovfournisseur',
			'position'	=> 4,
			'enabled' 	=> '$conf->ovfournisseur->enabled',
			'perms'		=> 1,
			'target'	=> '',
			'user'		=> 2 // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=billing,fk_leftmenu=ovfournisseur',
			'type'		=> 'left',
			'titre'		=> "ovfacturefrn",
			'url'		=> '/ovfournisseur/liste.php',
			'langs'		=> 'ovfournisseur@ovfournisseur',
			'position'	=> 5,
			'enabled' 	=> '$conf->ovfournisseur->enabled',
			'perms'		=> 1,
			'target'	=> '',
			'user'		=> 2 // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;

		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=billing,fk_leftmenu=ovfournisseur',
			'type'		=> 'left',
			'titre'		=> "ovsalaire",
			'url'		=> '/ovfournisseur/transferorders/liste.php',
			'langs'		=> 'ovfournisseur@ovfournisseur',
			'position'	=> 6,
			'perms'		=> 1,
			'enabled' 	=> '$conf->ovfournisseur->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;

	

		// Exports
		$r = 0;
		// dolibarr_get_const($db,'COLOR_OV_ENCOUR',$conf->entity) 
		// dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) ? dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) : ovfournisseur::COLORS_ETAT['traite'] )

		if (!dolibarr_get_const($this->db,'MSG_OBJET_OV'))
			dolibarr_set_const($this->db, "MSG_OBJET_OV", 'Ordre de virement', 'chaine', 0, '', $conf->entity);

		if (!dolibarr_get_const($this->db,'MSG_ENTETE_OV'))
			dolibarr_set_const($this->db, "MSG_ENTETE_OV", "Nous vous demande prions d\'exécuter le virement détaillé comme suit du moi", 'chaine', 0, '', $conf->entity);

		if (!dolibarr_get_const($this->db,'MSG_PIED_OV'))
			dolibarr_set_const($this->db, "MSG_PIED_OV","D'avance nous vous en remercions et vous prions d'agréer, Monsieur, l'expression de notre salutation distinguée.", 'chaine', 0, '', $conf->entity);
		
		if (!dolibarr_get_const($this->db,'COLOR_OV_ENCOUR'))
			dolibarr_set_const($this->db, "COLOR_OV_ENCOUR", '#FFB164', 'chaine', 0, '', $conf->entity);
		if (!dolibarr_get_const($this->db,'COLOR_OV_TRAITE'))
			dolibarr_set_const($this->db, "COLOR_OV_TRAITE", '#DBE270', 'chaine', 0, '', $conf->entity);

		if (!dolibarr_get_const($this->db,'COLOR_OT_ENCOUR'))
			dolibarr_set_const($this->db, "COLOR_OT_ENCOUR", '#FFB164', 'chaine', 0, '', $conf->entity);
		if (!dolibarr_get_const($this->db,'COLOR_OT_TRAITE'))
			dolibarr_set_const($this->db, "COLOR_OT_TRAITE", '#DBE270', 'chaine', 0, '', $conf->entity);

	}

	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
		global $conf;

		$sql = array();
		$sql1 = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."ov_fournisseur` (
		  `rowid` int(11) NULL AUTO_INCREMENT PRIMARY KEY,
		  `label` varchar(100) DEFAULT NULL,
		  `date_ordre` datetime NULL,
		  `fk_user_author` int(11) NULL,
		  `fk_supplier` int(11) NULL,
		  `fk_facture` int(11) NULL,
		  `fk_reglement` int(11) NULL,
		  `fk_account` int(11) NULL,
		  `montant` DOUBLE(24,8) NULL,
		  `type` varchar(255) NULL,
		  `etat` varchar(255) NULL
		)";
		$resql1 = $this->db->query($sql1);

		$sql_1 = "ALTER TABLE `".MAIN_DB_PREFIX."paiementfourn` ADD COLUMN `ov` SMALLINT(4) NULL DEFAULT NULL;";
		$resql_1 = $this->db->query($sql_1);

		$sql2 = "CREATE TABLE IF NOT EXISTS `".MAIN_DB_PREFIX."ov_transfer_order` (
		  `rowid` int(11) NULL AUTO_INCREMENT PRIMARY KEY,
		  `label` varchar(100) DEFAULT NULL,
		  `fk_user_author` int(8) NULL,
		  `fk_account` int(8) NULL,
		  `payment_date` datetime NULL,
		  `payment_salaries` text NULL,
		  `createdAt` datetime NULL,
		  `entity` int(4) DEFAULT NULL,
		  `etat` varchar(255) NULL
		)";

		$resql2 = $this->db->query($sql2);
		
		if (!$resql2) {
			$errors[] = 'Error '.get_class($this).' '. $this->db->lasterror();
			print_r($errors);
			die();
		} 


		$sql_2 = "ALTER TABLE `".MAIN_DB_PREFIX."payment_salary` ADD `payslip` SMALLINT(4) NULL DEFAULT NULL;";
		$resql_2 = $this->db->query($sql_2);



		$dd = $this->CreateOrdrevirementfrn();

		$extrafields = new ExtraFields($this->db);
		
		$extrafields->addExtraField('ov', 'Ordre de virement', "int", 0, "", "facture_fourn",  0, 0, '');


		return $this->_init($sql, $options);
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		// $sql 	= $this->dropColmunsAndRows();
		// $sql[] 	= "DROP TABLE `llx_transfer_order`";
		
		require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

		$sql = array(
			'DELETE FROM `'.MAIN_DB_PREFIX.'extrafields` WHERE `name` = "ov"',
		);

		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /mymodule/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/ovfournisseur/sql/');
	}

	private function CreateOrdrevirementfrn()
	{

		$sql = 'SELECT p.rowid as pid, p.datep as dp, p.amount as pamount, p.num_paiement as num,p.fk_user_author as author, ';
		$sql.= ' f.fk_soc as socid, b.fk_account as bank, f.rowid as factid';
		$sql.= ' FROM '.MAIN_DB_PREFIX.'paiementfourn AS p';
		$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'paiementfourn_facturefourn AS pf ON p.rowid=pf.fk_paiementfourn';
		$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'facture_fourn AS f ON f.rowid=pf.fk_facturefourn';
	    $sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'societe AS s ON s.rowid = f.fk_soc';
		$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'bank as b ON p.fk_bank = b.rowid';
		$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'bank_account as ba ON b.fk_account = ba.rowid';
		$sql.= ' where p.ov IS NULL OR p.ov = 0';
		$sql.= ' GROUP BY p.rowid';
		$resql = $this->db->query($sql);
		if($resql){
			while ($objet = $this->db->fetch_object($resql)) {

				$sql2 = "INSERT INTO `".MAIN_DB_PREFIX."ov_fournisseur` (`label`, `fk_reglement`, `fk_account`, `date_ordre`,`fk_supplier`, ,`fk_facture`, `fk_user_author`,`montant`,`etat`) VALUES
					('Ordre de virement ".$objet->num."', ".$objet->pid.", ".$objet->bank.", '".$objet->dp."',".$objet->socid.", ".$objet->factid.", ".$objet->author.", ".$objet->pamount.",'en_cours');";
				$resql2 = $this->db->query($sql2);

				if($resql2){
					$msql = 'UPDATE '.MAIN_DB_PREFIX.'paiementfourn SET ov = 1 where rowid='.$objet->pid;
					$remsql = $this->db->query($msql);
				}
			}
		}
	}
}
