<?php
/* Copyright (C) 2015  Yassine Belkaid   <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *      \file       htdocs/ovfournisseur/class/ovfournisseur.class.php
 *      \ingroup    salaries
 *      \brief		Class for transfer orders
 */
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/geturl.lib.php';

// Put here all includes required by your class file
require_once DOL_DOCUMENT_ROOT .'/core/class/commonobject.class.php';


/**
 *  Class to manage salary payments
 */
class ovfournisseur extends CommonObject
{
	public $errors = array();
	public $id;
	public $rowid;
	public $ref;

	public $label;
	public $date_ordre;
	public $fk_user_author;
	public $fk_reglement;
	public $fk_account;
	public $fk_facture;
	public $fk_supplier;
	public $montant;
	public $etat;
	public $type;


	public $element;
	public $table_element;

	const COLORS_ETAT = [
		'en_cours' 	=>'#FFB164',
		'traite' 	=>'#DBE270',
	];

		
	/**
	 *	Constructor
	 *
	 *  @param		DoliDB		$db      Database handler
	 */
	function __construct($db) {
		$this->db 			 = $db;
		$this->element 		 = 'ovfournisseur';
		$this->table_element = 'ov_fournisseur';
		$this->createdAt 	 = date('Y-m-d H:i:s');
		return 1;
	}

	/**
	 * Update database
	 *
	 * @param   User	$user        	User that modify
	 * @param	int		$notrigger	    0=no, 1=yes (no update trigger)
	 * @return  int         			<0 if KO, >0 if OK
	 */
	function update($to_id) {
		global $conf, $langs;

		$error = 0;
		
		// Update request
		$sql = "UPDATE ".MAIN_DB_PREFIX. $this->table_element ." SET";
		$sql.= " label ='". $this->label ."',";
		$sql.= " fk_user_author='". (int)$this->db->escape($this->fk_user_author) ."',";
		$sql.= " fk_account=". (int)$this->db->escape($this->fk_account) .",";
		$sql.= " fk_facture=". (int)$this->db->escape($this->fk_facture) .",";
		$sql.= " fk_supplier=". (int)$this->db->escape($this->fk_supplier) .",";
		$sql.= " date_ordre='". $this->db->idate($this->date_ordre) ."', ";
		$sql.= " etat='".$this->etat."', ";
		$sql.= " type='".$this->type."'";
		$sql.= " WHERE rowid=".$to_id;
		dol_syslog(get_class($this)."::update", LOG_DEBUG);
		$resql = $this->db->query($sql);
		
		if (!$resql) {
			$this->error="Error ".$this->db->lasterror();
			return $this->error;
		}

		if (!$error) {
			$this->db->commit();
			return $to_id;
		}
		else {
			$this->db->rollback();
			return -1;
		}
	}

	/**
	 *  Load object in memory from database
	 *
	 *  @param	int		$id         id object
	 *  @param  User	$user       User that load
	 *  @return int         		<0 if KO, >0 if OK
	 */
	function fetch($id, $user=null) {
		global $langs;
		$this->error = 0;

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX .$this->table_element. ' WHERE rowid = ' . $id;
		

		dol_syslog(get_class($this)."::fetch", LOG_DEBUG);
		$resql = $this->db->query($sql);

		if ($resql) {
			if ($this->db->num_rows($resql)) {
				$obj = $this->db->fetch_object($resql);

				$this->id    		= $obj->rowid;
				$this->rowid    		= $obj->rowid;
				$this->label   			= $obj->label;
				$this->fk_user_author 	= $obj->fk_user_author;
				$this->date_ordre 	    = $obj->date_ordre;
				$this->fk_account 		= $obj->fk_account;
				$this->fk_reglement     = $obj->fk_reglement;
				$this->fk_facture  		= $obj->fk_facture;
				$this->fk_supplier      = $obj->fk_supplier;
				$this->montant  		= $obj->montant;
				$this->etat  		    = $obj->etat;
				$this->type  		    = $obj->type;

			}

			$this->db->free($resql);

			return $this->id;
		}
		else {
			$this->error="Error ".$this->db->lasterror();
			return -1;
		}
	}



	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);
		$sql = "SELECT * FROM ";
		$sql .= MAIN_DB_PREFIX .$this->table_element;

		if (!empty($filter)) {
			$sql .= " WHERE 1>0 ".$filter;
		}
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		if (!empty($limit)) {
			if($offset==1)
				$sql .= " limit ".$limit;
			else
				$sql .= " limit ".$offset.",".$limit;				
		}
		$this->rows = array();
		$resql = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
                $line->id    			= $obj->rowid;
                $line->rowid         	= $obj->rowid;
				$line->label 			= $obj->label;
				$line->date_ordre 	    = $obj->date_ordre;
				$line->fk_user_author 	= $obj->fk_user_author;
				$line->fk_reglement  	= $obj->fk_reglement;
				$line->fk_account  		= $obj->fk_account;
				$line->fk_facture  		= $obj->fk_facture;
				$line->fk_supplier  	= $obj->fk_supplier;
				$line->montant  		= $obj->montant;
				$line->etat  		    = $obj->etat;                                              
				$line->type  		    = $obj->type;                                              
                // ....

				$this->rows[] 	= $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}



	/**
	 *  Delete object in database
	 *
	 *	@param	User	$user       User that delete
	 *	@return	int					<0 if KO, >0 if OK
	 */
	public function delete()
	{
		global $conf, $langs;
		$error=0;

		$sql = "DELETE FROM ".MAIN_DB_PREFIX.$this->table_element ." WHERE rowid=".$this->rowid;
		dol_syslog(get_class($this)."::delete", LOG_DEBUG);
		$resql = $this->db->query($sql);
		if (! $resql) {
			$this->error="Error ".$this->db->lasterror();
			return -1;
		}

		return 1;
	}

    /**
     *  Create in database
     *
     *  @param      User	$user       User that create
     *  @return     int      			<0 if KO, >0 if OK
     */
	function create() {
		global $conf, $langs;
		$error = 0;

		/// Clean parameters
		$this->label 			= trim($this->label);
		$this->date_ordre 	    = trim($this->date_ordre);
		$this->fk_user_author 	= (int) trim($this->fk_user_author);
		$this->fk_reglement  	= (int) trim($this->fk_reglement);
		$this->fk_supplier  	= (int) trim($this->fk_supplier);
		$this->fk_facture  	    = (int) trim($this->fk_facture);
		$this->fk_account  		= (int) trim($this->fk_account);
		$this->montant  		= $this->montant;
		$this->etat  		    = trim($this->etat);
		$this->type  		    = trim($this->type);
		
		$this->db->begin();

		// Insert into llx_payment_salary
		$sql = "INSERT INTO ".MAIN_DB_PREFIX. $this->table_element ." (label, fk_user_author, fk_reglement, fk_account, fk_supplier, fk_facture, date_ordre, etat, type, montant) ";
		$sql.= " VALUES ('";
			$sql .= $this->label ."', ";
			$sql .= $this->fk_user_author .", ";
			$sql .= $this->fk_reglement.", ";
			$sql .= $this->fk_account .", ";
			$sql .= $this->fk_supplier .", ";
			$sql .= $this->fk_facture .", '";
			$sql .= $this->db->idate($this->date_ordre)."', '";
			$sql .= $this->etat."', '";
			$sql .= $this->type."', ";
			$sql .= $this->montant .")";
		dol_syslog(get_class($this)."::create", LOG_DEBUG);
		$result = $this->db->query($sql);
		if ($result) {

			$this->id = $this->db->last_insert_id(MAIN_DB_PREFIX.$this->table_element);

			if ($this->id > 0) {
				$this->db->commit();
				return $this->id;
			}
			else {
				$this->db->rollback();
				return -2;
			}
		}
		else {
			$this->error = $this->db->error();
			$this->db->rollback();
			return -1;
		}
	}

	/**
	 *	Send name clicable (with possibly the picto)
	 *
	 *	@param	int		$withpicto		0=No picto, 1=Include picto into link, 2=Only picto
	 *	@param	string	$option			link option
	 *	@return	string					Chaine with URL
	 */
	function getNomUrl($withpicto=0,$option='')
	{
		global $langs;

		$result = '';
        $label  = $langs->trans("Showovfournisseur").': '.$this->rowid;
        $link 	= '<a href="'.dol_buildpath('/ovfournisseur/card.php?id='.$this->rowid,1).'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip">';

		$linkend = '</a>';
		$picto 	 = 'payment';

        if ($withpicto) 					$result .= ($link.img_object($label, $picto, 'class="classfortooltip"').' '.$this->rowid.$linkend);
		// if ($withpicto && $withpicto != 2) 	$result .= ' ';
		// if ($withpicto != 2) 				$result .= $link.$this->rowid.$linkend;
		
		return $result;
	}

	/**
	 * Fetch all transfer orders
	 *
	 * @return array
	 */
	
	/**
	 * Update PaymentSalaries
	 *
	 * @return int     1 updated, 0 error arised
	 */


	// Select with filter
	public function select_with_filter($selected=0,$name='vehicule',$showempty=1,$val="rowid",$opt="label",$id='',$attr=''){

	    global $conf;
	    $moreforfilter = '';
	    $nodatarole = '';
	    $id = (!empty($id)) ? $id : $name;

	    $moreforfilter.='<select width="100%" '.$attr.' class="flat" id="select_'.$id.'" name="'.$name.'">';
	    if ($showempty) $moreforfilter.='<option value="0">&nbsp;</option>';

    	$sql = "SELECT * FROM ".MAIN_DB_PREFIX.'paiementfourn';
		//echo $sql."<br>";
    	$resql = $this->db->query($sql);
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$moreforfilter.='<option value="'.$obj->$val.'"';
	            if ($obj->$val == $selected) $moreforfilter.=' selected';
	            $moreforfilter.='>'.$obj->ref.'</option>';
			}
			$this->db->free($resql);
		}

	    $moreforfilter.='</select>';
	    $moreforfilter.='<script>$(function(){$("#select_'.$id.'").select2();})</script>';
	    return $moreforfilter;
	}



	/**
	 * Get payement type
	 *
	 * @param integer $type_id id of c_paiement
	 */
	public function getPaymentType($type_id)
	{
		$type = "";
	 	$sql = "SELECT libelle as label";
		$sql.= " FROM ".MAIN_DB_PREFIX."c_paiement";
	    $sql.= " WHERE id = ". $this->db->escape((int) $type_id) ." AND active > 0";

	    $resql = $this->db->query($sql);

	    if ($resql) {
			$obj = $this->db->fetch_object($resql);
	    	
	    	$type = $obj->label;
	    }

	    return $type;
	}

	/**
	 * Update payslip when is generated
	 */
	function updatePayslip($id) {
		$sql = 'UPDATE '.MAIN_DB_PREFIX.'payment_salary SET payslip = 1';
		$sql.= ' WHERE rowid = '. $id;
		$result = $this->db->query($sql);

		if ($result) {
			return 1;
		} else {
			dol_print_error($this->db);
			return -1;
		}
	}

	public function getPaymentSalariesByovfournisseurId()
	{
		global $conf;

		$sql = "SELECT u.rowid as uid, u.lastname, u.firstname, u.login, u.email, u.admin, u.salary as current_salary, u.fk_soc as fk_soc,";
		$sql.= " s.rowid, s.fk_user, s.amount, s.salary, s.label, s.datep as datep, s.datev as datev, s.fk_typepayment as type, s.num_payment,";
		$sql.= " pst.code as payment_code";
		$sql.= " FROM ".MAIN_DB_PREFIX."  as s";
		$sql.= " LEFT JOIN ".MAIN_DB_PREFIX."c_paiement as pst ON s.fk_typepayment = pst.id,";
		$sql.= " ".MAIN_DB_PREFIX."user as u";
		$sql.= " WHERE u.rowid = s.fk_user";
		$sql.= " AND s.entity = ". $conf->entity ." and s.rowid in (". implode(", ", $this->payment_salaries) .")";
	
		$result =  $this->db->query($sql);
		
		return $result;
	}

	public function get_supplier($id)
	{
		global $conf;
		$id_soc = 0;
		$sql = 'SELECT ff.fk_soc as socid from '.MAIN_DB_PREFIX.'paiementfourn as p';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'paiementfourn_facturefourn as pf on p.rowid = pf.fk_paiementfourn ';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'facture_fourn as ff on pf.fk_facturefourn = ff.rowid ';
		$sql .= ' WHERE p.rowid = '.$id;

		$result =  $this->db->query($sql);
		if($result){
			if ($this->db->num_rows($result) > 0) {
				$obj_soc = $this->db->fetch_object($result);
				$id_soc = $obj_soc->socid;
				return $id_soc;
			}
		}
		return -1;
	}


	 public function getFact_Fournisseur($filter='')
    {
    	$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . 'facture_fourn WHERE fk_statut  IS NOT NULL AND fk_statut != 0';
    	if($filter){
    		$sql .= $filter;
    	}
    	$resql = $this->db->query($sql);
    	$invoices = array();
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$invoices[$obj->rowid] = $obj->ref; 
			}
			$this->db->free($resql);
    	}
    	return $invoices;
    }

    public function payements($fk_reglement)
    {
		$i = 0;
		$data = [];

    	$sql = 'SELECT * from '.MAIN_DB_PREFIX.'paiementfourn_facturefourn WHERE fk_paiementfourn ='.$fk_reglement;
    	$resql = $this->db->query($sql);
    	while ( $obj = $this->db->fetch_object($resql) ) {
    		$data[$i] = $obj;
    		$i++;
    	}

    	return $data;
    }

    public function get_paiement($socid=0,$factid=0)
    {
    	global $langs;
    	$sql = 'SELECT p.rowid as pid, p.ref as label from '.MAIN_DB_PREFIX.'paiementfourn as p';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'paiementfourn_facturefourn as pf on p.rowid = pf.fk_paiementfourn ';
		$sql .= ' LEFT JOIN '.MAIN_DB_PREFIX.'facture_fourn as ff on pf.fk_facturefourn = ff.rowid ';
		$sql .= ' where p.ov IS NULL OR p.ov = 0';

		if($socid){
			$sql .= ' AND ff.fk_soc = '.$socid;
		}elseif($factid){
			$sql .= ' AND ff.rowid = '.$factid;
		}
		$resql = $this->db->query($sql);
    	$paiements = array();
		$paiements['total'] = $langs->trans('totalite_facture'); 

		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$paiements[$obj->pid] = $obj->label; 
			}
			$this->db->free($resql);
    	}

		return $paiements;

    }

    public function get_Facture($id_frn, $fk_rglm)
    {
    	$sql = 'SELECT f.* FROM ' . MAIN_DB_PREFIX . 'facture_fourn as f';

    	$sql .= ' LEFT JOIN  '.MAIN_DB_PREFIX.'paiementfourn_facturefourn as pf on pf.fk_facturefourn = f.rowid';
    	$sql .= ' WHERE fk_soc='.$id_frn .' AND pf.fk_paiementfourn = '.$fk_rglm;
    	$resql = $this->db->query($sql);
    	$invoices = array();
		if ($resql) {
			while ($obj = $this->db->fetch_object($resql)) {
				$facture[$obj->rowid] = $obj->ref; 
			}
			$this->db->free($resql);
    	}
    	return $facture;
    }

    public function getRefov()
    {
	    global $conf;
			$sql = "SELECT MAX(CAST(SUBSTRING(label FROM 4) AS SIGNED)) as max";
			$sql.= " FROM ".MAIN_DB_PREFIX.$this->table_element;
			$sql.= " WHERE label LIKE 'OV-____%'";
			$resql=$this->db->query($sql);
			if ($resql)
			{
				$obj = $this->db->fetch_object($resql);
				if ($obj) $max = intval($obj->max);
				else $max=0;
			}
		    $dateY = date('Y');
			$NextRef = 'OV-'.sprintf("%04d", $id).'/'.$dateY;

			if ($max >= (pow(10, 4) - 1)) $num=$max+1;	// If counter > 9999, we do not format on 4 chars, we take number as it is
			else $num = sprintf("%04s", $max+1);

			return "OV-".$num.'/'.$dateY;



    }

    public function arr_status($etat="en_cours") {
    	$nb = '';
    	$this->fetchAll('','',0,0,' AND etat = "'.$etat.'"');
    	if(count($this->rows) > 0){
	    	$nb = count($this->rows);
    	}
    	return $nb;
	}


}
class ovfournisseurcls extends Commonobject{ 
    
    public function __construct($db){ 
        $this->db = $db;
        return 1;
    }

    public function fetch()
    {
        global $conf, $mysoc, $user, $langs;
        $langs->load('ovfournisseur@ovfournisseur');

		dol_include_once('/ovfournisseur/core/modules/modOVfournisseur.class.php');
        $modulrecrut = new modOVfournisseur($this->db);

        $nummodul = $modulrecrut->numero;
        $editeurmodul = 'nextgestion.com';

        if (!dolibarr_get_const($this->db,'EDITOR_MODULE_ovfournisseur',0))
            dolibarr_set_const($this->db,'EDITOR_MODULE_ovfournisseur','https://www.'.$editeurmodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'ID_MODULE_ovfournisseur',0))
            dolibarr_set_const($this->db,'ID_MODULE_ovfournisseur',$nummodul,'chaine',0,'',0);
        if (!dolibarr_get_const($this->db,'DATE_MODULE_ovfournisseur',0))
            dolibarr_set_const($this->db,'DATE_MODULE_ovfournisseur',date('Y-m-d'),'chaine',0,'',0);


        $id_modul      = dolibarr_get_const($this->db,'ID_MODULE_ovfournisseur',0);
        $date_modul    = dolibarr_get_const($this->db,'DATE_MODULE_ovfournisseur',0);
        $editor_modul  = dolibarr_get_const($this->db,'EDITOR_MODULE_ovfournisseur',0);

        $link = urlencode(dol_buildpath('/',2));

        if(!empty($date_modul) && $date_modul <= date('Y-m-d') && !empty($editor_modul) && !empty($id_modul) && !empty($link)){

        	$id_modul = urlencode($id_modul);

            $url = $editor_modul."/suivimod/module/registeruse?mod=".$id_modul."&link=".$link;
            $urldata = getURLContent($url);
            $response = json_decode($urldata['content']);

            if($response && $response->actif == 0){
                dolibarr_set_const($this->db,'ID_MODULE_ovfournisseur', 1, 'chaine',0,'',0);
                unActivateModule("modovfournisseur");
            }elseif($response && $response->actif == 1){
				dolibarr_set_const($this->db,'DATE_MODULE_ovfournisseur', date("Y-m-d", time() + 86400), 'chaine',0,'',0);
			}else{
				dolibarr_set_const($this->db,'DATE_MODULE_ovfournisseur', date("Y-m-d"), 'chaine',0,'',0);
			}
        }
        return 1;
    } 
}




















