<?php
/* Copyright (C) 2015 Yassine Belkaid   <y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	    \file       htdocs/ovfournisseur/card.php
 *      \ingroup    ovfournisseur
 *		\brief      Page of transfer orders
 */

$res=0;
if (! $res && file_exists("../main.inc.php")) $res=@include("../main.inc.php");       // For root directory
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';

require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';


require_once DOL_DOCUMENT_ROOT.'/fourn/class/paiementfourn.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/companybankaccount.class.php';

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/salaries.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';

dol_include_once('/ovfournisseur/class/ovfournisseur.class.php');
dol_include_once('/ovfournisseur/common.inc.php');


$langs->loadLangs(array('companies', 'bills', 'banks', 'compta'));
$langs->load('ovfournisseur@ovfournisseur');



$id 	= GETPOST("id",'int');
$action = GETPOST('action');
$format = GETPOST('format');

// Security check
$socid = GETPOST("socid","int");
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'salaries', '', '', '');

$ov  	            = new ovfournisseur($db);
$userstatic 		= new User($db);
$bankAccountstatic 	= new Account($db);
$facture  = new FactureFournisseur($db);
/**
 * Actions
 */

if ($_POST["cancel"] == $langs->trans("Cancel")) {
	header("Location: index.php");
	exit;
}

$morejs	= array("/ovfournisseur/js/ovfournisseur.js");
$error 	= 0;

if ($id && $action == "pdf") {
	$title = "Ordre de virement";


	require_once dol_buildpath('/ovfournisseur/pdf/pdf.lib.php');
	$pdf->SetFont('dejavusans', '', 14, '', true);

	// Add a page
	$pdf->AddPage();

	// set text shadow effect
	$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

	require_once dol_buildpath('/ovfournisseur/tpl/ovfournisseur.php');

	// Print text using writeHTMLCell()
	$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

	// ---------------------------------------------------------

	// Close and output PDF document
	// This method has several options, check the source code documentation for more information.
	$pdf->Output('order_virement-'.$cd .'-'. $cm .'-'. $cy.'.pdf', 'I');
	die();
}

if ($action == "pdfall") {
	
}


if ($action == 'add') {
	$insertedAll = true;
	$getInsertedLines = array();
	$fk_label 		  = (isset($_POST['fk_label']) && !empty($_POST['fk_label']) ? (string) trim($_POST['fk_label'])  : '');
	$date_ordre       = (isset($_POST['date_ordre']) && !empty($_POST['date_ordre']) ? trim($_POST['date_ordre'])  : '');
	$fk_user_author   = (isset($_POST['fk_user_author']) && !empty($_POST['fk_user_author']) ? (int) trim($_POST['fk_user_author'])  : '');
	$fk_account 	  = (isset($_POST['fk_account']) && !empty($_POST['fk_account']) ? (int) trim($_POST['fk_account'])  : '');
	$fk_reglement 	  = (isset($_POST['fk_reglement']) && !empty($_POST['fk_reglement']) ? $_POST['fk_reglement']  : '');
	$fk_facture 	  = (isset($_POST['facture_id']) && !empty($_POST['facture_id'] && $_POST['facture_id'] > 0) ? (int) trim($_POST['facture_id'])  : '');
	$fk_supplier 	  = (isset($_POST['supplier_id']) && !empty($_POST['supplier_id'] && $_POST['supplier_id'] > 0) ? (int) trim($_POST['supplier_id'])  : '');
	$montant    	  = (isset($_POST['reglement_amount']) && !empty($_POST['reglement_amount']) ? $_POST['reglement_amount']  : 0);
	$etat_ov    	  = (isset($_POST['etat']) && !empty($_POST['etat']) ? $_POST['etat']  : 'en_cours');
	$type             = "paiement";


	if($fk_reglement == 'total' || $fk_reglement == 0){
		$fk_reglement = 0;
		$type = "facture";
		$facture->fetch($fk_facture);
		
		$montant = $facture->total_ttc;

       
	}

	if($fk_reglement == -1){
		setEventMessages('Aucun paiement non réglé', $ov->errors, 'errors');
		header("Location: card.php?action=create&leftmenu=suppliers_bills");
		exit;
	}

	// unset some vars to have just clean array 
	unset($_POST['date_ordre'], $_POST['date_ordreday'], $_POST['date_ordremonth'], $_POST['date_ordreyear']);
	unset($_POST['fk_user_author'],$_POST['fk_account']);
	unset($_POST['action'], $_POST['token']);


	list($dpd, $mpd, $ypd) = explode("/", $date_ordre);
	// insert transfer order
	$ov->label  		   = $fk_label;
	$ov->date_ordre        = dol_mktime(12,0,0, $mpd, $dpd, $ypd);
	$ov->fk_user_author    = (int)$fk_user_author;
	$ov->fk_reglement 	   = (int)$fk_reglement;
	$ov->fk_account 	   = (int)$fk_account;
	$ov->fk_supplier 	   = (int)$fk_supplier;
	$ov->fk_facture 	   = (int)$fk_facture;
	$ov->montant 	       = $montant;
	$ov->etat 	           = $etat_ov;
	$ov->type              = $type;
	$check = $ov->create($user);
	if ($check > 0) {
		$msql = 'UPDATE '.MAIN_DB_PREFIX.'paiementfourn SET ov = 1 where rowid='.$fk_reglement;
        $remsql = $db->query($msql);
        if($type == 'facture'){
	        $sql = 'UPDATE '.MAIN_DB_PREFIX.'facture_fourn_extrafields set ov = '.$check.' WHERE fk_object ='.$fk_facture;
	        $resql = $db->query($sql);
			if(!$resql){
				$msql = "INSERT INTO ".MAIN_DB_PREFIX."facture_fourn_extrafields (fk_object,tms,ov) VALUES (".$fk_facture.",'".date('Y-m-d H:i:s')."',".$check.")";
		        $remsql = $db->query($msql);
			}
        }
        
		$db->commit();
		header("Location: liste.php");
		exit;
	}
	else {
		$db->rollback();
		setEventMessages($ov->error, $ov->errors, 'errors');
		header("Location: card.php?action=create&leftmenu=suppliers_bills");
		exit;
	}
}
if($action == 'add_ov_facture'){

	$backtopage = GETPOST('backtopage');
	$id_payement = GETPOST('id_payement');
	$fk_supplier = 0;
	$ov_facture = new ovfournisseur($db);
	$facture = new FactureFournisseur($db);
	if($id_payement){
		$payement = new PaiementFourn($db);
		$payement->fetch($id_payement);
		$dt_url = explode('?facid=', $backtopage);
		$fk_facture = $dt_url[1];
		if(strpos('&', $fk_facture)){
			$fk_facture = explode('&', $fk_facture);
			$fk_facture = $fk_facture[0];
		}
		$facture->fetch($fk_facture);
		$fk_supplier = $facture->fk_soc;

		$ov_facture->label = $ov_facture->getRefov();
		$ov_facture->fk_reglement = $id_payement;
		$ov_facture->date_ordre = date('Y-m-d',$payement->datepaye);
		$ov_facture->fk_user_author = $user->id;
		$ov_facture->fk_account = $payement->bank_account;
		$ov_facture->fk_supplier = $fk_supplier;
		$ov_facture->fk_facture = $fk_facture;
		$ov_facture->montant = $payement->montant;
		$ov_facture->etat = 'en_cours';
		$ov_facture->type = 'paiement';
		$new_id = $ov_facture->create();
	}

	if($new_id){
		$msql = 'UPDATE '.MAIN_DB_PREFIX.'paiementfourn SET ov = 1 where rowid='.$id_payement;
        $remsql = $db->query($msql);
		if($backtopage){
	        header('Location:'.$backtopage);
	    }else
	        header('Location: ./liste.php');
	    exit;
	}
	else{
		setEventMessages($object->error, $object->errors, 'errors');
        header('Location:'.$backtopage);
	    exit;

	}
}

if ($action == 'update') {

	
	// update transfer order
	$ovfournisseur->fetch($id);
	$ovfournisseur->update($id);

	if ($check > 0) {
		$db->commit();
		header("Location: card.php?id=". $id ."&leftmenu=suppliers_bills");
		exit;
	}
	else {
		$db->rollback();
		setEventMessages($ovfournisseur->error, $ovfournisseur->errors, 'errors');
		header("Location: card.php?id=". $id ."&leftmenu=suppliers_bills");
		exit;
	}
}

// traiter 
if ($action == 'traite' && $id) {
	$ov_fournisseur = new ovfournisseur($db);
	$ov_fournisseur->fetch($id);
	$ov_fournisseur->etat = 'traite';
	$result = $ov_fournisseur->update($id);
	if ($result > 0) {
		$db->commit();
		header("Location: card.php?id=".$id."&leftmenu=suppliers_bills");
		exit;
	}
}


// Delete ov
if ($action == 'delete' && $id) {
	
	$ovfournisseur_d = new ovfournisseur($db);
	$ovfournisseur_d->fetch($id);
	$fk_object = $ovfournisseur_d->fk_facture;
	if($ovfournisseur_d->fk_reglement){
		$msql = 'UPDATE '.MAIN_DB_PREFIX.'paiementfourn SET ov = 0 where rowid='.$ovfournisseur_d->fk_reglement;
		$remsql = $db->query($msql);
	}

	$ret = $ovfournisseur_d->delete();

	if ($ret > 0) {
		$db->commit();

		$sql_2 = "UPDATE `".MAIN_DB_PREFIX."facture_fourn_extrafields` set `ov` = NULL  WHERE `fk_object` = ".$fk_object ;
		$resql = $db->query($sql_2);

		header("Location: ".dol_buildpath('/ovfournisseur/liste.php',2)) ;
		exit;
	}
	else {
		$db->rollback();
		setEventMessage($ovfournisseur->error,'errors');
	}
}

/*
 *	View
 */
llxHeader(array(),'Ordre de virement','','','','',$morejs);

$form = new Form($db);



// New ov
if ($action == 'create') {
	$year_current 	= strftime("%Y",dol_now());
	$pastmonth 		= strftime("%m",dol_now()) - 1;
	$pastmonthyear = $year_current;

	if ($pastmonth == 0) {
		$pastmonth = 12;
		$pastmonthyear--;
	}

	$datesp = dol_mktime(0, 0, 0, $datespmonth, $datespday, $datespyear);
	$dateep = dol_mktime(23, 59, 59, $dateepmonth, $dateepday, $dateepyear);

	// We define date_start and date_end
	if (empty($datesp) || empty($dateep)) {
		$datesp=dol_get_first_day($pastmonthyear,$pastmonth,false); $dateep=dol_get_last_day($pastmonthyear,$pastmonth,false);
	}
	print '<form action="'.$_SERVER["PHP_SELF"].'" method="post">';
		print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
		print '<input type="hidden" name="action" value="add">';
		print '<input type="hidden" id="baseCore" value="'.DOL_URL_ROOT.'/core/">';
		print '<input type="hidden" id="ovfournisseur_root" value="'.dol_buildpath('/ovfournisseur/',2).'">';

		print_fiche_titre($langs->trans("Newovfournisseur"),'', 'title_accountancy.png');

		dol_fiche_head('', '');
		
		$date_ordre = (isset($_POST['date_ordre']) && !empty($_POST['date_ordre']) ? trim($_POST['date_ordre'])  : '');
	
		print '<table class="border table_ov" width="100%">';
			// Label
			print "<tr>";
				print '<td class="fieldrequired">'.$langs->trans("Label").'</td>';
				print '<td><input name="fk_label" value="'.$ov->getRefov().'"  size="20" width="200px" /></td>';
			print '</tr>';
			
			print "<tr>";
				print '<td class="fieldrequired">'.$langs->trans("Date").'</td>';
				print '<td>';
					$form->select_date(date('Y-m-d'),"date_ordre",0,0,0,'add',1,1,0, 0, '', '');
				print '</td>';
			print '</tr>';
			// Author
			print "<tr>";
				print '<td class="fieldrequired">'.$langs->trans("signe_by").'</td>';
				print '<td>';
					print $form->select_dolusers(GETPOST('fk_user_author','int'), 'fk_user_author', 1, '', 0, '', '', 0, 0, 0, '', 0, '', 'fk_user_author',true);
					print '<br></br><span class="msg_erreur" id="msg_erreur_author"><span class="etoil"> * </span>'.$langs->trans('txt_error_outhor').'</span>';
				print '</td>';
			print '</tr>';
			// Author
			print "<tr>";
				print '<td class="fieldrequired">'.$langs->trans("Supplier").'</td>';
				print '<td>';
					print $form->select_thirdparty(0, 'supplier_id');
					print '<br></br><span class="msg_erreur" id="msg_erreur_supplier"><span class="etoil"> * </span>'.$langs->trans('txt_error_supplier').'</span>';
				print '</td>';
			print '</tr>';
			// Author
			print "<tr>";
				print '<td class="fieldrequired">'.$langs->trans("invoice").'</td>';
				print '<td >';
			        print '<div class="list_facture">'.$form->selectarray('facture_id',NULL,'', 1, 0, 0, ' required ').'</div>';
			        print '<div class="amount_facture"><span class="fieldrequired">'.$langs->trans('Amount').' : </span> <span class="amount fieldrequired"></span> </div>';
					print '<br></br><span class="msg_erreur" id="msg_erreur_invoice"><span class="etoil"> * </span>'.$langs->trans('txt_error_invoice').'</span>';
				print '</td>';
			
			print '</tr>';
				print '<td class="fieldrequired">'.$langs->trans("reglement").'</td>';
				print '<td>';
					print '<input type="hidden" id="reglement_amount" name="reglement_amount" value="0">';
					print '<div class="list_reglement">';
				        print $form->selectarray('fk_reglement',NULL,'', 1, 0, 0, ' required ');
					print '</div>';
			        print '<div class="amount_reglement"><span class="fieldrequired">'.$langs->trans('Amount').' : </span> <span class="amount fieldrequired"></span> </div>';
					print '<br></br><span class="msg_erreur" id="msg_erreur_reglement"><span class="etoil"> * </span>'.$langs->trans('txt_error_reglement').'</span>';
				print '</td>';
			print '</tr>';
			// // Bank
			// print '<tr><td class="fieldrequired">'.$langs->trans("TotalTTC").'</td>';
			// 	print '<td>';
			// 		print '<span id="facture_amount" type="number" value="" >';  // Montant de la facture
			// 	print '</td>';
			// print '</tr>';
			// // Bank
			// Bank
			print '<tr><td class="fieldrequired">'.$langs->trans("Account").'</td>';
				print '<td>';
					$form->select_comptes($_POST["fk_account"],"fk_account",0,'',1);  // Affiche liste des comptes courant
					print '<br></br><span class="msg_erreur" id="msg_erreur_account"><span class="etoil"> * </span>'.$langs->trans('txt_error_account').'</span>';
				print '</td>';
			print '</tr>';
			print '<tr><td class="fieldrequired">'.$langs->trans("Status").'</td>';
				print '<td>';
					print '<select id="etat_ov" name="etat">';
						print '<option value="en_cours">'.$langs->trans('en_cours').'</option>';
						print '<option value="traite">'.$langs->trans('traite').'</option>';
					print '</select>';  //etat ov
				print '</td>';
			print '</tr>';
		print '</table>';

		print '<br/><br/>';
	  	
		print '<br><br><div class="center action_add">';
			print '<input type="submit" class="button" value="'.$langs->trans("Save").'">';
			print '<a href="./liste.php?" class="button">'.$langs->trans('Cancel').'</a>';
		print '</div>';

	print '</form>';
}

//  Show ov
if ($id) {
	$ov->fetch($id);
	if ($ov->error) {
		echo $ov->error;
	}

	$bankAccount2 = new Account($db);
	$bankAccount2->fetch($ov->fk_account);
	print_fiche_titre($langs->trans("ovfournisseur"),'', 'title_accountancy.png');
	$etat = (!empty($ov->etat) ? $ov->etat : 'en_cours');
	$const_color = [
		'en_cours' =>(dolibarr_get_const($db,'COLOR_OV_ENCOUR',$conf->entity) ? dolibarr_get_const($db,'COLOR_OV_ENCOUR',$conf->entity) : ovfournisseur::COLORS_ETAT['en_cours'] ),
		'traite' =>(dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) ? dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) : ovfournisseur::COLORS_ETAT['traite'] )
	];
	print '<table class="border" width="100%">';
		// label
		print "<tr>";
			print '<td width="25%">'.$langs->trans("Label").'</td><td>';
				print $ov->label;
				print '<span class="etat_ov" ><b>'.$langs->trans('Status_Ov').': </b><span class="etat_'.$etat.'" style="background:'.$const_color[$etat].'"></span>'.$langs->trans($etat).'</span>';
			print '</td>';
		print '</tr>';

		// date_virement
		print "<tr>";
			print '<td width="25%">'.$langs->trans("date_virement").'</td><td>';
				print dol_print_date($ov->date_ordre, 'day');
			print '</td>';
		print '</tr>';

		// Author
		print "<tr>";
			print '<td >'.$langs->trans("Author").'</td>';
			print '<td>';
				$userstatic = new User($db);
				$userstatic->fetch($ov->fk_user_author);
				print $userstatic->getNomUrl(1);
			print '</td>';
		print '</tr>';

		// Supplier
		print "<tr>";
			print '<td >'.$langs->trans("Supplier").'</td>';
			print '<td>';
	        	if($ov->fk_supplier){
					$supplier = new Societe($db);
					$supplier->fetch($ov->fk_supplier);
					print $supplier->getNomUrl(1);
	        	}
			print '</td>';
		print '</tr>';
		// Invoice
		print "<tr>";
			print '<td >'.$langs->trans("Invoice").'</td>';
			print '<td>';
	        	if($ov->fk_facture){
						$facture = new FactureFournisseur($db);
						$facture->fetch($ov->fk_facture);
						print $facture->getNomUrl(1);
		        	}
			print '</td>';
		print '</tr>';
		
		// Reglement
        if($ov_->type =='paiement'){
			print "<tr>";
				print '<td >'.$langs->trans("reglement").'</td>';
				print '<td>';
		        	if($ov->fk_reglement){
						$reglement = new PaiementFourn($db);
						$reglement->fetch($ov->fk_reglement);
						print $reglement->getNomUrl(1);
		        	}
				print '</td>';
			print '</tr>';
		}
		// Bank
		print '<tr><td>'.$langs->trans("Account").'</td><td>';
			print $bankAccount2->getNomUrl(1).' - '.$bankAccount2->label;  // Affiche liste des comptes courant
		print '</td></tr>';
		// Create Date
		print '<tr><td>'.$langs->trans("Amount").'</td><td>';
			print number_format($ov->montant,2,',',' ');  // Affiche liste des comptes courant
		print '</td></tr>';
	print '</table><br /><br />';

	if($ov->fk_reglement){

		$factures_regles = $ov->payements($ov->fk_reglement);

		if (count($factures_regles) > 0)
		{

			$i = 0;
			$total = 0;
			print '<b>'.$langs->trans("Invoices").'</b><br>';
			print '<table class="noborder" width="100%">';
			print '<tr class="liste_titre">';
			print '<td>'.$langs->trans('Ref').'</td>';
			print '<td>'.$langs->trans('RefSupplier').'</td>';
			print '<td class="right">'.$langs->trans('ExpectedToPay').'</td>';
			print '<td class="right">'.$langs->trans('PayedByThisPayment').'</td>';
			print '<td class="right">'.$langs->trans('Status_fact').'</td>';
			print "</tr>\n";
			foreach ($factures_regles as $key => $value) 
			{
				$facture = new FactureFournisseur($db);
				$facture->fetch($value->fk_facturefourn);

				print '<tr class="oddeven">';
					// Ref
					print '<td>';
					print $facture->getNomUrl(1);
					print "</td>\n";
					// Ref supplier
					print '<td>'.$facture->ref_supplier."</td>\n";
					// Third party
					// Expected to pay
					print '<td class="right">'.price($facture->total_ttc-$value->amount).'</td>';
					// Payed
					print '<td class="right">'.price($value->amount).'</td>';
					// Status
					print '<td class="right">'.$facture->LibStatut($facture->paye, $facture->fk_statut, 6, 1).'</td>';
				print "</tr>\n";

				if ($facture->paye == 1)
				{
					$allow_delete = 0;
					$title_button = dol_escape_htmltag($langs->transnoentitiesnoconv("CantRemovePaymentWithOneInvoicePaid"));
				}
				$total = $total + $facture->amount;
				$i++;
			}


			print "</table>\n";
		}
		else
		{
			dol_print_error($db);
		}
	}else{
		if($ov->type == 'facture'){

			print '<b>'.$langs->trans("Invoice").'</b><br>';
			print '<table class="noborder" width="100%">';
				print '<tr class="liste_titre">';
					print '<td>'.$langs->trans('Ref').'</td>';
					print '<td>'.$langs->trans('RefSupplier').'</td>';
					print '<td class="right">'.$langs->trans('Amount').'</td>';
					print '<td class="right">'.$langs->trans('Status_fact').'</td>';
				print "</tr>\n";

				$facture = new FactureFournisseur($db);
				$facture->fetch($ov->fk_facture);

				print '<tr class="oddeven">';
					// Ref
					print '<td>';
					print $facture->getNomUrl(1);
					print "</td>\n";
					// Ref supplier
					print '<td>'.$facture->ref_supplier."</td>\n";
					// Third party
					// Expected to pay
					print '<td class="right">'.price($facture->total_ttc).'</td>';
					// Payed
					// Status
					print '<td class="right">'.$facture->LibStatut($facture->paye, $facture->fk_statut, 6, 1).'</td>';
				print "</tr>\n";
			print "</table>\n";

		}
	}


	print '<div style="float: right; margin-top: 8px;">';
	if(empty($ov->etat) || $ov->etat == 'en_cours')
		print '<a href="card.php?action=traite&id='. $id .'" class="butAction">'.$langs->trans('traite').'</a>';
		print '<a href="./liste.php?" class="butAction">'.$langs->trans('Cancel').'</a>';
		print '<a href="card.php?action=delete&id='. $id .'" class="butActionDelete">'.$langs->trans('Delete').'</a>';
	print '</div>';
}

?>
<script type="text/javascript">
	$(document).ready(function(){
		$('select.fk_user,select[name="fk_account"],#facture_id,#fk_reglement').select2();
	});
</script>
<?php
llxFooter();

$db->close();
