<?php
/* Copyright (C) 2015	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       salariescontracts/common.inc.php
 *		\ingroup    salariescontracts
 *		\brief      Common load of data
 */

// require_once realpath(dirname(__FILE__)).'/../main.inc.php';
$res=@include("../../main.inc.php");                    // For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php")) $res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../../main.inc.php");        // For "custom" directory


require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';

require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';
require_once DOL_DOCUMENT_ROOT.'/fourn/class/paiementfourn.class.php';

dol_include_once('/ovfournisseur/class/ovfournisseur.class.php');
dol_include_once('/ovfournisseur/common.inc.php');


$langs->loadLangs(array('companies', 'bills', 'banks', 'compta'));
$langs->load('ovfournisseur@ovfournisseur');

$morejs = array('/ovfournisseur/js/ovfournisseur.js');

llxHeader(array(),'Configuration','','','','',$morejs);

$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'    . $langs->trans("BackToModuleList") . '</a>';


// print_barre_liste($langs->trans("Setup"), $page, $_SERVER["PHP_SELF"], $param, $sortfield, $sortorder, '', $num, $totalnboflines, 'title_accountancy.png');
print_fiche_titre($langs->trans('ovfournisseurSetup'), $linkback);



$action=GETPOST('action');

if($action == 'valide'){

	$objet_ov     = trim(GETPOST('objet'));
	$msgpied_ov   = trim(GETPOST('msgpied'));
	$msgentet_ov  = trim(GETPOST('msgentet'));
	// Color
	$color_en_cours = trim(GETPOST('color_en_cours'));
	$color_traite   = trim(GETPOST('color_traite'));

	$objet_ot     = trim(GETPOST('objet_ot'));
	$msgpied_ot   = trim(GETPOST('msgpied_ot'));
	$msgentet_ot  = trim(GETPOST('msgentet_ot'));
	// Color
	$color_en_cours_ot = trim(GETPOST('color_en_cours_ot'));
	$color_traite_ot   = trim(GETPOST('color_traite_ot'));

	dolibarr_set_const($db,'MSG_OBJET_OV',$objet_ov,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'MSG_PIED_OV',$msgpied_ov,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'MSG_ENTETE_OV',$msgentet_ov,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'COLOR_OV_ENCOUR',$color_en_cours,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'COLOR_OV_TRAITE',$color_traite,'chaine',0,'',$conf->entity);


	dolibarr_set_const($db,'MSG_OBJET_OT',$objet_ot,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'MSG_PIED_OT',$msgpied_ot,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'MSG_ENTETE_OT',$msgentet_ot,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'COLOR_OT_ENCOUR',$color_en_cours_ot,'chaine',0,'',$conf->entity);
	dolibarr_set_const($db,'COLOR_OT_TRAITE',$color_traite_ot,'chaine',0,'',$conf->entity);


}

print '<form class="config_ov" action="'.$_SERVER["PHP_SELF"].'" method="post">';
print '<input type="hidden" value="valide" name="action" >';

	print '<div class="liste_titre"> '.$langs->trans('config_ov').' </div>';

	print '<table class="border" style="width:100%;">';
		
		$objet_ov = (dolibarr_get_const($db,'MSG_OBJET_OV',$conf->entity) ? dolibarr_get_const($db,'MSG_OBJET_OV',$conf->entity) : $langs->trans('txt_objectov_pdf') );
		$entet_ov = (dolibarr_get_const($db,'MSG_ENTETE_OV',$conf->entity) ? dolibarr_get_const($db,'MSG_ENTETE_OV',$conf->entity) : $langs->trans('txt_entet_pdf'));
		$pied_ov  = (dolibarr_get_const($db,'MSG_PIED_OV',$conf->entity) ? dolibarr_get_const($db,'MSG_PIED_OV',$conf->entity) : $langs->trans('txt_pied_pdf') );
		$color_en_cours_ov = (dolibarr_get_const($db,'COLOR_OV_ENCOUR',$conf->entity) ? dolibarr_get_const($db,'COLOR_OV_ENCOUR',$conf->entity) : ovfournisseur::COLORS_ETAT['en_cours'] );
		$color_traite_ov = (dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) ? dolibarr_get_const($db,'COLOR_OV_TRAITE',$conf->entity) : ovfournisseur::COLORS_ETAT['traite']);

		print '<tr>';
			print '<td style="width:25%;">'.$langs->trans("Subject").'</td>';
			print '<td><input type="text" name="objet" value="'.$objet_ov.'" ></td>';
		print '</tr>';

		print '<tr>';
			print '<td>'.$langs->trans("msgentet").'</td>';
			print '<td><textarea class="msgentet" name="msgentet" > '.$entet_ov.' </textarea></td>';
		print '</tr>';

		print '<tr>';
			print '<td>'.$langs->trans("msgpied").'</td>';
			print '<td><textarea class="msgpied" name="msgpied" > '.$pied_ov.' </textarea></td>';
		print '</tr>';

	print '</table>';

	print '<br><br>';

	print '<div class="liste_titre"> '.$langs->trans('config_ot').' </div>';
	print '<table class="border" style="width:100%;">';
		
		$objet_ot = (dolibarr_get_const($db,'MSG_OBJET_OT',$conf->entity) ? dolibarr_get_const($db,'MSG_OBJET_OT',$conf->entity) : $langs->trans('txt_objectov_pdf') );
		$entet_ot = (dolibarr_get_const($db,'MSG_ENTETE_OT',$conf->entity) ? dolibarr_get_const($db,'MSG_ENTETE_OT',$conf->entity) : $langs->trans('txt_entet_pdf'));
		$pied_ot  = (dolibarr_get_const($db,'MSG_PIED_OT',$conf->entity) ? dolibarr_get_const($db,'MSG_PIED_OT',$conf->entity) : $langs->trans('txt_pied_pdf') );

		$color_en_cours_ot = (dolibarr_get_const($db,'COLOR_OT_ENCOUR',$conf->entity) ? dolibarr_get_const($db,'COLOR_OT_ENCOUR',$conf->entity) : ovfournisseur::COLORS_ETAT['en_cours'] );
		$color_traite_ot = (dolibarr_get_const($db,'COLOR_OT_TRAITE',$conf->entity) ? dolibarr_get_const($db,'COLOR_OT_TRAITE',$conf->entity) : ovfournisseur::COLORS_ETAT['traite']);

		print '<tr>';
			print '<td style="width:25%;">'.$langs->trans("Subject").'</td>';
			print '<td><input type="text" name="objet_ot" value="'.$objet_ot.'" ></td>';
		print '</tr>';

		print '<tr>';
			print '<td>'.$langs->trans("msgentet").'</td>';
			print '<td><textarea class="msgentet" name="msgentet_ot" > '.$entet_ot.' </textarea></td>';
		print '</tr>';

		print '<tr>';
			print '<td>'.$langs->trans("msgpied").'</td>';
			print '<td><textarea class="msgpied" name="msgpied_ot" > '.$pied_ot.' </textarea></td>';
		print '</tr>';

	print '</table>';

	print '<br><br>';
	print '<div class="liste_titre"> '.$langs->trans('config_colors').' </div>';
	print '<br><br>';

	print '<div class="fichecenter">';

		print '<div class="fichehalfleft">';
			print '<div class="liste_titre"> '.$langs->trans('ov_frn').' </div>';
			print '<table class="border config_colors" style="width:100%;">';
				
				print '<tr>';
					print '<td style="width:25%;">'.$langs->trans("color_en_cours").'</td>';
					print '<td>';
						print '<input type="color" name="color_en_cours" value="'.$color_en_cours_ov.'" >';
						print '<span class="cod_color">'.$color_en_cours_ov.'</span>';
					print ' </td>';
				print '</tr>';

				print '<tr>';
					print '<td>'.$langs->trans("color_traite").'</td>';
					print '<td><input type="color" name="color_traite" value="'.$color_traite_ov.'" >';
					print '<span class="cod_color">'.$color_traite_ov.'</span> </td>';
				print '</tr>';
													
			print '</table>';
		print '</div>';

		print '<div class="fichehalfright">';
			print '<div class="liste_titre"> '.$langs->trans('ov_salaire').' </div>';
			print '<table class="border config_colors" style="width:100%;">';
				
				print '<tr>';
					print '<td style="width:25%;">'.$langs->trans("color_en_cours").'</td>';
					print '<td><input type="color" name="color_en_cours_ot" value="'.$color_en_cours_ot.'" >';
					print '<span class="cod_color">'.$color_en_cours_ot.'</span> </td>';
				print '</tr>';

				print '<tr>';
					print '<td>'.$langs->trans("color_traite").'</td>';
					print '<td><input type="color" name="color_traite_ot" value="'.$color_traite_ot.'" >';
					print '<span class="cod_color">'.$color_traite_ot.'</span> </td>';
				print '</tr>';
													
			print '</table>';
		print '</div>';

	print '</div>';
	print '<br><br>';
	print '<div class="center">';
		print '<input type="submit" class="button" value="'.$langs->trans("Save").'">';
	print '</div>';

print '</form>';