<?php

if (!class_exists('SeedObject'))
{

    define('INC_FROM_DOLIBARR', true);
    require_once dirname(__FILE__).'/../config.php';
}


class OperationOrderBarCode extends SeedObject
{

    /** @var string $table_element Table name in SQL */
    public $table_element = 'operationorderbarcode';

    /** @var string $element Name of the element (tip for better integration in Dolibarr: this value should be the reflection of the class name with ucfirst() function) */
    public $element = 'operationorderbarcode';

    /** @var int $isextrafieldmanaged Enable the fictionalises of extrafields */
    public $isextrafieldmanaged = 1;

    /** @var int $ismultientitymanaged 0=No test on entity, 1=Test with field entity, 2=Test with link by societe */
    public $ismultientitymanaged = 1;

    /** @var string $picto a picture file in [@...]/img/object_[...@].png  */
    public $picto = 'operationorder@operationorder';

	/** @var int $fullday flag for event display like full day event */
	public $fullday = 1;

    public $fields=array(
        'label' => array('type'=>'varchar(255)', 'label'=>'Label', 'enabled'=>1, 'position'=>10, 'notnull'=>1, 'visible'=>1),
        'code' => array('type'=>'varchar(255)', 'label'=>'DateD', 'enabled'=>1, 'position'=>170, 'notnull'=>1, 'visible'=>1),
        'entity' => array('type'=>'int', 'label'=>'Entity', 'enabled'=>1, 'position'=>210, 'notnull'=>1, 'visible'=>1),
    );

    public $label;
    public $code;
    public $entity;

    /**
     * OperationOrder constructor.
     * @param DoliDB    $db    Database connector
     */
    public function __construct($db)
    {
        global $conf;

        parent::__construct($db);

        $this->init();

        $this->entity = $conf->entity;
    }

    /**
     * @param User $user User object
     * @param	bool	$notrigger	false=launch triggers after, true=disable triggers
     * @return int
     */
    public function save($user, $notrigger = false)
    {
        return parent::create($user, $notrigger);
    }

    /**
     * Function to update object or create or delete if needed
     *
     * @param   User    $user   user object
     * @param	bool	$notrigger	false=launch triggers after, true=disable triggers
     * @return  int                < 0 if ko, > 0 if ok
     */
    public function update(User &$user, $notrigger = false)
    {
        return parent::update($user, $notrigger);
    }

    /**
     * @param User $user User object
     * @param	bool	$notrigger	false=launch triggers after, true=disable triggers
     * @return int
     */
    public function delete(User &$user, $notrigger = false)
    {
        return parent::delete($user, $notrigger);
    }

}
