<?php
/* Copyright (C) 2013  Drosis Nikos  <ndrosis@technicks.gr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	mymodule	MyModule module
 * 	\brief		MyModule module descriptor.
 * 	\file		core/modules/modMyModule.class.php
 * 	\ingroup	mymodule
 * 	\brief		Description and activation file for module MyModule
 */
include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

/**
 * Description and activation class for module Factureodtopdf
 */
class mododtopdf extends DolibarrModules
{

	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;

		$this->numero = 13000;
		$this->rights_class = 'odtopdf';

		$this->family = "technic";

		$this->name = preg_replace('/^mod/i', '', get_class($this));

		$this->description = "Enable model ODT to PDF";

		$this->version = '3.7.1';

		$this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);

		$this->special = 0;

		$this->picto = 'odtopdf@odtopdf'; 

		$this->module_parts = array(
			'models' => 1,
		);


		$this->dirs = array();


		$this->config_page_url = array("admin_odtopdf.php@odtopdf");
		$this->depends = array('invoice');
		$this->requiredby = array();
		$this->phpmin = array(5, 2);
		$this->need_dolibarr_version = array(3, 2);
		$this->langfiles = array("odtopdf@odtopdf"); 

		$this->const = array();
		$r=0;
		
		$this->const[$r][0] = "FACTUREODTOPDF_ADDON_PDF_ODT_PATH";
        $this->const[$r][1] = "chaine";
        $this->const[$r][2] = "DOL_DATA_ROOT/odtopdftemplates/invoices";
        $this->const[$r][3] = "";
        $this->const[$r][4] = 0;
        $r++;
		
		$this->const[$r][0] = "PROPALEODTOPDF_ADDON_PDF_ODT_PATH";
		$this->const[$r][1] = "chaine";
		$this->const[$r][2] = "DOL_DATA_ROOT/odtopdftemplates/proposals";
		$this->const[$r][3] = "";
		$this->const[$r][4] = 0;
		$r++;
		
		$this->const[$r][0] = "COMMANDEODTOPDF_ADDON_PDF_ODT_PATH";
		$this->const[$r][1] = "chaine";
		$this->const[$r][2] = "DOL_DATA_ROOT/odtopdftemplates/orders";
		$this->const[$r][3] = "";
		$this->const[$r][4] = 0;
		
		
		$this->tabs = array();

		if ( ! isset($conf->mymodule->enabled)) $conf->mymodule->enabled = 0;
		$this->dictionnaries = array();
	

		// Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
		$this->boxes = array(); // Boxes list
		$r = 0;
		
		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 0;

		// Main menu entries
		$this->menus = array(); // List of menus to add
		$r = 0;
	}

	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		global $conf,$langs;

		// Remove permissions and default values
		$this->remove($options);

		//ODT template
		$src=DOL_DOCUMENT_ROOT.'/odtopdf/odtopdftemplates/template_odtopdf/template_odtopdf.odt';
		$srcpro=DOL_DOCUMENT_ROOT.'/odtopdf/odtopdftemplates/template_odtopdf/template_odtopdf_pro.odt';
		$srcord=DOL_DOCUMENT_ROOT.'/odtopdf/odtopdftemplates/template_odtopdf/template_odtopdf_ord.odt';
		$dirodt=DOL_DATA_ROOT.'/odtopdftemplates/invoices';
		$dirpro=DOL_DATA_ROOT.'/odtopdftemplates/proposals';
		$dirord=DOL_DATA_ROOT.'/odtopdftemplates/orders';
		$dest=$dirodt.'/template_invoice.odt';
		$destpro=$dirpro.'/template_proposal.odt';
		$destord=$dirord.'/template_order.odt';

		if (file_exists($src) && ! file_exists($dest))
		{
			require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
			dol_mkdir($dirodt);
			dol_mkdir($dirpro);
			dol_mkdir($dirord);
			$result=dol_copy($src,$dest,0,0);
			$result=dol_copy($srcpro,$destpro,0,0);
			$result=dol_copy($srcord,$destord,0,0);
			if ($result < 0)
			{
				$langs->load("errors");
				$this->error=$langs->trans('ErrorFailToCopyFile',$src,$srcpro,$srcord,$dest,$destpro,$destord);
				return 0;
			}
		}

		$sql = array();

		return $this->_init($sql,$options);
	}

    /**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
     */
    function remove($options='')
    {
		$sql = array();

		return $this->_remove($sql,$options);
    }
}

?>
