<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		admin/admin.php
 * 	\ingroup	menu3dresponsive
 * 	\brief		This file is an example module setup page
 * 				Put some comments here
 */
// Dolibarr environment
$res=@include("../../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../../main.inc.php");		// For "custom" directory

// Libraries
require_once DOL_DOCUMENT_ROOT . '/core/lib/admin.lib.php';

dol_include_once('/menu3dresponsive/lib/menu3dresponsive.lib.php');


// Translations
$langs->load("admin");
$langs->load("menu3dresponsive@menu3dresponsive");

// Access control
if (! $user->admin) accessforbidden();



/*
 * Actions
 */
$mesg="";
$action = GETPOST('action', 'alpha');

if (preg_match('/^set/',$action)) {
  // This is to force to add a new param after css urls to force new file loading
  // This set must be done before calling llxHeader().
//  $_SESSION['dol_resetcache']=dol_print_date(dol_now(),'dayhourlog');
}

// set toggled options
if ($action == 'show_vertical_menu') { 
  	$name = GETPOST ( 'name', 'text' );
  	$value = GETPOST ( 'value', 'int' );	

	if ($value) {
		$res = dolibarr_set_const($db, $name, 1, 'yesno', 0, '', $conf->entity);	
	} else {
		$res = dolibarr_set_const($db, $name, 0, 'yesno', 0, '', $conf->entity);
	}
	
	if (! $res > 0)	$error ++;
	
	if (! $error) {
		setEventMessage($langs->trans("SetupSaved"), 'mesgs');
	} else {
		setEventMessage($langs->trans("Error"), 'errors');
	}
} 

elseif ($action == 'hide_icons_top_menu') { 
  	$name = GETPOST ( 'name', 'text' );
  	$value = GETPOST ( 'value', 'int' );	

	if ($value) {
		$res = dolibarr_set_const($db, $name, 1, 'yesno', 0, '', $conf->entity);	
		$res2 = dolibarr_set_const($db, "MENU3DRESPONSIVE_HIDE_TEXT_HORIZENTAL_MENU", 0, 'yesno', 0, '', $conf->entity);
		if (! $res2 > 0)	$error ++;
	} else {
		$res = dolibarr_set_const($db, $name, 0, 'yesno', 0, '', $conf->entity);
	}
	
	if (! $res > 0)	$error ++;
	
	if (! $error) {
		setEventMessage($langs->trans("SetupSaved"), 'mesgs');
	} else {
		setEventMessage($langs->trans("Error"), 'errors');
	}
} 
elseif ($action == 'hide_text_top_menu') { 
  	$name = GETPOST ( 'name', 'text' );
  	$value = GETPOST ( 'value', 'int' );	

	if ($value) {
		$res = dolibarr_set_const($db, $name, 1, 'yesno', 0, '', $conf->entity);	
		$res2 = dolibarr_set_const($db, "MENU3DRESPONSIVE_HIDE_ICONS_HORIZENTAL_MENU", 0, 'yesno', 0, '', $conf->entity);
		if (! $res2 > 0)	$error ++;
	} else {
		$res = dolibarr_set_const($db, $name, 0, 'yesno', 0, '', $conf->entity);
	}
	
	if (! $res > 0)	$error ++;
	
	if (! $error) {
		setEventMessage($langs->trans("SetupSaved"), 'mesgs');
	} else {
		setEventMessage($langs->trans("Error"), 'errors');
	}
} 

// Get settings


/*
 * View
 */
$page_name = "Menu3dResponsiveSetup";
llxHeader('', $langs->trans($page_name),'','','','', array(),'' );

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'	. $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
$head = menu3dresponsive_admin_prepare_head();
dol_fiche_head(
	$head,
	'settings',
	$langs->trans("Module677720030Name"),
	0,
	""
);

dol_htmloutput_mesg($mesg);


// Setup page goes here

print '<br>'."\n";

// COLORS
// print '<div class="subsetting-title">' . $langs->trans("AS_SettingsColors") . '</div>';
print '<table class="noborder as-settings-colors">';

// HEADER ROW

// print '
// <tr class="liste_titre">
// 	<th>' . $langs->trans("Name") . '</td>
// 	<th>' . $langs->trans("Value") . '</td>
// </tr>
// '."\n";
print '<tr class="pair">';
print 	'<td class="titlefieldcreate">'.$langs->trans('Cacher_le_menu_à_gauche_de_Dolibarr').'</td>';

$name='MENU3DRESPONSIVE_SHOW_VERTICAL_MENU';
if (! empty ( $conf->global->MENU3DRESPONSIVE_SHOW_VERTICAL_MENU )) {
	print 	'<td><a href="' . $_SERVER ['PHP_SELF'] . '?action=show_vertical_menu&mainmenu=home&name='.$name.'&value=0">';
	print img_picto ( $langs->trans ( "Enabled" ), 'switch_on' );
	print 	"</a></td>";
} else {
	print 	'<td><a href="' . $_SERVER ['PHP_SELF'] . '?action=show_vertical_menu&mainmenu=home&name='.$name.'&value=1">';
	print img_picto ( $langs->trans ( "Disabled" ), 'switch_off' );
	print 	"</a></td>";
}
print "</tr>\n";



print '<tr class="pair">';
print 	'<td class="titlefieldcreate">'.$langs->trans('Cacher_les_icons_du_menu_en_haut').'</td>';

$name='MENU3DRESPONSIVE_HIDE_ICONS_HORIZENTAL_MENU';
if (! empty ( $conf->global->MENU3DRESPONSIVE_HIDE_ICONS_HORIZENTAL_MENU )) {
	print 	'<td><a href="' . $_SERVER ['PHP_SELF'] . '?action=hide_icons_top_menu&mainmenu=home&name='.$name.'&value=0">';
	print img_picto ( $langs->trans ( "Enabled" ), 'switch_on' );
	print 	"</a></td>";
} else {
	print 	'<td><a href="' . $_SERVER ['PHP_SELF'] . '?action=hide_icons_top_menu&mainmenu=home&name='.$name.'&value=1">';
	print img_picto ( $langs->trans ( "Disabled" ), 'switch_off' );
	print 	"</a></td>";
}
print "</tr>\n";



print '<tr class="pair">';
print 	'<td class="titlefieldcreate" style="white-space: nowrap;">'.$langs->trans('Afficher_seulement_les_icôns_du_menu_en_haut').'</td>';

$name='MENU3DRESPONSIVE_HIDE_TEXT_HORIZENTAL_MENU';
if (! empty ( $conf->global->MENU3DRESPONSIVE_HIDE_TEXT_HORIZENTAL_MENU )) {
	print 	'<td><a href="' . $_SERVER ['PHP_SELF'] . '?action=hide_text_top_menu&mainmenu=home&name='.$name.'&value=0">';
	print img_picto ( $langs->trans ( "Enabled" ), 'switch_on' );
	print 	"</a></td>";
} else {
	print 	'<td><a href="' . $_SERVER ['PHP_SELF'] . '?action=hide_text_top_menu&mainmenu=home&name='.$name.'&value=1">';
	print img_picto ( $langs->trans ( "Disabled" ), 'switch_off' );
	print 	"</a></td>";
}
print "</tr>\n";

print '
</tbody>
</table>

';


print '<br>';

// print '<table class="noborder as-settings-colors">';
// // print '
// // <tr class="liste_titre">
// // 	<th>' . $langs->trans("Name") . '</td>
// // 	<th>' . $langs->trans("Value") . '</td>
// // </tr>
// // '."\n";
// print '<tr class="pair">';
// print 	'<td>';

// $url = dol_buildpath('./menu3dresponsive/img/menus/');
// $array = scandir($url);
// $ignore = Array(".", "..");


// $url3 = dol_buildpath('/menu3dresponsive/img/menus/',2);
// $ignore = Array(".", "..");
// foreach($array as $curimg){
// 	if(!in_array($curimg, $ignore)) {
// 		// echo '<img src="'.$url3.$curimg.'" />';
// 	};
// }
// print 	'</td>';
// print "</tr>\n";

// print '
// </tbody>
// </table>
// <br>
// <br>
// ';
// Page end
dol_fiche_end();
llxFooter();
$db->close();
?>