<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    class/actions_marque.class.php
 * \ingroup marque
 * \brief   This file is an example hook overload class file
 *          Put some comments here
 */

/**
 * Class ActionsMarque
 */
class ActionsMarque
{
	/**
	 * @var array Hook results. Propagated to $hookmanager->resArray for later reuse
	 */
	public $results = array();

	/**
	 * @var string String displayed by executeHook() immediately after return
	 */
	public $resprints;

	/**
	 * @var array Errors
	 */
	public $errors = array();

	/**
	 * Constructor
	 */
	public function __construct()
	{
	}

	/**
	 * Overloading the doActions function : replacing the parent's function with the one below
	 *
	 * @param   array()         $parameters     Hook metadatas (context, etc...)
	 * @param   CommonObject    &$object        The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
	 * @param   string          &$action        Current action (if set). Generally create or edit or null
	 * @param   HookManager     $hookmanager    Hook manager propagated to allow calling another hook
	 * @return  int                             < 0 on error, 0 on success, 1 to replace standard code
	 */
	function doActions($parameters, &$object, &$action, $hookmanager)
	{
		$TContext = explode(':', $parameters['context']);

		if (in_array('agefodd', $TContext) && $parameters['location'] == 'document_trainee')
		{
			global $conf;
			
			if(( $action=='create' || $action == 'refresh')
				&& !empty($object->array_options['options_entity_marque'])
				&& $object->array_options['options_entity_marque'] > 0
				&& $object->array_options['options_entity_marque'] != $conf->entity) {
				$this->setMySocByEntity($object->array_options['options_entity_marque']);
			}
		}
	}
	
	function beforePDFCreation(&$parameters, &$object, &$action, $hookmanager) {
		global $conf;
		
		if(!empty($object->array_options['options_entity_marque'])
			&& $object->array_options['options_entity_marque'] > 0
			&& $object->array_options['options_entity_marque'] != $conf->entity) {
		
			$this->setMySocByEntity($object->array_options['options_entity_marque']);
		}
	}
	
	function afterPDFCreation(&$parameters, &$null, &$action, $hookmanager) {
		global $conf,$mysoc,$original_mysoc,$original_conf;
		
		if(!empty($original_mysoc)) {
			$mysoc = unserialize($original_mysoc); // étragement un clone ne change le pointeur mémoire que du premier niveau...
			$conf = unserialize($original_conf);
		}
	}
	
	function setMySocByEntity($entity) {
		global $db, $conf, $mysoc, $original_conf, $original_mysoc;
		
		$original_mysoc = serialize($mysoc);
		$original_conf = serialize($conf);
	
		$sourcecompany = &$mysoc;
		$sourceconf = &$conf;
		
		dol_include_once('/multicompany/class/dao_multicompany.class.php');
		
		$dao = new DaoMulticompany($db);
		$dao->fetch($entity);
		
		$sourceconf->mycompany->dir_output= DOL_DATA_ROOT;
		if($entity>1)$sourceconf->mycompany->dir_output.='/'.$entity.'/mycompany';
		else $sourceconf->mycompany->dir_output.='/mycompany'; 
		
		$sourcecompany->nom = $sourcecompany->name = $dao->MAIN_INFO_SOCIETE_NOM;
		$sourcecompany->town = $dao->MAIN_INFO_SOCIETE_TOWN;
		$sourcecompany->zip = $dao->MAIN_INFO_SOCIETE_ZIP;
		$sourcecompany->state = $dao->MAIN_INFO_SOCIETE_STATE;
		$sourcecompany->logo = $dao->MAIN_INFO_SOCIETE_LOGO;
		$sourcecompany->logo_small = $dao->MAIN_INFO_SOCIETE_LOGO_SMALL;
		$sourcecompany->logo_mini = $dao->MAIN_INFO_SOCIETE_LOGO_MINI;
		$sourcecompany->country_code = $dao->country_code;
		$sourcecompany->url = $dao->MAIN_INFO_SOCIETE_WEB;
		$sourcecompany->address = $dao->MAIN_INFO_SOCIETE_ADDRESS;
		$sourcecompany->phone = $dao->MAIN_INFO_SOCIETE_TEL;
		$sourcecompany->email = $dao->MAIN_INFO_SOCIETE_MAIL;
		$sourcecompany->fax = $dao->MAIN_INFO_SOCIETE_FAX;
		$sourcecompany->managers = $dao->MAIN_INFO_SOCIETE_MANAGERS;
		$sourcecompany->capital = $dao->MAIN_INFO_CAPITAL;
		$sourcecompany->typent_id = $dao->MAIN_INFO_SOCIETE_FORME_JURIDIQUE;
		$sourcecompany->idprof1 = $dao->MAIN_INFO_SIREN;
		$sourcecompany->idprof2 = $dao->MAIN_INFO_SIRET;
		$sourcecompany->idprof3 = $dao->MAIN_INFO_APE;
		$sourcecompany->idprof4 = $dao->MAIN_INFO_RCS;
		$sourcecompany->intra_vat = $dao->MAIN_INFO_TVAINTRA;
		$sourcecompany->tva_intra = $dao->MAIN_INFO_TVAINTRA;

	}
	
	function formObjectOptions(&$parameters, &$null, &$action, $hookmanager)
	{
		global $conf,$user,$langs,$db,$mysoc,$object;
		
		$TContext = explode(':', $parameters['context']);
		if (in_array('globalcard',$TContext))
		{
			if(!empty($conf->global->{'MARQUE_ENTITIES_LINKED_'.$conf->entity}) && (GETPOST('attribute') === 'entity_marque' || $action=='edit' ) ) {
				?>
				<script type="text/javascript">
				$(document).ready( function () {
					var TMarqueEntitiesAllowed = [<?php echo $conf->global->{'MARQUE_ENTITIES_LINKED_'.$conf->entity} ?>];
				
					$('#options_entity_marque option').each(function(i,item) {
						$item = $(item);
						
						var entid = parseInt($item.val()); 
						if(entid>0 && $.inArray(entid, TMarqueEntitiesAllowed) == -1 ) {
							$item.remove();
						}
					});
				});
				</script>
				<?php
			}
		}
	}
}
