<?php
/* Copyright (C)   Yassine Belkaid    y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/recap/class/recap.class.php
 * \ingroup recap
 * \brief   This file is recap CRUD class file
 *
 */

dol_include_once('/marches/db/nxdb.class.php');

/**
 * Class marches
 *
 * Contract Management class
 */
class Recap extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_recap';
	/**
	 * @var string Name of table without pref_marcheix where object is stored
	 */
	public $table_element 	  = 'm_recap';
	public $table_element_sec = 'm_missing_pieces';

	/**
	 * @var int ID
	 */
	public $id;
	public $ref;
	public $comment;
	public $fk_created_by;
	public $fk_marche;
	public $statut; /* 0 => unchecked, 1=> values of m_recap  */
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at= $this->now;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_created_by= $this->db->escape($this->fk_created_by);
		$this->fk_marche 	= $this->db->escape($this->fk_marche);
		$this->ref 			= $this->db->escape($this->ref);
		$this->comment 		= $this->comment ?: '';
		$this->statut 		= $this->statut ?: 0;
		$this->created_at 	= $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element_sec . ' (ref, fk_created_by, fk_marche, created_at, updated_at, statut, comment) VALUES (';
		$sql .= '"'. $this->ref .'",'.$this->fk_created_by.', '.$this->fk_marche.', "'.$this->created_at.'", "'.$this->updated_at .'", '. $this->statut .', "'. $this->comment .'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error recap ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId($this->table_element_sec);
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $fk_marche = null, $recap = true)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$table = ($recap ? $this->table_element : $this->table_element_sec);
		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $table;

		if (null !== $fk_marche) {
			$sql .= ' WHERE rowid = ' . $id .' AND fk_marche = ' . $fk_marche;
		} else {
			$sql .= ' WHERE rowid = ' . $id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_created_by = $obj->fk_created_by;
				$this->fk_marche 	 = $obj->fk_marche;
				$this->ref 	 		 = $obj->ref;
				$this->statut  		 = $obj->statut;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);

				if (!$recap)
					$this->comment = $obj->comment;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $ref Ref
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetchByRef($ref, $fk_marche = null, $recap = true)
	{
		$table = ($recap ? $this->table_element : $this->table_element_sec);
		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $table;

		if (null !== $fk_marche) {
			$sql .= ' WHERE ref = "' . $ref .'" AND fk_marche = ' . $fk_marche;
		} else {
			$sql .= ' WHERE ref = "' . $ref .'"';
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);

			if ($numrows) {
				$obj 				 = $this->db->fetch_object($resql);
				$this->id 			 = $obj->rowid;
				$this->fk_created_by = $obj->fk_created_by;
				$this->fk_marche 	 = $obj->fk_marche;
				$this->ref 	 		 = $obj->ref;
				$this->statut  		 = $obj->statut;
				$this->updated_at 	 = $this->db->jdate($obj->updated_at);
				$this->created_at 	 = $this->db->jdate($obj->created_at);
				
				if (!$recap)
					$this->comment = $obj->comment;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int 	$mid 	 Market id
	 * @param bool 	$recap   whether call default values from default table or not
	 * @param int   $status  set to normal table, if status 1 means grab values insrted from default table
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($mid, $recap = true, $status = 0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$table = ($recap ? $this->table_element : $this->table_element_sec);
		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $table;

		if (!$recap) {
			$sql .= ' WHERE fk_marche = '. $mid .' AND statut = '. $status;
		}

		$this->lines = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 			 = $obj->rowid;
				$line->fk_created_by = $obj->fk_created_by;
				$line->fk_marche 	 = $obj->fk_marche;
				$line->ref 	 		 = $obj->ref;
				$line->statut 		 = $obj->statut;
				$line->updated_at 	 = $this->db->jdate($obj->updated_at);
				$line->created_at 	 = $this->db->jdate($obj->created_at);
				if (!$recap)
					$line->comment = $obj->comment;
				$this->lines[] 		 = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id)
			return false;

		if (count($data) && is_array($data)) {
			// Update request
			$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element_sec . ' SET updated_at = "'. $this->now .'",';

			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= ' `'. $key. '` = '. $val .',';
			}

			$sql  = substr($sql, 0, -1);
			$sql .= ' WHERE rowid = ' . $id;

			$this->db->begin();

			$resql = $this->db->query($sql);

			if (!$resql) {
				$this->db->rollback();
				
				$this->error = 'Error ' . $this->db->lasterror();
				$this->errors[] = $this->error;
				dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

				return -1;
			} else {
				$this->db->commit();

				return 1;
			}
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element_sec .' WHERE rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	public function getRowsRefs($lines)
	{
		$ref = array();
		if (count($lines)) {
			foreach ($lines as $key => $row) {
				$ref[] = $row->ref;
			}
		}

		return $ref;
	}
}
