<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres//monitorings/index.php
 * \ingroup    list
 * \brief      List of monitorings related to given AO
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
dol_include_once('/marches/core/class/html.form.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/marches/monitorings/class/monitoring.class.php');
dol_include_once('/marches/class/appeloffre.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
dol_include_once('/marches/lib/marches.lib.php');

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$action	  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$ao 	  = GETPOST('ao', 'int');
$id 	  = GETPOST('id', 'int');

if (empty($ao) || $ao <= 0)
	die('ID Appel offre n\'existe pas!');

$search_created_by  		= $_GET['search_created_by'];
$search_observation 		= $_GET['search_observation'];
$search_demand_num      	= $_GET['search_demand_num'];
$search_demand_date    		= $_GET['search_demand_date'];
$search_delay_justfication 	= $_GET['search_delay_justfication'];

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_created_by 			= "";
	$search_observation   	   	= "";
	$search_demand_num     		= "";
    $search_demand_date 		= "";
    $search_delay_justfication 	= "";
}

/**
 * Actions
 */

/**
 * View
 */
$monitorings = new Monitoring($db);
$appeloffre  = new AppelOffre($db);
$filter 	 = '';

if ($id > 0) {
	$monitorings->fetch($id, $ao);
	$object 	= $monitorings;
    $param 		= '&ao='. $ao;

	$upload_dir = $conf->marches->dir_output.'/monitoring/'.$monitorings->id;
	$modulepart = 'marches';

	$filearray = array();

	// Construit liste des fichiers
	$filearray = dol_dir_list($upload_dir, "files", 0, '', '(\.meta|_preview\.png)$', $sortfield, (strtolower($sortorder)=='desc'?SORT_DESC:SORT_ASC),1);
	$totalsize=0;
	foreach($filearray as $key => $file) {
		$totalsize+=$file['size'];
	}


	include_once dol_buildpath('/marches/core/tpl/document_actions_pre_headers.tpl.php');
}


// Filter
$filter .= !empty($search_observation) ? " AND observation like '%". $db->escape($search_observation) ."%'" : "";
$filter .= !empty($search_demand_num) ? " AND demand_num = '". $db->escape($search_demand_num) ."'" : "";

if (isset($search_demand_date) && !empty($search_demand_date)) {
	list($sd, $sm, $sy)  = explode("/", $search_demand_date);
	$filter .=  " AND demand_date = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}

$filter .= (isset($search_delay_justfication) && !empty($search_delay_justfication)) ? " AND delay_justfication like '".$db->escape($search_delay_justfication) ."%'" : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ".$db->escape($search_created_by) : "";
/*************************************
 * Fin des filtres de recherche
*************************************/
llxHeader(array(), $langs->trans('ListOfMonitoring'), '', '', '', '', array('/marches/js/marches.js'));
//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');
// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getMonitorings = $monitorings->fetchAll($ao, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getMonitorings == '-1') {
    print_fiche_titre($langs->trans('ListOfMonitoring'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$monitorings->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($monitorings->lines);
$form 		= new FormChild($db);

if ($id > 0) {
	$monitorings->fetch($id, $ao);
	$appeloffre->fetch($ao);
	$object 	= $monitorings;
	$title 		= $langs->trans("ListOfMonitoring");
	$head  		= appeloffre_prepare_head($appeloffre);
	dol_fiche_head($head, 'monitoring', $title, 0, '');

	echo $appeloffre->getAppelOffreHeader();

	$createdBy  = new User($db);
	$createdBy->fetch($db->escape($monitorings->fk_created_by));
	$demand_num 		  = $monitorings->demand_num ? $monitorings->demand_num : '';
	$demand_date		  = $monitorings->demand_date ? dol_print_date($monitorings->demand_date, 'day'): '';
	$delay_justfication	  = $monitorings->delay_justfication ? $monitorings->delay_justfication : '';
	$response_st_num	  = $monitorings->response_st_num ? $monitorings->response_st_num : '';
	$response_st_date	  = $monitorings->response_st_date ? dol_print_date($monitorings->response_st_date, 'day') : '';
	$observation		  = $monitorings->observation ? $monitorings->observation : '';
	$created_at 		  = $monitorings->created_at ? dol_print_date($monitorings->created_at,'dayhoursec') : '';
	$defaultMoyens 		  = array('fax', 'bordereau', 'autres');

	print '<table class="border" width="100%">';
	print '<tr><td width="35%">'. $langs->trans("MonitoringLetterDemand") .'</td>';
	print '<td colspan="2">'. $demand_num .' &nbsp;&nbsp; '. $langs->trans("MonitoringDate") .' &nbsp;&nbsp; '. $demand_date .'</td></tr>';
	print '<tr><td width="35%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $createdBy->getNomUrl('1') .'</td></tr>';
	print '<tr><td width="35%">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. $created_at .'</td></tr>';
	print '<tr><td width="35%">'.$langs->trans("MonitoringDelayJustify").'</td>';
	print '<td colspan="2">'. $delay_justfication .'</td></tr>';
	print '<tr><td width="35%">'.$langs->trans("MonitoringResponseCompagnyNum").'</td>';
	print '<td colspan="2">'. $response_st_num .' &nbsp;&nbsp; '.$langs->trans("MonitoringDate").' &nbsp;&nbsp; '. $response_st_date .'</td></tr>';
	print '<tr><td valign="top">'.$langs->trans("ByAveraging").'</td><td>';

	foreach ($defaultMoyens as $key => $moyen) {
		$lmoyen = strtolower($moyen);
		$checked = '';

		if ($monitorings->moyens && array_key_exists($moyen, $monitorings->moyens)) {
	        print '<div style=""><span class="moniroting_moyen_blocks">'. ucfirst($moyen) .'</span>'. $monitorings->moyens[$moyen] .'</div>';
		}
	}
        print '</td></tr>';
	print '<tr><td width="35%">'.$langs->trans("MonitoringObserv").'</td>';
	print '<td colspan="2">'. $observation .'</td></tr>';
	
	print '</table>';

	if ($user->id && $user->rights->marches->write) {
		print '<div class="tabsAction">';
            // Boutons d'actions
			print '<a href="./card.php?action=edit&ao='. $ao .'&id='. $monitorings->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        	print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
            
            // If draft
            if ($user->rights->marches->delete)	{
            	print '<a href="./card.php?ao='.$_GET['ao'].'&action=delete&id='. $monitorings->id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
            }
        print '</div>';
	}
	$modulepart = 'marches';
    $permission = $user->rights->marches->write;
    $param 		            = '&ao='. $ao;
    $relativepathwithnofile = '/monitoring/'.$monitorings->id.'/';

    include_once dol_buildpath('/marches/core/tpl/document_actions_post_headers.tpl.php');
}
else {
	$title = $langs->trans("ListOfMonitoring");
	$appeloffre->fetch($ao);
	$head = appeloffre_prepare_head($appeloffre);
   	dol_fiche_head($head, 'monitoring', $title, 1, '');
   	$moreparam = 'ao='.$ao;

	echo $appeloffre->getAppelOffreHeader();

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">';
	print '<input type="hidden" name="ao" value="'. $ao .'" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("Ref"),$_SERVER["PHP_SELF"], "demand_num", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("MonitoringDate"), $_SERVER["PHP_SELF"], 'demand_date', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("MonitoringObserv"),$_SERVER["PHP_SELF"],"observation","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("MonitoringDelayJustify"),$_SERVER["PHP_SELF"],"delay_justfication","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat center" size="30" type="text" name="search_demand_num" value="'.dol_escape_htmltag($search_demand_num).'">';
	print '</td>';

    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
    print '</td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center datepicker" type="text" size="30" name="search_demand_date" value="'.$search_demand_date.'"></td>';

	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="14" name="search_observation" value="'.$search_observation.'"></td>';
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="14" name="search_delay_justfication" value="'.$search_delay_justfication.'"></td>';
	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($monitorings->lines)) {
		$createdBy = new User($db);

		foreach($monitorings->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_created_by));
			$demand_num 		  = null !== $line->demand_num ? $line->demand_num : '';
			$demand_date		  = null !== $line->demand_date ? dol_print_date($line->demand_date, 'day'): '';
			$delay_justfication	  = $line->delay_justfication ? $line->delay_justfication : '';
			$created_at			  = null !== $line->created_at ? dol_print_date($line->created_at,'day') : '';
			$observation 	 = '';
			$fullObservation = '';
			if (null !== $line->observation) {
				$fullObservation = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->observation)));
				$observation 	= substr($line->observation, 0, 100);
				$observation 	= strlen($line->observation) > 100 ? $observation.'...' : $observation;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $monitorings->getNomUrl(1,  $line->fk_appel_offre,  $line->id, $demand_num);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align="center">'. $demand_date .'</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullObservation .'">'. $observation .'</span></td>';
			print '<td align="center">'. $delay_justfication .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->marches->write) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&ao='. $ao .'" class="butAction">'.$langs->trans('AddMonitoring').'</a>';
		print '</div>';
	}

}

llxFooter();

$db->close();

?>