<?php
/* Copyright (C) 2016   Yassine Belkaid     y.belkaid@nextconcept.ma
 *
 */

/**
 * \file    marches/managementpackingslip/managementpackingslip.class.php
 * \ingroup marches
 * \brief   This file is marches CRUD class file
 *
 */
dol_include_once('/marches/db/nxdb.class.php');

/**
 * Class marches
 *
 * Management packing slip class
 */
class ManagementPackingSlip extends NXdb
{
	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see marches::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
	/**
	 * @var string Id to identify managed objects
	 */
	public $element = 'm_managementpackingslip';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'm_managementpackingslip';

	/**
	 * @var int ID
	 */
	public $id;
	public $fk_created_by;
	public $fk_marche;
	public $date_at;
	public $subject;
	public $number;
	public $observation;
	public $statut;
	public $created_at;
	public $updated_at;

	public $now;
	public $lines = array();
 
	/**
	 * Constructor
	 *
	 * @param DoliDb $db Database handler
	 */
	public function __construct(DoliDBMysqli $db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		$this->updated_at = $this->now;
		$this->statut 	= 0;
		return 1;
	}

	/**
	 * Create object into database
	 *
	 * @return int   id of last inserted id, otherwise -1 if error arised 
	 */
	public function create()
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->fk_marche 	  = $this->fk_marche ?: null;
		$this->fk_created_by  = $this->fk_created_by ?: null;
		$this->subject 		  = $this->subject ? $this->db->escape(trim($this->subject)) : null;
		$this->number  		  = $this->number ? $this->db->escape(trim($this->number)) : null;
		$this->observation	  = $this->observation ? $this->db->escape(trim($this->observation)) : null;
		$this->statut 		  = $this->statut ? $this->db->escape(trim($this->statut)) : 0;
		$this->date_at	  	  = $this->date_at ? $this->db->escape($this->date_at) : 0;
		$this->created_at 	  = $this->now;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element . ' (fk_marche, fk_created_by, subject, number, created_at, updated_at, observation, statut, date_at) VALUES (';		
		$sql .= $this->fk_marche.', '.$this->fk_created_by.', "'.$this->subject.'", '.$this->number.', "'.$this->created_at.'", "'.$this->updated_at .'", "'.$this->observation.'", '.$this->statut.', "'.$this->date_at.'")';

		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->error 	= 'Error Packing slip ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return $this->getLasInsrtedId();
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param int    $id  Id object
	 * @param string $num num
	 *
	 * @return int <0 if KO, 0 if not found, >0 if OK
	 */
	public function fetch($id, $marche_id = null)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element. ' WHERE rowid = ' . $id;

		if(null !== $marche_id) {
			$sql .= ' AND fk_marche = '. $marche_id;
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			  	  = $this->db->fetch_object($resql);
				$this->id 		  	  = $obj->rowid;
				$this->fk_created_by  = $obj->fk_created_by;
				$this->fk_marche 	  = $obj->fk_marche;
				$this->subject 	  	  = $obj->subject;
				$this->observation 	  = $obj->observation;
				$this->number	  	  = $obj->number;
				$this->date_at 	  	  = $this->db->jdate($obj->date_at);
				$this->statut	  	  = $obj->statut;
				$this->updated_at 	  = $this->db->jdate($obj->updated_at);
				$this->created_at 	  = $this->db->jdate($obj->created_at);
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Load object in memory from the database
	 *
	 * @param string $sortorder Sort Order
	 * @param string $sortfield Sort field
	 * @param int    $limit     offset limit
	 * @param int    $offset    offset limit
	 * @param array  $filter    filter array
	 * @param string $filtermode filter mode (AND or OR)
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function fetchAll($marche_id, $sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '', $filtermode = 'AND')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element . ' WHERE fk_marche ='. (int) $marche_id;

		if (!empty($filter)) {
			$sql .= $filter;
		}

		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}

		$this->lines = array();
		//die($sql);
		$resql 		 = $this->db->query($sql);
		$num 		= 0;
		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;

				$line->id 		  	  = $obj->rowid;
				$line->fk_created_by  = $obj->fk_created_by;
				$line->fk_marche 	  = $obj->fk_marche;
				$line->subject 	  	  = $obj->subject;
				$line->observation 	  = $obj->observation;
				$line->number	  	  = $obj->number;
				$line->date_at 	  	  = $this->db->jdate($obj->date_at);
				$line->statut	  	  = $obj->statut;
				$line->updated_at 	  = $this->db->jdate($obj->updated_at);
				$line->created_at 	  = $this->db->jdate($obj->created_at);
				$this->lines[] 	  	  = $line;
			}
			$this->db->free($resql);

			return $num;
		} else {
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	/**
	 * Update object into database
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function update($id, array $data = array())
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0 || !count($data))
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element . ' SET ';

		if (count($data) && is_array($data)) {
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : "'". $this->db->escape(trim($val)) ."'";
				$sql .= '`'. $key. '` = '. $val .',';
			}
		} else 
			return;

		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE rowid = ' . (int) $id;

		$this->db->begin();

		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			die($this->error);
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
	 * Delete object in database
	 *
	 * @param User $user      User that deletes
	 * @param bool $notrigger false=launch triggers after, true=disable triggers
	 *
	 * @return int <0 if KO, >0 if OK
	 */
	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE rowid = ' . (int) $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}

	/**
     *	Return clicable name (with picto eventually)
     *
     *  @author Yassine Belkaid <y.belkaid@nextconcept.ma>
     *	@param		int			$withpicto		0=_No picto, 1=Includes the picto in the linkn, 2=Picto only
     *	@return		string						String with URL
     */
    public function getNomUrl($withpicto = 0, $id, $mid)
    {
        global $langs;

        $result	= '';
        $id  	= ($id  ?: '');
        $label  = $langs->trans("Show").': '. $id;


        $link 	 = '<a href="'.dol_buildpath('/marches/managementpackingslip/index.php?id='. $id .'&mid='. $mid,2) .'" title="'.dol_escape_htmltag($label, 1).'" class="classfortooltip picto_marche_module">';
        $linkend ='</a>';
        $picto   = $this->defaultPicto;

        if ($withpicto) $result.=($link.img_object($label, $picto, 'class="classfortooltip"').$linkend);
        if ($withpicto && $withpicto != 2) $result.=' ';
        if ($withpicto != 2) $result.=$link.$label.$linkend;
        return $result;
    }

}
