<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/DelayManagement/index.php
 * \ingroup    DelayManagement
 * \brief      List of DelayManagement
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/marches/delaymanagement/class/delaymanagement.class.php');
dol_include_once('/marches/marche/class/marche.class.php');
dol_include_once('/marches/lib/marches.lib.php');

$langs->load('marches');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marche n\'existe pas!');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	= false;
$object = new DelayManagement($db);
$marche = new Marches($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action = 'request';
	// If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	    $start_date		 = trim($_POST['start_date']);
	    $resumption_date = trim($_POST['resumption_date']);
	    $mid 			 = trim(GETPOST('mid', 'int'));
    	$ref		 	 = trim($_POST['ref']);

	    if (!$mid || !$start_date || !$resumption_date || !$ref)
			return;

		if (isset($start_date) && !empty($start_date)) {
	        list($etd, $etm, $ety) = explode("/", $start_date);
	        $start_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($resumption_date) && !empty($resumption_date)) {
	        list($etd, $etm, $ety) = explode("/", $resumption_date);
	        $resumption_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $object->fk_created_by 	= $user->id;
	    $object->fk_marche  	= $mid;
	    $object->ref 			= $ref;
	    $object->start_date 	= $start_date;
	    $object->resumption_date= $resumption_date;

		$getDelay = $object->create();

		if ($getDelay) {
		    header('Location: ./index.php?id='. $getDelay .'&mid='.$mid);
		    die();
		} else {
			header('Location: ./index.php?mid='.$mid);
		    die();
		}
    }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {

	 if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	    $id  			 = trim(GETPOST('id', 'int'));
    	$ref		 	 = trim($_POST['ref']);
    	$start_date		 = trim($_POST['start_date']);
	    $resumption_date = trim($_POST['resumption_date']);
	    $mid 			 = trim(GETPOST('mid', 'int'));

	    if (!$mid || !$start_date || !$resumption_date || !$ref)
			return;

		if (isset($start_date) && !empty($start_date)) {
	        list($etd, $etm, $ety) = explode("/", $start_date);
	        $start_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($resumption_date) && !empty($resumption_date)) {
	        list($etd, $etm, $ety) = explode("/", $resumption_date);
	        $resumption_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
	    	'ref' 	 		 => $ref,
	    	'start_date' 	 => $start_date,
	    	'resumption_date'=> $resumption_date
	    );

		$object->update($id, $data);
		header('Location: ./index.php?id='. $id .'&mid='.$mid);
	    die();
	}

	$action = "edit";
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->marches->delete_marche) {
	$error = 0;
	$mid = GETPOST('mid', 'int');
	$id = (int) GETPOST('id', 'int');
	
	if (!$mid || !$id)
		return;

	$db->begin();

	$canedit = ($user->rights->marches->write_marche || $user->rights->marches->delete_marche);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
		$object->delete($id);
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
	} else {
		$db->rollback();
	}

	header('Location: ./index.php?leftmenu=marches&mid='.$mid);
	exit;
}

$form = new Form($db);

llxHeader(array(), $langs->trans('ListOfDelayManagement'),'','','','',array('/marches/js/marches.js'),array(),0,0);
//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');
print_fiche_titre($langs->trans('DelayManagement'),'','object_marches@marches');
$marche->fetch($mid);

if (empty($id) || $action == 'add' || $action == 'request' || $action == 'create') {
	if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
        $errors[] = $langs->trans('CantCreate');
    } else {
		$head  = marches_prepare_head($marche);
		dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

		$head_btm = phase_execution_prepare_head($marche);
		dol_fiche_head($head_btm, 'delaymanagement', $langs->trans("DelayManagementDetail"), 0, '');

		echo $marche->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td><td>';
        print '<input type="text" class="" value="" name="ref" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("StoppedDate").'</td><td>';
        print '<input type="text" class="datepicker" value="" name="start_date" required="required" />';
        print '</td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("ResumptionDate").'</td><td>';
        print '<input type="text" class="datepicker" value="" name="resumption_date" required="required" /></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateDelay") .'" name="bouton" class="button">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="button" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id);
		$head  = marches_prepare_head($marche);
		dol_fiche_head($head, 'execution', $langs->trans("ExecutionFile"), 0, '');

		$head_btm = phase_execution_prepare_head($marche);
		dol_fiche_head($head_btm, 'delaymanagement', $langs->trans("DelayManagementDetail"), 0, '');
		$canedit = ($user->rights->marches->delete_marche || $user->rights->marches->write_marche);

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete_marche) {
                    print $form->formconfirm("./card.php?mid=".$mid."&id=".$id, $langs->trans("TitleDeleteDelay"), $langs->trans("ConfirmDeleteDelay"), "confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
				echo $marche->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$ref		 	= $object->ref ?: '';
				$start_date	 	= $object->start_date ? dol_print_date($object->start_date, 'day'): '';
				$resumption_date= $object->resumption_date ? dol_print_date($object->resumption_date, 'day'): '';
				
		        print '<table class="border" width="100%">';
		        print '<tbody>';

			    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("Ref").'</td><td>';
		        print '<input type="text" class="" value="'. $ref .'" name="ref" required="required" />';
		        print '</td></tr>';

			    print '<tr><td class="fieldrequired" width="25%">'.$langs->trans("StoppedDate").'</td><td>';
		        print '<input type="text" class="datepicker" value="'. $start_date .'" name="start_date" required="required" />';
		        print '</td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("ResumptionDate").'</td><td>';
		        print '<input type="text" class="datepicker" value="'. $resumption_date .'" name="resumption_date" required="required" /></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                    if ($user->rights->marches->delete_marche)	{
                    	print '<a href="./card.php?id='.$id.'&action=delete&mid='. $mid .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                    }
                print '</div>';

		        print '</form>';
			}
        }
	}
}

llxFooter();

$db->close();

?>
