<?php
/* Gestion des marchés, you can add/edit/delete it
 * Copyright (C) 2015  Yassine Belkaid <y.belkaid@nextconcept.ma>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	marches
 * 	\brief		gestion des marches.
 * 	\file		core/modules/modMarches.class.php
 * 	\ingroup	marches
 * 	\brief		marches is for creating/Editing et deleting market management
 */
include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

/**
 * Description and activation class for module Gestion des marches
 */
class modMarches extends DolibarrModules
{
	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;
		$this->numero = 698890938;
		$this->rights_class = 'marches';
		$this->family = "Next";
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		$this->description = "Module698890938NDesc";
		$this->version = '5.0';
		$this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special = 0;
		$this->picto = 'marches@marches';
		$this->module_parts = array(
			'triggers' 	=> 1,
			'css' 		=> array('marches/css/marches.css'),
		);
		$this->dirs = array();
		$this->config_page_url = array();
		$this->hidden = false;
		$this->depends = array('modFacture');
		$this->requiredby = array();
		$this->conflictwith = array();
		$this->phpmin = array(5, 3);
		$this->need_dolibarr_version = array(4, 7);
		$this->langfiles = array("marches@marches");
	
		if (!isset($conf->marches->enabled)) {
			$conf->marches = new stdClass();
			$conf->marches->enabled = 0;
		}

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 1;

		//// Permission id (must not be already used)
		



		//// Permission id (must not be already used)
		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Lire les Appel d\'offre et tous leur éléments ';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'read';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Créer /Modifier les Appel d\'offre et tous leur éléments';
		$this->rights[$r][3] = 1;
		$this->rights[$r][4] = 'write';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;
		$this->rights[$r][1] = 'Supprimer les les Appel d\'offre et tous leur éléments';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'delete';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Lire les marchés et tous leur éléments';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'read_marche';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Modifier les marchés et tous leur éléments ';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'write_marche';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Supprimer les marchés et tous leur éléments';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'delete_marche';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Lire les BCs et tous leur éléments';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'read_bcs';
		$this->rights[$r][5] = '';
		$r++;
        $this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Créer/modifier les BCs et tous leur éléments';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'write_bcs';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Supprimer les BCs et tous leur éléments';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'delete_bcs';
		$this->rights[$r][5] = '';
		$r++;
	    $this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Lire les Q/C des entreprises ';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'read_qc';
		$this->rights[$r][5] = '';
		$r++;
        $this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Créer/modifier les Q/C des entreprises ';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'write_qc';
		$this->rights[$r][5] = '';
		$r++;

		$this->rights[$r][0] = $this->numero + $r;;
		$this->rights[$r][1] = 'Supprimer les Q/C des entreprises';
		$this->rights[$r][3] = 0;
		$this->rights[$r][4] = 'delete_qc';
		$this->rights[$r][5] = '';
		$r++;















		$r = 0;
		$this->menu = array();
		$this->menu[$r] = array(
			'fk_menu'	=> 0,
			'type'		=> 'top',
			'titre'		=> "MenuGMBC",
			'mainmenu' 	=> 'marches',
			'leftmenu'	=> 'marches',
			'url'		=> '/marches/index.php',
			'langs'		=> 'marches@marches',
			'enabled' 	=> '$conf->marches->enabled',
			'perms'	 	=> '$user->rights->marches->read',
			'position'=>100,
			'target'	=> '',
			'user'		=> 2 // 0=Menu for internal users, 1=external users, 2=both
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches',
			'type'		=> 'left',
			'leftmenu'	=> 'ao',
			'titre'		=> "ListOfAO",
			'url'		=> '/marches/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 1,
			'perms'	 	=> '$user->rights->marches->read',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches,fk_leftmenu=ao',
			'type'		=> 'left',
			'titre'		=> "ListOfAO",
			'url'		=> '/marches/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 2,
			'perms'	 	=> '$user->rights->marches->read',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches,fk_leftmenu=ao',
			'type'		=> 'left',
			'titre'		=> "New",
			'url'		=> '/marches/card.php?action=add',
			'langs'		=> 'marches@marches',
			'position'	=> 3,
			'perms'		=> '$user->rights->marches->write',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches',
			'type'		=> 'left',
			'leftmenu'	=> 'marche',
			'titre'		=> "ListOfMarkets",
			'url'		=> '/marches/marche/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 1,
			'perms'	 	=> '$user->rights->marches->read_marche',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches,fk_leftmenu=marche',
			'type'		=> 'left',
			'titre'		=> "ListOfMarkets",
			'url'		=> '/marches/marche/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 2,
			'perms'	 	=> '$user->rights->marches->read_marche',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);

		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches',
			'type'		=> 'left',
			'leftmenu'	=> 'bc',
			'titre'		=> "ListOfPurchaseOrderBC",
			'url'		=> '/marches/purchaseorder/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 1,
			'perms'	 	=> '$user->rights->marches->read_bcs',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches,fk_leftmenu=bc',
			'type'		=> 'left',
			'titre'		=> "ListOfPurchaseOrder",
			'url'		=> '/marches/purchaseorder/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 2,
			'perms'	 	=> '$user->rights->marches->read_bcs',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);

		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches',
			'type'		=> 'left',
			'leftmenu'	=> 'entrepriseqce',
			'titre'		=> "EntrepriseQCE",
			'url'		=> '/marches/qualifications/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 1,
			'perms'	 	=> '$user->rights->marches->read_qc',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches,fk_leftmenu=entrepriseqce',
			'type'		=> 'left',
			'titre'		=> "EntrepriseQC",
			'url'		=> '/marches/qualifications/index.php',
			'langs'		=> 'marches@marches',
			'position'	=> 2,
			'perms'	 	=> '$user->rights->marches->read_qc',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
		$this->menu[$r] = array(
			'fk_menu'	=> 'fk_mainmenu=marches,fk_leftmenu=entrepriseqce',
			'type'		=> 'left',
			'titre'		=> "New",
			'url'		=> '/marches/qualifications/card.php?action=add',
			'langs'		=> 'marches@marches',
			'position'	=> 2,
			'perms'		=> '$user->rights->marches->write_qc',
			'enabled' 	=> '$conf->marches->enabled',
			'target'	=> '',
			'user'		=> 2
		);
		$r++;
	}

	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();

		$result = $this->loadTables();

		return $this->_init($sql, $options);
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = $this->dropTables();

		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /mymodule/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/marches/sql/');
	}

	private function dropTables()
	{
		return array(
			// 'DROP TABLE `llx_appel_offre`',
			// 'DROP TABLE `llx_m_approval`',
			// 'DROP TABLE `llx_m_bails`',
			// 'DROP TABLE `llx_m_certificates`',
			// 'DROP TABLE `llx_m_competitors`',
			// 'DROP TABLE `llx_m_delaymanagement`',
			// 'DROP TABLE `llx_m_documentmanagement`',
			// 'DROP TABLE `llx_m_exceedingdelay`',
			// 'DROP TABLE `llx_m_executions`',
			// 'DROP TABLE `llx_m_managementpackingslip`',
			// 'DROP TABLE `llx_m_monitoring`',
			// 'DROP TABLE `llx_m_notifications`',
			// 'DROP TABLE `llx_m_paymentmanagement`',
			// 'DROP TABLE `llx_m_qualifications`',
			// 'DROP TABLE `llx_m_recap`',
			// 'DROP TABLE `llx_marches`',
			// 'DROP TABLE `llx_m_missing_pieces`'
		);
	}
}
