<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres//competitors/index.php
 * \ingroup    list
 * \brief      List of competitors related to given AO
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/marches/competitors/class/competitor.class.php');
dol_include_once('/marches/class/appeloffre.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
dol_include_once('/marches/lib/marches.lib.php');

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "winner";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id', 'int');
$competitor_id = GETPOST('competitor_id', 'int');

if (!$id)
	die('ID Appel offre n\'existe pas!');

$search_created_by  = GETPOST('search_created_by');
$search_name      	= GETPOST('search_name');
$search_amount    	= GETPOST('search_amount');
$search_created_at  = GETPOST('search_created_at');
$winner  			= GETPOST('winner');
$search_city  		= GETPOST('search_city');
$search_address		= GETPOST('search_address');


 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_name   	   	= "";
	$search_created_by 	= "";
	$search_amount     	= "";
    $search_created_at 	= "";
    $winner 			= "";
    $search_city 		= "";
    $search_address 	= "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$competitors = new Competitors($db);
$appeloffre  = new AppelOffre($db);
$filter 	 = '';

llxHeader(array(), $langs->trans('ListOfCompetitors'));

// Filter
$filter .= !empty($search_name) ? " AND name like '%". $db->escape($search_name) ."%'" : "";
$filter .= !empty($search_city) ? " AND city like '%". $db->escape($search_city) ."%'" : "";
$filter .= !empty($search_address) ? " AND address like '%". $db->escape($search_address) ."%'" : "";
$filter .= !empty($winner) ? " AND winner = '". $db->escape($winner) ."'" : "";

if (isset($search_created_at) && !empty($search_created_at)) {
	list($sd, $sm, $sy)  = explode("/", $search_created_at);
	$filter .=  " AND created_at = '". $db->escape($sy.'-'.$sm.'-'.$sd) ."'";
}

$filter .= (isset($search_amount) && !empty($search_amount)) ? " AND amount = ". $db->escape($search_amount) : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = ". $db->escape($search_created_by) : "";

/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		= $user->id;
$getCompetitors = $competitors->fetchAll($id, $sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getCompetitors == '-1') {
    print_fiche_titre($langs->trans('ListOfCompetitors'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$competitors->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($competitors->lines);
$form 		= new Form($db);
$formother 	= new FormOther($db);

if ($competitor_id > 0) {
	$competitors->fetch($competitor_id, $id);
	$appeloffre->fetch($id);
	$title = $langs->trans("ListOfCompetitors");
	$head  = appeloffre_prepare_head($appeloffre);
	dol_fiche_head($head, 'competitors', $title, 0, '');

	if ($id > 0) {
		echo $appeloffre->getAppelOffreHeader();
	}

	$createdBy  = new User($db);
	$createdBy->fetch($db->escape($competitors->fk_created_by));
	$name 		= $competitors->name ? ucfirst($competitors->name) : '';
	$amount	 	= $competitors->amount ? number_format($competitors->amount, 2, '.', ',') : '';
	$winner		= $competitors->winner ? $langs->trans('Yes') : $langs->trans('No');
	$created_at = $competitors->created_at ? dol_print_date($competitors->created_at,'dayhoursec') : '';

	print '<table class="border" width="100%">';
	// Name
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("CompetitorName").'</td>';
	print '<td colspan="2">'. $name .'</td></tr>';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $createdBy->getNomUrl('1') .'</td></tr>';
	// Created at
	print '<tr><td width="25%">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. $created_at .'</td></tr>';
	// City
	print '<tr><td width="25%">'.$langs->trans("City").'</td>';
	print '<td colspan="2">'. $competitors->city .'</td></tr>';
	// Address
	print '<tr><td width="25%">'.$langs->trans("Address").'</td>';
	print '<td colspan="2">'. $competitors->address .'</td></tr>';
	// Country
	print '<tr><td width="25%">'.$langs->trans("Country").'</td>';
	print '<td colspan="2">'. $competitors->country .'</td></tr>';
	// Amount
	print '<tr><td width="25%" class="fieldrequired">'.$langs->trans("Amountht").'</td>';
	print '<td colspan="2">'. $amount .'</td></tr>';
	// Dilvered date
	print '<tr><td width="25%">'.$langs->trans("Winner").'</td>';
	print '<td colspan="2">'. $winner .'</td></tr>';
	
	print '</table>';

	if ($user->id && $user->rights->marches->write) {
		print '<div class="tabsAction">';
            // Boutons d'actions
				if ($user->id && $user->rights->marches->write)

			print '<a href="./card.php?action=edit&id='. $id .'&competitor_id='. $competitors->id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        	print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
            
            // If draft
            if ($user->rights->marches->delete)	{
            	print '<a href="./card.php?id='.$_GET['id'].'&action=delete&competitor_id='. $competitors->id .'" class="butActionDelete">'.$langs->trans("Delete").'</a>';
            }
        print '</div>';
	}
}
else {
	$title = $langs->trans("ListOfCompetitors");
	$appeloffre->fetch($id);
	$head  = appeloffre_prepare_head($appeloffre);
   	dol_fiche_head($head, 'competitors', $title, 1, '');
   	$moreparam = 'id='.$id;

   	if ($id > 0) {
		echo $appeloffre->getAppelOffreHeader();
	}

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">'."\n";
	print '<input name="id" value="'. $id .'" type="hidden" />';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("CompetitorName"),$_SERVER["PHP_SELF"], "name", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("City"), $_SERVER["PHP_SELF"], 'city', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Address"), $_SERVER["PHP_SELF"], 'address', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Amountht"), $_SERVER["PHP_SELF"], 'amount', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedAt"),$_SERVER["PHP_SELF"],"created_at","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Winner"),$_SERVER["PHP_SELF"],"winner","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat center" size="30" type="text" name="search_name" value="'.dol_escape_htmltag($search_name).'">';
	print '</td>';

	// UTILISATEUR
    print '<td class="liste_titre" align="center">';
    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
    print '</td>';

	// Amount
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="30" name="search_city" value="'.$search_city.'"></td>';
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="30" name="search_address" value="'.$search_address.'"></td>';
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat center" type="text" size="30" name="search_amount" value="'.$search_amount.'"></td>';
	// Created Date
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat datepicker center" type="text" size="14" name="search_created_at" value="'.$search_created_at.'"></td>';
	print '<td class="liste_titre" colspan="1" align="center">&nbsp;</td>';
	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($competitors->lines)) {
		$createdBy = new User($db);

		foreach($competitors->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_created_by));
			$name 				  = $line->name;
			$winner 			  = 0 != $line->winner ? 'Oui' : 'Non';
			$amount 			  = null !== $line->amount ? number_format($line->amount, 2) : '0';
			$created_at			  = null !== $line->created_at ? dol_print_date($line->created_at,'day') : '';
			$fullAddress  = '';
			if (null !== $address = $line->address) {
				$addr = (strlen($address) > 30 ? substr($address, 0, 30).'...' : $address);
				$fullAddress = '<span class="classfortooltip" title="'. strip_tags(str_replace("\n\r", "", $address)) .'">'. $addr .'</span>';
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="260px">';
			print $competitors->getNomUrl(1,  $line->fk_appel_offre,  $line->id, $name);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align="center">'. $line->city .'</td>';
			print '<td align="center">'. $fullAddress .'</td>';
			print '<td align="center">'. $amount .' DH</td>';
			print '<td align="center">'. $created_at .'</td>';
			print '<td align="center">'. $winner .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->marches->write) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add&id='. $id .'" class="butAction">'.$langs->trans('AddCompetitor').'</a>';
		print '</div>';
	}

}

llxFooter();

$db->close();

?>