<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       marches/marche/card.php
 * \ingroup    marche
 * \brief      markets CRUD
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formsocialcontrib.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/marches/marche/class/marche.class.php');
dol_include_once('/marches/certificates/class/certificate.class.php');
dol_include_once('/marches/lib/marches.lib.php');
require_once DOL_DOCUMENT_ROOT.'/compta/sociales/class/chargesociales.class.php';

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$confirm  = GETPOST('confirm', 'alpha');
$id      = GETPOST('id', 'int');
$mid 	 = GETPOST('mid', 'int');
$error 	= false;
$request_method = $_SERVER['REQUEST_METHOD'];

$certificate        = new Certificates($db);
$formsocialcontrib  = new FormSocialContrib($db);
$marche             = new Marches($db);
$form               = new Form($db);

if ($action == 'create' && $request_method === 'POST') {
    // If no right to update a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
        $error = true;
        setEventMessage($langs->trans('CantCreate'));
        $action='edit';
    } else {

        if (!count($_POST['cs']))
            die('cs is empty');

        $mid = GETPOST('mid', 'int');

        foreach ($_POST['cs'] as $key => $val) {
            $cs_id = (int) $val;

            if (!empty($cs_id)) {
                $certificate->fk_marche = $mid;
                $certificate->fk_created_by = $user->id;
                $certificate->fk_chargesociales = $cs_id;

                $certificate->create();
            }
        }
    
        header("Location: ./index.php?mid=". $mid);
        die();
    }
}

if ($action == 'update' && $request_method === 'POST') {
	die('update');
}

if ($action == 'confirm_delete' and $confirm == 'yes') {
    if ($id && $user->rights->marches->delete_marche) {
        $deleted = $certificate->delete($id);

        if ($deleted)
            header("Location: ./index.php?mid=". $mid);
            die();
    }
}

/*
 * View
 */
$morejs  = array();
$morecss = array();

llxHeader(array(), $langs->trans('CertificatesList'),'','','','',$morejs,$morecss,0,0);
print_fiche_titre($langs->trans('CertificatesList'),'','object_marches@marches');


if ($id || $action == 'edit' || $action == 'update') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
        $errors[]=$langs->trans('CantCreate');
    }
    else {
		$canedit = ($user->rights->marches->delete_marche || $user->rights->marches->write_marche);
        
        if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete_marche) {
                    print $form->formconfirm("./card.php?id=".$id, $langs->trans("TitleDeleteCert"),$langs->trans("ConfirmDeleteCert"),"confirm_delete", '', 0, 1);
                }
            }

            $marche->fetch($mid);
            $certificate->fetch($id);
            $head = marches_prepare_head($marche);
            dol_fiche_head($head, 'certificates', $langs->trans("Certificates"), 0, '');

            if ($action == 'edit') {
                $edit = true;
                print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
                print '<input type="hidden" name="action" value="update" />';
                print '<input type="hidden" name="mid" value="'.$mid.'" />';
                print '<input type="hidden" name="id" value="'.$id.'" />';

                print '<table class="border" width="100%">';
                print '<tbody>';

                // Label
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketRef").'</td><td>';
                print '<input type="text" value="'. $marche->ref_marche .'" name="ref_marche" required="required" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketLabel").'</td><td>';
                print '<input type="text" value="'. $marche->label .'" name="label" required="required" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketDate").'</td><td>';
                print '<input type="text" class="datepicker" value="'. dol_print_date($marche->sig_date, 'day') .'" name="sig_date" required="required" readonly="readonly" /></td></tr>';
                print '<tr><td class="fieldrequired">'.$langs->trans("MarketAmount").'</td><td>';
                print '<input type="text" value="'. $marche->budget .'" name="budget" required="required" /></td></tr>';

                print '</tbody>';
                print '</table><br />';

                print '<div class="center">';
                // Boutons d'actions
                print '<input type="submit" class="button" value="'. $langs->trans('Modify') .'">';

                // If draft
                if ($user->rights->marches->delete_marche)	{
                	print '<a href="./card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
                }
                print '</div>';
            }

            dol_fiche_end();

        }
    }
}


// End of page
llxFooter();

if (is_object($db)) $db->close();

?>
