<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/bails/card.php
 *		\ingroup    bails
 *		\brief      Gestion des bails
 */

//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
dol_include_once('/marches/marche/class/marche.class.php');
dol_include_once('/marches/bails/class/bail.class.php');
dol_include_once('/marches/lib/marches.lib.php');
require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$mid 	 = GETPOST('mid', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$mid && $request_method !== 'POST')
	die('ID marché n\'existe pas!');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0)  $socid = $user->societe_id;

$error 	= false;
$object   = new Bails($db);
$marche = new Marches($db);
$account= new Account($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {
    $action='request';
    // If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	    $object_date= '';
	    $mid 	  = trim(GETPOST('mid', 'int'));
	    $amount   = (float)trim(GETPOST('amount'));
	    $num 	  = trim(GETPOST('num'));
	    $bank 	  = (int) GETPOST('bank_');
	    $sig_date = trim($_POST['sig_date']);
	    $deposit_date = trim($_POST['deposit_date']);

	    if (!$mid || $mid <= 0 || !$amount || !$num)
	    	return;

	    if (isset($_POST['bail_date']) && !empty($_POST['bail_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['bail_date']);
	        $object_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($sig_date) && !empty($sig_date)) {
	        list($etd, $etm, $ety) = explode("/", $sig_date);
	        $sig_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($deposit_date) && !empty($deposit_date)) {
	        list($etd, $etm, $ety) = explode("/", $deposit_date);
	        $deposit_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $object->fk_created_by 	= $user->id;
	    $object->fk_marche 	 	= $mid;
	    $object->fk_bank 	 	= $bank;
		$object->bail_date 	 	= $object_date;
		$object->sig_date 	 	= $sig_date;
		$object->deposit_date 	= $deposit_date;
		$object->amount 	 	= $amount;
	    $object->ref 			= $num;
		$getBailId = $object->create();

	    // If no SQL error we redirect to the request card
	    header('Location: ./index.php?mid='.$mid.'&id='.$getBailId);
	    die();
    }
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['mid'] > 0 && $request_method === 'POST') {
    $action = 'edit';
	// If no right to create a request
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    } else {
	   	$object_date= '';
	    $mid 	  = (int)trim(GETPOST('mid', 'int'));
	    $id 	  = (int)trim(GETPOST('id', 'int'));
	    $amount   = (float)trim(GETPOST('amount'));
	    $num 	  = trim(GETPOST('num'));
	    $bank 	  = (int) GETPOST('bank_');
	    $sig_date = trim($_POST['sig_date']);
	    $deposit_date = trim($_POST['deposit_date']);

	    if (!$mid || $mid <= 0 || !$amount || !$num)
	    	return;

	    if (isset($_POST['bail_date']) && !empty($_POST['bail_date'])) {
	        list($etd, $etm, $ety) = explode("/", $_POST['bail_date']);
	        $object_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($sig_date) && !empty($sig_date)) {
	        list($etd, $etm, $ety) = explode("/", $sig_date);
	        $sig_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($deposit_date) && !empty($deposit_date)) {
	        list($etd, $etm, $ety) = explode("/", $deposit_date);
	        $deposit_date = $ety.'-'.$etm.'-'.$etd;
	    }

	    $data = array(
		    'fk_bank' 	 	 => $bank,
			'bail_date' 	 => $object_date,
			'sig_date' 	 	 => $sig_date,
			'deposit_date' 	 => $deposit_date,
			'amount' 	 	 => $amount,
		    'ref' 			 => $num
		);

		$object->update($id, $data);

    	header('Location: ./index.php?mid='.$mid.'&id='.$id);
        die();
	}
}

$form 	 = new Form($db);

llxHeader(array(), $langs->trans('Bails'),'','','','',array("/marches/js/marches.js"),array(),0,0);
print_fiche_titre($langs->trans('Bails'),'','object_marches@marches');
$def = $langs->trans("Definit");
//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');

if (empty($mid) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) || empty($user->rights->marches->write_marche)) {
        $errors[] = $langs->trans('CantCreate');
    } else {
        // Formulaire de concurrents
		$marche->fetch($mid);
		$head = marches_prepare_head($marche);
		
		dol_fiche_head($head, 'notifications', $langs->trans('NotificationsPhase'), 0, '');

		$head_btm = phase_notification_prepare_head($marche);
		dol_fiche_head($head_btm, 'bails',$langs->trans('DefinitiveBail'), 0, '');
		echo $marche->getMarketHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";

        print '<table class="border" width="100%">';
        print '<tbody>';

        print '<tr><td width="20%" class="fieldrequired">'.$langs->trans("ApprovalBailAmount").' '. $def.'</td><td>';
        print '<input type="text" class="amount" value="" name="amount" required="required" /></td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalBailNum").' '. $def.'</td><td>';
        print '<input type="text" class="num" value="" name="num" required="required" /></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("BailDate").' '. $def.'</td><td>';
        print '<input type="text" class="datepicker" value="" name="bail_date" required="required" /></td></tr>';

        print '<tr><td class="">'.$langs->trans("SigDate").'</td><td><input type="text" class="datepicker" value="" name="sig_date" /></td></tr>';
		print '<tr><td class="">'.$langs->trans("DepositDate").'</td><td><input type="text" class="datepicker" value="" name="deposit_date" /></td></tr>';

        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
        print $form->select_comptes((GETPOST('bank_') ? GETPOST('bank_') : ''), 'bank_',0,'',1,'required="required"') ."<span class='bank_number'></span>";
        print'</td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateBail") .'" name="bouton" class="button">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="button" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $mid > 0) {
		$object->fetch($id, $mid);
		$marche->fetch($mid);
		$head  = marches_prepare_head($marche);
		$canedit = ($user->rights->marches->delete_marche || $user->rights->marches->write_marche);

		if ($canedit) {
            if ($action == 'delete') {
                die("Can not delete this bail");
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'notifications', $langs->trans('NotificationsPhase'), 0, '');

				$head_btm = phase_notification_prepare_head($marche);
				dol_fiche_head($head_btm, 'bails',$langs->trans('DefinitiveBail'), 0, '');
				echo $marche->getMarketHeader();

		        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="mid" value="'. $mid .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$account->fetch($object->fk_bank);
				$amount 	= $object->amount_def ?: '';
				$ref	  	= $object->ref ? $object->ref : '';
				$bail_date	= $object->bail_date ? dol_print_date($object->bail_date, 'day') : '';
				$sig_date	= $object->sig_date ? dol_print_date($object->sig_date, 'day') : '';
				$deposit_date= $object->deposit_date ? dol_print_date($object->deposit_date, 'day') : '';
				$number = '';
                if ($account->number) {
                    $number = "<span class='bank_number'> &nbsp;&nbsp;( <b><u>". $account->number ."</u></b> )</span>";
                }

		        print '<table class="border" width="100%">';
		        print '<tbody>';

		        print '<tr><td width="20%" class="fieldrequired">'.$langs->trans("ApprovalBailAmount").' '. $def.'</td><td>';
		        print '<input type="text" class="amount" value="'. $amount .'" name="amount" required="required" /></td></tr>';
		        
		        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalBailNum").' '. $def.'</td><td>';
		        print '<input type="text" class="num" value="'. $ref .'" name="num" required="required" /></td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("BailDate").' '. $def.'</td><td>';
		        print '<input type="text" class="datepicker" value="'. $bail_date .'" name="bail_date" required="required" /></td></tr>';

		        print '<tr><td class="">'.$langs->trans("SigDate").'</td><td><input type="text" class="datepicker" value="'. $sig_date .'" name="sig_date" /></td></tr>';
		        print '<tr><td class="">'.$langs->trans("DepositDate").'</td><td><input type="text" class="datepicker" value="'. $deposit_date .'" name="deposit_date" /></td></tr>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("Bank").'</td><td>';
		        print $form->select_comptes($object->fk_bank, 'bank_',0,'',1,'required="required"') . $number;
		        print'</td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}



llxFooter();

$db->close();

?>