<?php 
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       marches/competitors/card.php
 *		\ingroup    card
 *		\brief      Gestion des concurrents
 */

//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/CMailFile.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formmail.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
dol_include_once('/marches/class/appeloffre.class.php');
dol_include_once('/marches/competitors/class/competitor.class.php');
dol_include_once('/marches/marche/class/marche.class.php');
dol_include_once('/marches/approval/class/approval.class.php');
dol_include_once('/marches/lib/marches.lib.php');

// Get parameters
$myparam = GETPOST("myparam");
$action  = GETPOST('action', 'alpha');
$ao 	 = GETPOST('ao', 'int');
$id 	 = GETPOST('id', 'int');
$request_method = $_SERVER['REQUEST_METHOD'];

if (!$ao && $request_method !== 'POST')
	die('ID Appel offre n\'existe pas!');

$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$error 	    = false;
$approval   = new Approval($db);
$appeloffre = new AppelOffre($db);
$marches    = new Marches($db);

if ($_POST['action'] == 'create' && $request_method === 'POST') {

    // If no right to create a request
    if (empty($user->rights->marches->write) ) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='request';
    }

    $signature_date	= '';
    $approval_date	= '';
    $visa_date		= '';
    $bail_date 		= '';
    $bail_amount	= '';
    $bail_num 		= '';
    $ao 			= trim(GETPOST('ao', 'int'));
    $amount_ht 		= trim(GETPOST('amount_ht'));
    $amount_tva 	= trim(GETPOST('amount_tva'));
    $amount_ttc 	= trim(GETPOST('amount_ttc'));
    $signature_num 	= trim(GETPOST('signature_num'));
    $approval_num 	= trim(GETPOST('approval_num'));
    $visa_num 		= trim(GETPOST('visa_num'));
    $approved 		= trim(GETPOST('approved'));

    if (!$ao || $ao <= 0 || !$amount_ht)
    	return;

    if (isset($_POST['signature_date']) && !empty($_POST['signature_date'])) {
        list($etd, $etm, $ety) = explode("/", $_POST['signature_date']);
        $signature_date = $ety.'-'.$etm.'-'.$etd;
    }

    if (isset($_POST['approval_date']) && !empty($_POST['approval_date'])) {
        list($etd, $etm, $ety) = explode("/", $_POST['approval_date']);
        $approval_date = $ety.'-'.$etm.'-'.$etd;
    }

    if (isset($_POST['visa_date']) && !empty($_POST['visa_date'])) {
        list($etd, $etm, $ety) = explode("/", $_POST['visa_date']);
        $visa_date = $ety.'-'.$etm.'-'.$etd;
    }

    $statut = 2;
    $notification = '';
    if ($approved == 0) {
	    if (isset($_POST['bail_date']) && !empty($_POST['bail_date'])) {
	        list($btd, $btm, $bty) = explode("/", $_POST['bail_date']);
	        $bail_date 			   = $bty.'-'.$btm.'-'.$btd;
	    }
	    $bail_amount 	= trim(GETPOST('bail_amount'));
	    $bail_num 		= trim(GETPOST('bail_num'));
	    $checkMarketExisting = $marches->fetch(0, null, $ao);
	    if ($checkMarketExisting > 0) {
	    	$marches->update($marches->id, array('statut' => 1)); // marche achrive
    		$notification = '&notification=marketArchived';
	    }
    } else if ($approved == 1) {
		$statut = 1;
    	$notification = '&notification=marketCreated';

    	/*$competitor = new Competitors($db);
    	$getWinner  = $competitor->getWinner($ao);*/

    	$appeloffre->fetch($ao);
    	$marches->fk_created_by  = $user->id;
		$marches->fk_appel_offre = $ao;
		$marches->ref_marche	 = $appeloffre->ref;
		$marches->label 		 = $appeloffre->subject;
		$marches->budget 		 = $amount_ht/*($getWinner > 0 ? $competitor->amount : 0)*/;
		$marches->sig_date 		 = $signature_date;
		$marches->create();
    }

    $approval->fk_created_by = $user->id;
    $approval->fk_appel_offre= $ao;
    $approval->amount_ht 	 = $amount_ht;
	$approval->amount_tva 	 = $amount_tva;
	$approval->amount_ttc 	 = $amount_ttc;
    $approval->signature_date= $signature_date;
	$approval->signature_num = $signature_num;
	$approval->approval_num  = $approval_num;
	$approval->approval_date = $approval_date;
	$approval->visa_date   	 = $visa_date;
	$approval->visa_num   	 = $visa_num;
	$approval->approved   	 = $approved;
	$approval->bail_date   	 = $bail_date;
	$approval->bail_amount   = $bail_amount;
	$approval->bail_num   	 = $bail_num;
	$approval->statut   	 = $statut;

	$appeloffre->update($ao, array('statut' => $statut));
	$getApprovalId = $approval->create();

    // If no SQL error we redirect to the request card
    header('Location: ./index.php?ao='.$ao.'&id='.$getApprovalId. $notification);
    die();
}

if ($_POST['action'] == 'update' && $_POST['id'] > 0 && $_POST['ao'] > 0 && $request_method === 'POST') {
	// If no right to create a request
    if (empty($user->rights->marches->write) ) {
    	$error++;
    	setEventMessage($langs->trans('CantCreate'));
    	$action='add';
    } else {
	    $signature_date = '';
	    $approval_date	= '';
	    $visa_date		= '';

	    $ao 		  = trim(GETPOST('ao', 'int'));
	    $id  		  = trim(GETPOST('id', 'int'));
	    $amount_ht 	  = trim(GETPOST('amount_ht'));
	    $amount_tva	  = trim(GETPOST('amount_tva'));
	    $amount_ttc   = trim(GETPOST('amount_ttc'));
	    $approval_num = trim(GETPOST('approval_num'));
	    $signature_num= trim(GETPOST('signature_num'));
	    $visa_num 	  = trim(GETPOST('visa_num'));
	    $approved 	  = trim(GETPOST('approved'));

	    if (!$ao || $ao <= 0 || !$id)
	    	return;

		$bail_date 	 = '';
	    $bail_amount = '';
	    $bail_num 	 = '';
		$statut 	 = 2;
		$notification= '';

		if (isset($_POST['signature_date']) && !empty($_POST['signature_date'])) {
	        list($etd, $etm, $ety) 	= explode("/", $_POST['signature_date']);
	        $signature_date 		= $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['approval_date']) && !empty($_POST['approval_date'])) {
	        list($etd, $etm, $ety) 	= explode("/", $_POST['approval_date']);
	        $approval_date 			= $ety.'-'.$etm.'-'.$etd;
	    }

	    if (isset($_POST['visa_date']) && !empty($_POST['visa_date'])) {
	        list($etd, $etm, $ety) 	= explode("/", $_POST['visa_date']);
	        $visa_date 				= $ety.'-'.$etm.'-'.$etd;
	    }

	    if ($approved == 0) {
		    if (isset($_POST['bail_date']) && !empty($_POST['bail_date'])) {
		        list($btd, $btm, $bty) = explode("/", $_POST['bail_date']);
		        $bail_date 			   = $bty.'-'.$btm.'-'.$btd;
		    }
		    $bail_amount 	= trim(GETPOST('bail_amount'));
		    $bail_num 		= trim(GETPOST('bail_num'));

		    $checkMarketExisting = $marches->fetch(0, null, $ao);
		    if ($checkMarketExisting > 0) {
		    	$marches->update($marches->id, array('statut' => 1)); // marche achrive
    			$notification = '&notification=marketArchived';
		    }
	    } else if ($approved == 1) {
			$statut = 1;
			$checkMarketExisting = $marches->fetch(0, null, $ao);
		    if ($checkMarketExisting <= 0) {
		    	$notification 			 = '&notification=marketCreated';

		    	/*$competitor = new Competitors($db);
    			$getWinner  = $competitor->getWinner($ao);*/

				$appeloffre->fetch($ao);
		    	$marches->fk_created_by  = $user->id;
				$marches->fk_appel_offre = $ao;
				$marches->ref_marche	 = $appeloffre->ref;
				$marches->label 		 = $appeloffre->subject;
				$marches->budget 		 = $amount_ht/*($getWinner > 0 ? $competitor->amount : 0)*/;
				$marches->sig_date 		 = $signature_date;
				$marches->create();
			} else {
				$marches->update($marches->id, array('statut' => 0)); // marche active
		    	$notification = '&notification=marketActivated';
			}
	    }

	    $data = array(
		    'amount_ht' 	 => $amount_ht,
			'amount_tva' 	 => $amount_tva,
			'amount_ttc'     => $amount_ttc,
			'approval_num'   => $approval_num,
			'signature_num'  => $signature_num,
			'visa_num'    	 => $visa_num,
		    'signature_date' => $signature_date,
			'approval_date'  => $approval_date,
			'visa_date' 	 => $visa_date,
			'approved' 	 	 => $approved,
			'statut' 	 	 => $statut,
			'bail_amount' 	 => $bail_amount,
			'bail_num' 	 	 => $bail_num,
			'bail_date' 	 => $bail_date,
		);

		$appeloffre->update($ao, array('statut' => $statut));
		$approval->update($id, $ao, $data);

    	header('Location: ./index.php?ao='.$ao.'&id='.$id. $notification);
        die();
	}
}

if ($action == 'confirm_delete' && $_GET['confirm'] == 'yes' && $user->rights->marches->delete) {
	$error = 0;
	$ao = GETPOST('ao', 'int');
	$id = GETPOST('id', 'int');
	
	if (!$ao || !$id)
		return;

	$db->begin();

	$canedit = ( $user->rights->marches->delete);

	// Si l'utilisateur à le droit de lire ce contrat, il peut le supprimer
	if ($canedit) {
        $approval->id = (int) $id;
        $approval->fk_appel_offre = (int) $ao;
		$approval->delete();
	} else {
		$error = $langs->trans('ErrorCantDelete');
	}

	if (!$error) {
		$db->commit();
		header('Location: ./index.php?leftmenu=marches&ao='.$ao);
		exit;
	} else {
		$db->rollback();
        header('Location: ./index.php?leftmenu=marches&ao='.$ao);
        exit;
	}
}

$form 	 	= new Form($db);
$morejs  = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.js", "/marches/js/jquery/timepicker/timepicker-fr.js", "/marches/js/marches.js");
$morecss = array("/includes/jquery/plugins/timepicker/jquery-ui-timepicker-addon.css", "/marches/css/marches.css");

llxHeader(array(), $langs->trans('ListOfCompetitors'),'','','','',$morejs,$morecss,0,0);

//print '<script>var main_dir = "'. $dolibarr_main_url_root .'"</script>';
dol_include_once('/marches/loadjsmarches.php');

if (empty($ao) || $action == 'add' || $action == 'request' || $action == 'create') {
	// Si l'utilisateur n'a pas le droit de créer un marché
    if (empty($user->rights->marches->write) ) {
        $errors[] = $langs->trans('CantCreateMarche');
    } else {
        // Formulaire de concurrents
		$appeloffre->fetch($ao);
		$head = appeloffre_prepare_head($appeloffre);
		dol_fiche_head($head, 'approval', $langs->trans('AddApproval'), 0, '');

		echo $appeloffre->getAppelOffreHeader();

        print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">'."\n";
        print '<input type="hidden" name="action" value="create" />'."\n";
        print '<input type="hidden" name="ao" value="'. $ao .'" />'."\n";

        print '<table class="border" width="100%" data-row-id="0">';
        print '<tbody>';

        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountHT").'</td><td>';
        print '<input type="text" class="amount" value="" name="amount_ht" required="required" /></td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTva").'</td><td>';
        print '<input type="text" class="tva" value="" name="amount_tva" required="required" /></td></tr>';
        
        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTTC").'</td><td>';
        print '<input type="text" class="total_amout" value="" name="amount_ttc" required="required" /></td></tr>';

        print '<tr><td class="" width="400px">'.$langs->trans("ApprovalDateSigMarket").'</td><td>';
        print '<input type="text" class="" value="" name="signature_num" />&nbsp;&nbsp;'. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp;<input type="text" class="datepicker" value="" name="signature_date" readonly="readonly" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("ApprovalDateApprov").'</td><td>';
        print '<input type="text" class="" value="" name="approval_num" />&nbsp;&nbsp;'. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp;<input type="text" class="datepicker" value="" name="approval_date" readonly="readonly" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("ApprovalDateNumVisa").'</td><td>';
        print '<input type="text" class="" value="" name="visa_num" />&nbsp;&nbsp;'. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp;<input type="text" class="datepicker" value="" name="visa_date" readonly="readonly" />';
        print '</td></tr>';

        print '<tr><td>'.$langs->trans("Approved").'</td><td>';
        print '<input type="radio" class="approved" value="1" name="approved" checked /> Oui &nbsp;&nbsp;&nbsp; <input type="radio" class="approved" value="0" name="approved" /> Non';
        print '</td></tr>';

        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailNum").'</td><td><input type="text" class="" value="" name="bail_num" /></td></tr>';
        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailDate").'</td><td><input type="text" class="datepicker" value="" name="bail_date" readonly="readonly" /></td></tr>';
        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailAmount").'</td><td><input type="text" class="" value="" name="bail_amount" /></td></tr>';

        print '</tbody>';
        print '</table>';

		dol_fiche_end();

        print '<div class="center"  style="margin-top: 28px;">';
        print '<input type="submit" value="'. $langs->trans("CreateApproval") .'" name="bouton" class="button">';
        print '&nbsp; &nbsp; ';
        print '<input type="button" value="'. $langs->trans("Cancel") .'" class="button" onclick="history.go(-1)">';
        print '</div>';

        print '</form>';
    }
} else {
	if ($id > 0 && $ao > 0) {
		$approval->fetch($id, $ao);
		$appeloffre->fetch($ao);
		$head  = appeloffre_prepare_head($appeloffre);
		$canedit = ($user->rights->marches->delete);

		if ($canedit) {
            if ($action == 'delete') {
                if($user->rights->marches->delete) {
                    print $form->formconfirm("./card.php?ao=".$ao."&id=".$id, $langs->trans("TitleDeleteMonitoring"),$langs->trans("ConfirmDeleteMonitoring"),"confirm_delete", '', 0, 1);
                }
            }

			if ($action == 'edit' || $action == 'delete') {
				dol_fiche_head($head, 'approval', $langs->trans('AddApproval'), 0, '');

				echo $appeloffre->getAppelOffreHeader();

		        print '<form method="POST" action="'.$_SERVER['PHP_SELF'].'" class="sub_form_prt">'."\n";
		        print '<input type="hidden" name="action" value="update" />'."\n";
		        print '<input type="hidden" name="ao" value="'. $ao .'" />'."\n";
		        print '<input type="hidden" name="id" value="'. $id .'" />'."\n";

				$amount_ht 		  = $approval->amount_ht ? number_format($approval->amount_ht, 0, '', '') : '';
				$amount_tva		  = $approval->amount_tva ? number_format($approval->amount_tva, 0, '', '') : '';
				$amount_ttc	  	  = $approval->amount_ttc ? number_format($approval->amount_ttc, 0, '', '') : '';
				$signature_num	  = $approval->signature_num ? $approval->signature_num : '';
				$signature_date	  = $approval->signature_date ? dol_print_date($approval->signature_date, 'day') : '';
				$approval_num	  = $approval->approval_num ? $approval->approval_num : '';
				$approval_date	  = $approval->approval_date ? dol_print_date($approval->approval_date, 'day') : '';
				$visa_num	  	  = $approval->visa_num ? $approval->visa_num : '';
				$visa_date	  	  = $approval->visa_date ? dol_print_date($approval->visa_date, 'day') : '';
				$approved	  	  = $approval->approved ? $langs->trans('Yes') : $langs->trans('Non');
				$addMoreBtns 	  = ($approval->approved ? ' check_confirm_btn confirmActionToGo' : ' check_confirm_btn');

		        print '<table class="border" width="100%" data-row-id="0">';
		        print '<tbody>';

		        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountHT").'</td><td>';
		        print '<input type="text" class="amount" value="'. $amount_ht .'" name="amount_ht" required="required" /></td></tr>';
		        
		        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTva").'</td><td>';
		        print '<input type="text" class="tva" value="'. $amount_tva .'" name="amount_tva" required="required" /></td></tr>';
		        
		        print '<tr><td class="fieldrequired">'.$langs->trans("ApprovalAmountTTC").'</td><td>';
		        print '<input type="text" class="total_amout" value="'. $amount_ttc .'" name="amount_ttc" required="required" /></td></tr>';

		        print '<tr><td class="" width="400px">'.$langs->trans("ApprovalDateSigMarket").'</td><td>';
		        print '<input type="text" class="" value="'. $signature_num .'" name="signature_num" />&nbsp;&nbsp;'. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp;<input type="text" class="datepicker" value="'. $signature_date .'" name="signature_date" readonly="readonly" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("ApprovalDateApprov").'</td><td>';
		        print '<input type="text" class="" value="'. $approval_num .'" name="approval_num" />&nbsp;&nbsp;'. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp;<input type="text" class="datepicker" value="'. $approval_date .'" name="approval_date" readonly="readonly" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("ApprovalDateNumVisa").'</td><td>';
		        print '<input type="text" class="" value="'. $visa_num .'" name="visa_num" />&nbsp;&nbsp;'. $langs->trans("ApprovalDateAt").' &nbsp;&nbsp;<input type="text" class="datepicker" value="'. $visa_date .'" name="visa_date" readonly="readonly" />';
		        print '</td></tr>';

		        print '<tr><td>'.$langs->trans("Approved").'</td><td>';
		        print '<input type="radio" class="approved" value="1" name="approved" '. ($approval->approved == 1 ? ' checked="checked"' : '') .' /> Oui &nbsp;&nbsp;&nbsp; <input type="radio" class="approved" value="0" name="approved"'. ($approval->approved == 0 ? ' checked="checked"' : '') .' /> Non';
		        print '</td></tr>';

		        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailNum").'</td><td><input type="text" class="" value="'. $bail_num .'" name="bail_num" /></td></tr>';
		        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailDate").'</td><td><input type="text" class="datepicker" value="'. $bail_date .'" name="bail_date" readonly="readonly" /></td></tr>';
		        print '<tr class="hidden bail_info"><td>'.$langs->trans("ApprovalBailAmount").'</td><td><input type="text" class="" value="'. $bail_amount .'" name="bail_amount" /></td></tr>';

		        print '</tbody>';
		        print '</table>';

				dol_fiche_end();

		        print '<div class="tabsAction">';
                    // Boutons d'actions
		        	print '<input type="submit" value="'. $langs->trans("Modify") .'" name="bouton" class="butAction '. $addMoreBtns .'">';
                    print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
                print '</div>';

		        print '</form>';
			}
        }
	}
}



llxFooter();

$db->close();

?>