<?php
/* Copyright (C) 2016	Yassine Belkaid	<y.belkaid@nextconcept.ma>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file       appeloffres//qualifications/index.php
 * \ingroup    list
 * \brief      List of markets
 */
//require_once('../../main.inc.php');
$res=0;
if (! $res && file_exists("../../main.inc.php")) $res=@include("../../main.inc.php");       // For root directory
if (! $res && file_exists("../../../main.inc.php")) $res=@include("../../../main.inc.php"); // For "custom" 
require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
dol_include_once('/marches/qualifications/class/qualification.class.php');
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';

$langs->load('users');
$langs->load('marches');

// Protection if external user
if ($user->societe_id > 0) accessforbidden();

$sortfield = GETPOST("sortfield",'alpha');
$sortorder = GETPOST("sortorder",'alpha');
$page = GETPOST("page",'int');
$page = is_numeric($page) ? $page : 0;
$page = $page == -1 ? 0 : $page;
$filter = '';
if (! $sortfield) $sortfield = "rowid";
if (! $sortorder) $sortorder = "DESC";

$offset   = $conf->liste_limit * $page;
$pageprev = $page - 1;
$pagenext = $page + 1;
$id 	  = GETPOST('id','int');

$search_num      			= GETPOST('search_num');
$search_created_by      	= GETPOST('search_created_by');
$search_type      			= GETPOST('search_type');
$search_dilevered    		= GETPOST('search_dilevered');
$search_expired     		= GETPOST('search_expired');
$search_subject     		= GETPOST('search_subject');

 // Both test are required to be compatible with all browsers
if (GETPOST("button_removefilter_x") || GETPOST("button_removefilter")) {
	$search_num   	   = "";
	$search_created_by = "";
	$search_type  	   = "";
    $search_dilevered  = "";
	$search_expired    = "";
	$search_subject    = "";
}

/**
 * Actions
 */

// None

/**
 * View
 */

$qualifications = new Qualifications($db);
$filter 	= '';

llxHeader(array(), $langs->trans('EntrepriseQC'), '', '', '', '', array('/marches/js/marches.js'));

// Filter
$filter .= (!empty($search_num) && $search_num != -1) ? " AND num = '". $db->escape($search_num) ."'\n" : "";

if (isset($search_dilevered) && !empty($search_dilevered)) {
	list($sd, $sm, $sy)  = explode("/", $search_dilevered);
	$filter .=  " AND delivered = '". $sy.'-'.$sm.'-'.$sd ."'";
}
if (isset($search_expired) && !empty($search_expired)) {
	list($ed, $em, $ey)  = explode("/", $search_expired);
	$filter .=  " AND expired = '". $ey.'-'.$em.'-'.$ed ."'";
}

$filter .= (isset($search_subject) && !empty($search_subject)) ? " AND subject like '".$db->idate($search_subject).'"' : "";
$filter .= (!empty($search_created_by) && $search_created_by != -1) ? " AND fk_created_by = '".$db->escape($search_created_by)."'\n" : "";
$filter .= (!empty($search_type) && $search_type != -1) ? " AND type = '".$db->escape($search_type)."'\n" : "";
/*************************************
 * Fin des filtres de recherche
*************************************/

// Récupération de l'ID de l'utilisateur
$user_id 		   = $user->id;
$getQualifications = $qualifications->fetchAll($sortorder, $sortfield, $conf->liste_limit + 1, $offset, $filter);

// Si erreur SQL
if ($getQualifications == '-1') {
    print_fiche_titre($langs->trans('EntrepriseQC'), '', 'title_project.png');

    dol_print_error($db, $langs->trans('Error').' '.$qualifications->error);
    exit();
}

// Show table of vacations
$var 		= true;
$num 		= count($qualifications->lines);
$form 		= new Form($db);
$formother 	= new FormOther($db);

if ($id > 0) {
	$qualifications->fetch($id);
	$title = $langs->trans("EntrepriseQCE");
	dol_fiche_head('', 'tabgmbc', $title, 0, '');

	$createdBy  = new User($db);
	$createdBy->fetch($db->escape($qualifications->fk_created_by));
	$delivered 			= null !== $qualifications->delivered ? dol_print_date($qualifications->delivered,'day') : '';
	$expired			= null !== $qualifications->expired ? dol_print_date($qualifications->expired,'day') : '';
	$created_at 		= null !== $qualifications->created_at ? dol_print_date($qualifications->created_at,'dayhoursec') : '';
	$definitive  = '';
	$provisional = '';
	
	if (is_array($qualifications->definitive) and count($qualifications->definitive)) {
		if (count($qualifications->definitive['sector']))
			$definitive .= 'Secteur: '. implode(" & ", array_unique($qualifications->definitive['sector']));
		if (count($qualifications->definitive['qualification']))
			$definitive .= ', Qualifications: '. implode(" & ", array_unique($qualifications->definitive['qualification']));
		if (count($qualifications->definitive['class']))
			$definitive .= ', Classe: '. implode(" & ", array_unique($qualifications->definitive['class']));
	}

	if (is_array($qualifications->provisional) and count($qualifications->provisional)) {
		if (count($qualifications->provisional['sector']))
			$provisional .= 'Secteur: '. implode(" & ", array_unique($qualifications->provisional['sector']));
		if (count($qualifications->provisional['qualification']))
			$provisional .= ', Qualifications: '. implode(" & ", array_unique($qualifications->provisional['qualification']));
		if (count($qualifications->provisional['class']))
			$provisional .= ', Classe: '. implode(" & ", array_unique($qualifications->provisional['class']));
	}

	print '<table class="border" width="100%">';
	// Num
	print '<tr><td width="25%">'.$langs->trans("RefAO").'</td>';
	print '<td colspan="2">'. $qualifications->num .'</td></tr>';
	// Created By
	print '<tr><td width="25%">'.$langs->trans("CreatedBy").'</td>';
	print '<td colspan="2">'. $createdBy->getNomUrl('1') .'</td></tr>';
	// Created at
	print '<tr><td width="25%">'.$langs->trans("CreatedAt").'</td>';
	print '<td colspan="2">'. $created_at .'</td></tr>';
	// Type
	print '<tr><td width="25%">'.$langs->trans("Type").'</td>';
	print '<td colspan="2">'. $qualifications-> getTypeById($qualifications->type) .'</td></tr>';
	// Dilvered date
	print '<tr><td width="25%">'.$langs->trans("DileveredDate").'</td>';
	print '<td colspan="2">'. $delivered .'</td></tr>';
	// Expired date
	print '<tr><td width="25%">'.$langs->trans("ExpiredDate").'</td>';
	print '<td colspan="2">'. $expired .'</td></tr>';
	// subject
	print '<tr><td width="25%">'.$langs->trans("Subject").'</td>';
	print '<td colspan="2">'. nl2br($qualifications->subject) .'</td></tr>';
	// Months
	print '<tr><td width="25%">'.$langs->trans("MonthsPeriod").'</td>';
	print '<td colspan="2">'. $qualifications->months .'</td></tr>';
	// Definitive
	print '<tr><td width="25%">'.$langs->trans("Definitive").'</td>';
	print '<td colspan="2">'. $definitive .'</td></tr>';
	// Provisional
	print '<tr><td width="25%">'.$langs->trans("Provisional").'</td>';
	print '<td colspan="2">'. $provisional .'</td></tr>';
	print '</table>';

	if ($user->id && $user->rights->marches->write_all) {
		print '<div class="tabsAction">';
            // Boutons d'actions
			print '<a href="./card.php?action=edit&id='. $id .'" class="butAction">'.$langs->trans('Modify').'</a>';
        	print '<a onclick="history.go(-1)" class="butAction">'.$langs->trans("Cancel").'</a>';
            
            // If draft
            if ($user->rights->marches->delete)	{
            	print '<a href="./card.php?id='.$_GET['id'].'&action=delete" class="butActionDelete">'.$langs->trans("Delete").'</a>';
            }
        print '</div>';
	}
}
else {
	$title = (isset($display) && !empty($display)) ? $langs->trans("EntrepriseQC") : $langs->trans("EntrepriseQC");
	print_barre_liste($title, $page, $_SERVER["PHP_SELF"], '', $sortfield, $sortorder, "", $num, "", 'title_project.png');
	dol_fiche_head('');
   	$moreparam = 'id='.$id;

	print '<form method="get" action="'.$_SERVER["PHP_SELF"].'">';
	print '<table class="noborder" width="100%;">';
	print "<tr class=\"liste_titre\">";
	print_liste_field_titre($langs->trans("RefAO"),$_SERVER["PHP_SELF"], "num", '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("CreatedBy"),$_SERVER["PHP_SELF"],"fk_created_by", '', $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("Type"), $_SERVER["PHP_SELF"], 'type', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("Subject"),$_SERVER["PHP_SELF"], 'subject', '', $moreparam, 'align="center"', $sortfield, $sortorder);
	print_liste_field_titre($langs->trans("DileveredDate"), $_SERVER["PHP_SELF"],"dilvered","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre($langs->trans("ExpiredDate"),$_SERVER["PHP_SELF"],"expired","", $moreparam,'align="center"',$sortfield,$sortorder);
	print_liste_field_titre('',$_SERVER["PHP_SELF"],"",'','','',$sortfield,$sortorder,'maxwidthsearch ');
	print "</tr>\n";

	// FILTRES
	print '<tr class="liste_titre">';
	print '<td class="liste_titre" align="left" width="50">';
	print '<input class="flat" size="14" type="text" name="search_num" value="'.dol_escape_htmltag($search_num).'">';
	print '</td>';

	// UTILISATEUR
    print '<td class="liste_titre" align="left">';
    print $form->select_dolusers($search_created_by,"search_created_by",1,"",0,'','',0,32);
    print '</td>';

	// Type
	print '<td class="liste_titre" colspan="1" align="center">';
    print $form->selectarray('search_type', $qualifications-> getTypes(), $search_type, 1, 0, 0, '');
	print '</td>';

	// Budget
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat" type="text" size="50" name="search_subject" value="'.$search_subject.'"></td>';
	// Start Date
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat datepicker" type="text" size="14" name="search_dilevered" value="'.$search_dilevered.'"></td>';
	// End Date
	print '<td class="liste_titre" colspan="1" align="center"><input class="flat datepicker" type="text" size="14" name="search_expired" value="'.$search_expired.'"></td>';

	// ACTION
	print '<td align="right">';
	print '<input type="image" class="liste_titre" name="button_search" src="'.img_picto($langs->trans("Search"),'search.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("Search")).'" title="'.dol_escape_htmltag($langs->trans("Search")).'">';
	print '<input type="image" class="liste_titre" name="button_removefilter" src="'.img_picto($langs->trans("Search"),'searchclear.png','','',1).'" value="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'" title="'.dol_escape_htmltag($langs->trans("RemoveFilter")).'">';
	print '</td>';

	print "</tr>\n";

	// Lines
	if (count($qualifications->lines)) {
		$createdBy = new User($db);

		foreach($qualifications->lines as $line) {
			$var = !$var;
			$createdBy->fetch($db->escape($line->fk_created_by));
			$num 				= $line->num;
			$delivered 			= null !== $line->delivered ? dol_print_date($line->delivered,'day') : '';
			$expired 			= null !== $line->expired ? dol_print_date($line->expired,'day') : '';
			$subject 	 = '';
			$fullSubject = '';
			if (null !== $line->subject) {
				$fullSubject = str_replace(array("\r\n", "\n"), "", nl2br(strip_tags($line->subject)));
				$subject = substr($line->subject, 0, 100);
				$subject = strlen($line->subject) > 100 ? $subject.'...' : $subject;
			}

			print '<tr '.$bc[$var].'>';
			print '<td align="left" width="170px">';
			print $qualifications->getNomUrl(1,  $line->id, $num);
			print '</td>';
			print '<td align="center">'.$createdBy->getNomUrl('1').'</td>';
			print '<td align="center">'. $qualifications->getTypeById($line->type) .'</td>';
			print '<td align="center"><span class="classfortooltip" title="'. $fullSubject .'">'. $subject .'</span></td>';
			print '<td align="center">'. $delivered .'</td>';
			print '<td align="center">'. $expired .'</td>';
			print '<td></td>';
			print '</tr>'."\n";
		}
	}

	print '</table>';
	print '</form>';

	if ($user->id && $user->rights->marches->write) {
		print '<br>';
		print '<div style="float: right; margin-top: 8px;">';
		print '<a href="./card.php?action=add" class="butAction">'.$langs->trans('AddQC').'</a>';
		print '</div>';
	}
}

llxFooter();

$db->close();

?>