<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2012 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup   linecolorbystatus     Module linecolorbystatus
 *  \brief      Example of a module descriptor.
 *				Such a file must be copied into htdocs/linecolorbystatus/core/modules directory.
 *  \file       htdocs/linecolorbystatus/core/modules/modlinecolorbystatus.class.php
 *  \ingroup    linecolorbystatus
 *  \brief      Description and activation file for module linecolorbystatus
 */
include_once DOL_DOCUMENT_ROOT .'/core/modules/DolibarrModules.class.php';


/**
 *  Description and activation class for module linecolorbystatus
 */
class modlinecolorbystatus extends DolibarrModules
{
	/**
	 *   Constructor. Define names, constants, directories, boxes, permissions
	 *
	 *   @param      DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
        global $langs,$conf;

        $this->db = $db;

		// $this->editor_name = 'Editor';
		// $this->editor_url = 'https://www.site.ma';
		
		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 677740060;
		// Key text used to identify module (for permissions, menus, etc...)
		$this->rights_class = 'linecolorbystatus';

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "Next";
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i','',get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = "ModuleDesc677740060";
		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = '7.0';
		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto='linecolorbystatus@linecolorbystatus';
		
		// Defined all module parts (triggers, login, substitutions, menus, css, etc...)
		// for default path (eg: /linecolorbystatus/core/xxxxx) (0=disable, 1=enable)
		// for specific path of parts (eg: /linecolorbystatus/core/modules/barcode)
		// for specific css file (eg: /linecolorbystatus/css/linecolorbystatus.css.php)
		//$this->module_parts = array(
		//                        	'triggers' => 0,                                 	// Set this to 1 if module has its own trigger directory (core/triggers)
		//							'login' => 0,                                    	// Set this to 1 if module has its own login method directory (core/login)
		//							'substitutions' => 0,                            	// Set this to 1 if module has its own substitution function file (core/substitutions)
		//							'menus' => 0,                                    	// Set this to 1 if module has its own menus handler directory (core/menus)
		//							'theme' => 0,                                    	// Set this to 1 if module has its own theme directory (theme)
		//                        	'tpl' => 0,                                      	// Set this to 1 if module overwrite template dir (core/tpl)
		//							'barcode' => 0,                                  	// Set this to 1 if module has its own barcode directory (core/modules/barcode)
		//							'models' => 0,                                   	// Set this to 1 if module has its own models directory (core/modules/xxx)
		//							'css' => array('/linecolorbystatus/css/linecolorbystatus.css.php'),	// Set this to relative path of css file if module has its own css file
	 	//							'js' => array('/linecolorbystatus/js/linecolorbystatus.js'),          // Set this to relative path of js file if module must load a js on all pages
		//							'hooks' => array('hookcontext1','hookcontext2')  	// Set here all hooks context managed by module
		//							'dir' => array('output' => 'othermodulename'),      // To force the default directories names
		//							'workflow' => array('WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2'=>array('enabled'=>'! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)', 'picto'=>'yourpicto@linecolorbystatus')) // Set here all workflow context managed by module
		//                        );
		$this->module_parts = array(
		    'hooks' => array('invoicelist','supplierinvoicelist','propallist','supplier_proposallist','orderlist','supplierorderlist','projectlist'),
		    // 'hooks' => array('all'),
		    'css' => array('/linecolorbystatus/css/linecolorbystatus.css.php','/linecolorbystatus/css/linecolorbystatus.css'),
		    'js' => array('/linecolorbystatus/js/linecolorbystatus.js','/linecolorbystatus/js/linecolorbystatus.js.php'),
		);

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/linecolorbystatus/temp");
		$this->dirs = array();

		// Config pages. Put here list of php page, stored into linecolorbystatus/admin directory, to use to setup module.
		$this->config_page_url = array();
		$this->config_page_url = array("proposals.php@linecolorbystatus");

		// Dependencies
		$this->hidden = false;			// A condition to hide module
		$this->depends = array();		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->conflictwith = array();	// List of modules id this module is in conflict with
		$this->phpmin = array(5,0);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,0);	// Minimum version of Dolibarr required by module
		$this->langfiles = array("linecolorbystatus@linecolorbystatus");

		// Constants
		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 'current' or 'allentities', deleteonunactive)
		// Example: $this->const=array(0=>array('MYMODULE_MYNEWCONST1','chaine','myvalue','This is a constant to add',1),
		//                             1=>array('MYMODULE_MYNEWCONST2','chaine','myvalue','This is another constant to add',0, 'current', 1)
		// );
		$this->const = array();

		// Array to add new pages in new tabs
		// Example: $this->tabs = array('objecttype:+tabname1:Title1:linecolorbystatus@linecolorbystatus:$user->rights->linecolorbystatus->read:/linecolorbystatus/mynewtab1.php?id=__ID__',  	// To add a new tab identified by code tabname1
        //                              'objecttype:+tabname2:Title2:linecolorbystatus@linecolorbystatus:$user->rights->othermodule->read:/linecolorbystatus/mynewtab2.php?id=__ID__',  	// To add another new tab identified by code tabname2
        //                              'objecttype:-tabname:NU:conditiontoremove');                                                     						// To remove an existing tab identified by code tabname
		// where objecttype can be
		// 'categories_x'	  to add a tab in category view (replace 'x' by type of category (0=product, 1=supplier, 2=customer, 3=member)
		// 'contact'          to add a tab in contact view
		// 'contract'         to add a tab in contract view
		// 'group'            to add a tab in group view
		// 'intervention'     to add a tab in intervention view
		// 'invoice'          to add a tab in customer invoice view
		// 'invoice_supplier' to add a tab in supplier invoice view
		// 'member'           to add a tab in fundation member view
		// 'opensurveypoll'	  to add a tab in opensurvey poll view
		// 'order'            to add a tab in customer order view
		// 'order_supplier'   to add a tab in supplier order view
		// 'payment'		  to add a tab in payment view
		// 'payment_supplier' to add a tab in supplier payment view
		// 'product'          to add a tab in product view
		// 'propal'           to add a tab in propal view
		// 'project'          to add a tab in project view
		// 'stock'            to add a tab in stock view
		// 'thirdparty'       to add a tab in third party view
		// 'user'             to add a tab in user view
        $this->tabs = array();

        // Dictionaries
	    if (! isset($conf->linecolorbystatus->enabled))
        {
        	$conf->linecolorbystatus=new stdClass();
        	$conf->linecolorbystatus->enabled=0;
        }
		$this->dictionaries=array();
        /* Example:
        if (! isset($conf->linecolorbystatus->enabled)) $conf->linecolorbystatus->enabled=0;	// This is to avoid warnings
        $this->dictionaries=array(
            'langs'=>'linecolorbystatus@linecolorbystatus',
            'tabname'=>array(MAIN_DB_PREFIX."table1",MAIN_DB_PREFIX."table2",MAIN_DB_PREFIX."table3"),		// List of tables we want to see into dictonnary editor
            'tablib'=>array("Table1","Table2","Table3"),													// Label of tables
            'tabsql'=>array('SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table1 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table2 as f','SELECT f.rowid as rowid, f.code, f.label, f.active FROM '.MAIN_DB_PREFIX.'table3 as f'),	// Request to select fields
            'tabsqlsort'=>array("label ASC","label ASC","label ASC"),																					// Sort order
            'tabfield'=>array("code,label","code,label","code,label"),																					// List of fields (result of select to show dictionary)
            'tabfieldvalue'=>array("code,label","code,label","code,label"),																				// List of fields (list of fields to edit a record)
            'tabfieldinsert'=>array("code,label","code,label","code,label"),																			// List of fields (list of fields for insert)
            'tabrowid'=>array("rowid","rowid","rowid"),																									// Name of columns with primary key (try to always name it 'rowid')
            'tabcond'=>array($conf->linecolorbystatus->enabled,$conf->linecolorbystatus->enabled,$conf->linecolorbystatus->enabled)												// Condition to show each dictionary
        );
        */

        // Boxes
		// Add here list of php file(s) stored in core/boxes that contains class to show a box.
        $this->boxes = array();			// List of boxes
		// Example:
		//$this->boxes=array(array(0=>array('file'=>'myboxa.php','note'=>'','enabledbydefaulton'=>'Home'),1=>array('file'=>'myboxb.php','note'=>''),2=>array('file'=>'myboxc.php','note'=>'')););

		// Permissions
		$this->rights = array();		// Permission array used by this module
		$r=0;

		// Add here list of permission defined by an id, a label, a boolean and two constant strings.

		$this->rights[$r][0] = $this->numero + $r;	// Permission id (must not be already used)
		$this->rights[$r][1] = 'consulter';	// Permission label
		$this->rights[$r][3] = 1; 					// Permission by default for new user (0/1)
		$this->rights[$r][4] = 'gestion';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$this->rights[$r][5] = 'consulter';				// In php code, permission will be checked by test if ($user->rights->permkey->level1->level2)
		$r++;

		// Main menu entries
		// $this->menu = array();			// List of menus to add
		// $r=0;

		// Add here entries to declare new menus

		// Top Menu
		// $this->menu[$r]=array();
			$r++;
		// Exports
		$r=1;
	}



	/**
	 *		Function called when module is enabled.
	 *		The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *		It also creates data directories
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function init($options='')
	{
		
		$sqlm = array();

		$file = DOL_DOCUMENT_ROOT.'/comm/propal/list.php';
		@chmod($file, octdec(775));
		$config1 = file_get_contents($file);
		$strpropal = '<tr class="oddeven STATUSPROPAL_\'.$obj->fk_statut.\'">';
		if(!$obj->fk_statut){
			$strpropal = '<tr class="oddeven STATUSPROPAL_\'.$obj->status.\'">';
		}
		$config1 = str_replace('<tr class="oddeven">', $strpropal,$config1);
		file_put_contents($file, $config1);
		@chmod(DOL_DOCUMENT_ROOT.'/comm/propal/list.php', octdec(664));


		$file = DOL_DOCUMENT_ROOT.'/supplier_proposal/list.php';
		@chmod($file, octdec(775));
		$config3 = file_get_contents($file);
		$strpropal = '<tr class="oddeven STATUSPROPALFOURN_\'.$obj->fk_statut.\'">';
		if(!$obj->fk_statut){
			$strpropal = '<tr class="oddeven STATUSPROPALFOURN_\'.$obj->status.\'">';
		}
		$config3 = str_replace('<tr class="oddeven">', $strpropal,$config3);
		file_put_contents($file, $config3);
		@chmod(DOL_DOCUMENT_ROOT.'/supplier_proposal/list.php', octdec(664));



		$file = DOL_DOCUMENT_ROOT.'/commande/list.php';
		@chmod($file, octdec(775));
		$config2 = file_get_contents($file);
		$config2 = str_replace('<tr class="oddeven">', '<tr class="oddeven STATUSCOMMANDECLIENT_\'.$obj->fk_statut.\'">',$config2);
		file_put_contents($file, $config2);
		@chmod(DOL_DOCUMENT_ROOT.'/commande/list.php', octdec(664));


		$file = DOL_DOCUMENT_ROOT.'/fourn/commande/list.php';
		@chmod($file, octdec(775));
		$config3 = file_get_contents($file);
		$config3 = str_replace('<tr class="oddeven">', '<tr class="oddeven STATUSCOMMANDEFOURNISSEUR_\'.$obj->fk_statut.\'">',$config3);
		file_put_contents($file, $config3);
		@chmod(DOL_DOCUMENT_ROOT.'/fourn/commande/list.php', octdec(664));


		$file = DOL_DOCUMENT_ROOT.'/compta/facture/list.php';
		@chmod($file, octdec(775));
		$config4 = file_get_contents($file);
		$config4 = str_replace('<tr class="oddeven"', '<tr class="oddeven STATUSFACTURECLIENT_\'.$obj->fk_statut.\'"',$config4);
		file_put_contents($file, $config4);
		@chmod(DOL_DOCUMENT_ROOT.'/compta/facture/list.php', octdec(664));


		$file = DOL_DOCUMENT_ROOT.'/fourn/facture/list.php';
		@chmod($file, octdec(775));
		$config5 = file_get_contents($file);
		$config5 = str_replace('<tr class="oddeven">', '<tr class="oddeven STATUSFACTUREFOURNISSEUR_\'.$obj->fk_statut.\'">',$config5);
		file_put_contents($file, $config5);
		@chmod(DOL_DOCUMENT_ROOT.'/fourn/facture/list.php', octdec(664));


		$file = DOL_DOCUMENT_ROOT.'/projet/list.php';
		@chmod($file, octdec(775));
		$config6 = file_get_contents($file);
		// $config6 = str_replace('<tr class="oddeven">', '<tr class="oddeven STATUSPROJECT_\'.$obj->fk_statut.\'">',$config6);
		$config6 = str_replace('<tr class="oddeven">', '<tr class="oddeven STATUSPROJECT_\'.$obj->fk_opp_status.\'">',$config6);
		// $config6 = str_replace('<tr class="oddeven STATUSPROJECT_\'.$obj->fk_statut.\'">', '<tr class="oddeven STATUSPROJECT_\'.$obj->fk_opp_status.\'">',$config6);
		file_put_contents($file, $config6);
		@chmod(DOL_DOCUMENT_ROOT.'/projet/list.php', octdec(664));



		if (!dolibarr_get_const($this->db,'STATUSPROJECTSTATUSOROPPSTATUS',0)) dolibarr_set_const($this->db,'STATUSPROJECTSTATUSOROPPSTATUS','STATUS','setcol',0,'',0);

		if (!dolibarr_get_const($this->db,'STATUSPROJECT_7',0)) dolibarr_set_const($this->db,'STATUSPROJECT_7','#ffcccc','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROJECT_6',0)) dolibarr_set_const($this->db,'STATUSPROJECT_6','#eaffea','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROJECT_4',0)) dolibarr_set_const($this->db,'STATUSPROJECT_4','#dfdfff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROJECT_3',0)) dolibarr_set_const($this->db,'STATUSPROJECT_3','#ffcb97','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROJECT_2',0)) dolibarr_set_const($this->db,'STATUSPROJECT_2','#eaf5ff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROJECT_1',0)) dolibarr_set_const($this->db,'STATUSPROJECT_1','#ffffd7','setcol',0,'',0);

		// if (!dolibarr_get_const($this->db,'STATUSPROJECT_0',0)) dolibarr_set_const($this->db,'STATUSPROJECT_0','#ffffff','setcol',0,'',0);

		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_9',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_9','#debcbc','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_6',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_6','#ffe1e1','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_5',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_5','#caffca','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_4',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_4','#eaffea','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_3',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_3','#dfdfff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_2',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_2','#eaf5ff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_1',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_1','#ffffd7','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDEFOURNISSEUR_0',0)) dolibarr_set_const($this->db,'STATUSCOMMANDEFOURNISSEUR_0','#ffffff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSFACTUREFOURNISSEUR_2',0)) dolibarr_set_const($this->db,'STATUSFACTUREFOURNISSEUR_2','#eaffea','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSFACTUREFOURNISSEUR_1',0)) dolibarr_set_const($this->db,'STATUSFACTUREFOURNISSEUR_1','#ffe1e1','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSFACTUREFOURNISSEUR_0',0)) dolibarr_set_const($this->db,'STATUSFACTUREFOURNISSEUR_0','#ffffff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSFACTURECLIENT_3',0)) dolibarr_set_const($this->db,'STATUSFACTURECLIENT_3','#ffffd7','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSFACTURECLIENT_2',0)) dolibarr_set_const($this->db,'STATUSFACTURECLIENT_2','#eaffea','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSFACTURECLIENT_1',0)) dolibarr_set_const($this->db,'STATUSFACTURECLIENT_1','#ffe1e1','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSFACTURECLIENT_0',0)) dolibarr_set_const($this->db,'STATUSFACTURECLIENT_0','#ffffff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDECLIENT_-1',0)) dolibarr_set_const($this->db,'STATUSCOMMANDECLIENT_-1','#ffe1e1','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDECLIENT_3',0)) dolibarr_set_const($this->db,'STATUSCOMMANDECLIENT_3','#eaffea','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDECLIENT_2',0)) dolibarr_set_const($this->db,'STATUSCOMMANDECLIENT_2','#eaf5ff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDECLIENT_1',0)) dolibarr_set_const($this->db,'STATUSCOMMANDECLIENT_1','#ffffd7','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSCOMMANDECLIENT_0',0)) dolibarr_set_const($this->db,'STATUSCOMMANDECLIENT_0','#ffffff','setcol',0,'',0);

		if (!dolibarr_get_const($this->db,'STATUSPROPAL_4',0)) dolibarr_set_const($this->db,'STATUSPROPAL_4','#eaffea','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPAL_3',0)) dolibarr_set_const($this->db,'STATUSPROPAL_3','#ffe1e1','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPAL_2',0)) dolibarr_set_const($this->db,'STATUSPROPAL_2','#eaf5ff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPAL_1',0)) dolibarr_set_const($this->db,'STATUSPROPAL_1','#ffffd7','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPAL_0',0)) dolibarr_set_const($this->db,'STATUSPROPAL_0','#ffffff','setcol',0,'',0);

		if (!dolibarr_get_const($this->db,'STATUSPROPALFOURN_4',0)) dolibarr_set_const($this->db,'STATUSPROPALFOURN_4','#eaffea','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPALFOURN_3',0)) dolibarr_set_const($this->db,'STATUSPROPALFOURN_3','#ffe1e1','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPALFOURN_2',0)) dolibarr_set_const($this->db,'STATUSPROPALFOURN_2','#eaf5ff','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPALFOURN_1',0)) dolibarr_set_const($this->db,'STATUSPROPALFOURN_1','#ffffd7','setcol',0,'',0);
		if (!dolibarr_get_const($this->db,'STATUSPROPALFOURN_0',0)) dolibarr_set_const($this->db,'STATUSPROPALFOURN_0','#ffffff','setcol',0,'',0);

		// $result=$this->_load_tables('/linecolorbystatus/sql/');
		return $this->_init($sqlm, $options);
	}

	/**
	 *		Function called when module is disabled.
	 *      Remove from database constants, boxes and permissions from Dolibarr database.
	 *		Data directories are not deleted
	 *
     *      @param      string	$options    Options when enabling module ('', 'noboxes')
	 *      @return     int             	1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();

		return $this->_remove($sql, $options);
	}

}
