<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2015 ATM Consulting <support@atm-consulting.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		admin/linecolorbystatus.php
 * 	\ingroup	linecolorbystatus
 * 	\brief		This file is an example module setup page
 * 				Put some comments here
 */
// Dolibarr environment
$res = @include("../../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../../main.inc.php"); // From "custom" directory
}

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.commande.class.php';
require_once '../lib/linecolorbystatus.lib.php';

// Translations
$langs->load("linecolorbystatus@linecolorbystatus");
$langs->loadLangs(array('orders'));
$langs->load("admin");

// Access control
if (! $user->admin) {
    accessforbidden();
}

if (empty($conf->linecolorbystatus->enabled)) accessforbidden();

// Parameters
$action = GETPOST('action', 'alpha');


// $liststatus=array('0'=>$langs->trans("BillShortStatusDraft"), '1'=>$langs->trans("BillShortStatusNotPaid"), '2'=>$langs->trans("BillShortStatusPaid"), '3'=>$langs->trans("BillShortStatusCanceled"));


$statustohow = array(
    '0' => '0',
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6,7',
    '9' => '9'
);

$tmpsupplierorder = new CommandeFournisseur($db);
$liststatus = array();
foreach ($statustohow as $key => $value) {
    $tmpsupplierorder->statut = $key;
    $liststatus[$key] = $tmpsupplierorder->getLibStatut(1);
}



if ($action == 'set_colors') {
	$statuscolrs = GETPOST('statuscolrs', 'alpha');
	if($statuscolrs){
		foreach ($statuscolrs as $key => $statut) {
			$name = $statut['name'];
			$name = str_replace(",", "-", $name);
			
			$value = $statut['value'];
			if ($value) {
				$res = dolibarr_set_const($db, $name, $value, 'setcol', 0, '', 0);
				if (! $res > 0)	$error ++;
			}

		}
	}
	
	if (! $error) {
		setEventMessage($langs->trans("SetupSaved"), 'mesgs');
	} else {
		setEventMessage($langs->trans("Error"), 'errors');
	}
}


/*
 * View
 */
$page_name = "linecolorbystatusSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
    . $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
$head = linecolorbystatusAdminPrepareHead();
dol_fiche_head(
    $head,
    'SuppliersOrders',
    $langs->trans("linecolorbystatus"),
    0,
    "linecolorbystatus@linecolorbystatus"
);

// Setup page goes here
$form=new Form($db);
$var=false;


// print_r($status);
print '<form id="col4-form" method="post" action="commandes_fournisseurs.php">';
print '<input type="hidden" name="action" value="set_colors">';
print '<table class="noborder" width="100%">';
if($liststatus){
	$i = 0;
	foreach ($liststatus as $key => $label) {
		$name = "STATUSCOMMANDEFOURNISSEUR_".$key;
		$valusstat = $conf->global->$name;
		if(empty($valusstat))
			$valusstat = "#FFFFFF";
		print '<tr>';
			print '<td style="width:200px;">';
				print addslashes(trim($label));
			print '</td>';
			print '<td style="">';
				print '<input type="hidden" name="statuscolrs['.$i.'][name]" value="STATUSCOMMANDEFOURNISSEUR_'.$key.'">';
				// print '<input type="color" name="statuscolrs['.$i.'][value]" value="'.$valusstat.'" style="margin:0;">';
				print '<input type="color" class="inputcolor" name="statuscolrs['.$i.'][value]" value="'.$valusstat.'" style="margin:0;">';
				print '<input type="text" class="linecolorinputhexacolor" size="7" value="'.$valusstat.'">';
			print '</td>';
			// print '<td>';
			// print '<input type="submit" class="button" value="Valider">';
			// print '</td>';
		print '</tr>';
		$i++;
	}
}
print '</table>';
print '<br><div style="text-align:left;"><input type="submit" class="butAction" value="'.$langs->trans("Validate").'"></div>';
print '</form>';



llxFooter();

$db->close();


