<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2017  Libre Expert
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    verify.php
 * \ingroup lemodule
 * \brief   Module PHP page.
 *
 * Put detailed description here.
 */

//if (! defined('NOREQUIREUSER'))	define('NOREQUIREUSER','1');
//if (! defined('NOREQUIREDB'))		define('NOREQUIREDB','1');
//if (! defined('NOREQUIRESOC'))	define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))	define('NOREQUIRETRAN','1');
// Do not check anti CSRF attack test
//if (! defined('NOCSRFCHECK'))		define('NOCSRFCHECK','1');
// Do not check style html tag into posted data
//if (! defined('NOSTYLECHECK'))   define('NOSTYLECHECK','1');
// Do not check anti POST attack test
//if (! defined('NOTOKENRENEWAL'))	define('NOTOKENRENEWAL','1');
// If there is no need to load and show top and left menu
//if (! defined('NOREQUIREMENU'))	define('NOREQUIREMENU','1');
// If we don't need to load the html.form.class.php
//if (! defined('NOREQUIREHTML'))	define('NOREQUIREHTML','1');
//if (! defined('NOREQUIREAJAX'))	define('NOREQUIREAJAX','1');
// If this page is public (can be called outside logged session)
//if (! defined("NOLOGIN"))			define("NOLOGIN",'1');
// Change the following lines to use the correct relative path
// (../, ../../, etc)

// Load Dolibarr environment
if (false === (@include '../main.inc.php')) {  // From htdocs directory
	require '../../main.inc.php'; // From "custom" directory
}



global $db, $langs, $user;

dol_include_once('/lemodule/class/leclass.class.php');
dol_include_once('/lemodule/functions.php');


// Load translation files required by the page
$langs->load("lemodule@lemodule");

// Get parameters
$check = GETPOST('check', 'alpha');
$initialize = GETPOST('initialize', 'alpha');

// Access control
if ($user->socid > 0) {
	// External user
	accessforbidden();
}



/*
 * VIEW
 *
 * Put here all code to build page
 */
$title=$langs->trans('VerifyPageName');
llxHeader('', $title, '');
print load_fiche_titre($title,'','lemodule.png@lemodule');

print $langs->trans("VerifyPageDescription").'<br><br>';

$form = new Form($db);

$checkfile = 'checklist';


if ($initialize == 'true') {
    print "<br>";
    print  "<b>" . $langs->trans("InitializationStarted") . '</b>';

    // Build the checklist file recursively from DOCUMENT_ROOT and avoid the tmp folder of the module
    buildChecklistFile(DOL_DOCUMENT_ROOT, __DIR__ . '/tmp', __DIR__ . '/', $checkfile);

    print "<br><br>";
    print  "<b>" . $langs->trans("InitializationFinished") . '</b>';
    print "<br><br>";
    print "<p><input class=\"button\" name=\"button\" value=\"". $langs->trans("ReloadPage") . 
          "\" onclick=\"window.location.href='" . $_SERVER["PHP_SELF"]. "';\"></p>";    
    
}

// If the CheckNow button has been pressed
if ($check == 'true') {
    $dir = DOL_DOCUMENT_ROOT;
    $file = "checklist";
    if (unzip($file,getcwd(), $dir) == -1) {
        print 'no checklist file in ' . DOL_DOCUMENT_ROOT;
    }
    $md5ChkFile = $dir . '/' . $file . '.chk';
    $results = md5FileLoad($md5ChkFile);
    unlink($md5ChkFile);

    $errors = 0;
    //print_r($results);
    
    // Build the right path
    $root = DOL_DOCUMENT_ROOT;
    if (substr($root, -1) == "/") {
      $root = substr($root, 0, -1);
    }

    foreach($results as $line) {
        $md5sum = $line[0];
        // keep only string without EOL character
        $filename = $root . preg_replace('/([\r\n\t])/','', $line[1]);
	//print $filename;

        if (file_exists($filename)) {

            $md5result = md5_file($filename);
            //print $md5result . '*' . $md5sum . ' : '. $filename . '<br>';
            if ( $md5result != $md5sum) {
                $errors++;
                print  "<font color=\"red\">" . $langs->trans("TheFile") . " </font>" . $filename . 
                       "<font color=\"red\"> " . $langs->trans("HasBeenModified") . ".</font><br>";
            } 
        }


    }
    $color = "green";
    if ($errors > 0) $color ="red";

    print "<br><br>";
    print  "<b>" . $langs->trans("TheFilesCheckShows") . "<font color=\"$color\"> " .$errors . " </font>" . $langs->trans("ModifiedFiles") . ".</b><br><br>";
}

if ( ! file_exists(__DIR__ . '/'. $checkfile)) {
    print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
    print "<input type=\"hidden\" name=\"initialize\" value=\"true\">";
    print "<p><input class=\"button\" type=\"submit\" name=\"button\" value=\"".$langs->trans("Initialize")."\"></p>";
} else {
    if ($initialize != 'true') {
        print '<form method="POST" action="'.$_SERVER["PHP_SELF"].'">';
        print "<input type=\"hidden\" name=\"check\" value=\"true\">";
        print "<p><input class=\"button\" type=\"submit\" name=\"button\" value=\"".$langs->trans("CheckNow")."\"></p>";
        print $langs->trans("InitializationWasDoneOn") . " : " . date ("F d Y H:i:s.", filemtime(__DIR__ . '/'. $checkfile));
    }
}
// End of page
llxFooter();
