<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2017  Libre Expert
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    databasemanager.php
 * \ingroup lemodule
 * \brief   Module PHP page.
 *
 * Put detailed description here.
 */

//if (! defined('NOREQUIREUSER'))	define('NOREQUIREUSER','1');
//if (! defined('NOREQUIREDB'))		define('NOREQUIREDB','1');
//if (! defined('NOREQUIRESOC'))	define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))	define('NOREQUIRETRAN','1');
// Do not check anti CSRF attack test
//if (! defined('NOCSRFCHECK'))		define('NOCSRFCHECK','1');
// Do not check style html tag into posted data
//if (! defined('NOSTYLECHECK'))   define('NOSTYLECHECK','1');
// Do not check anti POST attack test
//if (! defined('NOTOKENRENEWAL'))	define('NOTOKENRENEWAL','1');
// If there is no need to load and show top and left menu
//if (! defined('NOREQUIREMENU'))	define('NOREQUIREMENU','1');
// If we don't need to load the html.form.class.php
//if (! defined('NOREQUIREHTML'))	define('NOREQUIREHTML','1');
//if (! defined('NOREQUIREAJAX'))	define('NOREQUIREAJAX','1');
// If this page is public (can be called outside logged session)
//if (! defined("NOLOGIN"))			define("NOLOGIN",'1');
// Change the following lines to use the correct relative path
// (../, ../../, etc)

// Load Dolibarr environment
if (false === (@include '../main.inc.php')) {  // From htdocs directory
	require '../../main.inc.php'; // From "custom" directory
}



global $db, $langs, $user;


dol_include_once('/lemodule/class/leclass.class.php');
dol_include_once('/lemodule/functions.php');


// Load translation files required by the page
$langs->load("lemodule@lemodule");


// Access control
if ($user->socid > 0) {
	// External user
	accessforbidden();
}


$title=$langs->trans('DatabaseManagerPageName');
//llxHeader('', $title, '', '', 0, 0, '', '', '', '');

/*Ouvre le fichier et retourne un tableau contenant une ligne par élément*/

global $dbHost; 
$dbHost = $conf->db->host;
global $dbName; 
$dbName= $conf->db->name;
global $dbLogin;
global $dbPassword;
global $dbPort;
$dbPort = "";

$lines = file(DOL_DOCUMENT_ROOT . '/conf/conf.php');
/*On parcourt le tableau $lines et on affiche le contenu de chaque ligne précédée de son numéro*/
foreach ($lines as $lineContent)
{
	$parameters = explode("=", $lineContent);
	//print $parameters[0];
	if ($parameters[0] == '$dolibarr_main_db_pass') {
		//print $parameters[0] . '=' . $parameters[1];
		//$dbPassword = str_replace("'", "", $parameters[1]);
		//$dbPassword = str_replace(";", "", $dbPassword);
		//$dbPassword = str_replace(" ", "", $dbPassword);
		$dbPassword = str_replace(array("'", ';', ' ', "\n", "\t", "\r"), '', $parameters[1]);
		
	}
	
	if ($parameters[0] == '$dolibarr_main_db_user') {
		//print $parameters[0] . '=' . $parameters[1];
// 		$dbLogin = str_replace("'", "", $parameters[1]);
// 		$dbLogin = str_replace(";", "", $dbLogin);
// 		$dbLogin = str_replace(" ", "", $dbLogin);
		$dbLogin = str_replace(array("'", ';', ' ', "\n", "\t", "\r"), '', $parameters[1]);
	}
	
	if ($parameters[0] == '$dolibarr_main_db_port') {
		//print $parameters[0] . '=' . $parameters[1];
		if (isset($parameters[1])) {
// 			$dbPort = str_replace("'", "", $parameters[1]);
// 			$dbPort = str_replace(";", "", $dbPort);
// 			$dbPort = str_replace(" ", "", $dbPort);
			$dbPort = str_replace(array("'", ';', ' ', "\n", "\t", "\r"), '', $parameters[1]);
		}
	
	}
}

//print "Le mot de passe est : " . $dbPassword;
//print "serveur : " . $conf->db->host;

$_GET["db"] = $dbName;
$_GET["username"] = $dbLogin;
if ($dbPort != "") { $dbHost .= ':' . $dbPort; }
$_GET["host"] = $dbHost;
$_GET["dbpassword"] = $dbPassword;

dol_syslog("serveur : " . $dbHost . " bdd : " . $dbName . " login : " . $dbLogin . " password : " . $dbPassword, $level = LOG_INFO);

// function adminer_object() {
//   
//   class AdminerSoftware extends Adminer {    
//    
//     
//     function credentials() {
//       server, username and password for connecting to database
//       dol_syslog("serveur : " . $dbHost . " login : " . $dbLogin . " password : " . $dbPassword, $level = LOG_INFO);
//       return array($dbHost, $dbLogin, $dbPassword);
//     }
//     
//     function database() {
//       database name, will be escaped by Adminer
//       return $dbName;
//     }
//     
//     function name() {
//       
//       return $dbName;
//     }
//     
//     function login($login, $password) {
//       validate user submitted credentials
//       return ($login == $dbLogin && $password == $dbPassword);
//     }
//     
//   }
//   
//   class AdminerLoginPasswordLess {
// 	/** @access protected */
// 	var $password_hash;
// 	
// 	/** Set allowed password
// 	* @param string result of password_hash
// 	*/
// 	function __construct($password_hash) {
// 		$this->password_hash = $password_hash;
// 	}
// 
// 	function credentials() {
// 		$password = get_password();
// 		return array($dbHost, $dbLogin, (password_verify($password, $this->password_hash) ? "" : $password));
// 	}
// 	
// 	function login($login, $password) {
// 		if ($password != "") {
// 			return true;
// 		}
// 	}
// 
// }
//  
//   new AdminerLoginPasswordLess($dbPassword); 
//  
//   return new AdminerSoftware;
// }

include './adminer-mysql.php';


// End of page
llxFooter();
