
#__Extra Admin Tools v1.2 --- Module for Dolibarr by Libre Expert__
----------------------------------------------


## English

This module was created by the **Libre Expert** company (www.libre-expert.com) to provide complementary administration tools for Dolibarr.

To contact us (in English or French) please go to our contact page https://www.libre-expert.com/en/contact-us

> Notice : The backup functionalities require the use of a Unix system like Linux.

> Warning: Must be present on the server for backups the commands: bash, tar and mysqldump

### Use :

To install the module, extract the provided Zip archive preferably in the **"htdocs/custom/"** directory of your Dolibarr installation, 
change files permissions if necessary so your webserver can access the new folder.
Your file **"htdocs/conf/conf.php"** must be set to include the alternate directory, by adjusting the parameters below (to be modified according to your characteristics):

####`$dolibarr_main_url_root_alt='/custom';`

####`$dolibarr_main_document_root_alt='/var/www/dolibarr/htdocs/custom';`

Once activated from the administrator menu **Configuration/Modules** in the **"Other"** rubric, this module will include 4 features, accessible
from the left menu on the Dolibarr home page for users with the role of administrator :

- Verifying the integrity of Dolibarr files
- An easy installer of modules for Dolibarr
- A file manager
- A backup configurator
- A database manager

####**1) The Integrity Checker**
This feature must be initialized the first time you go to its page, this step generates a reference file containing
a file checking database by md5sum. When you then go back to the same menu, 
it is proposed to perform a file integrity check, recursively from the **"htdocs"** directory of your Dolibarr installation.
To reset the md5sum database, you must manually delete the **"checklist"** file, which is a Zip archive located at the base of this module folder,
You will then be prompted to reset the md5sum database during the next visit on the feature page.

> Note: Using this feature on a slow system will cause a page refresh time

####**2) The easy modules installer**
This feature initially allows you to load and simulate the extraction of a module Zip archive for Dolibarr, in order to verify that it will deploy correctly.
There are three placement possibilities, you have to adjust according to the folders tree contained in the Zip archive. 
The recommended method is to place your new modules in the **"/htdocs/custom"** folder.
Then the verification made, a button allows you to confirm the actual extraction, it will only remain to activate the module thus copied, in the menu **Configuration/Modules**.

####**3) The file manager**
It allows you to act on the tree structure of your hosted files: copy, move, delete, archive, edit, rename, view, search.
Use the left click to select, and right click to see the possible actions.

####**4) Backup Configurator**
This function works in conjunction with the **CRON** or equivalent application, it must be set to run every hour 
the **"simplebashbu.sh"** script located in the module's **"scripts/"** directory. This script reads before execution a configuration file named **"backupconfig.conf"**
generated by the parameter page when you press the **"Save configuration and test database access"** button, this file is placed in the same **"scripts/"** directory  of the module.

Example of CRON programming to run the script every hour :

####`0 * * * * /var/www/dolibarr/htdocs/custom/lemodule/scripts/simplebashbu.sh`

>Important: You must set up this programming by yourself on your server, as this requires the user "root", and the file "simplebashbu.sh" must be set executable.

The action of this script consists of a full backup of Dolibarr files once a week, at the desired day and time, 
and then performs an incremental backup the other days of the week. The database is backed up every day at the same time as the files.
It results Gzip files placed in the directory that you specified in the configuration of this functionality, within the following tree folders :

* **ARCHIVED-BACKUPS** for full backups, every week are added 2 new Gzip files the database and the Dolibarr files
* **DAILY** for daily backups
* **LOGS** for backup reports

An email can be specified to send a report to the administrator for each backup performed, PHP Mail must be configured on your server.

####**5) The database manager**
It will allow you to manipulate the Dolibarr database, insert / modify / delete data, create / modify / delete tables, export / import data, pass SQL commands, etc ...

#### If you have any questions or suggestions, you can contact us using our form:
#### https://www.libre-expert.com/en/contact-us

####**Enjoy !**



## Français 

Ce module a été créé par l'entreprise **Libre Expert** (www.libre-expert.com) pour fournir des outils d'administration complémentaires à Dolibarr.

Pour nous contacter (en anglais ou en français), veuillez consulter notre page de contact https://www.libre-expert.com/contacts

> Remarque : Les fonctionnalités de sauvegardes nécessitent l'utilisation d'un système Unix comme Linux.

> Attention : Doivent être présentes sur le serveur pour les sauvegardes, les commandes : bash, tar et mysqldump

### Utilisation :

Pour mettre en place le module, extraire l'archive Zip fournie de préférence dans le répertoire **"htdocs/custom/"** de votre installation Dolibarr, 
Modifier les droits des fichiers si nécessaire pour permettre à votre serveur web d'accéder au nouveau dossier.
Votre fichier **"htdocs/conf/conf.php"** doit être paramétré afin d'inclure le répertoire alternatif, en ajustant les paramètres ci-dessous (à modifier selon vos caractéristiques) :

####`$dolibarr_main_url_root_alt='/custom';`

####`$dolibarr_main_document_root_alt='/var/www/dolibarr/htdocs/custom';`

Une fois activé depuis le menu administrateur **Configuration/Modules** dans la rubrique **"Autre"**, ce module comprendra 4 fonctionnalités, accessibles 
depuis le menu de gauche de la page d'accueil de Dolibarr pour les utilisateurs ayant le rôle d'administrateur :

- La vérification de l'intégrité des fichiers de Dolibarr
- Un installateur facile de modules pour Dolibarr
- Un gestionnaire de fichiers
- Un configurateur de sauvegardes
- Un gestionnaire de base de données


####**1) Le vérificateur d'intégrité**
Cette fonctionnalité doit être initialisée la première fois que l'on se rend sur sa page, cette étape génère un fichier de référence contenant 
une base de vérification des fichiers par md5sum. Lorsque l'on se rend ensuite sur le même menu, 
il est proposé de faire une vérification d'intégrité des fichiers, récursivement depuis le répertoire **"htdocs"** de votre installation de Dolibarr.
Pour réinitialiser la base des md5sum, il faut supprimer manuellement le fichier **"checklist"** qui est une archive Zip placée à la base du dossier de ce module, 
vous serez ensuite invité à réinitialiser la base md5sum à la prochaine visite sur la page de cette fonctionnalité.

> Remarque : L'usage de cette fonctionnalité sur un système lent, engendrera un temps d'attente du rafraichissement de la page

####**2) L'installateur facile de modules**
Cette fonctionnalité permet dans un premier temps de charger et simuler l'extraction d'une archive Zip de module pour Dolibarr, afin de vérifier que celle-ci se déploiera correctement. 
Il y a trois possibilités de placement, à vous de voir en fonction de l'arborescence contenue dans l'archive Zip, 
la méthode recommandée est de placer ses nouveaux modules dans le dossier **"/htdocs/custom"**.
Puis la vérification faite, un boutton permet confirmer l'extraction réelle, il ne restera plus qu'à activer le module ainsi copié, dans le menu **Configuration/Modules**.

####**3) Le gestionnaire de fichiers**
Il vous permettra d'agir sur l'arborescence de vos fichiers hébergés : copie, déplacement, suppression, archivage, édition, renommage, visualisation, recherche.
Utilisation du clic gauche pour sélectionner, et du clic droit pour voir apparaître les actions possibles.

####**4) Le configurateur de sauvegardes**
Cette fonctionnalité travaille de pair avec l'application **CRON** ou équivalente, il faut la paramétrer pour lui demander d'exécuter toutes les heures 
le script **"simplebashbu.sh"** situé dans le répertoire "scripts/" du module. Ce script lit avant exécution un fichier de configuration nommé **"backupconfig.conf"** 
généré par la page de paramétrages au moment de l'appui sur le bouton **"Enregistrer la configuration et tester l'accès à la base"**, 
ce fichier est placé dans le même répertoire **"scripts/"** du module.

Exemple de programmation de CRON pour exécuter le script toutes les heures :

####`0 * * * * /var/www/dolibarr/htdocs/custom/lemodule/scripts/simplebashbu.sh`

>Important : Vous devez mettre en place cette programmation par vous-même sur votre serveur, car cela nécessite l'utilisateur "root", et le fichier "simplebashbu.sh" doit être rendu exécutable.

L'action de ce script consiste en une sauvegarde intégrale des fichiers de Dolibarr une fois par semaine, au jour et à l'heure voulue, 
puis s'effectue une sauvegarde incrémentale les autres jours de la semaine. La base de données, elle, est sauvegardée intégralement chaque jour, à la même heure que les fichiers.
Il résulte des fichiers Gzip placés dans le répertoire que vous aurez précisé dans la configuration de cette fonctionnalité, avec l'arborescence suivante :

* **ARCHIVED-BACKUPS** pour les sauvegardes intégrales, chaque semaine sont ajoutés de 2 nouveaux fichiers Gzip, la base de données et les fichiers de Dolibarr
* **DAILY** pour les sauvegardes quotidiennes
* **LOGS** pour les rapports de sauvegardes

Un email peut être précisé pour envoyer un rapport à l'administrateur à chaque sauvegarde effectuée, il suffit que PHP Mail soit bien configuré sur votre serveur.

####**5) Le gestionnaire de base de données**
Il vous permettra de manipuler la base de données de Dolibarr, d'insérer / modifier / supprimer des données, créer / modifier/ effacer des tables, exporter / importer des données, passer des commandes SQL, etc...

####Voilà, si vous avez des questions ou des suggestions, vous pouvez vous adresser à nous à partir de notre formulaire :
####https://www.libre-expert.com/contacts

####**Bonne utilisation !**
