<?php

/* Copyright (C) 2007-2010 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) ---Put here your own copyright and developer email---
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       dev/skeletons/skeleton_page.php
 * 		\ingroup    mymodule othermodule1 othermodule2
 * 		\brief      This file is an example of a php page
 * 					Put here some comments
 */
//if (! defined('NOREQUIREUSER'))  define('NOREQUIREUSER','1');
//if (! defined('NOREQUIREDB'))    define('NOREQUIREDB','1');
//if (! defined('NOREQUIRESOC'))   define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))  define('NOREQUIRETRAN','1');
//if (! defined('NOCSRFCHECK'))    define('NOCSRFCHECK','1');
//if (! defined('NOTOKENRENEWAL')) define('NOTOKENRENEWAL','1');
//if (! defined('NOREQUIREMENU'))  define('NOREQUIREMENU','1');	// If there is no menu to show
//if (! defined('NOREQUIREHTML'))  define('NOREQUIREHTML','1');	// If we don't need to load the html.form.class.php
//if (! defined('NOREQUIREAJAX'))  define('NOREQUIREAJAX','1');
//if (! defined("NOLOGIN"))        define("NOLOGIN",'1');		// If this page is public (can be called outside logged session)
// Change this following line to use the correct relative path (../, ../../, etc)
$res = 0;
if (!$res && file_exists("../main.inc.php"))
    $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php"))
    $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php"))
    $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php"))
    $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res)
    die("Include of main fails");
// Change this following line to use the correct relative path from htdocs (do not remove DOL_DOCUMENT_ROOT)
//require_once(DOL_DOCUMENT_ROOT."/../dev/skeleton/skeleton_class.class.php");
require_once(DOL_DOCUMENT_ROOT . '/core/lib/files.lib.php');
require_once(DOL_DOCUMENT_ROOT . '/core/lib/functions.lib.php');
require_once(DOL_DOCUMENT_ROOT . '/core/lib/usergroups.lib.php');
require_once(DOL_DOCUMENT_ROOT . '/user/class/user.class.php');
require_once(DOL_DOCUMENT_ROOT . '/user/class/usergroup.class.php');
require_once(dirname(__FILE__) . '/class/kmgarchigeduserconfig.class.php');


$id = GETPOST('id', 'int');
$action = GETPOST('action');

$langs->load("companies");
$langs->load("members");
$langs->load("bills");
$langs->load("users");
$langs->load("kmgarchiged");

$fuser = new User($db);
$fuser->fetch($id);

$kmgarchigeduserconfig = new Kmgarchigeduserconfig($db);
$kmgarchigeduserconfig->fetch_from_user($id);

// If user is not user read and no permission to read other users, we stop
if (($fuser->id != $user->id) && (!$user->rights->user->user->lire))
    accessforbidden();

// Security check
$socid = 0;
if ($user->societe_id > 0)
    $socid = $user->societe_id;
$feature2 = (($socid && $user->rights->user->self->creer) ? '' : 'user');
if ($user->id === $id)
    $feature2 = ''; // A user can always read its own card
$result = restrictedArea($user, 'user', $id, '&user', $feature2);

/* * *************************************************************************** */
/*                     Actions                                                */
/* * *************************************************************************** */

if ($action === 'update' && ($user->rights->kmgarchiged->configuration->config_user
        || $user->admin) && !GETPOST("cancel")) {
    $db->begin();

    $kmgarchigeduserconfig->id = GETPOST("kmgarchigeduserconfig_id");
    $kmgarchigeduserconfig->fk_user = GETPOST("id");
    $kmgarchigeduserconfig->has_fldr = GETPOST("has_fldr");
    $kmgarchigeduserconfig->access_groups_fldr = GETPOST("access_groups_fldr");

    if ($kmgarchigeduserconfig->id > 0)
        $res = $kmgarchigeduserconfig->update($user);
    else
        $res = $kmgarchigeduserconfig->create($user);

    if ($res < 0) {
        if (!empty($kmgarchigeduserconfig->errors))
            setEventMessages(null, $kmgarchigeduserconfig->errors, 'errors');
        else
            setEventMessages($kmgarchigeduserconfig->error, null, 'errors');
        $db->rollback();
    }
    else {
        setEventMessages("SuccessfullySaved", null, 'mesgs');

        $db->commit();
        header("Location: " . dol_buildpath('/kmgarchiged/usertab_kmgarchigedconfig.php?id=' . $id,
                        1));
        exit;
    }
}

$fuser->kmgarchigeduserconfig_id = $kmgarchigeduserconfig->id;
$fuser->has_fldr = $kmgarchigeduserconfig->has_fldr;
$fuser->access_groups_fldr = $kmgarchigeduserconfig->access_groups_fldr;
$fuser->fk_user = $kmgarchigeduserconfig->fk_user;

if ($action != "edit") {
    if ($fuser->has_fldr) {
        if (dol_is_dir($conf->kmgarchiged->dir_output . '/user_' . $kmgarchigeduserconfig->fk_user)
                == FALSE)
            dol_mkdir($conf->kmgarchiged->dir_output . '/user_' . $kmgarchigeduserconfig->fk_user);
    }
    if ($fuser->access_groups_fldr) {

        $usergroup = new UserGroup($db);
        $groupslist = $usergroup->listGroupsForUser($id);

        if (!empty($groupslist)) {
            foreach ($groupslist as $current_group) {
                if (dol_is_dir($conf->kmgarchiged->dir_output . '/group_' . $current_group->id)
                        == FALSE)
                    dol_mkdir($conf->kmgarchiged->dir_output . '/group_' . $current_group->id);
            }
        }
    }
}
/* * *************************************************************************** */
/* Affichage fiche                                                            */
/* * *************************************************************************** */

llxHeader();

$form = new Form($db);

if ($id) {
    $head = user_prepare_head($fuser);

    $title = $langs->trans("User");
    dol_fiche_head($head, 'kmgarchigedconfig', $title, 0, 'user');

    dol_banner_tab($fuser, 'id', $linkback,
            $user->rights->user->user->lire || $user->admin);

    print "<form method=\"post\" action=\"usertab_kmgarchigedconfig.php\">";
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="id" value="' . $id . '">';
    print '<input type="hidden" name="kmgarchigeduserconfig_id" value="' . $fuser->kmgarchigeduserconfig_id . '">';
    print '<input type="hidden" name="action" value="update">';
    print '<table width="100%" class="border">';

    print '<tr class="liste_titre">';
    print '<td width="300px">' . $langs->trans("Name") . '</td>';
    print '<td>' . $langs->trans("Value") . '</td>';
    print '<td align="left">' . $langs->trans("FTPAccess") . '</td>';
    print "</tr>\n";
    print '<tr><td>' . $langs->trans("Kmgarchiged_has_fldr") . '</td><td class="valeur" colspan="3">';
    if ($action === 'edit')
        print $form->selectyesno('has_fldr', $fuser->has_fldr);
    else
        print yn($fuser->has_fldr) . '&nbsp;';
    print '</td></tr>';

    if ($fuser->has_fldr) {
        print '<tr><td style="text-align:right;"> >>&nbsp;&nbsp;</td>';
        print '<td>' . $user->getNomUrl() . '</td>';
        print '<td>';
        print str_replace(DOL_DATA_ROOT, '',
                        $conf->kmgarchiged->dir_output . '/user_' . $id);
        print '</td>';
        print '</tr>';
    }
    print '<tr><td>' . $langs->trans("Kmgarchiged_access_groups_fldr") . '</td><td class="valeur" colspan="3">';
    if ($action === 'edit')
        print $form->selectyesno('access_groups_fldr',
                        $fuser->access_groups_fldr);
    else
        print yn($fuser->access_groups_fldr) . '&nbsp;';
    print '</td></tr>';

    if ($fuser->access_groups_fldr) {

        $usergroup = new UserGroup($db);
        $groupslist = $usergroup->listGroupsForUser($id);
        if (!empty($groupslist)) {
            foreach ($groupslist as $current_group) {
                print '<tr>';
                print '<td style="text-align:right;"> >>&nbsp;&nbsp;</td>';
                print '<td>' . $current_group->getNomUrl() . '</td>';
                print '<td>';
                print str_replace(DOL_DATA_ROOT, '',
                                $conf->kmgarchiged->dir_output . '/group_' . $current_group->id);
                print '</td>';
                print '</tr>';
            }
        }
    }
    print "</table>";


    if ($action === 'edit') {
        print '<center><br>';
        print '<input type="submit" class="button" name="update" value="' . $langs->trans("Save") . '">';
        print '&nbsp; &nbsp;';
        print '<input type="submit" class="button" name="cancel" value="' . $langs->trans("Cancel") . '">';
        print '</center>';
    }

    print "</form>\n";


    /*
     * Actions
     */
    print '</div>';
    print '<div class="tabsAction">';

    if (($user->rights->kmgarchiged->configuration->config_user || $user->admin)
            && $action != 'edit') {
        print "<a class=\"butAction\" href=\"usertab_kmgarchigedconfig.php?id=" . $id . "&amp;action=edit\">" . $langs->trans('Modify') . "</a>";
    }

    print "</div>";
}

$db->close();

llxFooter();
