<?php

/* Copyright (C) 2011-      Kevin Guerrier <guerrier.k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

$res = 0;
if (!$res && file_exists("../main.inc.php"))
    $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php"))
    $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php"))
    $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../../main.inc.php"))
    $res = @include("../../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res)
    die("Include of main fails");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/cactioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/actioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/class/html.formorder.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/class/html.formfile.class.php");
require_once(DOL_DOCUMENT_ROOT . '/core/lib/files.lib.php');
require_once(DOL_DOCUMENT_ROOT . "/core/lib/functions2.lib.php");

require_once(DOL_DOCUMENT_ROOT . '/user/class/user.class.php');
require_once(DOL_DOCUMENT_ROOT . '/user/class/usergroup.class.php');

require_once(dirname(__FILE__) . "/lib/kmgarchiged.lib.php");
dol_include_once('/kmgarchiged/class/kmgarchigeduserconfig.class.php');

global $conf, $user;

if (!$user->rights->kmgarchiged->archives->consulter)
    accessforbidden();


$langs->load("other");
$langs->load("mails");
$langs->load("kmgarchiged@kmgarchiged");

/*
 * Actions
 */

$action = GETPOST('action');
$srcfile = GETPOST('srcfile');
$reference_fk_id = GETPOST('reference_fk_id');
$reference_type_element = GETPOST('reference_type_element');
$name = GETPOST('name');
$basename = GETPOST('basename');
$urlfile = GETPOST('urlfile');
$confirm = GETPOST('confirm');
if ($name == "")
    $name = $basename;
$extension = GETPOST('extension');
if ($extension != "")
    if (strpos($name, $extension) === FALSE)
        $name .= '.' . GETPOST('extension');


// Delete file/link
if ($action == 'confirm_deletefile' && $confirm == 'yes') {
    $upload_dir = $conf->kmgarchiged->dir_output;
    $urlfile = GETPOST('urlfile', 'alpha'); // Do not use urldecode here ($_GET and $_REQUEST are already decoded by PHP).
    $filenameonly = GETPOST('filenameonly', 'alpha'); // Do not use urldecode here ($_GET and $_REQUEST are already decoded by PHP).
//    $urlfile = basename($urlfile);
    $file = $upload_dir . "/" . $urlfile;
    if (!empty($upload_dirold))
        $fileold = $upload_dirold . "/" . $urlfile;

    if ($urlfile) {
        $dir = dirname($file) . '/';     // Chemin du dossier contenant l'image d'origine
        $dirthumb = $dir . '/thumbs/';   // Chemin du dossier contenant la vignette
//print $file.'<br />';

        $ret = dol_delete_file($file);
        if (!empty($fileold))
            dol_delete_file($fileold);     // Delete file using old path

            
// Si elle existe, on efface la vignette
        if (preg_match('/(\.jpg|\.jpeg|\.bmp|\.gif|\.png|\.tiff)$/i', $file,
                        $regs)) {
            $photo_vignette = basename(preg_replace('/' . $regs[0] . '/i', '',
                            $file) . '_small' . $regs[0]);
            if (file_exists(dol_osencode($dirthumb . $photo_vignette))) {
                dol_delete_file($dirthumb . $photo_vignette);
            }

            $photo_vignette = basename(preg_replace('/' . $regs[0] . '/i', '',
                            $file) . '_mini' . $regs[0]);
            if (file_exists(dol_osencode($dirthumb . $photo_vignette))) {
                dol_delete_file($dirthumb . $photo_vignette);
            }
        }

        if ($ret)
            setEventMessages($langs->trans("FileWasRemoved", $filenameonly),
                    null, 'mesgs');
        else
            setEventMessages($langs->trans("ErrorFailToDeleteFile",
                            $filenameonly), null, 'errors');
    }
    header('Location: ' . dol_buildpath('/kmgarchiged/archives.php', 2) . '?sannee=' . $sannee . '&strimestre=' . $strimestre);
    exit;
}


/*
 * View
 */

$help_url = 'EN:Module_ArchiGED|FR:Module_ArchiGED|ES:M&oacute;dulo_ArchiGED';
llxHeader('', $langs->trans("KMGArchiGED"), $help_url);

dol_htmloutput_mesg($mesg);

$form = new Form($db);
$formfile = new FormFile($db);

$list_files_archives = dol_dir_list($archives_output, 'directories', 0, '', '',
        'name', SORT_DESC);

$current_annee = date('Y');
$sannee = GETPOST('sannee');

if ($sannee <= 0)
    $sannee = $current_annee;

for ($i_annee = 0; $i_annee < 4; $i_annee++) {
    $list_annee[$current_annee - $i_annee] = $current_annee - $i_annee;
    $list_trimestre[1 + $i_annee] = 1 + $i_annee;
}

$strimestre = GETPOST('strimestre');

if ($strimestre <= 0) {
    $current_week = date('W');

    $ssemaine = $current_week;

    $current_trim = getTrimFromWeek($current_week);
}
else
    $current_trim = $strimestre;

$first_week = ($current_trim - 1) * 13;
$last_week = $first_week + 13;

print '<div class="titre" >' . $langs->trans('ListOfArchives');
print ' ' . $sannee . ' ' . $langs->trans('Trimestre') . ' ' . $current_trim;
print '</div><br />';

print '<form>';
print '<table>';
print '<tr>';
print '<td>';
print $langs->trans('Trimestre') . ' ';
print '</td>';
print '<td>';
print $form->selectarray("strimestre", $list_trimestre, $strimestre);
print '</td>';
print '<td>';
print $form->selectarray("sannee", $list_annee, $sannee);
print '</td>';
print '<td>';
print '<input type="submit" value="' . $langs->trans('Show') . '" /> ';
print '</td>';
print '</tr>';
print '</table>';
print '</form>';

if (!($user->admin)) {
    if (!($user->rights->banque))
        unset($listPredefinedFolders[1]);
    if (!($user->rights->tax))
        unset($listPredefinedFolders[2]);
    if (!($user->rights->tax))
        unset($listPredefinedFolders[3]);
    if (!($user->rights->tax))
        unset($listPredefinedFolders[4]);
    if (!($user->rights->fournisseur->facture))
        unset($listPredefinedFolders[0]);
}
$kmgarchigeduserconfig = new Kmgarchigeduserconfig($db);
$kmgarchigeduserconfig->fetch_from_user($user->id);

$usergroup = new UserGroup($db);
$groupslist = $usergroup->listGroupsForUser($user->id);

if (!empty($groupslist)) {
    foreach ($groupslist as $current_group) {
        $listgroup[] = $current_group->id;
    }
}

if ($kmgarchigeduserconfig->has_fldr) {
    $listPredefinedFolders[] = 'user_' . $user->id;
}

if ($kmgarchigeduserconfig->access_groups_fldr) {
    foreach ($groupslist as $current_group) {
        $listPredefinedFolders[] = 'group_' . $current_group->id;
    }
}


$permission_delete = $user->rights->kmgarchiged->archives->supprimer;
$permtoedit = 0;

$i_archives = 0;
$i_archives_fichier = 0;
if ($list_files_archives != "") {
    foreach ($list_files_archives as $fichier_archives_list) {
        $year = substr($fichier_archives_list['name'], 0, 4);
        $week = substr($fichier_archives_list['name'], 4, 2);

        if ($year == $sannee && $week >= $first_week && $week <= $last_week) {
            print '<div class="titre" >' . $langs->trans('Period') . ' - ' . $year . ' ' . $langs->trans('Week') . ' ' . $week . '</div>';
            print '<table class="liste formdoc"  width="100%">';
            print '<tr>';
            $largeur = floor(100 / (sizeof($listPredefinedFolders)));
            foreach ($listPredefinedFolders as $pdffolder) {
                print '<td style="vertical-align:top;width:' . $largeur . '%;">';

                $displayed_name = $langs->trans($pdffolder);
                if (substr($pdffolder, 0, 5) == 'user_') {
                    $displayed_name = $langs->trans('KMGARCHIGED_PERSONNALBAN') . ' - ' . $user->getFullName($langs);
                }


                if (substr($pdffolder, 0, 6) == 'group_') {
                    list($null, $id_group) = explode('_', $pdffolder);
                    $displayed_name = $langs->trans('KMGARCHIGED_GROUPBAN') . ' - ' . $groupslist[$id_group]->name;
                }

                print '<table class="nobordernopadding" width="100%">';
                print '<tr class="liste_titre">';
                print '<td class="liste_titre">';
                print '&nbsp;' . $displayed_name;
                print '</td>';
                print '</tr>';
                print '<tr>';
                print '<td>';
                $list_files = dol_dir_list($archives_output . '/' . $year . $week . '/' . $pdffolder,
                        'files', 0, '', $arrayofexclusion, 'name', SORT_DESC);
                if ($list_files != "") {
                    foreach ($list_files as $fichier_list) {
                        if ($fichier_list['path'] == '')
                            $fichier_list['path'] = str_replace('/' . $fichier_list['name'],
                                    '', $fichier_list['fullname']);

                        list($date, $nom_fichier) = explode('_',
                                $fichier_list['name'], 2);

                        $file = $fichier_list['name'];
                        $modulepart = 'kmgarchiged';
                        $filepath = '/archived/' . $year . $week . '/' . $pdffolder . '/';


                        if ($permission_delete) {
                            print '<a href="' . dol_buildpath('/kmgarchiged/archives.php',
                                            2) . '?action=delete&urlfile=' . urlencode($filepath . $file) . '&strimestre=' . $strimestre . '&sannee=' . $sannee . '&filenameonly=' . urlencode($file) . '" class="deletefilelink" rel="' . $filepath . '">';
                            print img_delete();
                            print '</a>';
                        }

                        print $formfile->showPreview($file, $modulepart,
                                        $filepath . $file, 0,
                                        '&perm=kmgarchiged&subperm=utiliser');

                        print '<a href="' . dol_buildpath('/document.php', 2) . '?modulepart=kmgarchiged&file=/archived/' . $year . $week . '/' . $pdffolder . '/' . $fichier_list['name'] . '" target="_blank">';
                        print img_picto($fichier_list['name'], 'file') . ' ' . dol_trunc($nom_fichier,
                                        16);
                        print '</a>';

                        print '<br />';
                    }
                }
                print '</td>';
                print '</tr>';
                print '</table>';
                print '</td>';
            }
            print '</tr>';
            print '</table>';
            print '<br />';
        }
    }

    $urlfile = GETPOST('urlfile', 'alpha'); // Do not use urldecode here ($_GET and $_REQUEST are already decoded by PHP).

    if ($action == 'delete' && $urlfile != "") {
        $filenameonly = GETPOST('filenameonly');

        $array_questions = array(
            array('name' => 'urlfile',
                'label' => $langs->trans('File'),
                'type' => 'hidden',
                'value' => $urlfile),
            array('name' => 'strimestre',
                'label' => $langs->trans('Trimestre'),
                'type' => 'hidden',
                'value' => $strimestre),
            array('name' => 'sannee',
                'label' => $langs->trans('Year'),
                'type' => 'hidden',
                'value' => $sannee),
            array('name' => 'filenameonly',
                'label' => $langs->trans('Filename'),
                'type' => 'hidden',
                'value' => $filenameonly)
        );
        $formconfirm = $form->formconfirm(dol_buildpath('/kmgarchiged/archives.php',
                        2), $langs->trans('DeleteArchivedFile'),
                $langs->trans('ConfirmDeleteArchivedFile',
                        urldecode($filenameonly)), 'confirm_deletefile',
                $array_questions, 0, 1);
        print $formconfirm;
    }
}

llxFooter();
$db->close();
