<?php
/* Copyright (C) 2011-      Kevin Guerrier <guerrier.k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * or see http://www.gnu.org/
 */

$res = 0;
if (!$res && file_exists("../main.inc.php"))
    $res = @include("../main.inc.php");
if (!$res && file_exists("../../main.inc.php"))
    $res = @include("../../main.inc.php");
if (!$res && file_exists("../../../main.inc.php"))
    $res = @include("../../../main.inc.php");
if (!$res && file_exists("../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../dolibarr/htdocs/main.inc.php");     // Used on dev env only
if (!$res && file_exists("../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res && file_exists("../../../../../dolibarr/htdocs/main.inc.php"))
    $res = @include("../../../../../dolibarr/htdocs/main.inc.php");   // Used on dev env only
if (!$res)
    die("Include of main fails");

require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/cactioncomm.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php");
require_once(dirname(__FILE__) . "/../lib/kmgarchiged.lib.php");

if (!$user->admin)
    accessforbidden();

$langs->load('kmgarchiged@kmgarchiged');

$action = GETPOST('action', 'alpha');

if ($action == 'update' || $action == 'add') {
    $constname = GETPOST('constname', 'alpha');
    $constvalue = GETPOST('constvalue', 'alpha');
    $consttype = GETPOST('consttype', 'alpha');
    $constnote = GETPOST('constnote', 'alpha');

    $res = dolibarr_set_const($db, $constname, $constvalue, $consttype, 0,
            $constnote, $conf->entity);

    if (!$res > 0)
        $error++;

    if (!$error) {
        $mesg = '<div class="ok">' . $langs->trans("SetupSaved") . "</div>";
    }
    else {
        $mesg = '<div class="error">' . $langs->trans("Error") . "</div>";
    }
}

$help_url = 'EN:Module KMGArchiGED setup|FR:Paramétrage_du_module_kmgarchiged';
llxHeader('', $langs->trans("KMGArchiGED"), $help_url);

$linkback = '<a href="' . dol_buildpath('/admin/modules.php', 2).'">' . $langs->trans("BackToModuleList") . '</a>';
print load_fiche_titre($langs->trans("KmgarchigedSetupModule"), $linkback,
                'title_setup');


//ini_set('error_reporting', E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);
//ini_set('display_errors', 1);


dol_htmloutput_mesg($mesg);
//$form = new Form($db);

//dol_fiche_head($head, 'general', $langs->trans("Actions"), 0);

print load_fiche_titre($langs->trans("KmgarchigedActioncomType"), '', '');

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td width="140">' . $langs->trans("Code") . '</td>';
print '<td>' . $langs->trans("Description") . '</td>';
print '<td width="140" align="center">' . $langs->trans("Status") . '</td>';
print '<td align="center" width="60">&nbsp;</td>';
print "</tr>\n";

$list_codes_events = array(
    'ACGED_DELETE',
    'ACGED_LINKED',
    'ACGED_NOTIFY',
    'ACGED_RECU',
);

$var = true;
$i = 0;

$nb_codes_events = count($list_codes_events);
while ($i < $nb_codes_events) {
    $var = !$var;
    $cactioncomm = new CActionComm($db);
    $cactioncomm->fetch($list_codes_events[$i]);
    print '<tr ' . $bc[$var] . '>';
    print '<td width="140">' . $list_codes_events[$i] . '</td>';
    print '<td >' . $langs->trans("lbl_" . $list_codes_events[$i]) . '</td>';
    print '<td align="left">';
    if ($cactioncomm->id > 0) {
        print img_allow(1) . ' ' . $langs->trans('Found');
        print '</td><td>';
    }
    else {
        print img_warning() . ' ' . $langs->trans('NotFoundWillBeUsedInstead',
                        $list_codes_events[$i], 'AC_OTH_AUTO');
        print '</td><td>';
        print '<div class="inline-block divButAction">';
        print '<form method="POST" action="' . dol_buildpath('/admin/dict.php', 2) . '?id=6">';
        print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '" />';
        print '<input type="hidden" name="code" value="' . $list_codes_events[$i] . '" />';
        print '<input type="hidden" name="libelle" value="' . $langs->trans("lbl_" . $list_codes_events[$i]) . '" />';
        print '<input type="hidden" name="type" value="user" />';
        print '<input type="hidden" name="position" value="' . $i . '" />';
        print '<input type="submit" class="butAction" name="actionadd" value="' . $langs->trans('Add') . '" />';
        print '</form>';
        print '</div>';
    }
    print '</td>';
    print "</tr>\n";

    $i++;
}
print '</table>' . "\n";


print '<br><br>';

print load_fiche_titre($langs->trans("KmgarchigedMailingParameters"), '', '');

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td width="140">' . $langs->trans("Type") . '</td>';
print '<td>' . $langs->trans("Description") . '</td>';
print '<td width="140" align="center">' . $langs->trans("Value") . '</td>';
print '<td align="center" width="60">&nbsp;</td>';
print "</tr>\n";

$list_codes_parameters = array(
    'MAIL_SUBJECT:text',
    'MAIL_MSG:textarea',
);

$var = true;
$i = 0;

$nb_codes_parameters = count($list_codes_parameters);
while ($i < $nb_codes_parameters) {
    list($codeparam, $typeparam) = explode(':', $list_codes_parameters[$i]);
    $var = !$var;
    print '<form method="POST">';
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '" />';
    print '<tr ' . $bc[$var] . '>';
    print '<td width="140">' . $codeparam . '</td>';
    print '<td >' . $langs->trans("lbl_" . $codeparam) . '</td>';
    print '<td align="left">';
    print '<input type="hidden" name="action" value="update">';
    print '<input type="hidden" name="consttype" value="string">';
    $key = "KMGED_" . $codeparam;
    print '<input type="hidden" name="constname" value="' . $key . '">';
    // Value
    $value = ($conf->global->$key) ? $conf->global->$key : $langs->trans("dft_" . $codeparam);
    if ($typeparam == "text") {
        print '<input type="text" size="60" name="constvalue" value="' . $value . '">';
    }
    elseif ($typeparam == "textarea") {
        $_GET['action'] = 'editconstvalue';

        if (!empty($conf->fckeditor->enabled)) {
//            print $form->editfieldval($langs->trans("lbl_" . $codeparam),
//                            'constvalue', $value, $object, 1,
//                            'ckeditor:dolibarr_details');

            require_once DOL_DOCUMENT_ROOT . '/core/class/doleditor.class.php';
            $doleditor = new DolEditor('constvalue', $value, '', '100',
                    'dolibarr_details', 'In', 0, true, true, '20', '100');
            print $doleditor->Create(1);
        }
        else {
//            print $form->editfieldval($langs->trans("lbl_" . $codeparam),
//                            'constvalue', $value, $object, 1,
//                            'textarea:' . ROWS_4 . ':60');
            print '<textarea name="constvalue" wrap="soft" rows="' . ROWS_4 . '" cols="60">' . $value . '</textarea>';
        }
    }
    print '</td><td>';
    print '<div class="inline-block divButAction">';
    print '<input type="submit" class="butAction" name="actionadd" value="' . $langs->trans('Add') . '" />';
    print '</div>';
    print '</td>';
    print "</tr>\n";
    print '</form>';

    $i++;
}
print '</table>' . "\n";


print '<br><br>';
print load_fiche_titre($langs->trans("Tools"), '', '');

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td width="140">' . $langs->trans("Name") . '</td>';
print '<td>' . $langs->trans("Description") . '</td>';
print '<td width="140" align="center">' . $langs->trans("Status") . '</td>';
print '<td align="center" width="60">&nbsp;</td>';
print "</tr>\n";

$list_codes_tools = array(
    'convert',
);

$var = true;
$i = 0;

$nb_codes_tools = count($list_codes_tools);
while ($i < $nb_codes_tools) {
    $var = !$var;
    print '<tr ' . $bc[$var] . '>';
    print '<td width="140">' . $list_codes_tools[$i] . '</td>';
    print '<td >' . $langs->trans("lbl_" . $list_codes_tools[$i]) . '</td>';
    print '<td align="left">';
    if (command_exists($list_codes_tools[$i]))
        print img_allow(1) . ' ' . $langs->trans('Found');
    else {
        print img_warning() . ' ' . $langs->trans('NotAvailable');
    }
    print '</td>';
    print '<td align="center" width="60">&nbsp;</td>';
    print "</tr>\n";

    $i++;
}
print '</table>' . "\n";


print '<br><br>';
print load_fiche_titre($langs->trans("FTPAccess"), '', '');

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td width="140">' . $langs->trans("Name") . '</td>';
print '<td>' . $langs->trans("Description") . '</td>';
print '<td width="140" align="center">' . $langs->trans("FTPLocation") . '</td>';
print '<td align="center" width="60">&nbsp;</td>';
print "</tr>\n";

$list_folders = array(
    'BankDocument',
    'ImpotsTax',
    'SocialDocument',
    'SupplierInvoices',
    'Others',
);

$var = true;
$i = 0;

$nb_folders = count($list_folders);
while ($i < $nb_folders) {
    $var = !$var;
    print '<tr ' . $bc[$var] . '>';
    print '<td width="140">' . $list_folders[$i] . '</td>';
    print '<td >' . $langs->trans("fldr_" . $list_folders[$i]) . '</td>';
    print '<td align="left">';
    print str_replace(DOL_DATA_ROOT, '',$conf->kmgarchiged->dir_output).'/'.$list_folders[$i];
    print '</td>';
    print '<td align="center" width="60">&nbsp;</td>';
    print "</tr>\n";

    $i++;
}
print '</table>' . "\n";

print '<br><br>';
print load_fiche_titre($langs->trans("ExternalCredits"), '', '');
print '<div>';
print $langs->trans('IconMadeBy').' <a href="http://www.freepik.com" title="Freepik" target="_blank" >Freepik</a> ';
print ' '.$langs->trans('from').' <a href="https://www.flaticon.com/" title="Flaticon" target="_blank" >www.flaticon.com</a> ';
print $langs->trans('IconLicensedBy').' <a href="http://creativecommons.org/licenses/by/3.0/" title="Creative Commons BY 3.0" target="_blank">CC 3.0 BY</a>';
print '</div>';

llxFooter();
