<?php

/* Copyright (C) 2011-2018 Jean-François Ferry    <hello@librethic.io>
 * Copyright (C) 2011      Regis Houssin          <regis@dolibarr.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *       \file       hosting/hosting.php
 *         \ingroup    hosting
 *         \brief        Main page of module hosting
 *         \author        jfefe - hello@librethic.io
 *         \remarks    Home of hosting module
 */
$res = '';
$res = @include "../main.inc.php"; // For root directory
if (!$res) {
    $res = @include "../../main.inc.php";
}
// For "custom" directory

require_once 'class/host.class.php';
require_once DOL_DOCUMENT_ROOT . '/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT . '/core/lib/company.lib.php';

// Load traductions files requiredby by page
$langs->load("companies");
$langs->load("other");
$langs->load("hosting@hosting");
if ($conf->monitoring->enabled) {
    $langs->load("monitoring@monitoring");
}

// Get parameters
$id = (GETPOST('id', 'int') ? GETPOST('id', 'int') : GETPOST('hostid', 'int')); // For backward compatibility
$socid = GETPOST('socid');
$mesg = GETPOST('mesg', 'alpha');

// If socid provided by ajax company selector
if (!empty($_REQUEST['socid_id'])) {
    $_GET['socid'] = $_GET['socid_id'];
    $_POST['socid'] = $_POST['socid_id'];
    $_REQUEST['socid'] = $_REQUEST['socid_id'];
}

$action = GETPOST('action');

// Protection if external user
if ($user->societe_id > 0) {
    //accessforbidden();
}

// Security check
$return = restrictedArea($user, 'hosting', $id, 'host');

/* * *************************************************
 * PAGE
 *
 * ************************************************** */
$help_url = 'EN:Module_Hosting|FR:Module_Hosting_FR|ES:Module_Hosting_ES';
llxHeader('', $langs->trans("Hosting"), $help_url);

$form = new Form($db);
if ($socid) {
    $soc = new Societe($db);
    $soc->id = $socid;
    $result = $soc->fetch($socid);
    if ($result < 0) {
        dol_print_error($db, $soc->error);
        exit;
    }
    $head = societe_prepare_head($soc);
}

print_fiche_titre($langs->trans("Hosting"), $mesg, 'host_32@hosting');

if ($mesg) {
    dol_htmloutput_mesg($mesg);
}

print '<div class="fichecenter">';

/*
 * Liste des derniers hôtes
 */
print '<div class="fichethirdleft">';

$max = 15;
$sql = "SELECT h.rowid, h.ref, h.status, h.label, h.date_creation, h.actif";
$sql .= " FROM " . MAIN_DB_PREFIX . "host as h";
if ($socid) {
    $sql .= " WHERE h.fk_soc = " . $socid;
}

$sql .= $db->order("h.date_creation", "DESC");
$sql .= $db->plimit($max, 0);

$result = $db->query($sql);
if ($result) {
    $num = $db->num_rows($result);

    $i = 0;

    if ($num > 0) {
        $host_static = new Host($db);

        $transRecordedType = $langs->trans("LastCreateHosts", $max);

        print '<table class="noborder centpercent">';

        print '<tr class="liste_titre">' .
            '<td colspan="3">' . $transRecordedType . '</td>';

        print '</tr>';

        $var = true;

        while ($i < $num) {
            $objh = $db->fetch_object($result);

            $var = !$var;
            print "<tr $bc[$var]>";
            // Name
            print '<td nowrap="nowrap">';
            $host_static->id = $objh->rowid;
            $host_static->ref = $objh->ref;
            $host_static->label = $objh->label;
            $host_static->date_creation = $db->jdate($objh->date_creation);
            $host_static->actif = $objh->actif;
            print $host_static->getNomUrl(1);
            print "</td>\n";
            
            print '<td>';
            print $host_static->label;
            print '</td>';

            // Created date
            print '<td align="right">';
            print dol_print_date($host_static->date_creation, 'day');
            print "</td>";

            print "</tr>\n";
            $i++;
        }

        $db->free();

        print "</table>";
    } else {
        print '<div class="info">' . $langs->trans('NoHost') . '</div>';
    }
} else {
    dol_print_error($db);
}

print '</div><!-- fichethirdleft -->';

/* Liste des tiers avec le nombre total d'hôtes par tiers */
print '<div class="fichetwothirdright">';
print '<div class="ficheaddleft">';
print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print_liste_field_titre($langs->trans("ThirdParties"), "", "s.nom", "", "", "", $sortfield, $sortorder);
print_liste_field_titre($langs->trans("NbOfHosts"), "", "", "", "", 'align="right"', $sortfield, $sortorder);
print "</tr>\n";

$sql = "SELECT count(h.rowid) as nb";
$sql .= ", s.nom, s.rowid as socid";
$sql .= " FROM " . MAIN_DB_PREFIX . "host as h";
$sql .= " LEFT JOIN " . MAIN_DB_PREFIX . "societe as s on h.fk_soc = s.rowid";
//$sql.= " WHERE b.entity = ".$conf->entity;

if ($socid) {
    $sql .= " WHERE s.rowid = " . $socid;
}

//if (!$user->rights->hosting->all->lire) $sql.= " AND h.rowid IN (".$hostListId.")";
$sql .= " GROUP BY s.nom, s.rowid";

$var = true;
$resql = $db->query($sql);
if ($resql) {
    $num = $db->num_rows($resql);
    $i = 0;

    while ($i < $num) {
        $obj = $db->fetch_object($resql);
        $var = !$var;
        print "<tr $bc[$var]>";
        print '<td nowrap="nowrap">';
        if ($obj->socid) {
            $socstatic = new Societe($db);
            $socstatic->id = $obj->socid;
            $socstatic->nom = $obj->nom;
            print $socstatic->getNomUrl(1);
        } else {
            print $langs->trans("OthersNotLinkedToThirdParty");
        }
        print '</td>';

        print '<td align="right"><a href="host_list.php?socid=' . $obj->socid . '">' . $obj->nb . '</a></td>';
        print "</tr>\n";

        $i++;
    }

    $db->free($resql);
} else {
    dol_print_error($db);
}

print '</td></tr></table>';
print '<br /><br />';

print '</div></div>';
print '</div>';

print '<div class="tabsAction" style="clear: both">';

/* View host list */
print '<div class="inline-block divButAction">';
print '<a class="butAction" href="host_list.php' . ($socid ? "?socid=$socid" : "") . '">' . $langs->trans("HostsList") . '</a>';
print '</div>';

/* New host */
if ($user->rights->hosting->write) {
    print '<div class="inline-block divButAction">';
    print '<a class="butAction" href="host_card.php?action=create' . ($socid ? "&socid=$socid" : "") . '">' . $langs->trans("HostAdd") . '</a>';
    print '</div>';
}

if ($conf->monitoring->enabled) {
    print '<div class="inline-block divButAction">';
    print '<a class="butAction" href="../monitoring/monitor_list.php' . ($socid ? "?socid=$socid" : "") . '">' . $langs->trans("MonitorList") . '</a>';
    print '</div>';
}
print '</div>';

// End of page
$db->close();
llxFooter();
