<?php
/* Copyright (C) 2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2018 Jean-François Ferry  <hello+jf@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *   	\file       host_extensions.php
 *		\ingroup    hosting
 *		\brief      Page to view host extensions
 */

//if (! defined('NOREQUIREUSER'))          define('NOREQUIREUSER','1');
//if (! defined('NOREQUIREDB'))            define('NOREQUIREDB','1');
//if (! defined('NOREQUIRESOC'))           define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))          define('NOREQUIRETRAN','1');
//if (! defined('NOSCANGETFORINJECTION'))  define('NOSCANGETFORINJECTION','1');			// Do not check anti CSRF attack test
//if (! defined('NOSCANPOSTFORINJECTION')) define('NOSCANPOSTFORINJECTION','1');		// Do not check anti CSRF attack test
//if (! defined('NOCSRFCHECK'))            define('NOCSRFCHECK','1');			// Do not check anti CSRF attack test done when option MAIN_SECURITY_CSRF_WITH_TOKEN is on.
//if (! defined('NOSTYLECHECK'))           define('NOSTYLECHECK','1');			// Do not check style html tag into posted data
//if (! defined('NOIPCHECK'))              define('NOIPCHECK','1');				// Do not check IP defined into conf $dolibarr_main_restrict_ip
//if (! defined('NOTOKENRENEWAL'))         define('NOTOKENRENEWAL','1');		// Do not check anti POST attack test
//if (! defined('NOREQUIREMENU'))          define('NOREQUIREMENU','1');			// If there is no need to load and show top and left menu
//if (! defined('NOREQUIREHTML'))          define('NOREQUIREHTML','1');			// If we don't need to load the html.form.class.php
//if (! defined('NOREQUIREAJAX'))          define('NOREQUIREAJAX','1');         // Do not load ajax.lib.php library
//if (! defined("NOLOGIN"))                define("NOLOGIN",'1');				// If this page is public (can be called outside logged session)

// Load Dolibarr environment
$res=0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (! $res && ! empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
    $res=@include($_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php");
}
// Try main.inc.php into web root detected using web root caluclated from SCRIPT_FILENAME
$tmp=empty($_SERVER['SCRIPT_FILENAME'])?'':$_SERVER['SCRIPT_FILENAME'];
$tmp2=realpath(__FILE__);
$i=strlen($tmp)-1;
$j=strlen($tmp2)-1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i]==$tmp2[$j]) {
    $i--;
    $j--;
}
if (! $res && $i > 0 && file_exists(substr($tmp, 0, ($i+1))."/main.inc.php")) {
    $res=@include(substr($tmp, 0, ($i+1))."/main.inc.php");
}
if (! $res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php")) {
    $res=@include(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php");
}
// Try main.inc.php using relative path
if (! $res && file_exists("../main.inc.php")) {
    $res=@include("../main.inc.php");
}
if (! $res && file_exists("../../main.inc.php")) {
    $res=@include("../../main.inc.php");
}
if (! $res && file_exists("../../../main.inc.php")) {
    $res=@include("../../../main.inc.php");
}
if (! $res) {
    die("Include of main fails");
}

include_once(DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php');
include_once(DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php');
dol_include_once('/hosting/class/host.class.php');
dol_include_once('/hosting/lib/hosting.lib.php');

// Load traductions files requiredby by page
$langs->loadLangs(array("hosting@hosting","other"));

// Get parameters
$id			= GETPOST('id', 'int');
$ref        = GETPOST('ref', 'alpha');
$action		= GETPOST('action', 'alpha');
$cancel     = GETPOST('cancel', 'aZ09');
$backtopage = GETPOST('backtopage', 'alpha');

// Initialize technical objects
$object=new Host($db);
$extrafields = new ExtraFields($db);
$diroutputmassaction=$conf->hosting->dir_output . '/temp/massgeneration/'.$user->id;
$hookmanager->initHooks(array('hostcard'));     // Note that conf->hooks_modules contains array
// Fetch optionals attributes and labels
$extralabels = $extrafields->fetch_name_optionals_label('host');
$search_array_options=$extrafields->getOptionalsFromPost($extralabels, '', 'search_');

// Initialize array of search criterias
$search_all=trim(GETPOST("search_all", 'alpha'));
$search=array();
foreach ($object->fields as $key => $val) {
    if (GETPOST('search_'.$key, 'alpha')) {
        $search[$key]=GETPOST('search_'.$key, 'alpha');
    }
}

if (empty($action) && empty($id) && empty($ref)) {
    $action='view';
}

// Security check - Protection if external user
if ($user->societe_id > 0) {
    access_forbidden();
}
if ($user->societe_id > 0) {
    $socid = $user->societe_id;
}
$return = restrictedArea($user, 'hosting', $id, 'host');

// fetch optionals attributes and labels
$extralabels = $extrafields->fetch_name_optionals_label($object->table_element);

// Load object
include DOL_DOCUMENT_ROOT.'/core/actions_fetchobject.inc.php';  // Must be include, not include_once  // Must be include, not include_once. Include fetch and fetch_thirdparty but not fetch_optionals



/*
 * Actions
 *
 * Put here all code to do according to value of "action" parameter
 */

$parameters=array();
$reshook=$hookmanager->executeHooks('doActions', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
if ($reshook < 0) {
    setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');
}

if (empty($reshook)) {
	$error=0;
	$permissiontoadd = $user->rights->hosting->write;
	$permissiontodelete = $user->rights->hosting->delete;
	$permissiondellink = $user->rights->hosting->write;
	$backurlforlist = dol_buildpath('/hosting/host_list.php', 1);
	
	$ret = $extrafields->setOptionalsFromPost($extralabels, $object);
	
	

	// Actions to send emails
	$trigger_name='HOST_SENTBYMAIL';
	$autocopy='MAIN_MAIL_AUTOCOPY_HOST_TO';
	$trackid='host'.$object->id;
	include DOL_DOCUMENT_ROOT.'/core/actions_sendmails.inc.php';
	
	if ($action == "associate_type") {
	    $typeid = GETPOST('typeid');
	    
	    $sql = 'SELECT code FROM ' . MAIN_DB_PREFIX . 'c_host_type WHERE rowid=' . $typeid;
	    $resql = $db->query($sql);
	    if ($resql) {
	        $num = $db->num_rows($resql);
	        $obj = $db->fetch_object($resql);
	        
	        $type = $obj->code;
	        $element = $rep = $element_page = strtolower($type);
	        $className = ucfirst($element);
	        
	        $element_page = $element."_card";
	        
	        if ($element == "monitor") {
	            $rep = "monitoring";
	        }
	        if (dol_include_once('/' . $rep . '/class/' . $element . '.class.php')) {
	            Header("Location: ../$rep/$element_page.php?action=create&hostid=$id&typeid=$typeid");
	            exit;
	        } else {
	            $mesg = '<div class="error">La classe de l\'objet n\'a pas été trouvée : ' . $rep . '/class/' . $element . '.class.php</div>';
	        }
	    } else {
	        dol_print_error($db->errors);
	    }
	}
}



/*
 * View
 *
 * Put here all code to build page
 */

$form=new Form($db);
$formfile=new FormFile($db);

llxHeader('', 'Host', '');


// Part to show record
if ((empty($action) || ($action != 'edit' && $action != 'create'))) {
    $head = hostPrepareHead($object);
    dol_fiche_head($head, 'extensions', $langs->trans("Host"), -1, 'host@hosting');
    
    // Object card
    // ------------------------------------------------------------
    $linkback = '<a href="' .dol_buildpath('/hosting/host_list.php', 1) . '?restore_lastsearch_values=1' . (! empty($socid) ? '&socid=' . $socid : '') . '">' . $langs->trans("BackToList") . '</a>';
    
    $morehtmlref='<div class="refidno">';
    $morehtmlref.=$object->label;
    // Thirdparty
    if ($object->thirdparty->id) {
        $morehtmlref.='<br>'.$langs->trans('ThirdParty') . ' : ' . $object->thirdparty->getNomUrl(1);
    }
    $morehtmlref.='<br />'.$langs->trans('DateCreation').' : '.dol_print_date($object->date_creation);
    $morehtmlref.='</div>';
    dol_banner_tab($object, 'ref', $linkback, 1, 'ref', 'ref', $morehtmlref);
    

	print '<div class="fichecenter">';
	
	print '<div class="underbanner clearboth"></div>';
	
	/*
	 *  Add host type form
	 */
	
	$html = new Form($db);
	$soc = new Societe($db);
	$soc->id = $socid;
	
	if ($soc->fetch($soc->id) && count($object->getListOfManagedType()) > 0) {
	    print '<form action="' . $_SERVER['PHP_SELF'] . '" method="post">';
	    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '" />';
	    print '<input type="hidden" name="socid" value="' . $soc->id . '" />';
	    print '<input type="hidden" name="id" value="' . $id . '" />';
	    // Line with titles
	    print '<table class="noborder centpercent">';
	    print '<tr class="liste_titre">';
	    $param = "&socid=" . $socid;
	    
	    print '<td class="liste_titre">' . $langs->trans("AddNewHostExtension") . '</td>';
	    
	    print '<td>&nbsp;</td>';
	    print '</tr>';
	    
	    $var = false;
	    
	    $actions = array();
	    
	    // Load array of available type
	    
	    $listofhosttype = $object->getListOfManagedType();
	    
	    foreach ($listofhosttype as $hosttype) {
	        $label = $langs->trans("Hosting_" . $hosttype['code']) != $langs->trans("Hosting_" . $hosttype['code']) ? $langs->trans("Hosting_" . $hosttype['code']) : $hosttype['label'];
	        $actions[$hosttype['rowid']] = $label;
	    }
	    print '<input type="hidden" name="action" value="associate_type">';
	    print '<tr ' . $bc[$var] . '>';
	    print '<td>';
	    print $html->selectarray("typeid", $actions, '', 1);
	    print '</td>';
	    
	    print '<td align="right"><input type="submit" class="button" value="' . $langs->trans("Add") . '"></td>';
	    print '</tr>';
	    
	    print '</table>';
	    
	    print '</form>';
	    print '<br>';
	}
	
	/*
	 * Affichage des extensions de l'hote'
	 */
	
	$var = true;
	
	// List of type for this host
	$sql = "SELECT h.rowid, h.fk_type, h.element, h.element_id,";
	$sql .= " type.code, type.label";
	$sql .= " FROM " . MAIN_DB_PREFIX . "c_host_type as type,";
	$sql .= " " . MAIN_DB_PREFIX . "host_def as h";
	$sql .= " WHERE type.rowid = h.fk_type";
	$sql .= " AND h.fk_host = " . $id;
	
	$resql = $db->query($sql);
	if ($resql) {
	    $num = $db->num_rows($resql);
	    $i = 0;
	    if ($num > 0) {
	        print_titre($langs->trans("ListOfHostExtension"), '', '');
	        print '<table class="noborder centpercent">';
	        print '<tr class="liste_titre">';
	        print '<td class="liste_titre">Type</td>';
	        print '<td class="liste_titre">' . $langs->trans("Label") . '</td>';
	        print '<td class="liste_titre">' . $langs->trans("DateCreation") . '</td>';
	        print '<td class="liste_titre">' . $langs->trans("Status") . '</td>';
	        print '</tr>';
	    }
	    
	    while ($i < $num) {
	        $var = !$var;
	        
	        $obj = $db->fetch_object($resql);
	        
	        $filename = strtolower($obj->element) . ".class.php";
	        $className = ucfirst($obj->code);
	        
	        $type = $obj->code;
	        $element = $rep = $element_page = strtolower($type);
	        
	        if ($element == "monitor") {
	            $rep = "monitoring";
	        }
	        $element_page = $element.'_card';
	        if (dol_include_once('/' . $rep . '/class/' . $element . '.class.php')) {
	            $label = $langs->trans("Hosting_" . $obj->code) != $langs->trans("Hosting_" . $obj->code) ? $langs->trans("Hosting_" . $obj->code) : $obj->label;
	            print '<tr ' . $bc[$var] . '>';
	            print '<td><a href="../' . $rep . '/' . $element_page . '.php?id=' . $obj->element_id . '">' . $label . '</a></td>';
	            $HostExt = new $className($db);
	            $HostExt->fetch($obj->element_id);
	            print '<td>' . $HostExt->label . '</td>';
	            print '<td>' . dol_print_date($HostExt->date_creation) . '</td>';
	            print '<td>' . $HostExt->getLibStatut(4) . '</td>';
	            print '</tr>';
	        }
	        $i++;
	    }
	    if ($num > 0) {
	        print '</table><br />';
	    }
	} else {
	    dol_print_error($sql);
	}
	
	
	print '</div>';
	
	print '<div class="fichehalfright">';
	print '<div class="ficheaddleft">';
	
	
	print '</div>';
	print '</div>';
	print '</div>';

	print '<div class="clearboth"></div><br>';

	dol_fiche_end();
}


// End of page
llxFooter();
$db->close();
