<?php
/**
 * Boxes definition for hosting module
 *
 * Copyright (C) 2011-2016    Jean-Fraçois Ferry    <hello@librethic.io>
 * Copyright (C) 2010         Regis Houssin        <regis@dolibarr.fr>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    hosting
 */

include_once DOL_DOCUMENT_ROOT . "/core/boxes/modules_boxes.php";

/**
 * Class to manage the box to show last hosts
 */
class box_hosts extends ModeleBoxes
{

    public $boxcode = "lasthosts";
    public $boximg = "host@hosting";
    public $boxlabel;
    public $depends = array("hosting"); // conf->hosting->enabled

    public $db;
    public $param;

    public $info_box_head = array();
    public $info_box_contents = array();

    /**
     *    Constructeur de la classe
     */
    public function __construct()
    {
        global $langs;
        $langs->load("hosting@hosting");

        $this->boxlabel = $langs->trans("BoxLasthosts");
    }

    /**
     * Charge les donnees en memoire pour affichage ulterieur
     *
     * @param    int    $max    Nombre maximum d'enregistrements a charger
     *
     * @return void    Load $this->info_box_contents
     */
    public function loadBox($max = 5)
    {
        global $user, $langs, $db, $conf;

        $this->max = $max;

        dol_include_once("/hosting/class/host.class.php");
        $hoststatic = new Host($db);

        $this->info_box_head = array('text' => $langs->trans("BoxTitleLasthosts", $max));

        if ($user->rights->hosting->read) {
            $sql = "SELECT s.nom, s.rowid as socid,";
            $sql .= " h.rowid, h.ref, h.label, h.date_creation";
            $sql .= " FROM " . MAIN_DB_PREFIX . "societe as s, " . MAIN_DB_PREFIX . "host as h";
            if (!$user->rights->societe->client->voir && !$user->societe_id) {
                $sql .= ", " . MAIN_DB_PREFIX . "societe_commerciaux as sc";
            }

            $sql .= " WHERE h.fk_soc = s.rowid";
            //$sql.= " AND c.entity = ".$conf->entity;
            if (!$user->rights->societe->client->voir && !$user->societe_id) {
                $sql .= " AND s.rowid = sc.fk_soc AND sc.fk_user = " . $user->id;
            }

            if ($user->societe_id) {
                $sql .= " AND s.rowid = " . $user->societe_id;
            }

            $sql .= " ORDER BY h.date_creation DESC, h.rowid DESC ";
            $sql .= $db->plimit($max, 0);

            $resql = $db->query($sql);
            if ($resql) {
                $num = $db->num_rows($resql);
                $now = gmmktime();

                $i = 0;

                while ($i < $num) {
                    $objp = $db->fetch_object($resql);
                    $datec = $db->jdate($objp->datec);
                    $dateterm = $db->jdate($objp->fin_validite);
                    $dateclose = $db->jdate($objp->date_cloture);
                    $late = '';

                    $hoststatic->statut = $objp->fk_statut;
                    $hoststatic->id = $objp->rowid;

                    // fin_validite is no more on host but on services
                    // if ($objp->fk_statut == 1 && $dateterm < ($now - $conf->contrat->cloture->warning_delay)) { $late = img_warning($langs->trans("Late")); }

                    $this->info_box_contents[$i][0] = array('td' => 'align="left" width="16"',
                        'logo' => $this->boximg,
                        'url' => dol_buildpath("/hosting/host_card.php?id=" . $objp->rowid, 1));

                    $this->info_box_contents[$i][1] = array('td' => 'align="left"',
                        'text' => ($objp->label ? $objp->label : $objp->rowid), // Some hosts have no ref
                        'text2' => $late,
                        'url' => dol_buildpath("/hosting/host_card.php?id=" . $objp->rowid, 1));

                    $this->info_box_contents[$i][2] = array('td' => 'align="left" width="16"',
                        'logo' => 'company',
                        'url' => DOL_URL_ROOT . "/comm/card.php?socid=" . $objp->socid);

                    $this->info_box_contents[$i][3] = array('td' => 'align="left"',
                        'text' => dol_trunc($objp->nom, 40),
                        'url' => DOL_URL_ROOT . "/comm/card.php?socid=" . $objp->socid);

                    $this->info_box_contents[$i][4] = array('td' => 'align="right"',
                        'text' => dol_print_date($datec, 'day'));

                    $this->info_box_contents[$i][5] = array('td' => 'align="right" nowrap="nowrap"',
                        'text' => '',
                        'asis' => 1,
                    );

                    $i++;
                }

                if ($num == 0) {
                    $this->info_box_contents[$i][0] = array('td' => 'align="center"', 'text' => $langs->trans("NoRecordedHosts"));
                }
            } else {
                dol_print_error($db);
            }
        } else {
            $this->info_box_contents[0][0] = array('td' => 'align="left"',
                'text' => $langs->trans("ReadPermissionNotAllowed"));
        }
    }

    /**
     * Show box with parent method
     *
     *  @param    array    $head       Array with properties of box title
     *    @param  array    $contents   Array with properties of box lines
     *    @return    void
     *
     * @return void    Load $this->info_box_contents
     */
    public function showBox($head = null, $contents = null, $nooutput = 0)
    {
    	parent::showBox($this->info_box_head, $this->info_box_contents, $nooutput);
    }
}
