<?php
/**
 * Copyright (C) - 2019 Jean-François Ferry <hello@librethic.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *    \file       hosting/class/actions_hosting.class.php
 *    \ingroup    hosting
 *    \brief      File Class hosting
 */

require_once "host.class.php";

require_once DOL_DOCUMENT_ROOT . '/core/lib/files.lib.php';
require_once DOL_DOCUMENT_ROOT . '/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT . '/contrat/class/contrat.class.php';
require_once DOL_DOCUMENT_ROOT . '/fichinter/class/fichinter.class.php';

/**
 *    \class      ActionsHosting
 *    \brief      Class Actions of the module hosting
 */
class ActionsHosting
{
    public $db;

    public $mesg;
    public $error;
    public $errors = array();
    //! Numero de l'erreur
    public $errno = 0;

    public $template_dir;
    public $template;

    /**
     * Constructor
     *
     * @param DoliDB $db Database handler
     */
    public function __construct($db)
    {
        $this->db = $db;
    }

    /**
     * Overloading the addMoreMassActions function : replacing the parent's function with the one below
     *
     * @param array        $parameters  Hook metadatas (context, etc...)
     * @param CommonObject $object      The object to process (an invoice if you are in invoice module, a propale in propale's module, etc...)
     * @param string       $action      Current action (if set). Generally create or edit or null
     * @param HookManager  $hookmanager Hook manager propagated to allow calling another hook
     *
     * @return int  < 0 on error, 0 on success, 1 to replace standard code
     */
    public function showLinkToObjectBlock($parameters, &$object, &$action, $hookmanager)
    {
        global $conf, $user, $langs;

        $error = 0; // Error counter

        if (in_array($parameters['currentcontext'], array('commonobject'))) {		// do something only for the context 'somecontext1' or 'somecontext2'
            if (is_object($object->thirdparty) && ! empty($object->thirdparty->id) && $object->thirdparty->id > 0) {
                $listofidcompanytoscan=$object->thirdparty->id;
                if (($object->thirdparty->parent > 0) && ! empty($conf->global->THIRDPARTY_INCLUDE_PARENT_IN_LINKTO)) {
                    $listofidcompanytoscan.=','.$object->thirdparty->parent;
                }
                if (($object->fk_project > 0) && ! empty($conf->global->THIRDPARTY_INCLUDE_PROJECT_THIRDPARY_IN_LINKTO)) {
                    include_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';
                    $tmpproject=new Project($this->db);
                    $tmpproject->fetch($object->fk_project);
                    if ($tmpproject->socid > 0 && ($tmpproject->socid != $object->thirdparty->id)) {
                        $listofidcompanytoscan.=','.$tmpproject->socid;
                    }
                    unset($tmpproject);
                }
                
                $this->results=array(
                    'hosting_host'=>array('enabled'=>$conf->hosting->enabled, 'perms'=>1, 'label'=>'LinkToHost', 'sql'=>"SELECT s.rowid as socid, s.nom as name, s.client, t.rowid, t.ref, t.label FROM ".MAIN_DB_PREFIX."societe as s, ".MAIN_DB_PREFIX."host as t WHERE t.fk_soc = s.rowid AND t.fk_soc IN (".$listofidcompanytoscan.') AND t.entity IN ('.getEntity('hosting').')'),
                );
            }
        }

        if (! $error) {
            return 0;                                    // or return 1 to replace standard code
        } else {
            $this->errors[] = 'Error message';
            return -1;
        }
    }
}
