<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *     \file        hosting/admin/about.php
 *     \ingroup    hosting
 *     \brief        Hosting module about page
 */
// Dolibarr environment
$res = @include "../../main.inc.php"; // From htdocs directory
if (!$res) {
    $res = @include "../../../main.inc.php"; // From "custom" directory
}

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/hosting.lib.php';

dol_include_once('/hosting/lib/php-markdown/markdown.php');

//require_once "../class/myclass.class.php";
// Translations
$langs->load("hosting@hosting");

// Access control
if (!$user->admin) {
    accessforbidden();
}

/*
 * View
 */
$page_name = "HostingAbout";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
. $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
$head = hosting_admin_prepare_head();
dol_fiche_head(
    $head,
    'about',
    $langs->trans("Module110100Name"),
    0,
    'hosting@hosting'
);

// About page goes here
$buffer = file_get_contents(dol_buildpath('/hosting/README.md', 0));
echo Markdown($buffer);

echo '<br>',
'<a href="' . dol_buildpath('/hosting/COPYING', 1) . '">',
'<img src="' . dol_buildpath('/hosting/img/gplv3.png', 1) . '"/>',
    '</a>';

echo '<br><br />';

print_titre($langs->trans("HostingAboutPage"));

echo '<br>',
'<p >' . $langs->trans('HostingAboutLibrethic') . '</p>',
'<br />',
'<a href="https://librethic.io">',
'<img src="' . dol_buildpath('/hosting/img/logo_librethic_color_bk_300x110.png', 1) . '"/>',
    '</a></p>';

dol_fiche_end();

llxFooter();

$db->close();
