<?php
/* Copyright (C) 2013 Florian Henry  <florian.henry@open-concept.pro>
 * Copyright (C) 2013 Juanjo Menent  <jmenent@2byte.es>
 * Copyright (C) 2015      Frederic France      <frederic.france@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 		\file       htdocs/core/boxes/.php
 * 		\ingroup    helloworld
 * 		\brief      Box to show last interventions
 */

include_once DOL_DOCUMENT_ROOT.'/core/boxes/modules_boxes.php';


/**
 * Class to manage the box to show last interventions
 */
class Box_helloworld extends ModeleBoxes
{
	var $boxcode="helloworld";
	var $boximg="object_Helloworld";
	var $boxlabel="BoxHelloworld";
	var $depends = array("helloworld");	// conf->contrat->enabled

	var $db;
	var $param;

	var $info_box_head = array();
	var $info_box_contents = array();


	/**
	 *  Load data for box to show them later
	 *
	 *  @param	int		$max        Maximum number of records to load
	 *  @return	void
	*/
	function loadBox($max=10)
	{
		global $user, $langs, $db, $conf;

		$this->max=$max;

		dol_include_once('/helloworld/class/planets.class.php');
		$helloworldstatic=new Planets($db);

		$this->info_box_head = array('text' => $langs->trans("BoxTitleLastFichePlanets",$max));

		if ($user->rights->helloworld->read)
		{
			$sql = "SELECT s.rowid, s.label";
			$sql.= " FROM ".MAIN_DB_PREFIX."planets as s";
			$sql.= " ORDER BY s.rowid DESC";
			$sql.= $db->plimit($max, 0);
//print '<div class=info>'.$sql.'</div>';
			dol_syslog(get_class($this).'::loadBox', LOG_DEBUG);
			$resql = $db->query($sql);
			if ($resql)
			{
				$num = $db->num_rows($resql);
				$now=dol_now();

				$i = 0;

				while ($i < $num)
				{
					$objp = $db->fetch_object($resql);
					
					$helloworldstatic->statut=$objp->fk_statut;
					$helloworldstatic->id=$objp->rowid;


					$this->info_box_contents[$i][0] = array('td' => 'align="left"',
					'text' => dol_trunc($objp->label,40),
					'url' => DOL_URL_ROOT."/helloworld/planets_card.php?id=".$objp->rowid);



					$i++;
				}

				if ($num==0) $this->info_box_contents[$i][0] = array('td' => 'align="center"','text'=>$langs->trans("NoRecordedInterventions"));

				$db->free($resql);
			}
			else
			{
				$this->info_box_contents[0][0] = array(  'td' => 'align="left"',
				'maxlength'=>500,
				'text' => ($db->error().' sql='.$sql));
			}
		}
		else
		{
			$this->info_box_contents[0][0] = array('td' => 'align="left"',
			'text' => $langs->trans("ReadPermissionNotAllowed"));
		}
	}

	/**
	 *	Method to show box
	 *
	 *	@param	array	$head       Array with properties of box title
	 *	@param  array	$contents   Array with properties of box lines
	 *  @param	int		$nooutput	No print, only return string
	 *	@return	void
	 */
    function showBox($head = null, $contents = null, $nooutput=0)
    {
		parent::showBox($this->info_box_head, $this->info_box_contents, $nooutput);
	}

}

