<?php

dol_include_once('/grh/db/nx_db.class.php');

class pointage extends NX_db{

	/**
	 * @var string Error code (or message)
	 * @deprecated
	 * @see test::errors
	 */
	public $error;
	/**
	 * @var string[] Error codes (or messages)
	 */
	public $errors = array();
 /**
	 * @var string Id to identify managed objects
	 */
	public $element = 'l_pointage';
	/**
	 * @var string Name of table without prefix where object is stored
	 */
	public $table_element = 'l_pointage';

	public $rowid;
	public $year_point ;
	public $month_point;
	public $created_by;
	public $fk_user;
	public $rows = array();
	public $now;
    public $type;
    public $val;
    public $jour;
    public $somme;
   // public $fk_project;
    public $id;
	public function __construct($db)
	{
		$this->db 		 = $db;
		$this->now 		 = new \DateTime("now");
		$this->now 		 = $this->now->format('Y-m-d H:i:s');
		return 1;
	}

	public function create()
	{
 		dol_syslog(__METHOD__, LOG_DEBUG);

		// Clean parameters
		$this->created_by 			    = $this->created_by ? $this->db->escape($this->created_by): null;
		$this->year_point			= $this->year_point ? $this->db->escape($this->year_point): 0;
		$this->month_point 			    = $this->month_point ? $this->db->escape($this->month_point): 0;
		$this->type			    = $this->type ? $this->db->escape($this->type): 0;
		$this->val			    = $this->val ? $this->db->escape($this->val): 0;
		$this->jour			    = $this->jour ? $this->db->escape($this->jour): 0;
		$this->fk_user			    = $this->fk_user ? $this->db->escape($this->fk_user): null;
		//$this->fk_project			    = $this->fk_project ? $this->db->escape($this->fk_project): null;

		// Insert request
		$sql = 'INSERT INTO ' . MAIN_DB_PREFIX . $this->table_element .'(created_by,fk_user,type,val,jour,month_point,year_point,created_at,updated_at) VALUES (';
		$sql .= ''.$this->created_by.', '.$this->fk_user.',"'.$this->type.'",'.$this->val.','.$this->jour.','.$this->month_point.',
		'.$this->year_point.',"'.$this->now.'","'.$this->now.'")';
		$this->db->begin();
		$resql = $this->db->query($sql);
		
		if (!$resql) {
			$this->db->rollback();
			$this->errors[] = 'Error Evenement ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			var_dump($errors);
			return -1;
		} else {
			$this->db->commit();
	return $this->getLasInsrtedId();
		}
	}
public function fetch($id=0,$year=0,$month=0)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		 if($id!=0) {
			$sql .= ' WHERE fk_user = ' . $id;
		}
		if($month!=0){
	   $sql .= ' and month_point = ' . $id;
	
		}
		if($year!=0){
		$sql .= ' and year_point = ' . $id;
	
		}

		$resql = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			   = $this->db->fetch_object($resql);
				$this->year_point  = $obj->year_point;
				$this->rowid       = $obj->rowid;
				$this->month_point = $obj->month_point;
				$this->fk_user     = $obj->fk_user;
			}

			$this->db->free($resql);

			if ($numrows) {
				return 1;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function delete($id)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$this->db->begin();

		$sql 	= 'DELETE FROM ' . MAIN_DB_PREFIX . $this->table_element .' WHERE  rowid = ' . $id;
		$resql 	= $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();

			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	
	public function update($id, array $data)
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		if (!$id || $id <= 0)
			return false;

		// Update request
		$sql = 'UPDATE ' . MAIN_DB_PREFIX . $this->table_element  . ' SET ';
		if (count($data) && is_array($data))
			foreach ($data as $key => $val) {
				$val = is_numeric($val) ? $val : '"'. $val .'"';
				$sql .= '`'. $key. '` = '. $val .',';
			}
		$sql  = substr($sql, 0, -1);
		$sql .= ' WHERE  rowid = ' . $id;
        
		$this->db->begin();
		$resql = $this->db->query($sql);

		if (!$resql) {
			$this->db->rollback();
			
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		} else {
			$this->db->commit();

			return 1;
		}
	}
	//search
	public function fetchAll($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '',$id = '',$month='')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT p.fk_user,p.month_point,p.year_point,CONCAT( u.lastname," ", u.firstname ) as  fs  FROM ' . MAIN_DB_PREFIX .$this->table_element.' p,'.MAIN_DB_PREFIX.'user u';
         $filter.=" and p.fk_user=u.rowid";
		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);

		}
		
		$sql .= " GROUP BY  p.fk_user,p.month_point,p.year_point";
		if (!empty($sortfield)) {
			$sql .= $this->db->order($sortfield, $sortorder);
		}	
		if (!empty($limit)) {
			$sql .= $this->db->plimit($limit,$offset);
		}	
		$this->rows = array();
		$resql 		 = $this->db->query($sql);

		if ($resql) {
			$num = $this->db->num_rows($resql);

			while ($obj = $this->db->fetch_object($resql)) {
				$line = new stdClass;
     	       	$line->year_point  = $obj->year_point;
				$line->rowid       = $obj->rowid;
				$line->month_point = $obj->month_point;
				$line->fk_user     = $obj->fk_user;
				$line->type        = $obj->type ;
				$line->jour 	   = $obj->jour ;
				$line->val	       = $obj->val ;
				//$line->fk_project  = $obj->fk_project ;
				$this->rows[] 	   = $line;
				
			}

			$this->db->free($resql);

			return $num;
		} else {
			echo 'erreur';

			die();
			$this->error 	= 'Error ' . $this->db->lasterror();
			$this->errors[] = $this->error;
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
	}

	public function getProjetId($mois=0,$annee=0,$iduser=0,$projet=0){

        dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		
		if ($iduser!=0) {
			$sql .= ' WHERE  fk_user= ' . '\'' . $iduser . '\'';
		}
		if ($annee!=0) {
			$sql .= ' and year_point= ' . '\'' . $annee . '\'';
		}
		if ($mois!=0) {
			$sql .= ' and month_point= ' . '\'' . $mois . '\'';
		}/*if ($projet!=-1) {
			$sql .= ' and fk_project= ' . '\'' . $projet . '\'';
		}*/

		$resql = $this->db->query($sql);
		
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if($numrows){
				return $numrows;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
}

	public function getVal($mois=0,$annee=0,$iduser=0,$type='',$jour=0){

        dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		
		if ($iduser!=0) {
			$sql .= ' WHERE  fk_user= ' . '\'' . $iduser . '\'';
		}
		if ($annee!=0) {
			$sql .= ' and year_point= ' . '\'' . $annee . '\'';
		}
		if ($mois!=0) {
			$sql .= ' and month_point= ' . '\'' . $mois . '\'';
		}if ($type!='') {
			$sql .= ' and type= ' . '\'' . $type . '\'';
		}if ($jour!=0) {
			$sql .= ' and jour= ' . '\'' . $jour . '\'';
		}/*if ($projet!=-1) {
			$sql .= ' and fk_project= ' . '\'' . $projet . '\'';
		}*/

		$resql = $this->db->query($sql);
		
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 		   = $this->db->fetch_object($resql);
				$this->val	   = $obj->val ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return $this->val;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
}
////////////////////////////////////
public function getID($mois=0,$annee=0,$iduser=0,$type='',$jour=0){

        dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT * FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		
		if ($iduser!=0) {
			$sql .= ' WHERE  fk_user= ' . '\'' . $iduser . '\'';
		}
		if ($annee!=0) {
			$sql .= ' and year_point= ' . '\'' . $annee . '\'';
		}
		if ($mois!=0) {
			$sql .= ' and month_point= ' . '\'' . $mois . '\'';
		}if ($type!='') {
			$sql .= ' and type= ' . '\'' . $type . '\'';
		}if ($jour!=0) {
			$sql .= ' and jour= ' . '\'' . $jour . '\'';
		}
		/*if ($projet!=-1) {
			$sql .= ' and fk_project= ' . '\'' . $projet . '\'';
		}*/

		$resql = $this->db->query($sql);
		
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			   = $this->db->fetch_object($resql);
				$this->rowid	   = $obj->rowid ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return $this->rowid;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}
}

////////////////////////status
public function fetchStatus($sortorder = '', $sortfield = '', $limit = 0, $offset = 0, $filter = '',$id = '',$type='')
	{
		dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT p.fk_user,p.year_point,p.month_point,p.type,sum(p.val) as somme FROM ' . MAIN_DB_PREFIX .$this->table_element.' p,'.MAIN_DB_PREFIX.'user u';

 if (!empty($type)) {
			$filter.= $type;
		}
		$filter.=" and p.fk_user=u.rowid";
		
		if (!empty($filter)) {
			$sql .= ' WHERE '. substr($filter, 4);
		}
			$sql .= " GROUP BY  p.fk_user,p.month_point,p.year_point";
	   
			
		$resql 		 = $this->db->query($sql);
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 			   = $this->db->fetch_object($resql);
				$this->somme	   = $obj->somme ;
			}

			$this->db->free($resql);

			if ($numrows) {
				return $this->somme;
			} else {
				return 0;
			}
		} else {
	
			$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);

			return -1;
		}

	}

public function getUsers()
    {
    	 $sql = "SELECT rowid, lastname , firstname ";
        
        $sql.= " FROM ".MAIN_DB_PREFIX ."user ";
    	$resql 		 = $this->db->query($sql);
    	$users = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$users[$obj->rowid] = $obj->firstname.' '.$obj->lastname;
			}
			$this->db->free($resql);
    	}

    	return $users;
    }

public function getUsersWithS($salary=true)
    {
    	 $sql = "SELECT u.rowid as rowid ";
        
        $sql.= " FROM ".MAIN_DB_PREFIX ."user u, ".MAIN_DB_PREFIX."user_extrafields e";
       
        $sql.=" WHERE u.statut = 1 AND e.nx_is_stagiaire = 0 ";
       
        if($salary)
        	$sql.="AND u.salary IS NOT NULL";
        else
        	$sql.="AND u.salary IS NULL";
       
       	// $sql .= " ORDER BY e.clas " ;

       	// echo $sql;
    	$resql 		 = $this->db->query($sql);
    	$users = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$users[$obj->rowid] = $obj->rowid;
			}
			$this->db->free($resql);
    	}else{
    		$this->errors[] = 'Error ' . $this->db->lasterror();
			dol_syslog(__METHOD__ . ' ' . join(',', $this->errors), LOG_ERR);
			print_r($this->errors);
    	}
    	// print_r($users);
    	return $users;
    }

    public function getUsersCNSS()
    {
    	 $sql = "SELECT u.rowid as rowid ";
        
        $sql.= " FROM ".MAIN_DB_PREFIX ."user u , ".MAIN_DB_PREFIX."user_extrafields e";
        $sql.=" WHERE u.statut = 1 AND e.nx_is_stagiaire = 0 ";
       	$sql.='AND e.nx_is_declared=1 ';
        	$sql.='AND u.rowid=e.fk_object ';
      
        	$sql.=" ORDER BY e.nx_cnss ASC";
        	// echo $sql;
    	$resql 		 = $this->db->query($sql);
    	$users = array();
		if ($resql) {
			$num = $this->db->num_rows($resql);
			while ($obj = $this->db->fetch_object($resql)) {
				$users[$obj->rowid] = $obj->firstname.' '.$obj->lastname;
			}
			$this->db->free($resql);
    	}

    	return $users;
    }


public function getValByMonth($annee,$mois,$iduser){

        dol_syslog(__METHOD__, LOG_DEBUG);

		$sql = 'SELECT SUM(val) as total FROM ' . MAIN_DB_PREFIX . $this->table_element ;
		
			$sql .= ' WHERE fk_user= ' . '\'' . $iduser . '\'';
		
			$sql .= ' and year_point= ' . '\'' . $annee . '\'';
		
			$sql .= ' and month_point= ' . '\'' . $mois . '\'';
	
			$sql .= ' GROUP BY fk_user ' ;
		$resql = $this->db->query($sql);
		$total = 0;
		if ($resql) {
			$numrows = $this->db->num_rows($resql);
			if ($numrows) {
				$obj 		   = $this->db->fetch_object($resql);
				$total	   = $obj->total ;
			}

			$this->db->free($resql);

		}

		 return $total;
		
	}

	public function nc_getUserInfo($key){
		$user_array = [];
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."user where rowid =".$key;
    	$result = $this->db->query($sql);
		if ($result)
		{
			$obj = $this->db->fetch_object($result);
			// print_r($obj);
			if ($obj)
			{
				$user_array = clone $obj;
			}
		}

		return $user_array;
	}






	public function grhpermissionto($source){
	    if(is_dir($source)) {
	    	@chmod($source, 0775);
	        $dir_handle=opendir($source);
	        while($file=readdir($dir_handle)){
	            if($file!="." && $file!=".."){
	                if(is_dir($source."/".$file)){
	                    @chmod($source."/".$file, 0775);
	                    $this->grhpermissionto($source."/".$file);
	                } else {
	                    @chmod($source."/".$file, 0664);
	                }
	            }
	        }
	        closedir($dir_handle);
	    } else {
	        @chmod($source, 0664);
	    }
	}

   
}
