<?php
/* Copyright (C) 2005-2009	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2009-2017	Regis Houssin		<regis.houssin@inodbox.com>
 * Copyright (C) 2014		Marcos García		<marcosgdf@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       htdocs/core/triggers/interface_20_all_Glpitodolibarr.class.php
 *  \ingroup    core
 *  \brief      Trigger file for
 */

require_once DOL_DOCUMENT_ROOT.'/core/triggers/dolibarrtriggers.class.php';
dol_include_once('/glpitodolibarr/class/glpitodolibarrdata.class.php');

/**
 *  Class of triggers 
 */
class InterfaceGlpitodolibarrtrigger extends DolibarrTriggers
{
	protected $db;
    /**
     * Constructor
     *
     *  @param      DoliDB      $db     Database handler
     */
    public function __construct($db)
    {
        $this->db = $db;
        $this->name = preg_replace('/^Interface/i', '', get_class($this));
        $this->family = "Next";
        $this->description = "Triggers of this module are empty functions.";
        $this->version = 'development';
        $this->picto = 'glpitodolibarr@glpitodolibarr';
    }

	/**
	 * Function called when a Dolibarrr security audit event is done.
	 * All functions "runTrigger" are triggered if file is inside directory htdocs/core/triggers or htdocs/module/code/triggers (and declared)
	 *
	 * @param string		$action		Event action code
	 * @param Object		$object     Object
	 * @param User			$user       Object user
	 * @param Translate		$langs      Object langs
	 * @param conf			$conf       Object conf
	 * @return int         				<0 if KO, 0 if no triggered ran, >0 if OK
	 */
	public function runTrigger($action, $object, User $user, Translate $langs, Conf $conf)
    {


        $date = dol_now();

        // die($action);
        // Actions
        if ($action == 'USER_DELETE')
        {   
            $this->delete_glpidata($object,'user');
        }
        elseif($action == 'GROUP_DELETE'){
            $this->delete_glpidata($object,'group');
        }
        elseif($action == 'COMPANY_DELETE'){
            $this->delete_glpidata($object,'supplier');
        }
        elseif($action == 'PROJECT_DELETE'){
            $this->delete_glpidata($object,'project');
        }
        elseif($action == 'TASK_DELETE'){
            $this->delete_glpidata($object,'projecttask');
        }

        elseif($action == 'CONTACT_DELETE'){
            $this->delete_glpidata($object,'contact');
        }
        elseif($action == 'PRODUCT_DELETE'){
            $this->delete_glpidata($object,'product');
        }
        elseif($action == 'CATEGORY_DELETE'){
            $this->delete_glpidata($object,'category');
        }


        $result=1;
        if ($result > 0)
        {
            return 1;
        }
        else
        {
            $error ="Failed to to remove element from glpitodolibarrdata table: ".$event->error;
            $this->error=$error;

            dol_syslog(get_class($this).": ".$this->error, LOG_ERR);
            return -1;
        }
    }

    public function delete_glpidata($object,$element)
    {
        $glpitodolibarrdata = new glpitodolibarrdata($this->db);
        $glpitodolibarrdata->fetchAll('', '', '', '', " AND fk_id_doli = ".$object->id." AND elementtype =  '".$element."'");
        if (count($glpitodolibarrdata->rows) > 0) {
            $glpitodo = $glpitodolibarrdata->rows[0];
            $glpitodolibarrdata->fetch($glpitodo->id);
            if($glpitodolibarrdata){
                $result = $glpitodolibarrdata->delete();
                if($result){
                    if($element == 'supplier'){
                        $glpidatachild = new glpitodolibarrdata($this->db);
                        $glpidatachild->fetchAll('', '', '', '', " AND elementtype = 'contact' AND parenttype = 'supplier' AND fk_id_parent = ".$object->id);
                        foreach ($glpidatachild->rows as $key => $value) {
                            $glpidatachild->fetch($value->id);
                            $glpidatachild->delete();
                        }
                    }elseif( $element == 'project'){
                        $glpidatachild = new glpitodolibarrdata($this->db);
                        $glpidatachild_tasks = new glpitodolibarrdata($this->db);
                        $glpidatachild->fetchAll('', '', '', '', " AND elementtype = 'contact' AND parenttype = 'project' AND fk_id_parent = ".$object->id);
                        if(count($glpidatachild->rows) > 0){
                            foreach ($glpidatachild->rows as $key => $value) {
                                $glpidatachild->fetch($value->id);
                                $glpidatachild->delete();
                            }
                        }
                        $glpidatachild_tasks->fetchAll('', '', '', '', " AND elementtype = 'projecttask' AND parenttype = 'project' AND fk_id_parent = ".$object->id);
                        if(count($glpidatachild_tasks->rows) > 0){
                            foreach ($glpidatachild_tasks->rows as $key => $value) {
                                # code...
                            }
                        }
                    }
                }
            }
        }
    }
}
